/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.Variable;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Security;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ssl
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private boolean open;
    private SSLSocket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private String[] cipherSuites;
    private int enableSessionCreation = -1;
    private int needClientAuth = -1;
    private int useClientMode = -1;
    private int port = 80;
    private int MAX_LENGTH = -1;

    private static void addProvider() {
        try {
            Security.addProvider((java.security.Provider)new Provider());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String currentHandler = System.getProperty("java.protocol.handler.pkgs");
            if (currentHandler == null) {
                Properties p = System.getProperties();
                p.put("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                System.setProperties(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBuffering(boolean in, boolean out) {
    }

    @Override
    public void setBlockSize(int size) {
        this.MAX_LENGTH = size > 0 ? size : -1;
    }

    public void setOpenSleep(int value) {
    }

    public static final String getProtocol() {
        return "ssl";
    }

    private String extract(String option) {
        if (option == null) {
            return null;
        }
        String part = null;
        int optionLength = option.length();
        int index = this.filename.indexOf(option);
        int finalIndex = -1;
        if (index >= 0) {
            finalIndex = this.filename.indexOf(47, index + 1);
            if (finalIndex >= 0) {
                part = this.filename.substring(index + optionLength, finalIndex);
                this.filename = this.filename.substring(0, index) + this.filename.substring(finalIndex);
            } else {
                part = this.filename.substring(index + optionLength);
                this.filename = this.filename.substring(0, index);
            }
        }
        if (part != null) {
            part = part.trim();
        }
        return part;
    }

    private void setFilename(String paramFilename) {
        boolean reduce = true;
        while (reduce) {
            reduce = false;
            if ((paramFilename = paramFilename.trim()).toUpperCase().startsWith("SSL:")) {
                paramFilename = paramFilename.substring(4);
                reduce = true;
            }
            if (paramFilename.toUpperCase().startsWith("SOCKET:")) {
                paramFilename = paramFilename.substring(7);
                reduce = true;
            }
            if (!paramFilename.startsWith("//")) continue;
            paramFilename = paramFilename.substring(2);
            reduce = true;
        }
        int index = -1;
        String part = null;
        Vector<String> cipherSuitesVector = null;
        this.filename = paramFilename;
        reduce = true;
        while (reduce) {
            reduce = false;
            part = this.extract("/cipher-suite=");
            if (part != null) {
                reduce = true;
                if (part.length() > 0) {
                    if (cipherSuitesVector == null) {
                        cipherSuitesVector = new Vector<String>();
                    }
                    cipherSuitesVector.addElement(part);
                }
            }
            if ((part = this.extract("/enable-session-creation=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.enableSessionCreation = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/need-client-auth=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.needClientAuth = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/use-client-mode=")) != null) {
                reduce = true;
                if (part.length() > 0) {
                    this.useClientMode = part.toUpperCase().startsWith("T") ? 1 : 0;
                }
            }
            if ((part = this.extract("/port=")) == null) continue;
            reduce = true;
            try {
                this.port = Integer.parseInt(part);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (cipherSuitesVector != null && cipherSuitesVector.size() > 0) {
            int size = cipherSuitesVector.size();
            this.cipherSuites = new String[size];
            for (int i = 0; i < size; ++i) {
                this.cipherSuites[i] = (String)cipherSuitesVector.elementAt(i);
            }
        }
        if ((index = this.filename.indexOf(58)) >= 0) {
            try {
                this.port = Integer.valueOf(this.filename.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.filename = this.filename.substring(0, index);
        }
    }

    @Override
    public final boolean init(String passFilename, boolean lineSequential) {
        if (passFilename != null) {
            this.setFilename(passFilename);
        }
        this.lineSequential = lineSequential;
        this.readable = true;
        this.writable = true;
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        if (this.os == null) {
            return -48;
        }
        try {
            if (this.MAX_LENGTH <= 0) {
                this.os.write(data, offset, length);
                this.flush();
            } else {
                while (length > this.MAX_LENGTH) {
                    this.os.write(data, offset, this.MAX_LENGTH);
                    offset += this.MAX_LENGTH;
                    length -= this.MAX_LENGTH;
                    this.flush();
                }
                if (length > 0) {
                    this.os.write(data, offset, length);
                    this.flush();
                }
            }
            return 0;
        }
        catch (IOException e) {
            return -93;
        }
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        if (!this.open) {
            return -47;
        }
        if (this.is == null) {
            return -47;
        }
        int bytesRead = 0;
        this.flush();
        try {
            block29: {
                if (this.lineSequential) {
                    int bytesStored = 0;
                    int ch = 0;
                    boolean finished = false;
                    boolean escaped = false;
                    boolean eof = false;
                    try {
                        do {
                            if ((ch = this.is.read()) < 0) {
                                finished = true;
                                eof = true;
                                continue;
                            }
                            if (ch == 0 && !escaped) {
                                escaped = true;
                                continue;
                            }
                            if (!escaped) {
                                switch (ch) {
                                    case 13: {
                                        break;
                                    }
                                    case 10: {
                                        finished = true;
                                        break;
                                    }
                                    case 26: {
                                        finished = true;
                                        eof = true;
                                        break;
                                    }
                                    default: {
                                        if (bytesStored < length) {
                                            data[offset + bytesStored] = (byte)(ch & 0xFF);
                                            ++bytesStored;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                            } else if (bytesStored < length) {
                                data[offset + bytesStored] = (byte)(ch & 0xFF);
                                ++bytesStored;
                            }
                            escaped = false;
                        } while (!finished);
                    }
                    catch (Exception eofException) {
                        eof = true;
                    }
                    for (int i = bytesStored; i < length; ++i) {
                        data[offset + i] = Variable.SPACE_BYTE;
                    }
                    return eof ? -10 : bytesStored;
                }
                bytesRead = 0;
                int chunk = 0;
                if (this.MAX_LENGTH <= 0) {
                    try {
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                        }
                    }
                    catch (Exception endOfFile) {
                        bytesRead = -1;
                    }
                } else {
                    try {
                        while (length > this.MAX_LENGTH && (chunk = this.is.read(data, offset, this.MAX_LENGTH)) > 0) {
                            offset += chunk;
                            length -= chunk;
                            bytesRead += chunk;
                        }
                        if (length <= 0) break block29;
                        while ((chunk = this.is.read(data, offset, length)) > 0) {
                            offset += chunk;
                            if ((bytesRead += chunk) < (length -= chunk)) continue;
                            break;
                        }
                    }
                    catch (Exception e) {
                        bytesRead = -1;
                    }
                }
            }
            return bytesRead <= 0 ? -10 : bytesRead;
        }
        catch (Exception permanentError) {
            return -10;
        }
    }

    @Override
    public final int close(int mode) {
        this.open = false;
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception e) {
                return -30;
            }
        }
        this.is = null;
        this.os = null;
        return 0;
    }

    @Override
    public final int open(int mode) {
        if (this.open) {
            return -41;
        }
        this.readable = false;
        this.writable = false;
        if ((mode & 1) != 0) {
            this.readable = true;
        }
        if ((mode & 2) != 0) {
            this.writable = true;
        }
        try {
            SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.socket = (SSLSocket)sslSocketFactory.createSocket(this.filename, this.port);
            int result = 0;
            try {
                if (this.cipherSuites != null) {
                    this.socket.setEnabledCipherSuites(this.cipherSuites);
                }
            }
            catch (Exception e) {
                result = -4;
            }
            try {
                if (this.enableSessionCreation == 0) {
                    this.socket.setEnableSessionCreation(false);
                } else if (this.enableSessionCreation == 1) {
                    this.socket.setEnableSessionCreation(true);
                }
            }
            catch (Exception e) {
                result = -4;
            }
            try {
                if (this.needClientAuth == 0) {
                    this.socket.setNeedClientAuth(false);
                } else if (this.needClientAuth == 1) {
                    this.socket.setNeedClientAuth(true);
                }
            }
            catch (Exception e) {
                result = -4;
            }
            try {
                if (this.useClientMode == 0) {
                    this.socket.setUseClientMode(false);
                } else if (this.useClientMode == 1) {
                    this.socket.setUseClientMode(true);
                }
            }
            catch (Exception e) {
                result = -4;
            }
            this.is = this.readable ? new DataInputStream(this.socket.getInputStream()) : null;
            this.os = this.writable ? new DataOutputStream(this.socket.getOutputStream()) : null;
            this.open = true;
            return result;
        }
        catch (IOException e) {
            return -30;
        }
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    @Override
    public final Object getObject() {
        return this.socket;
    }

    @Override
    public void flush() {
        try {
            if (this.os != null) {
                this.os.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        ssl.addProvider();
    }
}

