/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.fileprotocol;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.ibm.sslite.SSLContext;
import com.ibm.sslite.SSLException;
import com.ibm.sslite.SSLInputStream;
import com.ibm.sslite.SSLOutputStream;
import com.ibm.sslite.SSLServerSocket;
import com.ibm.sslite.SSLSocket;
import com.ibm.sslite.SSLightKeyRing;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;

public class ssliteserver
implements FileProtocol,
FileConstants {
    private String filename;
    private boolean readable = true;
    private boolean writable = true;
    private boolean lineSequential;
    private int max_parms = 3;
    private String ascii;
    private String KeyRing;
    private static final char CR = '\r';
    private SSLServerSocket sslserversocket;
    private SSLContext sslcontext = new SSLContext();
    private int port;
    int bufferedReadChar = -1;
    private Hashtable<Thread, SocketGroup> socketMapping = new Hashtable();

    public static final String getProtocol() {
        return "ssliteserver";
    }

    @Override
    public final boolean init(String filename, boolean lineSequential) {
        if (filename != null) {
            filename = filename.trim();
        }
        if (filename == null) {
            return true;
        }
        this.filename = filename;
        this.lineSequential = lineSequential;
        if (filename.toUpperCase().startsWith("SSLITESERVER:")) {
            filename = filename.substring(14);
        }
        this.readable = true;
        this.writable = true;
        int i = 0;
        int j = 0;
        int k = 0;
        String[] dest_parm = new String[this.max_parms];
        j = 0;
        for (i = 0; i < this.max_parms - 1 && j < filename.length(); ++i) {
            k = filename.indexOf(58, j);
            if (k < 0) continue;
            dest_parm[i] = filename.substring(j, k);
            j = k + 1;
        }
        if (j <= filename.length() - 1) {
            dest_parm[this.max_parms - 1] = filename.substring(j, filename.length() - 1);
        }
        this.KeyRing = dest_parm[1];
        if (dest_parm[0] != null) {
            try {
                this.port = Integer.valueOf(dest_parm[0].substring(2));
            }
            catch (Exception e) {
                this.port = 9335;
            }
        }
        try {
            SSLServerSocket tempServerSocket;
            this.sslserversocket = tempServerSocket = new SSLServerSocket(this.port, this.sslcontext);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
    }

    @Override
    public final int write(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -48;
        }
        if (!this.isWritable()) {
            return -48;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -48;
        }
        try {
            group.os.write(data, offset, length);
            return 0;
        }
        catch (Exception e) {
            return -93;
        }
    }

    @Override
    public final int read(byte[] data, int offset, int length) {
        if (!this.isOpen()) {
            return -47;
        }
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -47;
        }
        int bytesRead = 0;
        if (this.lineSequential) {
            byte[] buffer = new byte[1];
            try {
                for (bytesRead = 0; bytesRead <= length; ++bytesRead) {
                    int minorbytes;
                    int rc;
                    do {
                        if (this.bufferedReadChar != -1) {
                            rc = this.bufferedReadChar;
                            this.bufferedReadChar = -1;
                            if (bytesRead < length) {
                                data[offset + bytesRead] = (byte)rc;
                            }
                            minorbytes = 1;
                            continue;
                        }
                        if (bytesRead < length) {
                            minorbytes = group.is.read(data, offset + bytesRead, 1);
                            rc = (char)data[offset + bytesRead];
                        } else {
                            minorbytes = group.is.read(buffer, 0, 1);
                            rc = (char)buffer[0];
                        }
                        if (minorbytes != -1) continue;
                        rc = 65535;
                    } while (rc == 13 && minorbytes != -1);
                    if (rc == 10 || minorbytes == -1) {
                        --bytesRead;
                        if (minorbytes != -1) {
                            if (offset + bytesRead > 0 && data[offset + bytesRead] == 13) {
                                --bytesRead;
                            }
                            if (bytesRead < 0) {
                                bytesRead = 0;
                            }
                        }
                        try {
                            for (int i = bytesRead + 1; i < length; ++i) {
                                data[offset + i] = 32;
                            }
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                        if (bytesRead <= 0 && minorbytes == -1) {
                            return -10;
                        }
                        return bytesRead;
                    }
                    if (bytesRead != length) continue;
                    this.bufferedReadChar = rc;
                }
            }
            catch (Exception e) {
                try {
                    for (int i = bytesRead + 1; i < length; ++i) {
                        data[offset + i] = 32;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -10;
            }
            if (bytesRead > 0) {
                return bytesRead;
            }
            return -10;
        }
        try {
            bytesRead = group.is.read(data, offset, length);
            if (bytesRead <= 0) {
                return -10;
            }
            int start = 0;
            if (bytesRead > 0) {
                start = bytesRead;
            }
            for (int i = start; i < length; ++i) {
                data[offset + i] = 32;
            }
            return bytesRead;
        }
        catch (Exception e) {
            try {
                return -10;
            }
            catch (Exception t) {
                return -10;
            }
        }
    }

    @Override
    public final int close(int mode) {
        SocketGroup group = this.getSocketGroup();
        if (group == null) {
            return -30;
        }
        group.open = false;
        this.removeSocketGroup();
        if (group.socket != null) {
            try {
                group.socket.close();
            }
            catch (Exception e) {
                return -30;
            }
        }
        if ((mode & 0x10) != 0) {
            try {
                if (this.sslserversocket != null) {
                    this.sslserversocket.close();
                    this.sslserversocket = null;
                }
            }
            catch (Exception e) {
                return -30;
            }
        }
        return 0;
    }

    @Override
    public final int open(int mode) {
        int i = 0;
        int j = 0;
        int k = 0;
        String password = null;
        int max_parms = 3;
        String[] dest_parm = new String[max_parms];
        boolean cipher_failure = false;
        j = 0;
        for (i = 0; i < max_parms - 1 && j < this.filename.length(); ++i) {
            k = this.filename.indexOf(58, j);
            if (k < 0) continue;
            dest_parm[i] = this.filename.substring(j, k);
            j = k + 1;
        }
        if (j <= this.filename.length() - 1) {
            dest_parm[max_parms - 1] = this.filename.substring(j, this.filename.length() - 1);
        }
        password = dest_parm[2];
        try {
            SSLightKeyRing ring = (SSLightKeyRing)Class.forName(this.KeyRing).newInstance();
            this.ascii = ring.getKeyRingData();
            this.sslcontext.importKeyRings(this.ascii, password);
        }
        catch (Exception e) {
            return -30;
        }
        try {
            SocketGroup group = this.getSocketGroup();
            if (group == null) {
                group = new SocketGroup();
                this.setSocketGroup(group);
            } else if (group.open) {
                return -41;
            }
            if (this.sslserversocket != null) {
                SSLSocket c;
                group.socket = c = (SSLSocket)this.sslserversocket.accept();
                group.is = (SSLInputStream)c.getInputStream();
                group.os = (SSLOutputStream)c.getOutputStream();
                group.open = true;
            }
            if (!(cipher_failure = false)) {
                group.open = true;
                return 0;
            }
            return -30;
        }
        catch (SSLException group) {
        }
        catch (IOException e) {
            return -30;
        }
        catch (Exception e) {
            return -30;
        }
        return 0;
    }

    @Override
    public final long getFilePointer() {
        return -90L;
    }

    @Override
    public final int seek(long position) {
        return -90;
    }

    @Override
    public final long length() {
        return -90L;
    }

    @Override
    public final int backup() {
        return 0;
    }

    @Override
    public final boolean isStream() {
        return true;
    }

    @Override
    public final boolean isReadable() {
        return this.readable;
    }

    @Override
    public final boolean isWritable() {
        return this.writable;
    }

    @Override
    public final boolean isSeekable() {
        return false;
    }

    @Override
    public final boolean isOpen() {
        SocketGroup group = this.getSocketGroup();
        if (group != null) {
            return group.open;
        }
        return false;
    }

    @Override
    public final int readLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean readUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean readUnlock(int handle) {
        return true;
    }

    @Override
    public final int writeLock(long offset, int length) {
        return 0;
    }

    @Override
    public final boolean writeUnlock(long offset, int length) {
        return true;
    }

    @Override
    public final boolean writeUnlock(int handle) {
        return true;
    }

    private SocketGroup getSocketGroup() {
        SocketGroup s;
        Thread t = Thread.currentThread();
        SocketGroup o = this.socketMapping.get(t);
        try {
            s = o;
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    private void removeSocketGroup() {
        Thread t = Thread.currentThread();
        this.socketMapping.remove(t);
    }

    private void setSocketGroup(SocketGroup s) {
        Thread t = Thread.currentThread();
        this.socketMapping.put(t, s);
    }

    @Override
    public final Object getObject() {
        SSLSocket socket2;
        SocketGroup group = this.getSocketGroup();
        if (group != null && (socket2 = group.socket) != null) {
            return socket2;
        }
        return this.sslserversocket;
    }

    @Override
    public void setBlockSize(int size) {
    }

    @Override
    public void flush() {
        try {
            SocketGroup group = this.getSocketGroup();
            if (group == null) {
                return;
            }
            if (group.os != null) {
                group.os.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class SocketGroup {
        public SSLSocket socket;
        public SSLInputStream is;
        public SSLOutputStream os;
        public PrintStream ps;
        public boolean open;

        SocketGroup() {
        }
    }
}

