/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Display;
import com.heirloomcomputing.ecs.exec.FileCountTracker;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.RecordFile;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.Version;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.fileprotocol.file;
import com.heirloomcomputing.ecs.exec.idxFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class fileserver
extends Thread {
    private static PrintStream pout = System.out;
    private static boolean logging = false;
    private static boolean show = false;
    private static boolean visibleExit = false;
    private static int defaultServerPort = 6584;
    public static final byte INFO_COMMAND = 0;
    public static final byte INIT_COMMAND = 1;
    public static final byte OPEN_COMMAND = 2;
    public static final byte CLOSE_COMMAND = 3;
    public static final byte READ_COMMAND = 4;
    public static final byte WRITE_COMMAND = 5;
    public static final byte BACKUP_COMMAND = 6;
    public static final byte LENGTH_COMMAND = 7;
    public static final byte SEEK_COMMAND = 8;
    public static final byte GETFILEPOINTER_COMMAND = 9;
    public static final byte ISSTREAM_COMMAND = 10;
    public static final byte ISREADABLE_COMMAND = 11;
    public static final byte ISWRITABLE_COMMAND = 12;
    public static final byte ISSEEKABLE_COMMAND = 13;
    public static final byte ISOPEN_COMMAND = 14;
    public static final byte READLOCK_COMMAND = 15;
    public static final byte READUNLOCK_COMMAND = 16;
    public static final byte READUNLOCK2_COMMAND = 17;
    public static final byte WRITELOCK_COMMAND = 18;
    public static final byte WRITEUNLOCK_COMMAND = 19;
    public static final byte WRITEUNLOCK2_COMMAND = 20;
    public static final byte SHUTDOWN_COMMAND = 21;
    public static final int IDX_DECLARE = 64;
    public static final int IDX_END_DECLARE = 65;
    public static final int IDX_OPEN = 66;
    public static final int IDX_CLOSE = 67;
    public static final int IDX_START = 68;
    public static final int IDX_READ = 69;
    public static final int IDX_READNEXT = 70;
    public static final int IDX_WRITE = 71;
    public static final int IDX_WRITENEXT = 72;
    public static final int IDX_REWRITE = 73;
    public static final int IDX_DELETE = 74;
    public static final int IDX_INIT = 75;
    public static final int IDX_ISINPUT = 76;
    public static final int IDX_ISOUTPUT = 77;
    public static final int IDX_ISIO = 78;
    public static final int IDX_ISEXTEND = 79;
    public static final int IDX_ISWRITABLE = 80;
    public static final int IDX_FLUSH = 85;
    public static final int IDX_RESET = 86;
    public static final int IDX_UNLOCK = 87;
    public static final int IDX_EXCLUSIVE = 88;
    public static final int IDX_EXCLUSIVE_CONDITIONALLY = 89;
    public static final int IDX_UNEXCLUSIVE = 90;
    public static final int IDX_READPREVIOUS = 91;
    private static String serverDirectory = null;
    private static Vector<String> allowFiles = null;
    private static int clientCount = 0;
    private static Hashtable<String, FileCountTracker> fileregistry = new Hashtable();
    private static Hashtable<Integer, String> clientregistry = new Hashtable();
    private Socket client = null;
    private int clientNumber = ++clientCount;
    private idxFile serverIdxFile = null;
    private int masterRecordAddress = 0;
    private boolean duplicates = false;
    private int numberOfKeys = 0;
    private int iostatus = 0;
    private String filename = null;

    public static String version() {
        return Version.getVersion();
    }

    public static void msg(String text) {
        if (show) {
            pout.println(text);
        }
    }

    public static final void server(int port) {
        ServerSocket s;
        fileserver.msg("fileserver Copyright (C) 2010-2023 Heirloom Computing.  All rights reserved.");
        fileserver.msg("");
        fileserver.msg("Starting fileserver on port " + port);
        try {
            fileserver.msg("Waiting for connection on " + new Date());
            s = new ServerSocket(port);
        }
        catch (Exception e) {
            fileserver.msg("Could not create server socket on port " + port);
            if (visibleExit) {
                JOptionPane.showMessageDialog(null, "File Server Already Executing\nMust Shutdown Before Start");
            }
            System.exit(0);
            return;
        }
        try {
            while (true) {
                Socket incoming = s.accept();
                fileserver serverThread = new fileserver(incoming);
                serverThread.start();
            }
        }
        catch (Exception e) {
            fileserver.msg("Could not accept socket connection on port " + port);
            return;
        }
    }

    private static boolean visiblePrompt(String msg) {
        int result = JOptionPane.showConfirmDialog(null, msg, msg, 2);
        boolean flag = result == 0;
        return flag;
    }

    public static void service(boolean shutdown, boolean eclipse, String[] params) {
        visibleExit = eclipse;
        if (shutdown) {
            if (eclipse && !fileserver.visiblePrompt("Shutting down File Server...")) {
                System.exit(0);
                return;
            }
            fileserver.shutdown(defaultServerPort);
            System.exit(0);
        } else {
            if (eclipse && !fileserver.visiblePrompt("Initializing File Server...")) {
                System.exit(0);
                return;
            }
            fileserver.main(params);
        }
    }

    public static void shutdown(int serverPort) {
        try {
            Socket s = new Socket("127.0.0.1", serverPort);
            DataOutputStream out = new DataOutputStream(s.getOutputStream());
            out.writeByte(21);
            out.flush();
            out.close();
            s.close();
            fileserver.msg("Shutdown fileserver.");
        }
        catch (Exception e) {
            fileserver.msg("Problem occurred during shutdown of fileserver:\n" + e);
        }
    }

    private static void usage(PrintStream msgPS) {
        msgPS.println("fileserver Copyright (C) 2010-2023 Heirloom Computing.  All rights reserved.");
        msgPS.println("");
        msgPS.println("Usage: java fileserver [start|shutdown|quit|exit|stop|restart] [-p|--port port#]");
        msgPS.println("                       [-l|--log 0|1|2] [-d|--directory server_directory]");
        msgPS.println("                       [-f|--securityfile security_file]");
        msgPS.println("");
        msgPS.println("Security File Commands:");
        msgPS.println("");
        msgPS.println("not directory");
        msgPS.println("match x\t\t\tnot match x\ncimatch x\t\tnot cimatch x");
        msgPS.println("begin x\t\t\tnot begin x\ncibegin x\t\tnot cibegin x");
        msgPS.println("end x\t\t\tnot end x\nciend x\t\t\tnot ciend x");
        msgPS.println("contain x\t\tnot contain x\ncicontain x\t\tnot cicontain x");
        msgPS.println("matchall");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean stop = false;
        boolean start = true;
        int extraArg = 0;
        String priorArg = "";
        block22: for (String anArg : args) {
            switch (extraArg) {
                case 0: {
                    break;
                }
                case 1: {
                    try {
                        defaultServerPort = Integer.decode(anArg);
                    }
                    catch (Exception e) {
                        System.err.println("fileserver:  invalid port number");
                        System.err.println("");
                        fileserver.usage(System.err);
                        stop = false;
                        start = false;
                    }
                    extraArg = 0;
                    continue block22;
                }
                case 2: {
                    serverDirectory = anArg;
                    if (!serverDirectory.endsWith(File.separator)) {
                        serverDirectory = serverDirectory + File.separator;
                    }
                    fileserver.msg("Serving for directory '" + serverDirectory + "'");
                    extraArg = 0;
                    continue block22;
                }
                case 3: {
                    try {
                        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(args[2])));
                        try {
                            allowFiles = new Vector();
                            while (true) {
                                String allow = in.readLine();
                                allowFiles.addElement(allow);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                in.close();
                            }
                            catch (Exception exception2) {}
                        }
                    }
                    catch (Exception fileNotFound) {
                        System.err.println("fileserver: Could not find security file '" + anArg + "'");
                        System.err.println("");
                        fileserver.usage(System.err);
                        stop = false;
                        start = false;
                    }
                    extraArg = 0;
                    continue block22;
                }
                case 4: {
                    try {
                        switch (Integer.decode(anArg)) {
                            case 0: {
                                show = false;
                                logging = false;
                                break;
                            }
                            case 1: {
                                show = true;
                                logging = false;
                                break;
                            }
                            case 2: {
                                show = true;
                                logging = true;
                                break;
                            }
                            default: {
                                show = true;
                                logging = true;
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println("fileserver: invalid log level '" + anArg + "'");
                        System.err.println("");
                        fileserver.usage(System.err);
                        stop = false;
                        start = false;
                    }
                    extraArg = 0;
                    continue block22;
                }
            }
            if (anArg.equalsIgnoreCase("start")) {
                start = true;
                stop = false;
            } else if (anArg.equalsIgnoreCase("restart")) {
                stop = true;
                start = true;
            } else if (anArg.equalsIgnoreCase("shutdown") || anArg.equalsIgnoreCase("quit") || anArg.equalsIgnoreCase("exit") || anArg.equalsIgnoreCase("stop")) {
                stop = true;
                start = false;
            } else if (anArg.equals("-p") || anArg.equals("--port")) {
                extraArg = 1;
            } else if (anArg.equals("-d") || anArg.equals("--directory")) {
                extraArg = 2;
            } else if (anArg.equals("-f") || anArg.equals("--securityfile")) {
                extraArg = 3;
            } else if (anArg.equals("-l") || anArg.equals("--log")) {
                extraArg = 4;
            } else if (anArg.equals("-h") || anArg.equals("--help")) {
                fileserver.usage(System.out);
                stop = false;
                start = false;
            } else {
                System.err.println("fileserver:  command '" + anArg + "' invalid");
                System.err.println();
                fileserver.usage(System.err);
                stop = false;
                start = false;
            }
            priorArg = anArg;
        }
        if (extraArg != 0) {
            System.err.println("fileserver:  expecting argument following '" + priorArg + "'");
            System.err.println();
            fileserver.usage(System.err);
            return;
        }
        if (stop) {
            fileserver.shutdown(defaultServerPort);
        }
        if (!start) return;
        fileserver.server(defaultServerPort);
    }

    public fileserver(Socket client) {
        fileserver.msg(this.clientNumber + ": Serving remote connection " + client.getInetAddress() + ":" + client.getPort() + " to local connection " + client.getLocalAddress() + ":" + client.getLocalPort() + " on " + new Date());
        this.client = client;
    }

    private final byte[] readBytes(DataInputStream in) {
        try {
            int length = in.readInt();
            byte[] byteArray = new byte[length];
            in.readFully(byteArray);
            return byteArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final String readString(DataInputStream in) {
        try {
            int length = in.readInt();
            char[] charArray = new char[length];
            for (int i = 0; i < length; ++i) {
                charArray[i] = in.readChar();
            }
            return new String(charArray);
        }
        catch (Exception e) {
            return null;
        }
    }

    private final boolean writeBytes(DataOutputStream out, byte[] byteArray) {
        try {
            int length = byteArray.length;
            out.writeInt(length);
            out.write(byteArray, 0, length);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final boolean writeString(DataOutputStream out, String str) {
        try {
            int length = str.length();
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                out.write(str.charAt(i));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String fname;
        int count;
        FileCountTracker thisfile;
        file fileProtocol;
        DataOutputStream out;
        DataInputStream in;
        block259: {
            in = null;
            out = null;
            try {
                in = new DataInputStream(new BufferedInputStream(this.client.getInputStream()));
                out = new DataOutputStream(new BufferedOutputStream(this.client.getOutputStream()));
            }
            catch (Exception e) {
                fileserver.msg(this.clientNumber + ": Could not obtain input/output stream from client.");
                try {
                    in.close();
                    out.flush();
                    out.close();
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            fileProtocol = new file();
            try {
                while (true) {
                    if (logging) {
                        fileserver.msg(this.clientNumber + ":Waiting for Command (IOStatus=" + this.iostatus + ")");
                    }
                    byte command = in.readByte();
                    if (logging) {
                        fileserver.msg(this.clientNumber + ":*" + command);
                    }
                    switch (command) {
                        case 0: {
                            this.writeString(out, fileserver.version());
                            out.writeByte(0);
                            out.flush();
                            break;
                        }
                        case 1: {
                            boolean lineSequential = in.readBoolean();
                            String tempString = this.readString(in);
                            if (tempString == null) break block259;
                            if (File.separatorChar != '/') {
                                int i = 0;
                                do {
                                    if ((i = tempString.indexOf("//", i)) < 0) continue;
                                    tempString = tempString.substring(0, i - 1) + '\u0100' + tempString.substring(i + 1);
                                    ++i;
                                } while (i >= 0);
                                i = 0;
                                do {
                                    if ((i = tempString.indexOf(47, i)) < 0) continue;
                                    tempString = tempString.substring(0, i - 1) + File.separator + tempString.substring(i + 1);
                                    ++i;
                                } while (i >= 0);
                                i = 0;
                                do {
                                    if ((i = tempString.indexOf(256, i)) < 0) continue;
                                    tempString = tempString.substring(0, i - 1) + '/' + tempString.substring(i + 1);
                                    ++i;
                                } while (i >= 0);
                            }
                            if (allowFiles != null) {
                                boolean found = false;
                                for (int i = 0; i < allowFiles.size(); ++i) {
                                    String allow = allowFiles.elementAt(i);
                                    if (allow.startsWith("not directory")) {
                                        if (tempString.indexOf(File.separatorChar) < 0) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("match ")) {
                                        if (!tempString.equals(allow.substring(6))) continue;
                                        found = true;
                                        break;
                                    }
                                    if (allow.startsWith("not match ")) {
                                        if (!tempString.equals(allow.substring(10))) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("begin ")) {
                                        if (!tempString.startsWith(allow.substring(6))) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not begin ")) {
                                        if (!tempString.startsWith(allow.substring(10))) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("end ")) {
                                        if (!tempString.endsWith(allow.substring(4))) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not end ")) {
                                        if (!tempString.endsWith(allow.substring(9))) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("contain ")) {
                                        if (tempString.indexOf(allow.substring(8)) < 0) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not contain ")) {
                                        if (tempString.indexOf(allow.substring(12)) < 0) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("cimatch ")) {
                                        if (!tempString.equalsIgnoreCase(allow.substring(8))) continue;
                                        found = true;
                                        break;
                                    }
                                    if (allow.startsWith("not cimatch ")) {
                                        if (!tempString.equalsIgnoreCase(allow.substring(12))) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("cibegin ")) {
                                        if (!tempString.toUpperCase().startsWith(allow.substring(8).toUpperCase())) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not cibegin ")) {
                                        if (!tempString.toUpperCase().startsWith(allow.substring(12).toUpperCase())) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("ciend ")) {
                                        if (!tempString.toUpperCase().endsWith(allow.substring(6).toUpperCase())) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not ciend ")) {
                                        if (!tempString.toUpperCase().endsWith(allow.substring(11).toUpperCase())) continue;
                                        found = false;
                                        break;
                                    }
                                    if (allow.startsWith("cicontain ")) {
                                        if (tempString.toUpperCase().indexOf(allow.substring(10).toUpperCase()) < 0) continue;
                                        found = true;
                                        continue;
                                    }
                                    if (allow.startsWith("not cicontain ")) {
                                        if (tempString.toUpperCase().indexOf(allow.substring(14).toUpperCase()) < 0) continue;
                                        found = false;
                                        break;
                                    }
                                    if (!allow.startsWith("matchall")) continue;
                                    found = true;
                                }
                                if (!found) {
                                    fileserver.msg(this.clientNumber + ": Disallowing initialization of file '" + tempString + "' because of security file (client=" + this.client + ").");
                                    out.writeBoolean(false);
                                    out.flush();
                                    break block259;
                                }
                            }
                            fileserver.msg(this.clientNumber + ": Opening file '" + tempString + "', lineSequential=" + lineSequential);
                            if (serverDirectory != null) {
                                tempString = serverDirectory + tempString;
                            }
                            boolean tempBoolean = fileProtocol.initWithLocalFilename(tempString, lineSequential);
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 2: {
                            int tempInt = in.readInt();
                            tempInt = fileProtocol.open(tempInt | 0x800);
                            out.writeInt(tempInt);
                            out.flush();
                            break;
                        }
                        case 3: {
                            int tempInt = in.readInt();
                            tempInt = fileProtocol.close(tempInt | 0x800);
                            out.writeInt(tempInt);
                            out.flush();
                            if ((tempInt & 0x10) != 0) {
                                fileserver.msg(this.clientNumber + ": Closed with lock, cannot be reopened, connection closing.");
                                break block259;
                            }
                            break;
                        }
                        case 4: {
                            int length = in.readInt();
                            byte[] byteArray = new byte[length];
                            int tempInt = fileProtocol.read(byteArray, 0, length);
                            out.writeInt(tempInt);
                            this.writeBytes(out, byteArray);
                            out.flush();
                            break;
                        }
                        case 5: {
                            int tempInt;
                            byte[] byteArray = this.readBytes(in);
                            if (byteArray != null) {
                                tempInt = fileProtocol.write(byteArray, 0, byteArray.length);
                                out.writeInt(tempInt);
                                out.flush();
                                break;
                            }
                            break block259;
                        }
                        case 6: {
                            int tempInt = fileProtocol.backup();
                            out.writeInt(tempInt);
                            out.flush();
                            break;
                        }
                        case 7: {
                            long tempLong = fileProtocol.length();
                            out.writeLong(tempLong);
                            out.flush();
                            break;
                        }
                        case 8: {
                            long tempLong = in.readLong();
                            int tempInt = fileProtocol.seek(tempLong);
                            out.writeInt(tempInt);
                            out.flush();
                            break;
                        }
                        case 9: {
                            long tempLong = fileProtocol.getFilePointer();
                            out.writeLong(tempLong);
                            out.flush();
                            break;
                        }
                        case 10: {
                            boolean tempBoolean = fileProtocol.isStream();
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 11: {
                            boolean tempBoolean = fileProtocol.isReadable();
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 12: {
                            boolean tempBoolean = fileProtocol.isWritable();
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 13: {
                            boolean tempBoolean = fileProtocol.isSeekable();
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 14: {
                            boolean tempBoolean = fileProtocol.isOpen();
                            out.writeBoolean(tempBoolean);
                            out.flush();
                            break;
                        }
                        case 15: {
                            long tempLong = in.readLong();
                            int tempInt = in.readInt();
                            tempInt = fileProtocol.readLock(tempLong, tempInt);
                            out.writeInt(tempInt);
                            out.flush();
                            break;
                        }
                        case 16: {
                            long tempLong = in.readLong();
                            int tempInt = in.readInt();
                            fileProtocol.readUnlock(tempLong, tempInt);
                            break;
                        }
                        case 17: {
                            int tempInt = in.readInt();
                            fileProtocol.readUnlock(tempInt);
                            break;
                        }
                        case 18: {
                            long tempLong = in.readLong();
                            int tempInt = in.readInt();
                            tempInt = fileProtocol.writeLock(tempLong, tempInt);
                            out.writeInt(tempInt);
                            out.flush();
                            break;
                        }
                        case 19: {
                            long tempLong = in.readLong();
                            int tempInt = in.readInt();
                            fileProtocol.writeUnlock(tempLong, tempInt);
                            break;
                        }
                        case 20: {
                            int tempInt = in.readInt();
                            fileProtocol.writeUnlock(tempInt);
                            break;
                        }
                        case 21: {
                            if (this.client.getInetAddress().getHostAddress().equals("127.0.0.1")) {
                                fileserver.msg(this.clientNumber + ": Shutting down by request of " + this.client.getInetAddress());
                                try {
                                    in.close();
                                    out.flush();
                                    out.close();
                                    this.client.close();
                                }
                                catch (Exception found) {
                                    // empty catch block
                                }
                                System.exit(0);
                            }
                            fileserver.msg(this.clientNumber + ": Ignoring shutdown request of " + this.client);
                            break;
                        }
                        case 64: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    Display dependingOn = null;
                                    boolean id_optional = in.readBoolean();
                                    this.filename = this.readString(in);
                                    fileserver.msg(this.clientNumber + ": Declare Index file '" + this.filename + "'");
                                    this.serverIdxFile = RecordFile.getIdxFile((Vector<basicFile>)null, this.filename);
                                    int lio = this.filename.lastIndexOf(58);
                                    if (lio > 0) {
                                        this.filename = this.filename.substring(lio + 1);
                                    }
                                    int id_reserve = in.readInt();
                                    int id_accessMode = in.readInt();
                                    int id_blockFrom = in.readInt();
                                    int id_blockTo = in.readInt();
                                    boolean id_isRecords = in.readBoolean();
                                    int id_recordFrom = in.readInt();
                                    int id_recordTo = in.readInt();
                                    if (in.readBoolean()) {
                                        dependingOn = new Display(1);
                                    }
                                    int id_newModes = in.readInt();
                                    int id_keyCompression = in.readInt();
                                    int id_dataCompression = in.readInt();
                                    int id_idxFormat = in.readInt();
                                    this.serverIdxFile.declare(id_optional, this.filename, id_reserve, null, id_accessMode, null, id_blockFrom, id_blockTo, id_isRecords, id_recordFrom, id_recordTo, (Variable)dependingOn, id_newModes);
                                    this.serverIdxFile.setKeyCompress(id_keyCompression);
                                    this.serverIdxFile.setDataCompress(id_dataCompression);
                                    this.serverIdxFile.setIdxFormat(id_idxFormat);
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_DECLARE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 65: {
                            byte[] tempByteArray;
                            int tempInt;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    Memory masterMemory = new Memory(16384, new String[0]);
                                    this.masterRecordAddress = in.readInt();
                                    this.numberOfKeys = in.readInt();
                                    for (int i = 0; i < this.numberOfKeys; ++i) {
                                        String className = this.readString(in);
                                        this.duplicates = in.readBoolean();
                                        if (i == 0) {
                                            this.duplicates = false;
                                        }
                                        tempInt = in.readInt();
                                        tempByteArray = this.readBytes(in);
                                        this.serverIdxFile.alternateKey(Variable.fromIdxByteArray(className, tempByteArray, masterMemory, this.masterRecordAddress), this.duplicates ? 512 : 0);
                                    }
                                    this.serverIdxFile.endDeclare();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_END_DECLARE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 66: {
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempInt = in.readInt();
                                    FileCountTracker thisfile2 = fileregistry.get(this.filename);
                                    fileserver.msg(this.clientNumber + ": Opening Index file '" + this.filename + "', mode=" + (tempInt &= 0xFFFFF7FF));
                                    Integer ci = new Integer(this.clientNumber);
                                    if (thisfile2 == null) {
                                        tempBoolean = this.serverIdxFile.open(tempInt);
                                        this.iostatus = this.serverIdxFile.priorError();
                                        if (this.iostatus > -10 && this.iostatus < 10) {
                                            thisfile2 = new FileCountTracker(this.serverIdxFile);
                                            fileregistry.put(this.filename, thisfile2);
                                            clientregistry.put(ci, this.filename);
                                        }
                                    } else {
                                        String fname2 = clientregistry.get(ci);
                                        if (this.filename.equals(fname2)) {
                                            fileserver.msg(this.clientNumber + ": Attempting to reopen a file without closing it first.");
                                            tempBoolean = this.serverIdxFile.open(tempInt);
                                            this.iostatus = this.serverIdxFile.priorError();
                                        } else {
                                            fileserver.msg(this.clientNumber + ": Sharing previously opened indexed file.");
                                            thisfile2.incCount();
                                            this.serverIdxFile = thisfile2.getIdxFile();
                                            this.iostatus = 0;
                                            tempBoolean = true;
                                            clientregistry.put(ci, this.filename);
                                        }
                                    }
                                    out.writeInt(this.iostatus);
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_OPEN");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 67: {
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    Object ci2;
                                    tempInt = in.readInt();
                                    FileCountTracker thisfile3 = fileregistry.get(this.filename);
                                    fileserver.msg(this.clientNumber + ": Closing Index file '" + this.filename + "', mode=" + (tempInt &= 0xFFFFF7FF));
                                    try {
                                        ci2 = new Integer(this.clientNumber);
                                        String fname3 = clientregistry.get(ci2);
                                        if (this.filename.equals(fname3)) {
                                            clientregistry.remove(ci2);
                                        }
                                    }
                                    catch (Exception ci2) {
                                        // empty catch block
                                    }
                                    if (thisfile3 != null) {
                                        ci2 = thisfile3;
                                        synchronized (ci2) {
                                            if (!thisfile3.decCount()) {
                                                this.iostatus = 0;
                                                tempBoolean = true;
                                            } else {
                                                tempBoolean = this.serverIdxFile.close(tempInt);
                                                this.iostatus = this.serverIdxFile.priorError();
                                                fileregistry.remove(this.filename);
                                            }
                                        }
                                    } else {
                                        tempBoolean = this.serverIdxFile.close(tempInt);
                                        this.iostatus = this.serverIdxFile.priorError();
                                    }
                                    out.writeInt(this.iostatus);
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_CLOSE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 68: {
                            byte[] tempByteArray;
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempInt = in.readInt();
                                    int tempInt2 = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempBoolean = this.serverIdxFile.start(tempInt, tempInt2, tempByteArray);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_START");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 69: {
                            byte[] tempByteArray;
                            int tempInt;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempByteArray = this.serverIdxFile.readNetwork(false, tempInt, tempByteArray, mode, timeout);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    this.writeBytes(out, tempByteArray);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_READ");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 70: {
                            byte[] tempByteArray;
                            int tempInt;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempByteArray = this.serverIdxFile.readNetwork(true, tempInt, tempByteArray, mode, timeout);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    this.writeBytes(out, tempByteArray);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_READNEXT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 91: {
                            byte[] tempByteArray;
                            int tempInt;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempByteArray = this.serverIdxFile.readNetwork(true, tempInt, tempByteArray, mode, timeout, -1);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    this.writeBytes(out, tempByteArray);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_READNEXT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 71: {
                            byte[] tempByteArray;
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempBoolean = in.readBoolean();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempBoolean = this.serverIdxFile.writeNetwork(tempBoolean, tempInt, tempByteArray, mode, timeout);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_WRITE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 72: {
                            byte[] tempByteArray;
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = in.readBoolean();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempBoolean = this.serverIdxFile.writeNetwork(tempBoolean, tempInt, tempByteArray, 0, 0.0);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_WRITENEXT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 73: {
                            byte[] tempByteArray;
                            int tempInt;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempInt = in.readInt();
                                    tempByteArray = this.readBytes(in);
                                    tempBoolean = this.serverIdxFile.rewriteNetwork(tempInt, tempByteArray, mode, timeout);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_REWRITE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 74: {
                            byte[] tempByteArray;
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    int mode = in.readInt();
                                    double timeout = in.readDouble();
                                    tempByteArray = this.readBytes(in);
                                    tempBoolean = this.serverIdxFile.delete(tempByteArray, mode, timeout, false);
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeInt(this.serverIdxFile.getFileMarkerKeyOffset());
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_DELETE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 75: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    this.serverIdxFile.init();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_INIT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 76: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.isInput();
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_ISINPUT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 77: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.isOutput();
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_ISOUTPUT");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 78: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.isIO();
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_ISIO");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 79: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.isExtend();
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_ISEXTEND");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 80: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.isWritable();
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_ISWRITABLE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 85: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.flushCache();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_FLUSH");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 86: {
                            boolean tempBoolean;
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    tempBoolean = this.serverIdxFile.reset();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.writeBoolean(tempBoolean);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_RESET");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 87: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    this.serverIdxFile.unlock();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_UNLOCK");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 88: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    this.serverIdxFile.exclusive();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_EXCLUSIVE");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 89: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    this.serverIdxFile.exclusiveConditionally();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_EXCLUSIVE_CONDITIONALLY");
                                    }
                                    break block259;
                                }
                            }
                        }
                        case 90: {
                            fileserver found = this;
                            synchronized (found) {
                                try {
                                    this.serverIdxFile.unexclusive();
                                    this.iostatus = this.serverIdxFile.priorError();
                                    out.writeInt(this.iostatus);
                                    out.flush();
                                }
                                catch (Exception e) {
                                    if (logging) {
                                        fileserver.msg("Exception " + e + " in IDX_UNEXCLUSIVE");
                                    }
                                    break block259;
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (fileProtocol != null && fileProtocol.isOpen()) {
            fileProtocol.close(0);
        }
        if (this.serverIdxFile != null && this.serverIdxFile.isOpen()) {
            this.serverIdxFile.close(0);
        }
        Integer ci = new Integer(this.clientNumber);
        if (this.filename != null && (thisfile = fileregistry.get(this.filename)) != null && (count = thisfile.getCount()) == 1 && this.filename.equals(fname = clientregistry.get(new Integer(this.clientNumber)))) {
            try {
                fileregistry.remove(this.filename);
                thisfile.decCount();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            clientregistry.remove(ci);
        }
        catch (Exception exception) {
            // empty catch block
        }
        fileserver.msg(this.clientNumber + ": Connection closed at " + new Date() + ".");
        try {
            in.close();
            out.flush();
            out.close();
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

