/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.util.JUrl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class intrdrFile
extends seqFile {
    private String ebpPort;
    private boolean debugMode;
    private List<String> recList;

    public intrdrFile() {
        this.setEbpPort(System.getProperty("ebp.intrdr.port"));
        this.setRecList(new ArrayList<String>());
        this.setDebugMode(!System.getProperty("ebp.intrdr.debug", "false").equalsIgnoreCase("false"));
    }

    @Override
    public boolean open(int mode) {
        if (this.getEbpPort() != null) {
            return true;
        }
        return super.open(mode);
    }

    @Override
    public boolean close() {
        if (this.getEbpPort() != null) {
            if (!this.getRecList().isEmpty()) {
                this.submitToReader();
                this.getRecList().clear();
            }
            return false;
        }
        return super.close();
    }

    @Override
    public boolean write(Variable data, int mode, Numeric timeout) {
        return this.write(data, mode, timeout, false);
    }

    @Override
    public boolean write(Variable data, int mode, Numeric timeout, boolean printSequential) {
        if (this.getEbpPort() != null) {
            if (data.toText().startsWith("/*EOF")) {
                this.submitToReader();
                this.getRecList().clear();
            } else {
                this.addRec(data);
            }
            return false;
        }
        return super.write(data, mode, timeout, printSequential);
    }

    private void submitToReader() {
        String url2 = "http://localhost:8080/ebp/submit";
        String port = this.getEbpPort().trim();
        if (!port.isEmpty()) {
            url2 = "http://localhost:" + port + "/ebp/submit";
        }
        try {
            File tmpJobFile = File.createTempFile("intrdr", ".tmp");
            BufferedWriter bw = new BufferedWriter(new FileWriter(tmpJobFile));
            for (int i = 0; i < this.getRecList().size(); ++i) {
                bw.write(this.getRecList().get(i).trim());
                if (i + 1 >= this.getRecList().size()) continue;
                bw.write(System.lineSeparator());
            }
            bw.close();
            JUrl jurl = new JUrl();
            String[] args = new String[]{"-F", "\"deck=@" + tmpJobFile.getAbsolutePath() + ";type=text/plain\"", url2};
            String jurlOutput = jurl.opt(args).exec(null);
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isDebugMode()) {
                System.out.println("JUrl out: ");
                System.out.println(jurlOutput);
            }
            boolean successfulDelete = tmpJobFile.delete();
            if (this.isDebugMode() && !successfulDelete) {
                System.out.println("intrdrFile:: delete of " + tmpJobFile.getAbsolutePath() + "failed");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            super.iostatus(-98);
        }
    }

    private void addRec(Variable data) {
        this.recList.add(data.toText().replaceAll("\\r\\n|\\r|\\n", ""));
    }

    private String getEbpPort() {
        return this.ebpPort;
    }

    private void setEbpPort(String ebpPort) {
        this.ebpPort = ebpPort;
    }

    private List<String> getRecList() {
        return this.recList;
    }

    private void setRecList(List<String> recList) {
        this.recList = recList;
    }

    private boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

