/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.jdk14;

import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockRecordChannel
extends LockRecord
implements FileConstants {
    public static final long POLL_TIMEOUT = 33L;
    private int status;
    private smartFile smartFileObject;
    private FileChannel fileChannel;
    private boolean singleMode;
    private final Hashtable<Long, FileLock> locks = new Hashtable();
    private FileLock singleModeLock;
    public static final boolean EXCLUSIVE_MODE = false;
    public static final boolean SHARED_MODE = true;
    private FileLock exclusiveLock;

    private FileChannel getFileChannel() {
        if (this.fileChannel == null) {
            this.refreshFileObject();
        }
        return this.fileChannel;
    }

    private void refreshFileObject() {
        try {
            if (this.smartFileObject != null) {
                Object fileObject = this.smartFileObject.getObject();
                this.refreshFileObject(fileObject);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void refreshFileObject(Object fileObject) {
        if (fileObject instanceof RandomAccessFile) {
            this.fileChannel = ((RandomAccessFile)fileObject).getChannel();
        } else if (fileObject instanceof FileOutputStream) {
            this.fileChannel = ((RandomAccessFile)fileObject).getChannel();
        } else if (fileObject instanceof FileInputStream) {
            this.fileChannel = ((RandomAccessFile)fileObject).getChannel();
        }
    }

    @Override
    public void setFileObject(Object fileObject) {
        if (fileObject instanceof smartFile) {
            this.smartFileObject = (smartFile)fileObject;
            this.refreshFileObject();
        } else {
            this.smartFileObject = null;
            this.refreshFileObject(fileObject);
        }
    }

    @Override
    public void open(String filename, int mode) {
        this.singleMode = (mode & 0x10000) == 0;
        this.fileChannel = null;
    }

    @Override
    public void close() {
        this.unlockAll();
        this.fileChannel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLock getFileLock(long record) {
        if (this.singleMode) {
            return this.singleModeLock;
        }
        Hashtable<Long, FileLock> hashtable = this.locks;
        synchronized (hashtable) {
            try {
                return this.locks.get(new Long(record));
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileLock(long record) {
        if (this.singleMode) {
            this.singleModeLock = null;
            return;
        }
        Hashtable<Long, FileLock> hashtable = this.locks;
        synchronized (hashtable) {
            try {
                this.locks.remove(new Long(record));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFileLock(long record, FileLock fileLock) {
        if (this.singleMode) {
            if (this.singleModeLock != null) {
                try {
                    this.singleModeLock.release();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.singleModeLock = fileLock;
            return;
        }
        Hashtable<Long, FileLock> hashtable = this.locks;
        synchronized (hashtable) {
            this.locks.put(new Long(record), fileLock);
        }
    }

    @Override
    public boolean isStatusLocked() {
        return LockRecordChannel.isStatusLocked(this.getStatus());
    }

    @Override
    public boolean isStatusRejected() {
        return LockRecordChannel.isStatusRejected(this.getStatus());
    }

    @Override
    public boolean isStatusRejectedNoErrors() {
        int status = this.getStatus();
        return LockRecordChannel.isStatusRejected(status) && LockRecordChannel.isStatusNoErrors(status);
    }

    @Override
    public boolean isStatusFileChanged() {
        return LockRecordChannel.isStatusFileChanged(this.getStatus());
    }

    @Override
    public boolean isStatusRecordChanged() {
        return LockRecordChannel.isStatusRecordChanged(this.getStatus());
    }

    @Override
    public boolean isStatusErrorUnknown() {
        return LockRecordChannel.isStatusErrorUnknown(this.getStatus());
    }

    @Override
    public boolean isStatusTooMany() {
        return LockRecordChannel.isStatusTooMany(this.getStatus());
    }

    public static boolean isStatusNoErrors(int n) {
        return (n & 0x18) == 0;
    }

    public static boolean isStatusLocked(int n) {
        return (n & 1) != 0;
    }

    public static boolean isStatusRejected(int n) {
        return (n & 1) == 0;
    }

    public static boolean isStatusFileChanged(int n) {
        return (n & 2) != 0;
    }

    public static boolean isStatusRecordChanged(int n) {
        return (n & 4) != 0;
    }

    public static boolean isStatusErrorUnknown(int n) {
        return (n & 8) != 0;
    }

    public static boolean isStatusTooMany(int n) {
        return (n & 0x10) != 0;
    }

    @Override
    public boolean lock(long record, long size) {
        return this.writeLock(record, size);
    }

    @Override
    public boolean writeLock(long record, long size) {
        try {
            FileLock fileLock;
            if (size < 0L) {
                size = 1L;
            }
            if ((fileLock = this.getFileChannel().tryLock(record, size, false)) == null) {
                this.status = 0;
                return false;
            }
            this.setFileLock(record, fileLock);
            this.status = 1;
            return true;
        }
        catch (Throwable t) {
            this.status = 0;
            return false;
        }
    }

    @Override
    public boolean blockingReadLock(long record, long size) {
        return this.blockingReadLockTimeout(record, size, 30000L);
    }

    private boolean blockingReadLockTimeout(long record, long size, long millis) {
        try {
            if (size < 0L) {
                size = 1L;
            }
            long stopTimeMillis = System.currentTimeMillis() + millis;
            do {
                try {
                    FileLock fileLock = this.getFileChannel().tryLock(record, size, true);
                    this.setFileLock(record, fileLock);
                    if (fileLock == null) {
                        this.status = 0;
                        try {
                            Thread.sleep(33L);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    this.status = 1;
                    return true;
                }
                catch (Throwable lockException) {
                    try {
                        Thread.sleep(33L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } while (System.currentTimeMillis() < stopTimeMillis);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.status = 0;
        return false;
    }

    @Override
    public boolean blockingWriteLock(long record, long size) {
        return this.blockingWriteLockTimeout(record, size, 30000L);
    }

    public boolean blockingWriteLockTimeout(long record, long size, long millis) {
        try {
            if (size < 0L) {
                size = 1L;
            }
            long stopTimeMillis = System.currentTimeMillis() + millis;
            do {
                try {
                    FileLock fileLock = this.getFileChannel().tryLock(record, size, false);
                    if (fileLock == null) {
                        this.status = 0;
                        try {
                            Thread.sleep(33L);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    this.setFileLock(record, fileLock);
                    this.status = 1;
                    return true;
                }
                catch (Throwable lockException) {
                    try {
                        Thread.sleep(33L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            } while (System.currentTimeMillis() < stopTimeMillis);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.status = 0;
        return false;
    }

    @Override
    public boolean readLock(long record, long size) {
        try {
            FileLock fileLock;
            if (size < 0L) {
                size = 1L;
            }
            if ((fileLock = this.getFileChannel().tryLock(record, size, true)) == null) {
                this.status = 0;
                return false;
            }
            this.setFileLock(record, fileLock);
            this.status = 1;
            return true;
        }
        catch (Throwable throwable) {
            this.status = 0;
            return false;
        }
    }

    @Override
    public void writeUnlock(long record, long size) {
        try {
            this.getFileLock(record).release();
            this.removeFileLock(record);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void unlock(long record, long size) {
        this.writeUnlock(record, size);
    }

    @Override
    public void readUnlock(long record, long size) {
        try {
            this.getFileLock(record).release();
            this.removeFileLock(record);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll() {
        this.unexclusive();
        Hashtable<Long, FileLock> hashtable = this.locks;
        synchronized (hashtable) {
            Enumeration<FileLock> e = this.locks.elements();
            while (e.hasMoreElements()) {
                try {
                    e.nextElement().release();
                }
                catch (Exception exception) {}
            }
            this.locks.clear();
        }
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    @Override
    public boolean exclusive() {
        try {
            this.exclusiveLock = this.getFileChannel().tryLock();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void unexclusive() {
        if (this.exclusiveLock != null) {
            try {
                this.exclusiveLock.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.exclusiveLock = null;
        }
    }

    static {
        Class<FileChannel> clazz = FileChannel.class;
    }
}

