/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Comp1;
import com.heirloomcomputing.ecs.exec.Comp2;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.Index;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.ProcedurePointer;
import com.heirloomcomputing.ecs.exec.QuickVector;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedList;

public final class parameterList {
    private int length;
    private boolean[] byContent;
    private boolean[] needsFilling;
    private Memory[] valueMemory;
    private int[] valueAddress;
    private int[] size;
    private Memory[] origMemory;
    private int[] origAddress;
    private int[] origSize;
    private QuickVector[] origNotify;
    private Index[] indexValue;
    private Variable[] vars;
    private Object[] objectValue;
    private Object[] argsList;
    private boolean[] argsListByRef;
    private LinkedList<Object> missingList;
    private int bufferNarg = -1;
    private int max_args = 255;
    public static final int MAX_ARGS = 255;
    public static final int C_int = 0;
    public static final int C_unsigned = 1;
    public static final int C_short = 2;
    public static final int C_char = 3;
    public static final int C_long = 4;
    public static final int C_pointer = 5;
    public static final int C_void = 6;
    public static final int C_OK = 0;
    public static final int C_HALT = 1;
    public static final int C_NOTFOUND = -1;

    public Object[] toObjectArray() {
        Object[] result = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.vars[i] != null ? this.vars[i] : (this.indexValue[i] != null ? this.indexValue[i] : this.objectValue[i]);
        }
        return result;
    }

    public Serializable[] toSerializableArray() {
        Serializable[] result = new Serializable[this.length];
        for (int i = 0; i < this.length; ++i) {
            try {
                if (this.vars[i] != null) {
                    result[i] = this.vars[i];
                    continue;
                }
                if (this.indexValue[i] != null) {
                    result[i] = this.indexValue[i];
                    continue;
                }
                result[i] = (Serializable)this.objectValue[i];
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean[] toConventionArray() {
        boolean[] result = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = !this.byContent[i];
        }
        return result;
    }

    public parameterList() {
        this(255);
    }

    public parameterList(int maxArgs) {
        this.initSize(maxArgs);
    }

    public parameterList(Object[] args) {
        this(null, args);
    }

    public parameterList(Object[] args, boolean[] byRef) {
        int length = args.length;
        int max_args = args != null ? length : 0;
        this.initSize(max_args);
        if (args != null) {
            int setter;
            int byRefLength = byRef != null ? byRef.length : 0;
            for (setter = 0; setter < byRefLength; ++setter) {
                this.byContent[setter] = !byRef[setter];
            }
            while (setter < length) {
                this.byContent[setter] = true;
                ++setter;
            }
            for (int i = 0; i < length; ++i) {
                this.add(args[i], this.byContent[i]);
            }
        }
    }

    public parameterList(boolean[] byRef, Object[] args) {
        this(args, byRef);
        this.argsList = args;
        this.argsListByRef = byRef;
    }

    private void initSize(int maxArgs) {
        this.max_args = maxArgs;
        this.byContent = new boolean[this.max_args];
        this.needsFilling = new boolean[this.max_args];
        this.valueMemory = new Memory[this.max_args];
        this.valueAddress = new int[this.max_args];
        this.indexValue = new Index[this.max_args];
        this.size = new int[this.max_args];
        this.vars = new Variable[this.max_args];
        this.objectValue = new Object[this.max_args];
        this.origMemory = new Memory[this.max_args];
        this.origNotify = new QuickVector[this.max_args];
        this.origAddress = new int[this.max_args];
        this.origSize = new int[this.max_args];
        this.missingList = null;
    }

    public boolean isCallFromJava() {
        return this.getArgsListByRef() != null && this.getArgsList() != null;
    }

    public void completeJavaCall(Variable[] linkageVars) {
        for (int i = 0; i < this.getArgsList().length; ++i) {
            try {
                if (!this.getArgsListByRef()[i]) continue;
                Object arg = this.getArgsList()[i];
                Variable linkageVar = linkageVars[i];
                if (linkageVar == null) {
                    this.replaceArgsListItem(i, null);
                    continue;
                }
                if (arg == null) {
                    this.replaceArgsListItem(i, linkageVar);
                    continue;
                }
                if (arg instanceof String) {
                    this.replaceArgsListItem(i, linkageVar.toDisplayString());
                    continue;
                }
                if (arg instanceof Number) {
                    if (arg instanceof Byte) {
                        this.replaceArgsListItem(i, new Byte(linkageVar.toByte()));
                        continue;
                    }
                    if (arg instanceof Short) {
                        this.replaceArgsListItem(i, new Short(linkageVar.toShort()));
                        continue;
                    }
                    if (arg instanceof Integer) {
                        this.replaceArgsListItem(i, new Integer(linkageVar.toInt()));
                        continue;
                    }
                    if (arg instanceof Long) {
                        this.replaceArgsListItem(i, new Long(linkageVar.toLong()));
                        continue;
                    }
                    if (arg instanceof Float) {
                        this.replaceArgsListItem(i, new Float(linkageVar.toFloat()));
                        continue;
                    }
                    if (arg instanceof Double) {
                        this.replaceArgsListItem(i, new Double(linkageVar.toDouble()));
                        continue;
                    }
                    if (!(arg instanceof BigDecimal)) continue;
                    this.replaceArgsListItem(i, new BigDecimal(linkageVar.toNumericString()));
                    continue;
                }
                if (arg instanceof Boolean) {
                    this.replaceArgsListItem(i, new Boolean(linkageVar.toBoolean()));
                    continue;
                }
                if (arg instanceof IDatatype) {
                    ((IDatatype)this.getArgsList()[i]).fromDatatype(linkageVar);
                    continue;
                }
                if (arg instanceof byte[]) {
                    this.replaceArgsListItem(i, linkageVar.toByteArray());
                    continue;
                }
                this.replaceArgsListItem(i, linkageVar);
                continue;
            }
            catch (Exception argumentRestoreException) {
                this.replaceArgsListItem(i, null);
            }
        }
    }

    public void setBufferNarg(int value) {
        this.bufferNarg = value;
    }

    public int getBufferNarg() {
        return this.bufferNarg;
    }

    public final boolean isIndex(int n) {
        if (n > this.length || n < 0) {
            return false;
        }
        if (this.indexValue[n] == null) {
            return false;
        }
        return this.valueMemory[n] == null;
    }

    public boolean isVariable(int parameterIndex) {
        this.checkParameter(parameterIndex);
        return this.valueMemory[parameterIndex] != null && this.indexValue[parameterIndex] == null;
    }

    public final Index getIndex(int n) {
        if (n > this.length || n < 0) {
            return null;
        }
        if (this.valueMemory[n] != null) {
            return null;
        }
        return this.indexValue[n];
    }

    public final Variable getVariable(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return new Variable(String.valueOf(this.indexValue[parameterIndex].toInt()));
        }
        if (this.vars[parameterIndex] != null) {
            this.vars[parameterIndex].flushToMemory();
            return this.vars[parameterIndex];
        }
        return new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
    }

    public final int getPointerAddress(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return 0;
        }
        return this.valueAddress[parameterIndex];
    }

    public final Memory getPointerMemory(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return null;
        }
        return this.valueMemory[parameterIndex];
    }

    public void setVariable(int index, Variable v) {
        this.expandParameter(index);
        this.vars[index] = v;
    }

    public final Memory getMemory(int n) {
        if (n > this.length || n < 0) {
            return null;
        }
        try {
            return this.valueMemory[n];
        }
        catch (Exception e) {
            return null;
        }
    }

    public final int getAddress(int n) {
        if (n > this.length || n < 0) {
            return 0;
        }
        try {
            return this.valueAddress[n];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public final byte[] getByteArray(int n) {
        if (n > this.length || n < 0) {
            return null;
        }
        if (this.objectValue[n] instanceof byte[]) {
            return (byte[])this.objectValue[n];
        }
        Variable v = this.vars[n];
        if (v != null) {
            return v.toByteArray();
        }
        Memory pMemory = this.valueMemory[n];
        if (pMemory != null) {
            int address = this.valueAddress[n];
            int length = pMemory.getTopOfMemory() - address;
            byte[] result = new byte[length];
            pMemory.copy(address, result, 0, length);
            return result;
        }
        return null;
    }

    public void set(int parameterIndex, Variable value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, Variable value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public final basicFile getFile(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.objectValue[parameterIndex] == null) {
            return null;
        }
        if (this.objectValue[parameterIndex] instanceof basicFile) {
            try {
                return (basicFile)this.objectValue[parameterIndex];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public final void add(Object object, boolean byContent) {
        if (object == null) {
            this.addOmitted(byContent);
        } else if (object instanceof IDatatype) {
            if (object instanceof Variable) {
                this.add((Variable)object, byContent);
            } else if (object instanceof Index) {
                this.add((Index)object, byContent);
            } else {
                this.add(((IDatatype)object).toText());
            }
        } else if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                this.add((BigDecimal)object);
            } else if (object instanceof Byte) {
                this.add((Byte)object);
            } else if (object instanceof Short) {
                this.add((Short)object);
            } else if (object instanceof Integer) {
                this.add((Integer)object);
            } else if (object instanceof Long) {
                this.add((Long)object);
            } else if (object instanceof Float) {
                this.add(((Float)object).floatValue());
            } else if (object instanceof Double) {
                this.add((Double)object);
            }
        } else if (object instanceof Boolean) {
            this.add((Boolean)object);
        } else {
            this.objectValue[this.length] = object;
            ++this.length;
        }
    }

    public final void add(Object object) {
        this.add(object, true);
    }

    public final void add(Variable v, boolean content, int itemSize) {
        v.flushToMemory();
        this.byContent[this.length] = content;
        this.valueMemory[this.length] = v.pointerMemory;
        this.valueAddress[this.length] = v.pointerAddress;
        this.size[this.length] = itemSize;
        this.vars[this.length] = v;
        ++this.length;
    }

    public final void add(Index i, boolean content, int itemSize) {
        this.byContent[this.length] = content;
        this.valueMemory[this.length] = null;
        this.valueAddress[this.length] = 0;
        this.indexValue[this.length] = i;
        this.size[this.length] = itemSize;
        ++this.length;
    }

    public final void add(Variable v, boolean content) {
        this.add(v, content, v.length());
    }

    public final void add(Variable v) {
        this.add(v, true, v.length());
    }

    public final void add(Index i, boolean content) {
        this.add(i, content, 0);
    }

    public final void add(Index i) {
        this.add(i, true, 0);
    }

    public final void add(basicFile f, boolean content) {
        this.objectValue[this.length] = f;
        ++this.length;
    }

    public final void add(basicFile f) {
        this.objectValue[this.length] = f;
        ++this.length;
    }

    public final void add(ProcedurePointer object, boolean content) {
        this.objectValue[this.length] = object;
        ++this.length;
    }

    public final void add(ProcedurePointer object) {
        this.objectValue[this.length] = object;
        ++this.length;
    }

    public int getVarsSize() {
        if (this.vars != null) {
            return this.vars.length;
        }
        return 0;
    }

    public final void add(byte value) {
        this.add(new Numeric(value));
    }

    public final void add(short value) {
        this.add(new Numeric(value));
    }

    public final void add(int value) {
        this.add(new Numeric(value));
    }

    public final void add(long value) {
        this.add(new Numeric(value));
    }

    public final void add(float value) {
        this.add(new Comp1(value));
    }

    public final void add(double value) {
        this.add(new Comp2(value));
    }

    public final void add(char value) {
        this.add(new Variable(String.valueOf(value)));
    }

    public final void add(boolean value) {
        this.add(new Numeric(value));
    }

    public final void add(String value) {
        this.add(new Variable(value));
    }

    public final void add(BigDecimal value) {
        this.add(new Numeric(value.toString()));
    }

    final Memory getOrigMemory(int parameterIndex) {
        return this.origMemory[parameterIndex];
    }

    final void setOrigMemory(int parameterIndex, Memory m) {
        this.expandParameter(parameterIndex);
        this.origMemory[parameterIndex] = m;
    }

    final QuickVector getOrigNotify(int parameterIndex) {
        return this.origNotify[parameterIndex];
    }

    final void setOrigNotify(int parameterIndex, QuickVector notify) {
        this.expandParameter(parameterIndex);
        this.origNotify[parameterIndex] = notify;
    }

    final int getOrigAddress(int parameterIndex) {
        return this.origAddress[parameterIndex];
    }

    final void setOrigAddress(int parameterIndex, int addr) {
        this.expandParameter(parameterIndex);
        this.origAddress[parameterIndex] = addr;
    }

    final int getOrigSize(int parameterIndex) {
        return this.origSize[parameterIndex];
    }

    final void setOrigSize(int parameterIndex, int size) {
        this.expandParameter(parameterIndex);
        this.origSize[parameterIndex] = size;
    }

    private final void checkParameter(int parameterIndex) {
        if (parameterIndex >= this.length || parameterIndex < 0) {
            throw new IllegalArgumentException("Parameter to get must be 0<=n<length_of_parameter_list (" + this.length + ")");
        }
    }

    private final void expandParameter(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex >= this.max_args) {
            throw new IllegalArgumentException("Parameter to set must be 0<=n<length_of_parameter_list (" + this.length + ")");
        }
        if (parameterIndex < this.length) {
            return;
        }
        this.length = parameterIndex + 1;
    }

    public final void addOmitted(boolean content) {
        this.byContent[this.length] = content;
        this.valueMemory[this.length] = null;
        this.valueAddress[this.length] = 0;
        this.size[this.length] = 0;
        ++this.length;
    }

    public final void addOmitted() {
        this.byContent[this.length] = true;
        this.valueMemory[this.length] = null;
        this.valueAddress[this.length] = 0;
        this.size[this.length] = 0;
        ++this.length;
    }

    public final void addNull(boolean content) {
        this.addOmitted(content);
    }

    public final void addNull() {
        this.addOmitted(true);
    }

    public boolean isOmitted(int parameterIndex) {
        try {
            this.checkParameter(parameterIndex);
            return this.valueMemory[parameterIndex] == null && this.vars[parameterIndex] == null && this.indexValue[parameterIndex] == null && this.objectValue[parameterIndex] == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isNull(int parameterIndex) {
        return this.isOmitted(parameterIndex);
    }

    public void addMissing(int index, Object formalParmMemory) {
        if (this.missingList == null) {
            this.missingList = new LinkedList();
        }
        this.missingList.add(index - this.length, formalParmMemory);
    }

    public Object getMissing(int index) {
        if (this.missingList == null || index < this.length || index >= this.length + this.missingList.size()) {
            return null;
        }
        return this.missingList.get(index - this.length);
    }

    public boolean isMissing(int index) {
        if (this.missingList == null) {
            return false;
        }
        return index >= this.length && index < this.missingList.size() + this.length;
    }

    public int numberMissing() {
        if (this.missingList == null) {
            return 0;
        }
        return this.missingList.size();
    }

    public void clearMissing() {
        if (this.missingList != null) {
            this.missingList.clear();
        }
    }

    public final boolean byContent(int parameterIndex) {
        if (parameterIndex > this.length || parameterIndex < 0) {
            return false;
        }
        return this.byContent[parameterIndex];
    }

    public final boolean isByContent(int n) {
        if (n > this.length || n < 0) {
            return true;
        }
        return this.byContent[n];
    }

    public final boolean isByReference(int n) {
        if (n > this.length || n < 0) {
            return false;
        }
        return !this.byContent[n];
    }

    public final boolean byReference(int n) {
        try {
            if (this.needsFilling[n]) {
                this.getVariable(n).fillFromMemory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = this.needsFilling[n] = !this.needsFilling[n];
        if (n > this.length || n < 0) {
            return false;
        }
        return !this.byContent[n];
    }

    public final int getSize(int n) {
        if (n > this.length || n < 0) {
            return 0;
        }
        return this.size[n];
    }

    public final int getMaxSize(int n) {
        if (n > this.length || n < 0) {
            return 0;
        }
        if (this.vars[n] != null && this.vars[n].maxItemSize != -1000) {
            return this.vars[n].maxItemSize;
        }
        return this.size[n];
    }

    public final int getLength() {
        return this.length;
    }

    public final int size() {
        return this.length;
    }

    public final int count() {
        return this.length;
    }

    public final int getInt(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return this.indexValue[parameterIndex].toInt();
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toInt();
        }
        return new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]).toInt();
    }

    public byte[] getArgument(int parameterIndex) {
        try {
            this.checkParameter(parameterIndex);
            if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
                return ConvertData.nativeIntToBytes(this.indexValue[parameterIndex].toInt());
            }
            if (this.vars[parameterIndex] != null) {
                return this.vars[parameterIndex].getArgument();
            }
            if (this.valueMemory[parameterIndex] != null) {
                return ConvertData.nativeIntToBytes(this.valueAddress[parameterIndex]);
            }
            if (this.objectValue[parameterIndex] != null) {
                return ConvertData.nativeIntToBytes(this.objectValue[parameterIndex].hashCode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public long getMemoryAddress(int parameterIndex) {
        try {
            this.checkParameter(parameterIndex);
            if (this.vars[parameterIndex] != null) {
                return this.vars[parameterIndex].getMemory().getMemoryBasePointer() + (long)this.vars[parameterIndex].getAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public void setArgument(int parameterIndex, byte[] data) {
        if (this.byContent[parameterIndex]) {
            return;
        }
        this.setArgumentValue(parameterIndex, data);
    }

    public void setArgumentValue(int parameterIndex, byte[] data) {
        try {
            this.expandParameter(parameterIndex);
            if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
                this.indexValue[parameterIndex].setTo(ConvertData.nativeBytesToInt(data));
                return;
            }
            if (this.vars[parameterIndex] != null) {
                this.vars[parameterIndex].setArgument(data);
                return;
            }
            if (this.valueMemory[parameterIndex] != null) {
                this.valueAddress[parameterIndex] = ConvertData.nativeBytesToInt(data);
                return;
            }
            if (this.objectValue[parameterIndex] == null) {
                this.objectValue[parameterIndex] = data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isByteArray(int parameterIndex) {
        return this.objectValue[parameterIndex] instanceof byte[];
    }

    public final char getChar(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return (char)this.indexValue[parameterIndex].toInt();
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toChar();
        }
        Variable result = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        return result.toChar();
    }

    public final boolean getBoolean(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return this.indexValue[parameterIndex].toInt() != 0;
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toBoolean();
        }
        Variable result = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        return result.toBoolean();
    }

    public final byte getByte(int parameterIndex) {
        return (byte)this.getInt(parameterIndex);
    }

    public final short getShort(int parameterIndex) {
        return (short)this.getInt(parameterIndex);
    }

    public final long getLong(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return this.indexValue[parameterIndex].toInt();
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toLong();
        }
        return new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]).toLong();
    }

    public final float getFloat(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return this.indexValue[parameterIndex].toInt();
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toFloat();
        }
        Variable result = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        return result.toFloat();
    }

    public final double getDouble(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return this.indexValue[parameterIndex].toInt();
        }
        if (this.vars[parameterIndex] != null) {
            return this.vars[parameterIndex].toDouble();
        }
        Variable result = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        return result.toDouble();
    }

    public final int[] getIntArray(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return new int[]{this.indexValue[parameterIndex].toInt()};
        }
        Variable v = this.vars[parameterIndex] != null ? this.vars[parameterIndex] : new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        int limit = v.occurs();
        int[] result = new int[limit];
        Variable element = null;
        for (int i = 0; i < limit; ++i) {
            element = v.subscript(i);
            result[i] = element.toInt();
            element.releaseSubscript();
        }
        return result;
    }

    public final double[] getDoubleArray(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return new double[]{this.indexValue[parameterIndex].toInt()};
        }
        Variable v = this.vars[parameterIndex] != null ? this.vars[parameterIndex] : new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        int limit = v.occurs();
        double[] result = new double[limit];
        Variable element = null;
        for (int i = 0; i < limit; ++i) {
            element = v.subscript(i);
            result[i] = element.toDouble();
            element.releaseSubscript();
        }
        return result;
    }

    public final String getString(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return String.valueOf(this.indexValue[parameterIndex].toInt());
        }
        Variable v = null;
        if (this.vars[parameterIndex] != null) {
            v = this.vars[parameterIndex];
        } else if (this.valueMemory[parameterIndex] != null) {
            v = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        } else if (this.objectValue[parameterIndex] != null) {
            return this.objectValue[parameterIndex].toString();
        }
        return v.toString();
    }

    public final String getDisplayString(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return String.valueOf(this.indexValue[parameterIndex].toInt());
        }
        Variable v = null;
        if (this.vars[parameterIndex] != null) {
            v = this.vars[parameterIndex];
        } else if (this.valueMemory[parameterIndex] != null) {
            v = new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        } else if (this.objectValue[parameterIndex] != null) {
            return this.objectValue[parameterIndex].toString();
        }
        return v.toDisplayString();
    }

    public final String[] getDisplayStringArray() {
        String[] strs = new String[this.length];
        for (int i = 0; i < this.length; ++i) {
            strs[i] = this.getDisplayString(i);
        }
        return strs;
    }

    public final Object getObject(int parameterIndex) {
        this.checkParameter(parameterIndex);
        Object object = this.objectValue[parameterIndex];
        if (object != null) {
            return object;
        }
        object = this.vars[parameterIndex];
        if (object != null) {
            return object;
        }
        object = this.indexValue[parameterIndex];
        if (object != null) {
            return object;
        }
        object = this.valueMemory[parameterIndex];
        if (object != null) {
            return object;
        }
        return null;
    }

    public final String[] getStringArray(int parameterIndex) {
        this.checkParameter(parameterIndex);
        if (this.valueMemory[parameterIndex] == null && this.indexValue[parameterIndex] != null) {
            return new String[]{String.valueOf(this.indexValue[parameterIndex].toInt())};
        }
        Variable v = this.vars[parameterIndex] != null ? this.vars[parameterIndex] : new Variable(this.valueMemory[parameterIndex], this.valueAddress[parameterIndex], this.size[parameterIndex]);
        int limit = v.occurs();
        String[] result = new String[limit];
        Variable element = null;
        for (int i = 0; i < limit; ++i) {
            element = v.subscript(i);
            result[i] = element.toString();
            element.releaseSubscript();
        }
        return result;
    }

    public void setParameter(int parameterIndex, String value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, String value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, byte value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, byte value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, short value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, short value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, int value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void setParameter(int parameterIndex, boolean value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, int value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, long value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, long value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, float value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, float value) {
        this.setParameter(parameterIndex, value);
    }

    public void setParameter(int parameterIndex, double value) {
        this.expandParameter(parameterIndex);
        this.getVariable(parameterIndex).move(value);
    }

    public void set(int parameterIndex, double value) {
        this.setParameter(parameterIndex, value);
    }

    public int getArgumentType(int n) {
        return this.vars[n] != null ? this.vars[n].getArgumentType() : -1;
    }

    public int getNumericDigits(int n) {
        int info = this.getNumericInfo(n);
        return info & 0xFF;
    }

    public int getNumericScale(int n) {
        int info = this.getNumericInfo(n);
        return info >> 8;
    }

    public int getNumericInfo(int n) {
        return this.vars[n] != null ? this.vars[n].getNumericInfo() : 0;
    }

    private Object[] getArgsList() {
        return this.argsList;
    }

    private void replaceArgsListItem(int i, Object o) {
        this.getArgsList()[i] = o;
    }

    private boolean[] getArgsListByRef() {
        return this.argsListByRef;
    }
}

