/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.block;

public class recordBlock
extends block {
    public static final boolean debugMode = false;
    private boolean keyArrayIsSetup = false;
    private boolean[] keyArray = null;
    private int[] indexArray = null;

    public static void debug(String text) {
        Utilities.debugOutput("recordBlock: " + text);
    }

    public recordBlock(int dataSize) {
        super(dataSize);
        this.setNumberOfRecords(0);
        this.index = 1;
    }

    public recordBlock() {
        this.setNumberOfRecords(0);
        this.index = 1;
    }

    @Override
    public final void setData(byte[] data, int offset, int len) {
        super.setData(data, offset, len);
        this.keyArrayIsSetup = false;
    }

    private final boolean setNumberOfRecords(int numberOfRecords) {
        if (numberOfRecords < 0 || numberOfRecords > 255) {
            return false;
        }
        this.data[0] = (byte)(numberOfRecords - 128);
        return true;
    }

    public final int getNumberOfRecords() {
        int numberOfRecords = this.data[0] + 128;
        return numberOfRecords;
    }

    private final int searchForIndex(int findKey, int numberOfRecords) {
        int curIndex = 1;
        for (int count = 0; count < numberOfRecords; ++count) {
            int key = this.data[curIndex] + 128;
            if (key == findKey) {
                return curIndex;
            }
            int length = (this.data[curIndex + 4] & 0xFF) << 24 | (this.data[curIndex + 3] & 0xFF) << 16 | (this.data[curIndex + 2] & 0xFF) << 8 | this.data[curIndex + 1] & 0xFF;
            curIndex = curIndex + 5 + length;
        }
        return -1;
    }

    private final void setupKeyArray(int numberOfRecords) {
        if (this.indexArray == null) {
            this.keyArray = new boolean[256];
            this.indexArray = new int[256];
        } else {
            for (int i = 0; i < 256; ++i) {
                this.keyArray[i] = false;
                this.indexArray[i] = 0;
            }
        }
        this.index = 1;
        for (int count = 0; count < numberOfRecords; ++count) {
            int key = this.data[this.index] + 128;
            this.keyArray[key] = true;
            this.indexArray[key] = this.index;
            int length = (this.data[this.index + 4] & 0xFF) << 24 | (this.data[this.index + 3] & 0xFF) << 16 | (this.data[this.index + 2] & 0xFF) << 8 | this.data[this.index + 1] & 0xFF;
            this.index += 5 + length;
        }
        this.keyArrayIsSetup = true;
    }

    private final int addKey() {
        int count;
        int numberOfRecords = this.getNumberOfRecords();
        if (numberOfRecords == 255) {
            return -1;
        }
        if (!this.keyArrayIsSetup) {
            this.setupKeyArray(numberOfRecords);
        }
        for (count = 0; count < numberOfRecords && this.keyArray[count]; ++count) {
        }
        if (count == 256) {
            return -1;
        }
        this.keyArray[count] = true;
        this.setNumberOfRecords(numberOfRecords + 1);
        return count;
    }

    private final int getIndex(int key) {
        int index;
        if (key < 0 || key > 255) {
            return -1;
        }
        if (!this.keyArrayIsSetup) {
            this.setupKeyArray(this.getNumberOfRecords());
        }
        if ((index = this.indexArray[key]) == 0) {
            return -1;
        }
        return index;
    }

    private final int getRecordNumberIndex(int recordNumber) {
        int numberOfRecords = this.getNumberOfRecords();
        if (numberOfRecords == 0) {
            return -1;
        }
        if (recordNumber < 0 || recordNumber >= numberOfRecords) {
            return -1;
        }
        int curIndex = 1;
        for (int count = 0; count < recordNumber; ++count) {
            int length = ConvertData.bytesToInt(this.data, curIndex + 1);
            curIndex = curIndex + 5 + length;
        }
        return curIndex;
    }

    private final int getRecordNumberKey(int recordNumber) {
        int curIndex = this.getRecordNumberIndex(recordNumber);
        if (curIndex < 0) {
            return curIndex;
        }
        return this.data[curIndex] + 128;
    }

    public final byte[] getRecord(int key) {
        int curIndex = -1;
        if (!this.keyArrayIsSetup) {
            int numRecords = this.getNumberOfRecords();
            if (numRecords < 6) {
                curIndex = this.searchForIndex(key, numRecords);
            } else {
                this.setupKeyArray(numRecords);
                curIndex = this.getIndex(key);
            }
        } else {
            curIndex = this.getIndex(key);
        }
        if (curIndex < 0) {
            return null;
        }
        int length = (this.data[curIndex + 4] & 0xFF) << 24 | (this.data[curIndex + 3] & 0xFF) << 16 | (this.data[curIndex + 2] & 0xFF) << 8 | this.data[curIndex + 1] & 0xFF;
        byte[] tempRecord = new byte[length];
        System.arraycopy(this.data, curIndex + 5, tempRecord, 0, length);
        return tempRecord;
    }

    public final byte[] getRecordNumber(int recordNumber) {
        int curIndex = this.getRecordNumberIndex(recordNumber);
        if (curIndex < 0) {
            return null;
        }
        int length = ConvertData.bytesToInt(this.data, curIndex + 1);
        byte[] tempRecord = new byte[length];
        System.arraycopy(this.data, curIndex + 5, tempRecord, 0, length);
        return tempRecord;
    }

    public final int addRecord(byte[] newRecord) {
        return this.addRecord(newRecord, 0, newRecord.length);
    }

    public final int addRecord(byte[] newRecord, int offset, int length) {
        if (!this.isFree(length)) {
            return -1;
        }
        int key = this.addKey();
        if (key < 0) {
            return key;
        }
        if (this.index <= 0) {
            return -1;
        }
        this.data[this.index] = (byte)(key - 128);
        int value = length;
        this.data[this.index + 1] = (byte)(value & 0xFF);
        this.data[this.index + 2] = (byte)(value >> 8 & 0xFF);
        this.data[this.index + 3] = (byte)(value >> 16 & 0xFF);
        this.data[this.index + 4] = (byte)(value >> 24 & 0xFF);
        System.arraycopy(newRecord, offset, this.data, this.index + 5, length);
        this.indexArray[key] = this.index;
        this.index = this.index + 5 + length;
        return key;
    }

    public final boolean deleteRecord(int key) {
        int curIndex;
        if (key < 0 || key > 255) {
            return false;
        }
        int numberOfRecords = this.getNumberOfRecords();
        if (!this.keyArrayIsSetup) {
            this.setupKeyArray(numberOfRecords);
        }
        if ((curIndex = this.getIndex(key)) < 0) {
            return false;
        }
        int length = ConvertData.bytesToInt(this.data, curIndex + 1);
        int dif = length + 5;
        for (int count = curIndex + dif; count < this.index; ++count) {
            this.data[curIndex] = this.data[count];
            ++curIndex;
        }
        this.index = curIndex;
        this.keyArray[key] = false;
        this.indexArray[key] = 0;
        this.setNumberOfRecords(numberOfRecords - 1);
        this.keyArrayIsSetup = false;
        return true;
    }

    public final boolean updateRecord(byte[] curRecord, int key) {
        int curIndex;
        if (key < 0 || key > 255) {
            return false;
        }
        int numberOfRecords = this.getNumberOfRecords();
        if (!this.keyArrayIsSetup) {
            this.setupKeyArray(numberOfRecords);
        }
        if ((curIndex = this.getIndex(key)) < 0) {
            return false;
        }
        int length = ConvertData.bytesToInt(this.data, curIndex + 1);
        if (curRecord.length > length) {
            int dif = curRecord.length - length;
            for (int tempIndex = this.index + dif; tempIndex > curIndex + 5 + length; --tempIndex) {
                this.data[tempIndex] = this.data[tempIndex - dif];
            }
            this.data[curIndex + 1] = (byte)(curRecord.length & 0xFF);
            this.data[curIndex + 2] = (byte)(curRecord.length >> 8 & 0xFF);
            this.data[curIndex + 3] = (byte)(curRecord.length >> 16 & 0xFF);
            this.data[curIndex + 4] = (byte)(curRecord.length >> 24 & 0xFF);
            System.arraycopy(curRecord, 0, this.data, curIndex + 5, curRecord.length);
            this.index += dif;
            this.keyArrayIsSetup = false;
        } else if (curRecord.length < length) {
            int dif = length - curRecord.length;
            for (int tempIndex = curIndex + 5 + curRecord.length; tempIndex == this.index - dif; ++tempIndex) {
                this.data[tempIndex] = this.data[tempIndex + dif];
            }
            this.data[curIndex + 1] = (byte)(curRecord.length & 0xFF);
            this.data[curIndex + 2] = (byte)(curRecord.length >> 8 & 0xFF);
            this.data[curIndex + 3] = (byte)(curRecord.length >> 16 & 0xFF);
            this.data[curIndex + 4] = (byte)(curRecord.length >> 24 & 0xFF);
            System.arraycopy(curRecord, 0, this.data, curIndex + 5, curRecord.length);
            this.index -= dif;
            this.keyArrayIsSetup = false;
        } else {
            System.arraycopy(curRecord, 0, this.data, curIndex + 5, length);
        }
        return true;
    }

    public final boolean updateRecordNumber(byte[] curRecord, int recordNumber) {
        int key = this.getRecordNumberKey(recordNumber);
        if (key < 0) {
            return false;
        }
        return this.updateRecord(curRecord, key);
    }

    public final boolean isFree(int length) {
        return this.index + 5 + length <= this.data.length;
    }

    @Override
    public final block copy() {
        recordBlock myBlock = new recordBlock(this.data.length);
        myBlock.nextBlock = this.nextBlock;
        myBlock.lastBlock = this.lastBlock;
        myBlock.index = this.index;
        myBlock.status = this.status;
        myBlock.reserved = this.reserved;
        System.arraycopy(this.data, 0, myBlock.data, 0, this.data.length);
        System.arraycopy(this.tempBlock, 0, myBlock.tempBlock, 0, this.tempBlock.length);
        myBlock.keyArrayIsSetup = false;
        myBlock.isDirty = this.isDirty;
        return myBlock;
    }

    @Override
    public final void clear() {
        this.nextBlock = -1L;
        this.lastBlock = -1L;
        this.index = 1;
        this.status = 0;
        int length = this.data.length;
        this.data = new byte[length];
        this.setNumberOfRecords(0);
        this.keyArrayIsSetup = false;
        this.isDirty = false;
        this.priority = 0;
        this.location = 0L;
        this.referenceCount = 0;
    }

    @Override
    public String toString() {
        String text = super.toString();
        String lineSep = RuntimeEnvironment.getGlobalParameter("line.separator");
        int numberOfRecords = this.getNumberOfRecords();
        text = text + "Number of records: " + numberOfRecords + lineSep;
        if (!this.keyArrayIsSetup) {
            this.setupKeyArray(numberOfRecords);
        }
        int curIndex = 1;
        for (int count = 0; count < numberOfRecords; ++count) {
            int length = (this.data[curIndex + 4] & 0xFF) << 24 | (this.data[curIndex + 3] & 0xFF) << 16 | (this.data[curIndex + 2] & 0xFF) << 8 | this.data[curIndex + 1] & 0xFF;
            curIndex = curIndex + 5 + length;
        }
        return text;
    }
}

