/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.block;
import com.heirloomcomputing.ecs.exec.blockFile;
import com.heirloomcomputing.ecs.exec.recordBlock;

public class recordBlockFile
extends blockFile {
    private long partialBlockRoot = 0L;
    private long fullBlockRoot = -1L;
    private int fullThreshold = -1;
    private int blockDataSize = 0;
    private byte[] recordExtendedHeader = null;
    private static final float fullThresholdPercent = 0.85f;

    public static void debug(String text) {
        System.out.println("recordBlockFile: " + text);
    }

    public recordBlockFile(byte majorVersion, byte minorVersion, short headerSize, int blockSize, byte[] extendedHeader, LockRecord dataLockRecord, LockRecord idxLockRecord) {
        super(majorVersion, minorVersion, blockSize, new recordBlock(blockSize - 32), (short)(headerSize + 20));
        this.setLockRecords(dataLockRecord, idxLockRecord);
        this.blockDataSize = blockSize - 32;
        this.fullThreshold = (int)((float)this.blockDataSize * 0.85f);
        this.recordExtendedHeader = this.getUpdatedHeader(extendedHeader);
        super.setExtendedHeader(this.recordExtendedHeader);
    }

    public final byte[] getUpdatedHeader(byte[] extendedHeader) {
        int length = extendedHeader == null ? 20 : extendedHeader.length + 20;
        byte[] newHeader = null;
        if (this.recordExtendedHeader != null && this.recordExtendedHeader.length == length) {
            newHeader = this.recordExtendedHeader;
        } else {
            newHeader = new byte[length];
            this.recordExtendedHeader = newHeader;
        }
        recordBlockFile.setBytesFromLong(newHeader, 0, this.partialBlockRoot);
        recordBlockFile.setBytesFromLong(newHeader, 8, this.fullBlockRoot);
        recordBlockFile.setBytesFromInt(newHeader, 16, this.fullThreshold);
        if (length > 20) {
            System.arraycopy(extendedHeader, 0, newHeader, 20, extendedHeader.length);
        }
        return newHeader;
    }

    private final void setExtendedHeader() {
        this.recordExtendedHeader = super.getExtendedHeader();
        recordBlockFile.setBytesFromLong(this.recordExtendedHeader, 0, this.partialBlockRoot);
        recordBlockFile.setBytesFromLong(this.recordExtendedHeader, 8, this.fullBlockRoot);
        recordBlockFile.setBytesFromInt(this.recordExtendedHeader, 16, this.fullThreshold);
        super.setExtendedHeader(this.recordExtendedHeader);
    }

    @Override
    public final void setExtendedHeader(byte[] extendedHeader) {
        super.setExtendedHeader(this.getUpdatedHeader(extendedHeader));
    }

    @Override
    public final int updateHeaderInformation() {
        return super.updateHeaderInformation();
    }

    @Override
    public final byte[] getExtendedHeader() {
        byte[] extendedHeader = super.getExtendedHeader();
        this.recordExtendedHeader = extendedHeader;
        this.partialBlockRoot = recordBlockFile.getLongFromBytes(extendedHeader, 0);
        this.fullBlockRoot = recordBlockFile.getLongFromBytes(extendedHeader, 8);
        this.fullThreshold = recordBlockFile.getIntFromBytes(extendedHeader, 16);
        byte[] newHeader = new byte[extendedHeader.length - 20];
        System.arraycopy(extendedHeader, 20, newHeader, 0, newHeader.length);
        return newHeader;
    }

    public final int getBlockDataSize() {
        return this.blockDataSize;
    }

    @Override
    public final int open(int mode) {
        int returnCode = super.open(mode);
        if (returnCode != 0) {
            return returnCode;
        }
        if (!this.isNewFile()) {
            this.getExtendedHeader();
        }
        return returnCode;
    }

    public final long findRecordBlock(int length) {
        long myBlockNumber = 0L;
        if (!this.isWritable()) {
            this.warning("recordBlockFile.findRecordBlock", "invalid operaiton, file not open for output");
            return -48L;
        }
        block currentBlock = null;
        if (this.partialBlockRoot >= 0L) {
            if (length < this.fullThreshold) {
                myBlockNumber = this.partialBlockRoot;
                do {
                    if ((currentBlock = this.allocateBlock(myBlockNumber)) == null) {
                        return -1L;
                    }
                    if (((recordBlock)currentBlock).isFree(length)) {
                        this.deallocateBlock(currentBlock);
                        return myBlockNumber;
                    }
                    myBlockNumber = currentBlock.getNextBlock();
                    this.deallocateBlock(currentBlock);
                } while (myBlockNumber >= 0L);
            }
            long tempBlockNumber = this.partialBlockRoot;
            currentBlock = this.allocateBlock();
            if (currentBlock == null) {
                return -1L;
            }
            currentBlock.setLastBlock(-1L);
            currentBlock.setNextBlock(this.partialBlockRoot);
            long curIndex = currentBlock.getLocation();
            if (!this.deallocateBlock(currentBlock, true)) {
                return -1L;
            }
            this.partialBlockRoot = curIndex;
            if (tempBlockNumber >= 0L) {
                currentBlock = this.allocateBlock(tempBlockNumber);
                if (currentBlock == null) {
                    return -1L;
                }
                currentBlock.setLastBlock(this.partialBlockRoot);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1L;
                }
            }
            this.setExtendedHeader();
            return this.partialBlockRoot;
        }
        currentBlock = this.allocateBlock();
        if (currentBlock == null) {
            return -1L;
        }
        long location = currentBlock.getLocation();
        if (!this.deallocateBlock(currentBlock, true)) {
            return -1L;
        }
        this.partialBlockRoot = location;
        this.setExtendedHeader();
        return this.partialBlockRoot;
    }

    public final int addRecord(long blockNumber, byte[] data) {
        return this.addRecord(blockNumber, data, 0, data.length);
    }

    public final int addRecord(long blockNumber, byte[] data, int offset, int length) {
        int key;
        boolean inFull = false;
        if (!this.isWritable()) {
            this.warning("recordBlockFile.addRecord", "invalid operaiton, file not open for output");
            return -48;
        }
        if (blockNumber < 0L) {
            return -1;
        }
        block currentBlock = this.allocateBlock(blockNumber);
        if (currentBlock == null) {
            return -1;
        }
        if (currentBlock.getIndex() >= this.fullThreshold) {
            inFull = true;
        }
        if ((key = ((recordBlock)currentBlock).addRecord(data, offset, length)) < 0) {
            this.deallocateBlock(currentBlock);
            return -1;
        }
        if (!inFull && currentBlock.getIndex() >= this.fullThreshold) {
            long curBlock = currentBlock.getLocation();
            long nextBlock = currentBlock.getNextBlock();
            long lastBlock = currentBlock.getLastBlock();
            if (!this.deallocateBlock(currentBlock, true)) {
                return -1;
            }
            if (nextBlock >= 0L) {
                currentBlock = this.allocateBlock(nextBlock);
                if (currentBlock == null) {
                    return -1;
                }
                currentBlock.setLastBlock(lastBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1;
                }
            }
            if (lastBlock >= 0L) {
                currentBlock = this.allocateBlock(lastBlock);
                if (currentBlock == null) {
                    return -1;
                }
                currentBlock.setNextBlock(nextBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1;
                }
            } else {
                this.partialBlockRoot = nextBlock;
            }
            if (this.fullBlockRoot >= 0L) {
                currentBlock = this.allocateBlock(this.fullBlockRoot);
                if (currentBlock == null) {
                    return -1;
                }
                currentBlock.setLastBlock(curBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1;
                }
            }
            if ((currentBlock = this.allocateBlock(curBlock)) == null) {
                return -1;
            }
            currentBlock.setNextBlock(this.fullBlockRoot);
            currentBlock.setLastBlock(-1L);
            long tempIndex = currentBlock.getLocation();
            if (!this.deallocateBlock(currentBlock, true)) {
                return -1;
            }
            this.fullBlockRoot = tempIndex;
            if (this.partialBlockRoot >= 0L) {
                currentBlock = this.allocateBlock(this.partialBlockRoot);
                if (currentBlock == null) {
                    return -1;
                }
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1;
                }
            } else {
                currentBlock = this.allocateBlock();
                if (currentBlock == null) {
                    return -1;
                }
                long tempLocation = currentBlock.getLocation();
                if (!this.deallocateBlock(currentBlock, true)) {
                    return -1;
                }
                this.partialBlockRoot = tempLocation;
            }
            this.setExtendedHeader();
        } else if (!this.deallocateBlock(currentBlock, true)) {
            return -1;
        }
        return key;
    }

    public final byte[] getRecord(long blockNumber, int recordKey) {
        block currentBlock = this.allocateBlock(blockNumber);
        if (currentBlock == null) {
            return null;
        }
        byte[] rbytes = ((recordBlock)currentBlock).getRecord(recordKey);
        this.deallocateBlock(currentBlock);
        return rbytes;
    }

    public final int updateRecord(long blockNumber, int recordKey, byte[] tempBytes) {
        if (!this.isWritable()) {
            this.warning("recordBlockFile.updateRecord", "invalid operaiton, file not open for output");
            return -48;
        }
        block currentBlock = this.allocateBlock(blockNumber);
        if (currentBlock == null) {
            return this.priorError();
        }
        if (((recordBlock)currentBlock).updateRecord(tempBytes, recordKey)) {
            if (!this.deallocateBlock(currentBlock, true)) {
                return this.priorError();
            }
            return 0;
        }
        this.deallocateBlock(currentBlock);
        this.warning("recordBlockFile.updateRecord", "invalid key, random record missing");
        return -23;
    }

    public final int deleteRecord(long blockNumber, int recordKey) {
        long tempLocation;
        long lastBlock;
        long nextBlock;
        long curBlock;
        boolean inFull = false;
        if (!this.isWritable()) {
            this.warning("recordBlockFile.deleteRecord", "invalid operaiton, file not open for output");
            return -48;
        }
        if (blockNumber < 0L) {
            this.warning("recordBlockFile.deleteRecord", "can't position file");
            return -90;
        }
        block currentBlock = this.allocateBlock(blockNumber);
        if (currentBlock == null) {
            return this.priorError();
        }
        if (currentBlock.getIndex() >= this.fullThreshold) {
            inFull = true;
        }
        if (!((recordBlock)currentBlock).deleteRecord(recordKey)) {
            this.deallocateBlock(currentBlock);
            this.warning("recordBlockFile.deleteRecord", "invalid key, random record missing");
            return -23;
        }
        boolean shouldReadInAgain = true;
        long readInAgainLocation = currentBlock.getLocation();
        if (currentBlock.getIndex() <= 1) {
            curBlock = currentBlock.getLocation();
            nextBlock = currentBlock.getNextBlock();
            lastBlock = currentBlock.getLastBlock();
            if (!this.deallocateBlock(currentBlock, true)) {
                return -1;
            }
            if (nextBlock >= 0L) {
                currentBlock = this.allocateBlock(nextBlock);
                if (currentBlock == null) {
                    return this.priorError();
                }
                currentBlock.setLastBlock(lastBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
            }
            if (lastBlock >= 0L) {
                currentBlock = this.allocateBlock(lastBlock);
                if (currentBlock == null) {
                    return this.priorError();
                }
                currentBlock.setNextBlock(nextBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
            } else if (inFull) {
                this.fullBlockRoot = nextBlock;
            } else {
                this.partialBlockRoot = nextBlock;
            }
            if ((currentBlock = this.allocateBlock(curBlock)) == null) {
                return this.priorError();
            }
            if (!this.deallocateAndDeleteBlock(currentBlock)) {
                return this.priorError();
            }
            inFull = false;
            if (this.partialBlockRoot >= 0L) {
                currentBlock = this.allocateBlock(this.partialBlockRoot);
                if (currentBlock == null) {
                    return this.priorError();
                }
                shouldReadInAgain = false;
                readInAgainLocation = this.partialBlockRoot;
            } else {
                currentBlock = this.allocateBlock();
                if (currentBlock == null) {
                    return this.priorError();
                }
                tempLocation = currentBlock.getLocation();
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
                this.partialBlockRoot = tempLocation;
                readInAgainLocation = tempLocation;
            }
            this.setExtendedHeader();
        } else if (!this.deallocateBlock(currentBlock, true)) {
            return -1;
        }
        if (shouldReadInAgain && (currentBlock = this.allocateBlock(readInAgainLocation)) == null) {
            return -1;
        }
        if (inFull && currentBlock.getIndex() < this.fullThreshold) {
            curBlock = currentBlock.getLocation();
            nextBlock = currentBlock.getNextBlock();
            lastBlock = currentBlock.getLastBlock();
            if (!this.deallocateBlock(currentBlock)) {
                return -1;
            }
            if (nextBlock >= 0L) {
                currentBlock = this.allocateBlock(nextBlock);
                if (currentBlock == null) {
                    return this.priorError();
                }
                currentBlock.setLastBlock(lastBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
            }
            if (lastBlock >= 0L) {
                currentBlock = this.allocateBlock(lastBlock);
                if (currentBlock == null) {
                    return this.priorError();
                }
                currentBlock.setNextBlock(nextBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
            } else {
                this.fullBlockRoot = nextBlock;
            }
            if (this.partialBlockRoot >= 0L) {
                currentBlock = this.allocateBlock(this.partialBlockRoot);
                if (currentBlock == null) {
                    return this.priorError();
                }
                currentBlock.setLastBlock(curBlock);
                if (!this.deallocateBlock(currentBlock, true)) {
                    return this.priorError();
                }
            }
            if ((currentBlock = this.allocateBlock(curBlock)) == null) {
                return this.priorError();
            }
            currentBlock.setNextBlock(this.partialBlockRoot);
            currentBlock.setLastBlock(-1L);
            tempLocation = currentBlock.getLocation();
            if (!this.deallocateBlock(currentBlock, true)) {
                return this.priorError();
            }
            this.partialBlockRoot = tempLocation;
            this.setExtendedHeader();
        } else if (!this.deallocateBlock(currentBlock)) {
            return -1;
        }
        return 0;
    }

    @Override
    public final int close(int mode) {
        int returnCode = super.close(mode);
        return returnCode;
    }

    public final int getMaxRecordSize() {
        return this.blockDataSize - 6;
    }

    public void setCharsetName(String charsetName) {
        this.file.setCharset(charsetName);
    }
}

