/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.LockFile;
import com.heirloomcomputing.ecs.exec.LockRecord;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.basicFile;
import com.heirloomcomputing.ecs.exec.smartFile;
import java.io.File;
import java.util.Calendar;

public class relFile
extends basicFile {
    private static boolean defaultMicroFocus;
    private static boolean defaultACU;
    public static final int STATUS_UNINITIALIZED = 0;
    public static final int STATUS_DELETED = 1;
    public static final int STATUS_VALID = 2;
    public static final int STATUS_IMPOSSIBLE = 3;
    private boolean randomFile;
    public int STARTING_RECORD = 1;
    protected int minimum = -1;
    protected int maximum = -1;
    protected int permanentMinimum = -1;
    protected int permanentMaximum = -1;
    protected Variable dependingOn;
    protected Variable fileStatus;
    protected boolean optional;
    protected String filename;
    protected boolean isOpen;
    protected int size;
    protected int readSize;
    protected boolean readable;
    protected boolean writable;
    protected boolean extend;
    protected int priorErrorCode;
    protected Variable relativeKey;
    protected long readRecord;
    protected relFile externalFile;
    protected long positionValue;
    protected Variable filenameVariable;
    protected boolean keyalreadypresent;
    protected int accessMode = -1;
    protected int alignment = 1;
    protected boolean microfocus;
    protected boolean microfocus_unix;
    protected boolean microfocus_win;
    protected boolean acucobol;
    protected boolean override_variable;
    protected boolean override_fixed;
    protected boolean override_varying;
    protected long maxDigitsInKey = 999999999999999999L;
    protected int newModes;
    protected smartFile file = new smartFile();
    protected LockRecord lockRecord = LockRecord.create(this.file);
    private boolean noOps = false;
    private LastOp lastOp;
    protected static final byte[] spaces;

    public relFile setDuplicatePrimary() {
        throw new RuntimeException("AS/400 Support: Duplicate Primary");
    }

    public relFile setFileStatus2(Variable v) {
        return this;
    }

    @Override
    public void setFileProperty(String name, Object value) {
        if (name.equalsIgnoreCase("RANDOM")) {
            if (value instanceof Boolean) {
                this.randomFile = (Boolean)value;
            }
            this.STARTING_RECORD = this.randomFile ? 0 : 1;
        }
    }

    private static void initFilesystems() {
        defaultMicroFocus = false;
        defaultACU = false;
        String s = RuntimeEnvironment.getGlobalParameter("FILESYSTEMREL");
        if (s == null) {
            s = RuntimeEnvironment.getGlobalParameter("FILESYSTEM");
        }
        if (s != null) {
            if ((s = s.toUpperCase()).equalsIgnoreCase("MF")) {
                defaultMicroFocus = true;
            }
            if (s.equalsIgnoreCase("MICROFOCUS")) {
                defaultMicroFocus = true;
            }
            if (s.equalsIgnoreCase("MERANT")) {
                defaultMicroFocus = true;
            }
            if (s.equalsIgnoreCase("ACU")) {
                defaultACU = true;
            }
            if (s.equalsIgnoreCase("ACUCOBOL")) {
                defaultACU = true;
            }
            if (s.equalsIgnoreCase("ACUCORP")) {
                defaultACU = true;
            }
        }
    }

    public final relFile settingExternalFile(Context context, String name) {
        Object copy = context.getExternalFile(this, name);
        if (copy == null) {
            return this;
        }
        if (!(copy instanceof relFile)) {
            return this;
        }
        if (copy == this) {
            return this;
        }
        this.externalFile = (relFile)copy;
        this.file = this.externalFile.file;
        return this;
    }

    public boolean isReadable() {
        return this.externalFile != null ? this.externalFile.isReadable() : this.readable;
    }

    public boolean isWritable() {
        return this.externalFile != null ? this.externalFile.isWritable() : this.writable;
    }

    public boolean isExtend() {
        return this.externalFile != null ? this.externalFile.isExtend() : this.extend;
    }

    public void setReadable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setReadable(state);
        }
        this.readable = state;
    }

    public void setWritable(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setWritable(state);
        }
        this.writable = state;
    }

    public void setExtend(boolean state) {
        if (this.externalFile != null) {
            this.externalFile.setExtend(state);
        }
        this.extend = state;
    }

    public boolean isInput() {
        return this.isReadable() && !this.isWritable();
    }

    public boolean isOutput() {
        return this.isWritable() && !this.isReadable() && !this.isExtend();
    }

    public boolean isIO() {
        return this.isReadable() && this.isWritable();
    }

    public boolean isinvalidkey(int returnCode) {
        return returnCode >= -29 && returnCode <= -20;
    }

    public boolean isatend(int returnCode) {
        if (returnCode == -23 || returnCode == -10) {
            if (this.isSequential()) {
                this.iostatus(-10);
            }
            return true;
        }
        return false;
    }

    public boolean useExceptionNotInvalid() {
        int rc = this.priorError();
        if (rc > 0) {
            rc = -rc;
        }
        return rc <= 10 && rc != -22 && rc != -23 && rc != -24;
    }

    public boolean useException() {
        return this.priorError() >= 10;
    }

    public boolean useAtEnd() {
        return this.priorError() == -10 || this.priorError() == 10 || this.priorError() == 14 || this.priorError() == -14;
    }

    public boolean isOK() {
        return this.priorError() > -10;
    }

    public synchronized boolean isOpen() {
        if (this.file == null) {
            return false;
        }
        return this.file.isOpen();
    }

    public int useException(int specific, int input, int output, int io, int extend) {
        if (this.useException()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useException(int specific) {
        return this.useException() ? specific : -1;
    }

    public int useExceptionNotInvalid(int specific, int input, int output, int io, int extend) {
        if (this.useExceptionNotInvalid()) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public final synchronized int useExceptionNotInvalid(int specific) {
        return this.useExceptionNotInvalid() ? specific : -1;
    }

    public int useAtEnd(int specific, int input, int output, int io, int extend) {
        if (this.priorError() == 10 || this.priorError() == -10) {
            if (specific >= 0) {
                return specific;
            }
            if (this.isExtend()) {
                return extend;
            }
            if (this.isInput()) {
                return input;
            }
            if (this.isOutput()) {
                return output;
            }
            if (this.isIO()) {
                return io;
            }
        }
        return -1;
    }

    public int useAtEnd(int specific) {
        if ((this.priorError() == 10 || this.priorError() == -10) && specific >= 0) {
            return specific;
        }
        return -1;
    }

    public void iostatus(String x) {
        try {
            this.iostatus(-Integer.parseInt(x.trim()));
        }
        catch (Exception e) {
            this.iostatus(0);
        }
    }

    public void iostatus(int status) {
        try {
            int n = status = status < 0 ? -status : 0;
            if (status == 9) {
                status = 0;
            }
            this.setPriorError(status);
            if (this.fileStatus != null) {
                if (status == 0) {
                    this.fileStatus.move("00");
                } else if (status < 10) {
                    this.fileStatus.move("0" + status);
                } else {
                    this.fileStatus.move(status);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setPriorError(int status) {
        if (this.externalFile != null) {
            this.externalFile.setPriorError(status);
        }
        this.priorErrorCode = status;
    }

    @Override
    public int priorError() {
        return this.externalFile != null ? this.externalFile.priorError() : this.priorErrorCode;
    }

    public relFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, relativeKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public relFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        this.newModes = newModes;
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, relativeKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public relFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        String assignTo = null;
        this.filenameVariable = filenameVariable;
        if (filenameVariable != null) {
            assignTo = filenameVariable.toString();
        }
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, relativeKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    public relFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable relativeKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        try {
            this.optional = optional;
            if (assignTo != null) {
                this.setFilename(assignTo);
                this.filename = assignTo;
            }
            this.fileStatus = fileStatus;
            this.relativeKey = relativeKey;
            this.accessMode = accessMode;
            this.dependingOn = dependingOn;
            this.minimum = recordFrom;
            this.maximum = recordTo;
            if (this.maximum < 0) {
                this.maximum = -1;
            }
            if (this.minimum < 0) {
                this.minimum = -1;
            }
            if (this.minimum < 0 && this.maximum >= 0) {
                this.minimum = this.maximum;
            }
            if (this.maximum < 0 && this.minimum >= 0) {
                this.maximum = this.minimum;
            }
            if (this.minimum > this.maximum) {
                this.maximum = this.minimum;
            }
            this.permanentMaximum = this.maximum;
            this.permanentMinimum = this.minimum;
            if (relativeKey != null) {
                String maxPic = Variable.HIGH_VALUES.special(relativeKey);
                int length = relativeKey.relativeKeyLength();
                maxPic = Variable.all('9', length - relativeKey.getPlace());
                try {
                    this.maxDigitsInKey = Integer.parseInt(maxPic);
                }
                catch (Exception e) {
                    this.maxDigitsInKey = 999999999999999999L;
                }
            } else {
                this.maxDigitsInKey = 999999999999999999L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public relFile endDeclare() {
        return this;
    }

    public int getSize() {
        return this.maximum;
    }

    public int currentSize() {
        return this.dependingOn != null ? this.dependingOn.toInt() : this.maximum;
    }

    public boolean fixed() {
        if (this.override_fixed) {
            return true;
        }
        return !this.variable();
    }

    public boolean variable() {
        if (this.override_variable) {
            return true;
        }
        if (this.microfocus) {
            if (this.override_varying) {
                return true;
            }
            return this.dependingOn != null;
        }
        return this.minimum != this.maximum || this.dependingOn != null;
    }

    public void setFilename(String assignTo) {
        relFile.initFilesystems();
        assignTo = this.aliasFilename(assignTo);
        this.microfocus = false;
        this.microfocus_unix = false;
        this.microfocus_win = false;
        this.acucobol = false;
        String loAssignTo = assignTo.toLowerCase();
        if (loAssignTo.startsWith("ec:")) {
            assignTo = assignTo.substring(3);
        } else if (loAssignTo.startsWith("ecobol:")) {
            assignTo = assignTo.substring(7);
        } else if (loAssignTo.startsWith("mf:")) {
            assignTo = assignTo.substring(3);
            this.microfocus = true;
        }
        if (defaultMicroFocus) {
            this.microfocus = true;
        } else if (defaultACU) {
            this.acucobol = true;
        }
        if (loAssignTo.startsWith("acu:")) {
            assignTo = assignTo.substring(4);
            this.acucobol = true;
        }
        if (this.microfocus) {
            this.alignment = 4;
            String os = RuntimeEnvironment.getGlobalParameter("os.name");
            String string2 = os = os != null ? os.toUpperCase() : "";
            if (os.startsWith("WIN") || os.startsWith("OS2") || os.startsWith("OS/2")) {
                this.microfocus_win = true;
            } else {
                this.microfocus_unix = true;
            }
        }
        if (loAssignTo.startsWith("mfu:")) {
            assignTo = assignTo.substring(4);
            this.microfocus = true;
            this.microfocus_unix = true;
            this.microfocus_win = false;
            this.alignment = 4;
        }
        if (loAssignTo.startsWith("mfw:")) {
            assignTo = assignTo.substring(4);
            this.microfocus = true;
            this.microfocus_unix = false;
            this.microfocus_win = true;
            this.alignment = 4;
        }
        this.file.setFilename(assignTo);
    }

    public void setFixed() {
        this.newModes = 1;
    }

    public void setVariable() {
        this.newModes = 2;
    }

    private String currentFilename() {
        String filename;
        if (this.filenameVariable != null && (filename = this.filenameVariable.toString()) != null) {
            filename = filename.trim();
            filename = this.aliasFilename(filename);
            this.file.setFilename(filename);
        }
        return this.getFilename();
    }

    @Override
    public boolean open(int mode) {
        this.setLastOp(LastOp.OPEN);
        try {
            String filename;
            mode = LockFile.transformOpenMode(mode);
            mode = this.setOpenMode(mode);
            this.readRecord = 0L;
            this.maximum = this.permanentMaximum;
            this.minimum = this.permanentMinimum;
            this.override_variable = false;
            this.override_fixed = false;
            this.override_varying = false;
            if ((this.newModes & 1) != 0) {
                this.override_fixed = true;
            }
            if ((this.newModes & 2) != 0) {
                this.override_variable = true;
            }
            if ((this.newModes & 4) != 0) {
                this.override_varying = true;
            }
            if ((filename = this.currentFilename()).equalsIgnoreCase("NUL") || filename.equalsIgnoreCase("/dev/null")) {
                this.noOps = true;
                this.iostatus(0);
                return true;
            }
            boolean fileAlreadyExists = false;
            this.readSize = -1;
            if ((mode & 1) != 0) {
                this.setReadable(true);
            } else {
                this.setReadable(false);
            }
            if ((mode & 2) != 0) {
                this.setWritable(true);
            } else {
                this.setWritable(false);
            }
            if ((mode & 4) != 0) {
                this.setWritable(true);
                mode |= 1;
                this.setExtend(true);
            } else {
                this.setExtend(false);
            }
            if (this.optional || (mode & 4) != 0 && this.microfocus) {
                mode |= 8;
            }
            int returnCode = this.file.open(mode);
            this.iostatus(returnCode);
            this.file.setCharset(this.dataCharset);
            this.lockRecord.open(filename, mode & 0x16000);
            boolean bl = this.isOpen = returnCode == 0;
            if (this.isOpen) {
                fileAlreadyExists = !this.file.isNewFile();
                returnCode = this.file.seek(0);
                if (returnCode != 0) {
                    this.iostatus(returnCode);
                    this.lockRecord.close();
                    return false;
                }
                if (fileAlreadyExists) {
                    returnCode = this.readHeader();
                    if (returnCode == -99) {
                        try {
                            this.lockRecord.close();
                            this.file.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.iostatus(-93);
                        return false;
                    }
                    if (returnCode == -10) {
                        return true;
                    }
                    if (returnCode < 0) {
                        return false;
                    }
                } else {
                    this.writeHeader();
                }
            }
            this.readRecord = 0L;
            if (this.isExtend()) {
                if (!this.isOpen) {
                    this.writeHeader();
                }
                long lengthOfFile = this.file.length();
                this.readRecord = (lengthOfFile - (long)this.getHeaderSize()) / (long)this.getTotalRecordSize() + 1L;
                if (this.readRecord < 0L) {
                    this.readRecord = 0L;
                }
                if (!this.acucobol) {
                    byte[] smallRead = new byte[2];
                    long search = this.readRecord;
                    if (search > 0L) {
                        boolean isEmpty = false;
                        do {
                            returnCode = 0;
                            if (this.acucobol) {
                                isEmpty = this.isDeleted(search, true);
                                continue;
                            }
                            if (search < 0L) continue;
                            this.positionStatus(search);
                            smallRead[0] = 3;
                            int mylock = this.file.readLock(this.positionValue, 1);
                            this.file.clearReadError();
                            returnCode = this.file.read(smallRead, 0, 2);
                            this.file.readUnlock(mylock);
                            if (this.microfocus) {
                                if (smallRead[0] == 13) {
                                    isEmpty = smallRead[1] != 10;
                                    continue;
                                }
                                isEmpty = smallRead[0] != 10;
                                continue;
                            }
                            boolean bl2 = isEmpty = smallRead[0] == 0 || smallRead[0] == 1;
                        } while (--search >= 0L && (returnCode == -10 || returnCode == -1 || isEmpty));
                        this.readRecord = search + 1L;
                    }
                }
                if (lengthOfFile < 0L || this.readRecord < 0L) {
                    this.readRecord = 0L;
                }
                this.position(this.readRecord);
                this.updateRelativeKey();
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
        return this.isOpen;
    }

    public synchronized boolean openTimeoutSeconds(int mode, Numeric timeout) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            double seconds = timeout.toDouble();
            boolean success = false;
            long currentTime = System.currentTimeMillis();
            long finalTime = currentTime + (long)(seconds * 1000.0);
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success || System.currentTimeMillis() >= finalTime) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success && System.currentTimeMillis() < finalTime);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public synchronized boolean openTimeoutRetries(int mode, Numeric timeout) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            int attempts = timeout.toInt();
            if (attempts < 0) {
                attempts = 0;
            }
            ++attempts;
            boolean success = false;
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success || --attempts <= 0) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success && attempts > 0);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public synchronized boolean openTimeoutRetries(int mode) {
        try {
            mode = LockFile.transformOpenMode(mode);
            int timeout_mask = 0x2100000;
            mode &= ~timeout_mask;
            boolean success = false;
            do {
                this.iostatus(0);
                success = this.open(mode);
                if (success) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!success);
            return success;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    @Override
    public boolean close() {
        this.setLastOp(LastOp.CLOSE);
        return this.close(0);
    }

    public boolean close(int mode) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            this.readSize = -1;
            this.lockRecord.close();
            int returnCode = this.file.close(mode);
            this.iostatus(returnCode);
            this.isOpen = returnCode == 0;
            return !this.isOpen;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            this.isOpen = false;
            return false;
        }
    }

    public boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable data, int mode, Numeric timeout) {
        return this.readPrevious(data, mode, timeout);
    }

    public boolean readPrevious(Variable data, int mode, Numeric timeout) {
        block19: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.readPrevious(data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block19;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        boolean status = this.readPrevious(data);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable data, int mode, Numeric timeout) {
        return this.readNext(data, mode, timeout);
    }

    public boolean readNext(Variable data, int mode, Numeric timeout) {
        block19: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.readNext(data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block19;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        boolean status = this.readNext(data);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean readPrevious(String format, Variable nullKeyMap, Variable nullMap, Variable data) {
        return this.readPrevious(data);
    }

    public boolean readPrevious(Variable data) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.isRandom()) {
                this.iostatus(0);
                return this.read(data);
            }
            int returnCode = this.inner_readPrevious(data);
            this.iostatus(returnCode);
            if (returnCode <= -10) {
                this.readSize = -1;
            }
            return returnCode <= -10;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable data) {
        return this.readNext(data);
    }

    public boolean readNext(Variable data) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            if (this.isRandom()) {
                this.iostatus(0);
                return this.read(data);
            }
            int returnCode = this.inner_readNext(data);
            this.iostatus(returnCode);
            if (returnCode <= -10) {
                this.readSize = -1;
            }
            return returnCode <= -10;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable data, int mode, Numeric timeout) {
        return this.read(data, mode, timeout);
    }

    public boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable data, Variable ignoreKey, int mode, Numeric timeout) {
        return this.read(data, mode, timeout);
    }

    public boolean read(Variable data, int mode, Numeric timeout) {
        block19: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.read(data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block19;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        boolean status = this.read(data);
                        if (this.isInput()) {
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        if (this.isOK()) {
                            if (this.lockingSingle()) {
                                return status;
                            }
                            if ((mode & 0x200000) != 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            if (this.lockingManual() && (mode & 0x1000000) == 0) {
                                this.lockRecord.unlock(lockNumber);
                                return status;
                            }
                            return status;
                        }
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x200000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable data) {
        return this.read(data);
    }

    @Override
    public boolean read(Variable data) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            this.iostatus(0);
            if (this.isSequential()) {
                return this.readNext(data);
            }
            int returnCode = this.inner_read(data);
            this.iostatus(returnCode);
            if (returnCode <= -10) {
                this.readSize = -1;
            }
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable data, int mode, Numeric timeout) {
        return this.rewrite(data, mode, timeout);
    }

    public boolean rewrite(Variable data, int mode, Numeric timeout) {
        block15: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.rewrite(data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block15;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        boolean status = this.rewrite(data);
                        if (this.isOK()) {
                            if (this.lockingMultiple() && (mode & 0x200000) == 0 || (mode & 0x1000000) != 0) {
                                return status;
                            }
                            if (this.lockingSingle()) {
                                return status;
                            }
                            this.lockRecord.unlock(lockNumber);
                            return status;
                        }
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable data, int mode, Numeric timeout) {
        return this.write(data, mode, timeout);
    }

    public boolean write(Variable data, int mode, Numeric timeout) {
        block14: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.write(data);
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block14;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        boolean status = this.write(data);
                        if (this.lockingSingle()) {
                            return status;
                        }
                        if ((mode & 0x1000000) != 0) {
                            return status;
                        }
                        this.lockRecord.unlock(lockNumber);
                        return status;
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean delete(String format, Variable nullKeyMap, int mode, Numeric timeout) {
        return this.delete(mode, timeout);
    }

    public boolean delete(int mode, Numeric timeout) {
        block12: {
            if (this.noOps) {
                this.iostatus(0);
                return true;
            }
            try {
                boolean locking;
                boolean bl = locking = this.lockingAutomatic() && (mode & 0x400000) == 0 || this.lockingManual() && (mode & 0x1000000) != 0;
                if (!locking) {
                    return this.delete();
                }
                int retries = 0;
                long currentTime = 0L;
                long finalTime = 0L;
                if ((mode & 0x100000) != 0 && timeout != null) {
                    double seconds = timeout.toDouble();
                    currentTime = System.currentTimeMillis();
                    finalTime = currentTime + (long)(seconds * 1000.0);
                }
                long lockNumber = 0L;
                if (!locking) break block12;
                lockNumber = this.getLockPosition();
                boolean retry = false;
                do {
                    if (this.lockRecord.lock(lockNumber, this.getTotalRecordSize())) {
                        this.delete();
                        this.lockRecord.unlock(lockNumber);
                    }
                    retry = false;
                    if ((mode & 0x2000000) != 0) {
                        if (timeout != null && ++retries >= timeout.toInt()) continue;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        retry = true;
                        continue;
                    }
                    if ((mode & 0x100000) == 0 || System.currentTimeMillis() >= finalTime) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() >= finalTime) continue;
                    retry = true;
                } while (retry);
                this.iostatus(-99);
            }
            catch (Throwable javaException) {
                this.iostatus(-98);
                return false;
            }
        }
        return false;
    }

    public boolean write(String format, Variable nullKeyMap, Variable nullMap, Variable data) {
        return this.write(data);
    }

    @Override
    public boolean write(Variable data) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            data.flushToMemory();
            this.iostatus(0);
            int returnCode = this.inner_write(data);
            this.iostatus(returnCode);
            this.readSize = -1;
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean rewrite(String format, Variable nullKeyMap, Variable nullMap, Variable data) {
        return this.rewrite(data);
    }

    public boolean rewrite(Variable data) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            data.flushToMemory();
            this.iostatus(0);
            int returnCode = this.inner_rewrite(data);
            this.iostatus(returnCode);
            this.readSize = -1;
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean delete(String format, Variable nullKeyMap) {
        return this.delete();
    }

    public boolean delete() {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            this.iostatus(0);
            this.readSize = -1;
            int returnCode = this.inner_delete();
            this.iostatus(returnCode);
            return returnCode != 0 && returnCode != -10;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    public boolean undelete() {
        try {
            this.iostatus(0);
            this.readSize = -1;
            int returnCode = this.inner_undelete();
            this.iostatus(returnCode);
            return returnCode != 0 && returnCode != -10;
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    private int privateRead(smartFile file2, Variable var, int len) {
        byte[] buf = new byte[len <= 0 ? var.getSize() : len];
        int returnCode = file2.read(buf, 0, len);
        if (returnCode > 0) {
            var.getMemory().copy(buf, 0, var.getAddress(), len > returnCode ? len : returnCode);
        }
        return returnCode;
    }

    private int privateWrite(smartFile file2, Variable var, int len) {
        byte[] buf = new byte[len];
        var.getMemory().copy(var.getAddress(), buf, 0, len);
        return file2.write(buf, 0, len);
    }

    public int inner_readNext(Variable data) {
        int returnCode;
        int n = this.readSize = this.dependingOn != null ? this.dependingOn.toInt() : this.maximum;
        if (this.readSize <= 0) {
            this.readSize = data.length();
        }
        if (this.getLastOp() == LastOp.READPREV) {
            this.readRecord = this.relativeKey.toLong() + 1L;
        }
        boolean firstCheck = true;
        do {
            if (!firstCheck) {
                ++this.readRecord;
            } else {
                firstCheck = false;
                if (this.readRecord == 0L) {
                    ++this.readRecord;
                }
            }
            if (this.readRecord > this.maxDigitsInKey) {
                return -14;
            }
            returnCode = this.positionStatus(this.readRecord);
            if (returnCode == 0) continue;
            this.updateRelativeKey();
            this.iostatus(returnCode);
            return returnCode;
        } while (this.isDeletedErrorTrue() && this.priorError() == 23);
        this.updateRelativeKey();
        returnCode = this.priorError();
        if (returnCode != 0) {
            return -returnCode;
        }
        if (this.variable()) {
            this.readSize = this.getLength();
            if (this.readSize < 0) {
                returnCode = this.readSize;
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
        }
        this.positionData(this.readRecord);
        data.prepareMemoryForWrite();
        int mylock = this.file.readLock(this.positionValue, this.readSize);
        returnCode = this.privateRead(this.file, data, this.readSize);
        this.file.readUnlock(mylock);
        ++this.readRecord;
        this.setLastOp(LastOp.READNEXT);
        if (this.dependingOn != null) {
            this.dependingOn.move(this.readSize);
        }
        if (returnCode > 0 && returnCode != this.readSize && !this.file.isLineSequential()) {
            returnCode = -4;
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int inner_readPrevious(Variable data) {
        int returnCode;
        int n = this.readSize = this.dependingOn != null ? this.dependingOn.toInt() : this.maximum;
        if (this.readSize <= 0) {
            this.readSize = data.length();
        }
        if (this.getLastOp() == LastOp.READNEXT) {
            this.readRecord = this.relativeKey.toLong() - 1L;
        }
        boolean firstCheck = true;
        do {
            if (!firstCheck) {
                --this.readRecord;
            } else {
                firstCheck = false;
            }
            if (this.readRecord < (long)this.STARTING_RECORD) {
                return -10;
            }
            returnCode = this.positionStatus(this.readRecord);
            if (returnCode == 0) continue;
            this.updateRelativeKey();
            this.iostatus(returnCode);
            return returnCode;
        } while (this.isDeletedErrorTrue() && this.priorError() == 23);
        this.updateRelativeKey();
        returnCode = this.priorError();
        if (returnCode != 0) {
            return -returnCode;
        }
        if (this.variable()) {
            this.readSize = this.getLength();
            if (this.readSize < 0) {
                returnCode = this.readSize;
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
        }
        this.positionData(this.readRecord);
        data.prepareMemoryForWrite();
        int mylock = this.file.readLock(this.positionValue, this.readSize);
        returnCode = this.privateRead(this.file, data, this.readSize);
        this.file.readUnlock(mylock);
        --this.readRecord;
        this.setLastOp(LastOp.READPREV);
        if (this.dependingOn != null) {
            this.dependingOn.move(this.readSize);
        }
        if (returnCode > 0 && returnCode != this.readSize && !this.file.isLineSequential()) {
            returnCode = -4;
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int getLength() {
        this.positionLength();
        if (this.microfocus) {
            if (this.fixed()) {
                return this.maximum;
            }
            int size = this.MF_prefixSize();
            byte[] varsize = new byte[size];
            int mylock = this.file.readLock(this.positionValue, varsize.length);
            int returnCode = this.file.read(varsize, 0, varsize.length);
            this.file.readUnlock(mylock);
            if (returnCode < 0) {
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
            if (size == 2) {
                this.readSize = ((varsize[0] & 0xF) << 8 | varsize[1] & 0xFF) & 0xFFF;
            } else if (size == 4) {
                this.readSize = ((varsize[0] & 0xF) << 24 | (varsize[1] & 0xFF) << 16 | (varsize[2] & 0xFF) << 8 | varsize[3] & 0xFF) & 0xFFFFFFF;
            }
            return this.readSize;
        }
        if (this.acucobol) {
            if (this.fixed()) {
                return this.maximum;
            }
            byte[] varsize = new byte[2];
            int mylock = this.file.readLock(this.positionValue, varsize.length);
            int returnCode = this.file.read(varsize, 0, varsize.length);
            this.file.readUnlock(mylock);
            if (returnCode < 0) {
                this.iostatus(returnCode);
                this.readSize = -1;
                return returnCode;
            }
            this.readSize = ((varsize[0] & 0xF) << 8 | varsize[1] & 0xFF) & 0xFFF;
            return this.readSize;
        }
        byte[] varsize = new byte[4];
        int mylock = this.file.readLock(this.positionValue, varsize.length + this.readSize);
        int returnCode = this.file.read(varsize, 0, varsize.length);
        this.file.readUnlock(mylock);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            this.readSize = -1;
            return returnCode;
        }
        this.readSize = this.bytesToInt(varsize);
        return this.readSize;
    }

    public int inner_read(Variable data) {
        int mylock = 0;
        if (this.acucobol) {
            int returnCode;
            Memory memory = data.getMemory();
            int address = data.getAddress();
            boolean deleted = false;
            if (this.readRecord > this.maxDigitsInKey) {
                int returnCode2 = -14;
                this.iostatus(-14);
                return returnCode2;
            }
            this.file.clearReadError();
            if (this.variable()) {
                this.readSize = this.getLength();
                if (this.readSize < 0) {
                    int returnCode3 = this.readSize;
                    this.iostatus(returnCode3);
                    this.readSize = -1;
                    returnCode3 = -23;
                    return -23;
                }
            } else {
                int n = this.readSize = this.dependingOn != null ? this.dependingOn.toInt() : this.maximum;
                if (this.readSize <= 0) {
                    this.readSize = data.length();
                }
            }
            if ((returnCode = this.positionData()) < 0) {
                this.updateRelativeKey();
                returnCode = -23;
                this.iostatus(-23);
                return returnCode;
            }
            data.prepareMemoryForWrite();
            returnCode = this.privateRead(this.file, data, this.readSize);
            if (returnCode <= 0) {
                this.updateRelativeKey();
                returnCode = -23;
                this.iostatus(returnCode);
                return returnCode;
            }
            deleted = true;
            for (int i = 0; i < returnCode; ++i) {
                if (memory.getByte(address + i) == 0) continue;
                deleted = false;
                break;
            }
            if (deleted) {
                returnCode = -23;
                this.iostatus(returnCode);
                return returnCode;
            }
            this.updateRelativeKey();
            returnCode = this.priorError();
            if (returnCode != 0) {
                return -returnCode;
            }
            if (this.dependingOn != null) {
                this.dependingOn.move(this.readSize);
            }
            if (returnCode > 0 && returnCode != this.readSize) {
                returnCode = -4;
            }
            if (returnCode >= 0) {
                returnCode = 0;
            }
            return returnCode;
        }
        boolean redo = false;
        this.file.clearReadError();
        int returnCode = this.positionStatus();
        if (returnCode != 0) {
            return returnCode;
        }
        int n = this.readSize = this.dependingOn != null ? this.dependingOn.toInt() : this.maximum;
        if (this.readSize <= 0) {
            this.readSize = data.length();
        }
        this.file.clearReadError();
        if (this.isDeletedErrorTrue()) {
            if (this.priorError() == 46) {
                this.file.clearReadError();
                this.iostatus(0);
                this.file.clearReadError();
            } else {
                returnCode = this.priorError();
                return -23;
            }
        }
        data.prepareMemoryForWrite();
        do {
            this.file.clearReadError();
            if (this.variable()) {
                this.readSize = this.getLength();
                if (this.readSize < 0) {
                    returnCode = this.readSize;
                    this.iostatus(returnCode);
                    this.readSize = -1;
                    return returnCode;
                }
            }
            this.positionData();
            mylock = this.file.readLock(this.positionValue, this.readSize);
            returnCode = this.privateRead(this.file, data, this.readSize);
            this.file.readUnlock(mylock);
            if (this.dependingOn != null) {
                this.dependingOn.move(this.readSize);
            }
            redo = false;
            if (returnCode != -46) continue;
            this.file.clearReadError();
            redo = true;
            this.iostatus(0);
        } while (redo);
        if (returnCode > 0 && returnCode != this.readSize && !this.file.isLineSequential()) {
            returnCode = -4;
        }
        if (returnCode >= 0) {
            returnCode = 0;
        }
        this.iostatus(returnCode);
        return returnCode;
    }

    public int inner_write(Variable data) {
        byte[] result;
        this.setLastOp(LastOp.WRITE);
        if (!this.isWritable()) {
            return -48;
        }
        this.file.clearReadError();
        ++this.readRecord;
        int returnCode = this.positionStatus();
        if (returnCode != 0 && returnCode != -10) {
            this.iostatus(returnCode);
            return returnCode;
        }
        this.isDeletedErrorFalse();
        if (this.keyalreadypresent) {
            return -22;
        }
        this.updateRelativeKey();
        this.size = data.length();
        if (this.dependingOn != null) {
            this.size = this.dependingOn.toInt();
        } else if (this.size <= 0) {
            this.size = this.maximum;
        }
        if (this.microfocus) {
            if (this.fixed()) {
                returnCode = this.positionData();
                if (returnCode != 0 && returnCode != -10) {
                    this.iostatus(returnCode);
                    return returnCode;
                }
                int statusSize = this.MF_statusSize();
                int mylock = this.file.writeLock(this.positionValue, statusSize + this.size);
                int result2 = this.privateWrite(this.file, data, this.size);
                if (this.size < this.maximum) {
                    int pad = this.maximum - this.size;
                    while (pad > 0) {
                        if (pad > 80) {
                            result2 = this.file.write(spaces, 0, 80);
                            pad -= 80;
                            continue;
                        }
                        result2 = this.file.write(spaces, 0, pad);
                        pad = 0;
                    }
                }
                byte[] status = new byte[statusSize];
                if (statusSize == 1) {
                    status[0] = 10;
                } else {
                    status[0] = 13;
                    status[1] = 10;
                }
                this.positionStatus();
                int result22 = this.file.write(status, 0, status.length);
                this.file.writeUnlock(mylock);
                if (result2 < 0) {
                    return result2;
                }
                if (result22 < 0) {
                    return result22;
                }
                return result2;
            }
            returnCode = this.positionLength();
            if (returnCode != 0 && returnCode != -10) {
                this.iostatus(returnCode);
                return returnCode;
            }
            int prefixSize = this.MF_prefixSize();
            int statusSize = this.MF_statusSize();
            int mylock = this.file.writeLock(this.positionValue, statusSize + prefixSize + this.size);
            byte[] prefix = new byte[prefixSize];
            if (prefixSize == 2) {
                prefix[0] = (byte)(0x40 | this.size >> 8 & 0xF);
                prefix[1] = (byte)(this.size & 0xFF);
            } else {
                prefix[0] = (byte)(0x40 | this.size >> 24 & 0xF);
                prefix[1] = (byte)(this.size >> 16 & 0xFF);
                prefix[2] = (byte)(this.size >> 8 & 0xFF);
                prefix[3] = (byte)(this.size & 0xFF);
            }
            int result1 = this.file.write(prefix, 0, prefix.length);
            byte[] status = new byte[statusSize];
            if (statusSize == 1) {
                status[0] = 10;
            } else {
                status[0] = 13;
                status[1] = 10;
            }
            this.positionData();
            int result2 = this.privateWrite(this.file, data, this.size);
            this.positionStatus();
            int result3 = this.file.write(status, 0, status.length);
            if (result1 < 0) {
                this.iostatus(result1);
                return result1;
            }
            if (result2 < 0) {
                this.iostatus(result2);
                return result2;
            }
            return result3;
        }
        if (this.acucobol) {
            int result4;
            byte[] result5;
            returnCode = this.position();
            if (returnCode != 0 && returnCode != -10) {
                this.iostatus(returnCode);
                return returnCode;
            }
            int prefixSize = 0;
            if (this.variable()) {
                prefixSize += 2;
            }
            int mylock = this.file.writeLock(this.positionValue, prefixSize + this.size);
            if (returnCode != 0 && returnCode != -10) {
                this.file.writeUnlock(mylock);
                this.iostatus(returnCode);
                return returnCode;
            }
            if (this.variable() && (returnCode = this.file.write(result5 = this.shortToBytes(this.size), 0, 2)) == -9) {
                returnCode = 0;
            }
            if ((result4 = this.privateWrite(this.file, data, this.size)) >= 0 && this.size < this.maximum) {
                int pad = this.maximum - this.size;
                while (pad > 0) {
                    if (pad > 80) {
                        result4 = this.file.write(spaces, 0, 80);
                        pad -= 80;
                        continue;
                    }
                    result4 = this.file.write(spaces, 0, pad);
                    pad = 0;
                }
            }
            this.file.writeUnlock(mylock);
            return result4;
        }
        returnCode = this.position();
        if (returnCode != 0 && returnCode != -10) {
            this.iostatus(returnCode);
            return returnCode;
        }
        int mylock = this.file.writeLock(this.positionValue, 4 + this.size);
        returnCode = this.inner_undelete();
        if (returnCode != 0 && returnCode != -10) {
            this.file.writeUnlock(mylock);
            this.iostatus(returnCode);
            return returnCode;
        }
        if (this.variable() && (returnCode = this.file.write(result = this.intToBytes(this.size), 0, 4)) == -9) {
            returnCode = 0;
        }
        int result3 = this.privateWrite(this.file, data, this.size);
        this.file.writeUnlock(mylock);
        return result3;
    }

    public int inner_rewrite(Variable data) {
        int mylock;
        this.setLastOp(LastOp.REWRITE);
        if (this.isSequential() || this.relativeKey == null) {
            int mylock2;
            if (this.readSize == -1) {
                return -43;
            }
            if (!this.isIO()) {
                return -49;
            }
            this.size = data.length();
            if (this.dependingOn != null) {
                this.size = this.dependingOn.toInt();
            } else if (this.size <= 0) {
                this.size = this.maximum;
            }
            if (this.microfocus) {
                if (this.fixed()) {
                    int statusSize = this.MF_statusSize();
                    int mylock3 = this.file.writeLock(this.positionValue, statusSize + this.size);
                    int result = this.positionData();
                    if (result < 0) {
                        this.file.writeUnlock(mylock3);
                        this.readSize = -1;
                        this.iostatus(result);
                        return result;
                    }
                    result = this.privateWrite(this.file, data, this.size);
                    if (this.size < this.maximum) {
                        int pad = this.maximum - this.size;
                        while (pad > 0) {
                            if (pad > 80) {
                                result = this.file.write(spaces, 0, 80);
                                pad -= 80;
                                continue;
                            }
                            result = this.file.write(spaces, 0, pad);
                            pad = 0;
                        }
                    }
                    byte[] status = new byte[statusSize];
                    if (statusSize == 1) {
                        status[0] = 10;
                    } else {
                        status[0] = 13;
                        status[1] = 10;
                    }
                    result = this.positionStatus();
                    if (result < 0) {
                        this.file.writeUnlock(mylock3);
                        this.iostatus(result);
                        return result;
                    }
                    int result2 = this.file.write(status, 0, status.length);
                    this.file.writeUnlock(mylock3);
                    if (result2 < 0) {
                        this.iostatus(result2);
                        return result2;
                    }
                    return result;
                }
                this.positionLength();
                int prefixSize = this.MF_prefixSize();
                int statusSize = this.MF_statusSize();
                int mylock4 = this.file.writeLock(this.positionValue, statusSize + prefixSize + this.size);
                byte[] prefix = new byte[prefixSize];
                if (prefixSize == 2) {
                    prefix[0] = (byte)(0x40 | this.size >> 8 & 0xF);
                    prefix[1] = (byte)(this.size & 0xFF);
                } else {
                    prefix[0] = (byte)(0x40 | this.size >> 24 & 0xF);
                    prefix[1] = (byte)(this.size >> 16 & 0xFF);
                    prefix[2] = (byte)(this.size >> 8 & 0xFF);
                    prefix[3] = (byte)(this.size & 0xFF);
                }
                int result1 = this.file.write(prefix, 0, prefix.length);
                byte[] status = new byte[statusSize];
                if (statusSize == 1) {
                    status[0] = 10;
                } else {
                    status[0] = 13;
                    status[1] = 10;
                }
                this.positionData();
                int result2 = this.privateWrite(this.file, data, this.size);
                this.positionStatus();
                int result = this.file.write(status, 0, status.length);
                if (result1 < 0) {
                    this.iostatus(result1);
                    return result1;
                }
                if (result2 < 0) {
                    this.iostatus(result2);
                    return result2;
                }
                this.file.writeUnlock(mylock4);
                return result;
            }
            if (this.acucobol) {
                int result2;
                this.positionLength();
                int prefixSize = 0;
                if (this.variable()) {
                    prefixSize += 2;
                }
                int mylock5 = this.file.writeLock(this.positionValue, prefixSize + this.size);
                int result1 = 0;
                if (this.variable()) {
                    byte[] prefix = this.shortToBytes(this.size);
                    result1 = this.file.write(prefix, 0, prefix.length);
                }
                this.positionData();
                int result = result2 = this.privateWrite(this.file, data, this.size);
                if (result2 >= 0 && this.size < this.maximum) {
                    int pad = this.maximum - this.size;
                    while (pad > 0) {
                        if (pad > 80) {
                            result = this.file.write(spaces, 0, 80);
                            pad -= 80;
                            continue;
                        }
                        result = this.file.write(spaces, 0, pad);
                        pad = 0;
                    }
                }
                if (result1 < 0) {
                    this.iostatus(result1);
                    return result1;
                }
                if (result2 < 0) {
                    this.iostatus(result2);
                    return result2;
                }
                this.iostatus(result);
                this.file.writeUnlock(mylock5);
                return result2;
            }
            int returnCode = this.file.backup();
            if (returnCode == -90) {
                return -49;
            }
            if (returnCode == -48) {
                return -49;
            }
            if (this.variable()) {
                byte[] result = this.intToBytes(this.size);
                mylock2 = this.file.writeLock(this.positionValue, 4);
                returnCode = this.file.write(result, 0, 4);
                this.file.writeUnlock(mylock2);
                if (returnCode == -9) {
                    returnCode = 0;
                }
            }
            mylock2 = this.file.writeLock(this.positionValue, this.size + 4);
            returnCode = this.privateWrite(this.file, data, this.size);
            this.file.writeUnlock(mylock2);
            if (returnCode == -48) {
                returnCode = -44;
            }
            return returnCode;
        }
        if (!this.isIO()) {
            return -49;
        }
        long restoreReadRecordPosition = this.readRecord++;
        int returnCode = this.position();
        if (returnCode != 0 && returnCode != -10) {
            this.iostatus(returnCode);
            return returnCode;
        }
        this.updateRelativeKey();
        if (this.microfocus) {
            this.size = data.length();
            if (this.dependingOn != null) {
                this.size = this.dependingOn.toInt();
            } else if (this.size <= 0) {
                this.size = this.maximum;
            }
            if (this.fixed()) {
                int statusSize = this.MF_statusSize();
                this.positionData();
                int mylock6 = this.file.writeLock(this.positionValue, statusSize + this.size);
                int result = this.privateWrite(this.file, data, this.size);
                byte[] status = new byte[statusSize];
                if (statusSize == 1) {
                    status[0] = 10;
                } else {
                    status[0] = 13;
                    status[1] = 10;
                }
                this.positionStatus();
                int result2 = this.file.write(status, 0, status.length);
                this.file.writeUnlock(mylock6);
                this.readRecord = restoreReadRecordPosition;
                if (result < 0) {
                    return result;
                }
                if (result2 < 0) {
                    return result2;
                }
                return result;
            }
            int prefixSize = this.MF_prefixSize();
            int statusSize = this.MF_statusSize();
            int mylock7 = this.file.writeLock(this.positionValue, statusSize + prefixSize + this.size);
            byte[] prefix = new byte[prefixSize];
            if (prefixSize == 2) {
                prefix[0] = (byte)(0x40 | this.size >> 8 & 0xF);
                prefix[1] = (byte)(this.size & 0xFF);
            } else {
                prefix[0] = (byte)(0x40 | this.size >> 24 & 0xF);
                prefix[1] = (byte)(this.size >> 16 & 0xFF);
                prefix[2] = (byte)(this.size >> 8 & 0xFF);
                prefix[3] = (byte)(this.size & 0xFF);
            }
            this.positionLength();
            int result1 = this.file.write(prefix, 0, prefix.length);
            byte[] status = new byte[statusSize];
            if (statusSize == 1) {
                status[0] = 10;
            } else {
                status[0] = 13;
                status[1] = 10;
            }
            this.positionStatus();
            int result2 = this.file.write(status, 0, status.length);
            this.positionData();
            int result = this.privateWrite(this.file, data, this.size);
            this.readRecord = restoreReadRecordPosition;
            if (result1 < 0) {
                this.iostatus(result1);
                return result1;
            }
            if (result2 < 0) {
                this.iostatus(result2);
                return result2;
            }
            return result;
        }
        if (this.acucobol) {
            this.size = data.length();
            if (this.dependingOn != null) {
                this.size = this.dependingOn.toInt();
            } else if (this.size <= 0) {
                this.size = this.maximum;
            }
            this.positionLength();
            int prefixSize = 0;
            if (this.variable()) {
                prefixSize += 2;
            }
            int mylock8 = this.file.writeLock(this.positionValue, prefixSize + this.size);
            int result1 = 0;
            if (this.variable()) {
                byte[] prefix = this.shortToBytes(this.size);
                result1 = this.file.write(prefix, 0, prefix.length);
            }
            this.positionData();
            int result2 = this.privateWrite(this.file, data, this.size);
            this.readRecord = restoreReadRecordPosition;
            int result = result2;
            if (result >= 0 && this.size < this.maximum) {
                int pad = this.maximum - this.size;
                while (pad > 0) {
                    if (pad > 80) {
                        result = this.file.write(spaces, 0, 80);
                        pad -= 80;
                        continue;
                    }
                    result = this.file.write(spaces, 0, pad);
                    pad = 0;
                }
            }
            if (result1 < 0) {
                this.iostatus(result1);
                return result1;
            }
            if (result2 < 0) {
                this.iostatus(result2);
                return result2;
            }
            this.iostatus(result);
            this.file.writeUnlock(mylock8);
            return result2;
        }
        returnCode = this.inner_undelete();
        if (returnCode != 0 && returnCode != -10) {
            this.iostatus(returnCode);
            return returnCode;
        }
        this.size = data.length();
        if (this.dependingOn != null) {
            this.size = this.dependingOn.toInt();
        } else if (this.size <= 0) {
            this.size = this.maximum;
        }
        if (this.variable()) {
            byte[] result = this.intToBytes(this.size);
            mylock = this.file.writeLock(this.positionValue, 4);
            returnCode = this.file.write(result, 0, 4);
            this.file.writeUnlock(mylock);
            if (returnCode == -9) {
                returnCode = 0;
            }
        }
        mylock = this.file.writeLock(this.positionValue, this.size + 4);
        int result = this.privateWrite(this.file, data, this.size);
        this.file.writeUnlock(mylock);
        this.readRecord = restoreReadRecordPosition;
        return result;
    }

    @Override
    public boolean advance(int n) {
        return false;
    }

    @Override
    public boolean advance() {
        return false;
    }

    @Override
    public boolean advancePage() {
        return false;
    }

    public int inner_delete() {
        int returnCode;
        this.setLastOp(LastOp.DELETE);
        if (this.acucobol) {
            this.position();
            byte[] deleted = new byte[this.getTotalRecordSize()];
            return this.file.write(deleted, 0, deleted.length);
        }
        long restoreReadRecordPosition = this.readRecord;
        if (this.isSequential()) {
            this.readRecord = this.relativeKey.toLong();
        }
        if ((returnCode = this.positionStatus()) != 0 && returnCode != -10) {
            this.readRecord = restoreReadRecordPosition;
            return returnCode;
        }
        if (this.microfocus) {
            int statusSize = this.MF_statusSize();
            int mylock = this.file.writeLock(this.positionValue, statusSize);
            byte[] status = new byte[statusSize];
            if (statusSize == 1) {
                status[0] = 0;
            } else {
                status[0] = 13;
                status[1] = 0;
            }
            int result = this.file.write(status);
            this.file.writeUnlock(mylock);
            this.readRecord = restoreReadRecordPosition;
            return result;
        }
        int mylock = this.file.writeLock(this.positionValue, 1);
        int result = this.file.write(new byte[]{1});
        this.file.writeUnlock(mylock);
        this.readRecord = restoreReadRecordPosition;
        return result;
    }

    public int inner_undelete() {
        if (this.acucobol) {
            return 0;
        }
        this.readSize = -1;
        long restoreReadRecordPosition = this.readRecord;
        int returnCode = this.positionStatus();
        if (returnCode != 0 && returnCode != -10) {
            this.readRecord = restoreReadRecordPosition;
            return returnCode;
        }
        if (this.microfocus) {
            int statusSize = this.MF_statusSize();
            int mylock = this.file.writeLock(this.positionValue, statusSize);
            byte[] status = new byte[statusSize];
            if (statusSize == 1) {
                status[0] = 0;
            } else {
                status[0] = 13;
                status[1] = 0;
            }
            int result = this.file.write(status);
            this.file.writeUnlock(mylock);
            this.readRecord = restoreReadRecordPosition;
            return result;
        }
        int mylock = this.file.writeLock(this.positionValue, 1);
        int result = this.file.write(new byte[]{2});
        this.file.writeUnlock(mylock);
        this.readRecord = restoreReadRecordPosition;
        return result;
    }

    public long getPosition() {
        return this.relativeKey == null || this.isSequential() ? this.readRecord : this.relativeKey.toLong();
    }

    public long getLockPosition() {
        return (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (this.relativeKey == null || this.isSequential() ? this.readRecord + 1L : this.relativeKey.toLong());
    }

    public int position() {
        return this.position(this.getPosition());
    }

    public int positionStatus() {
        return this.positionStatus(this.getPosition());
    }

    public int positionData() {
        return this.positionData(this.getPosition());
    }

    public int positionLength() {
        return this.positionLength(this.getPosition());
    }

    protected int getTotalRecordSize() {
        int length = this.maximum + this.getRecordHeaderSize();
        if (this.alignment != 1 && this.variable()) {
            int adjustment = this.alignment - length % this.alignment;
            if (adjustment == this.alignment) {
                adjustment = 0;
            }
            length += adjustment;
        }
        return length;
    }

    public int position(long n) {
        this.readRecord = n;
        if (this.readRecord < (long)this.STARTING_RECORD) {
            return -24;
        }
        long offset = (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (n - (long)this.STARTING_RECORD);
        int returnCode = this.file.seek(offset);
        this.positionValue = offset;
        if (returnCode > 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int positionStatus(long n) {
        this.readRecord = n;
        if (this.readRecord < (long)this.STARTING_RECORD) {
            return -24;
        }
        long offset = (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (n - (long)this.STARTING_RECORD);
        if (this.microfocus) {
            offset = this.fixed() ? (offset += (long)this.maximum) : (offset += (long)(this.MF_prefixSize() + this.maximum));
        }
        int returnCode = this.file.seek(offset);
        this.positionValue = offset;
        if (returnCode > 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int positionData(long n) {
        this.readRecord = n;
        if (this.readRecord < (long)this.STARTING_RECORD) {
            return -24;
        }
        long offset = (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (n - (long)this.STARTING_RECORD);
        if (this.microfocus) {
            if (this.variable()) {
                offset += (long)this.MF_prefixSize();
            }
        } else if (this.acucobol) {
            if (this.variable()) {
                offset += 2L;
            }
        } else {
            ++offset;
            if (this.variable()) {
                offset += 4L;
            }
        }
        int returnCode = this.file.seek(offset);
        this.positionValue = offset;
        if (returnCode > 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public int positionLength(long n) {
        this.readRecord = n;
        if (this.readRecord < (long)this.STARTING_RECORD) {
            return -24;
        }
        long offset = (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (n - (long)this.STARTING_RECORD);
        if (!this.microfocus && !this.acucobol) {
            ++offset;
        }
        int returnCode = this.file.seek(offset);
        this.positionValue = offset;
        if (returnCode > 0) {
            returnCode = 0;
        }
        return returnCode;
    }

    public boolean isPositionWithinFile(long n) {
        if (n < (long)this.STARTING_RECORD) {
            return false;
        }
        long offset = (long)this.getHeaderSize() + (long)this.getTotalRecordSize() * (n - (long)this.STARTING_RECORD);
        return offset + (long)this.getTotalRecordSize() <= this.file.length();
    }

    public int lastPosition() {
        long lenlesshead = this.file.length() - (long)this.getHeaderSize();
        long totreclen = this.getTotalRecordSize();
        long n = lenlesshead / totreclen;
        long r = lenlesshead % totreclen;
        if (n < 0L) {
            n = 0L;
        } else if (this.variable() && r != 0L) {
            ++n;
        }
        return (int)n;
    }

    public int getRecordHeaderSize() {
        if (this.microfocus) {
            int osheader = this.microfocus_unix ? 1 : 2;
            return this.fixed() ? osheader : osheader + this.MF_prefixSize();
        }
        if (this.acucobol) {
            return this.variable() ? 2 : 0;
        }
        return this.variable() ? 5 : 1;
    }

    public void updateRelativeKey() {
        if (this.relativeKey != null) {
            this.relativeKey.move(this.readRecord);
        }
    }

    public boolean isDeleted(long recordNumber, boolean defaultError) {
        this.keyalreadypresent = false;
        int returnCode = this.positionStatus(recordNumber);
        if (returnCode < 0) {
            return true;
        }
        return this.isDeleted(defaultError);
    }

    public boolean isDeleted(boolean defaultError) {
        this.keyalreadypresent = false;
        int delCheck = this.acucobol ? this.getTotalRecordSize() : 1;
        byte[] delArray = null;
        delArray = new byte[delCheck];
        int mylock = this.file.readLock(this.positionValue, delCheck);
        int returnCode = this.file.read(delArray, 0, delCheck, true);
        this.file.readUnlock(mylock);
        if (returnCode > 0) {
            if (returnCode < delCheck) {
                delCheck = returnCode;
            }
            returnCode = 0;
        }
        if (returnCode < 0) {
            this.iostatus(returnCode);
            return defaultError;
        }
        if (this.microfocus) {
            byte status = delArray[0];
            if (status == 13) {
                mylock = this.file.readLock(this.positionValue + 1L, 1);
                returnCode = this.file.read(delArray, 0, 1, true);
                this.file.readUnlock(mylock);
                status = delArray[0];
            }
            if (status == 0) {
                this.iostatus(-23);
                return true;
            }
            this.keyalreadypresent = true;
            this.iostatus(0);
            return false;
        }
        if (this.acucobol) {
            int limit = delArray.length;
            if (delCheck < limit) {
                limit = delCheck;
            }
            for (int i = 0; i < limit; ++i) {
                if (delArray[i] == 0) continue;
                this.keyalreadypresent = true;
                return false;
            }
            return true;
        }
        byte status = delArray[0];
        if (status == 0) {
            this.iostatus(-23);
            return defaultError;
        }
        if (status == 1) {
            this.iostatus(-23);
            return true;
        }
        if (status == 2) {
            this.keyalreadypresent = true;
            this.iostatus(0);
            return false;
        }
        return defaultError;
    }

    public boolean isDeletedErrorTrue() {
        return this.isDeleted(true);
    }

    public boolean isDeletedErrorFalse() {
        return this.isDeleted(false);
    }

    public boolean start(String format, Variable nullKeyMap, int mode, Variable keyposition) {
        return this.start(mode, keyposition);
    }

    public boolean start(int mode, Variable keyposition) {
        return this.start(mode, keyposition.toInt());
    }

    public boolean start(String format, Variable nullKeyMap, int keyposition) {
        return this.start(keyposition);
    }

    public boolean start(int keyposition) {
        return this.start(0, keyposition);
    }

    public boolean start(String format, Variable nullKeyMap, Variable keyposition) {
        return this.start(keyposition);
    }

    public boolean start(Variable keyposition) {
        return this.start(0, keyposition.toInt());
    }

    public boolean start(String format, Variable nullKeyMap, int mode, int keyposition) {
        return this.start(mode, keyposition);
    }

    public boolean start(int mode, int keyposition) {
        if (this.noOps) {
            this.iostatus(0);
            return true;
        }
        try {
            this.iostatus(0);
            this.file.clearReadError();
            this.readSize = -1;
            int returnCode = 0;
            if (this.acucobol) {
                int limit = this.maximum;
                if (limit > 256) {
                    limit = 256;
                }
                byte[] checkExist = new byte[limit];
                int mylock = this.file.readLock(this.positionValue, 1);
                int returnCodeRead = 0;
                returnCode = this.position(keyposition);
                returnCodeRead = this.file.read(checkExist);
                this.file.readUnlock(mylock);
                boolean deleted = true;
                if (returnCodeRead > 0) {
                    if (returnCodeRead < limit) {
                        limit = returnCodeRead;
                    }
                    for (int i = 0; i < limit; ++i) {
                        if (checkExist[i] == 0) continue;
                        deleted = false;
                    }
                    returnCodeRead = 0;
                }
                if (returnCodeRead == -10 || deleted) {
                    returnCode = -23;
                    this.file.clearReadError();
                } else {
                    this.position(keyposition);
                }
            } else if (this.microfocus) {
                byte[] checkExist = new byte[1];
                int mylock = this.file.readLock(this.positionValue, 1);
                int returnCodeRead = 0;
                if (mode == 2 || mode == 1 || mode == -2 || mode == -1) {
                    if (mode == 2 || mode == 1 && keyposition == 0) {
                        ++keyposition;
                    } else if (mode == -2) {
                        --keyposition;
                    }
                    if (mode == 2 || mode == 1) {
                        --keyposition;
                    } else {
                        int lp = this.lastPosition();
                        if (keyposition > lp) {
                            keyposition = lp;
                        }
                        ++keyposition;
                    }
                    do {
                        keyposition = mode == 2 || mode == 1 ? ++keyposition : --keyposition;
                        checkExist[0] = 3;
                        returnCode = this.position(keyposition);
                        if (returnCode != 0) {
                            returnCodeRead = returnCode;
                            break;
                        }
                        mylock = this.file.readLock(this.positionValue, 1);
                        this.file.clearReadError();
                        returnCodeRead = this.file.read(checkExist);
                        this.file.readUnlock(mylock);
                    } while (checkExist[0] == 0 || checkExist[0] == 1 || checkExist[0] == 0);
                    if (returnCodeRead == -10) {
                        returnCode = -23;
                        this.file.clearReadError();
                    }
                } else {
                    returnCode = this.position(keyposition);
                    returnCodeRead = this.file.read(checkExist);
                    mylock = this.file.readLock(this.positionValue, 1);
                    this.file.readUnlock(mylock);
                    if (returnCodeRead > 0) {
                        returnCodeRead = 0;
                    }
                    if (returnCodeRead == -10 || checkExist[0] == 0) {
                        returnCode = -23;
                        this.file.clearReadError();
                    }
                }
            } else {
                byte[] checkExist = new byte[1];
                int returnCodeRead = 0;
                if (mode == 2 || mode == 1 || mode == -2 || mode == -1) {
                    if (mode == 2 || mode == 1 && keyposition == 0) {
                        ++keyposition;
                    } else if (mode == -2) {
                        --keyposition;
                    }
                    if (mode == 2 || mode == 1) {
                        --keyposition;
                    } else {
                        int lp = this.lastPosition();
                        if (keyposition > lp) {
                            keyposition = lp;
                        }
                        ++keyposition;
                    }
                    do {
                        keyposition = mode == 2 || mode == 1 ? ++keyposition : --keyposition;
                        checkExist[0] = 3;
                        returnCode = this.position(keyposition);
                        if (returnCode != 0) {
                            returnCodeRead = returnCode;
                            break;
                        }
                        int mylock = this.file.readLock(this.positionValue, 1);
                        this.file.clearReadError();
                        returnCodeRead = this.file.read(checkExist);
                        this.file.readUnlock(mylock);
                    } while (checkExist[0] == 0 || checkExist[0] == 1);
                    if (returnCodeRead == -10 || checkExist[0] != 2) {
                        returnCode = -23;
                        this.file.clearReadError();
                    }
                } else {
                    returnCode = this.position(keyposition);
                    returnCodeRead = this.file.read(checkExist);
                    int mylock = this.file.readLock(this.positionValue, 1);
                    this.file.readUnlock(mylock);
                    if (returnCodeRead > 0) {
                        returnCodeRead = 0;
                    }
                    if (returnCodeRead == -10 || checkExist[0] == 0) {
                        returnCode = -23;
                        this.file.clearReadError();
                    }
                }
            }
            this.setLastOp(LastOp.START);
            this.iostatus(returnCode);
            return this.isinvalidkey(returnCode);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return false;
        }
    }

    @Override
    public void init() {
        try {
            this.readSize = -1;
            if (this.isOpen) {
                this.close();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public Numeric getLinageCounter() {
        return new Numeric(1);
    }

    public String toString() {
        try {
            String linesep = System.getProperty("line.separator");
            if (linesep == null) {
                linesep = "\n";
            }
            StringBuffer result = new StringBuffer();
            result.append("ORGANIZATION IS RELATIVE").append(linesep);
            if (this.isRandom()) {
                result.append("ACCESS MODE IS RANDOM").append(linesep);
            } else if (this.isDynamic()) {
                result.append("ACCESS MODE IS DYNAMIC").append(linesep);
            } else {
                result.append("ACCESS MODE IS SEQUENTIAL").append(linesep);
            }
            if (this.optional) {
                result.append("OPTIONAL").append(linesep);
            }
            if (this.filenameVariable != null) {
                result.append("ASSIGN TO ").append(this.filenameVariable.getName()).append("=\"").append(this.filenameVariable.toString().trim()).append("\"").append(linesep);
            } else if (this.file != null) {
                result.append("ASSIGN TO \"").append(this.file.getFilename()).append("\"").append(linesep);
            }
            if (this.file.isOpen()) {
                result.append("CURRENTLY OPEN").append(linesep);
            } else {
                result.append("CURRENTLY CLOSED").append(linesep);
            }
            if (this.externalFile != null) {
                result.append("EXTERNAL").append(linesep);
            }
            if (this.fileStatus != null) {
                result.append("FILE STATUS IS ").append(this.fileStatus.getName()).append("=").append(this.fileStatus.toDisplayString()).append(linesep);
            } else if (this.priorErrorCode < 0) {
                result.append("IMPLICIT FILE STATUS IS ").append(-this.priorErrorCode).append(linesep);
            } else {
                result.append("IMPLICIT FILE STATUS IS ").append(this.priorErrorCode).append(linesep);
            }
            if (this.fixed()) {
                result.append("RECORDING MODE IS FIXED").append(linesep);
            } else {
                result.append("RECORDING MODE IS VARIABLE").append(linesep);
            }
            if (this.dependingOn != null) {
                result.append("DEPENDING ON ").append(this.dependingOn.getName()).append('=').append(this.dependingOn.toInt()).append(linesep);
            }
            String prot = "ECOBOL PROTOCOL";
            if (defaultMicroFocus) {
                prot = "MICRO FOCUS PROTOCOL";
            }
            if (defaultACU) {
                prot = "ACUCOBOL PROTOCOL";
            }
            result.append(prot).append(linesep);
            if (this.minimum != -1 || this.maximum != -1) {
                if (this.minimum == this.maximum) {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" CHARACTERS").append(linesep);
                } else {
                    result.append("RECORD CONTAINS ").append(this.minimum).append(" TO ").append(this.maximum).append(" CHARACTERS").append(linesep);
                }
            }
            return result.toString();
        }
        catch (RuntimeException t) {
            return "RELATIVE FILE (LOOKUP EXCEPTION OCCURRED)";
        }
    }

    @Override
    public Object getObject() {
        return this.file != null ? this.file.getObject() : null;
    }

    public void finalize() {
        this.init();
    }

    public boolean deleteFile() {
        File ref;
        boolean deleted = false;
        String filename = this.currentFilename();
        if (filename != null && (ref = new File(filename)).exists()) {
            deleted = ref.delete();
        }
        if (deleted) {
            this.iostatus(0);
        } else {
            this.iostatus(-5);
        }
        return deleted;
    }

    @Override
    public String getFilename() {
        return this.file != null ? this.file.getFilename() : null;
    }

    protected boolean isRandom() {
        return this.accessMode == 2;
    }

    protected boolean isDynamic() {
        return this.accessMode == 4;
    }

    protected boolean isSequential() {
        return this.accessMode == 1;
    }

    private int bytesToInt(byte[] array) {
        int number = 0;
        if (this.microfocus || this.acucobol) {
            if (array.length == 4) {
                number = (array[0] & 0xFF) << 24 | (array[1] & 0xFF) << 16 | (array[2] & 0xFF) << 8 | array[3] & 0xFF;
            } else if (array.length == 2) {
                number = (array[0] & 0xFF) << 8 | array[1] & 0xFF;
            }
        } else if (array.length == 4) {
            number = (array[3] & 0xFF) << 24 | (array[2] & 0xFF) << 16 | (array[1] & 0xFF) << 8 | array[0] & 0xFF;
        } else if (array.length == 2) {
            number = (array[1] & 0xFF) << 8 | array[0] & 0xFF;
        }
        return number;
    }

    private byte[] intToBytes(int number) {
        byte[] result = new byte[4];
        if (this.microfocus || this.acucobol) {
            result[3] = (byte)(number & 0xFF);
            result[2] = (byte)(number >> 8 & 0xFF);
            result[1] = (byte)(number >> 16 & 0xFF);
            result[0] = (byte)(number >> 24 & 0xFF);
        } else {
            result[0] = (byte)(number & 0xFF);
            result[1] = (byte)(number >> 8 & 0xFF);
            result[2] = (byte)(number >> 16 & 0xFF);
            result[3] = (byte)(number >> 24 & 0xFF);
        }
        return result;
    }

    private byte[] shortToBytes(int number) {
        byte[] result = new byte[2];
        if (this.microfocus || this.acucobol) {
            result[1] = (byte)(number & 0xFF);
            result[0] = (byte)(number >> 8 & 0xFF);
        } else {
            result[0] = (byte)(number & 0xFF);
            result[1] = (byte)(number >> 8 & 0xFF);
        }
        return result;
    }

    private boolean writeHeader() {
        if (this.acucobol) {
            return true;
        }
        if (this.microfocus) {
            if (this.fixed()) {
                return true;
            }
            this.file.seek(0);
            byte[] data = this.MF_header();
            int mylock = this.file.writeLock(0L, data.length);
            this.file.write(data, 0, data.length);
            this.file.writeUnlock(mylock);
            return true;
        }
        int mylock = this.file.writeLock(0L, 8);
        byte[] varsize = this.intToBytes(this.minimum);
        this.file.write(varsize);
        varsize = this.intToBytes(this.maximum);
        this.file.write(varsize);
        this.file.writeUnlock(mylock);
        return true;
    }

    private int readHeader() {
        if (this.acucobol) {
            return 0;
        }
        if (this.microfocus) {
            if (this.fixed()) {
                return 0;
            }
            this.file.seek(0);
            int mylock = this.file.readLock(0L, 128);
            byte[] header = new byte[128];
            this.file.read(header, 0, 128);
            boolean result = this.MF_header(header);
            this.file.readUnlock(mylock);
            return result ? 0 : -39;
        }
        int oldmin = this.minimum;
        int oldmax = this.maximum;
        byte[] varsize = new byte[4];
        int mylock = this.file.readLock(0L, 4);
        int returnCode = this.file.read(varsize, 0, 4);
        this.file.readUnlock(mylock);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            this.readSize = -1;
            return returnCode;
        }
        this.minimum = this.bytesToInt(varsize);
        mylock = this.file.readLock(4L, 4);
        returnCode = this.file.read(varsize, 0, 4);
        this.file.readUnlock(mylock);
        if (returnCode < 0) {
            this.iostatus(returnCode);
            this.readSize = -1;
            return returnCode;
        }
        this.maximum = this.bytesToInt(varsize);
        if (oldmax > this.maximum) {
            this.maximum = oldmax;
            this.minimum = oldmin;
            this.file.close();
            this.isOpen = false;
            this.iostatus(-39);
            return -39;
        }
        return 0;
    }

    private int getHeaderSize() {
        if (this.microfocus) {
            return this.fixed() ? 0 : 128;
        }
        if (this.acucobol) {
            return 0;
        }
        return 12;
    }

    private int MF_prefixSize() {
        return this.maximum >= 4096 ? 4 : 2;
    }

    private int MF_statusSize() {
        return this.microfocus && this.microfocus_win ? 2 : 1;
    }

    private byte[] MF_header() {
        int i;
        byte zero;
        byte[] result = new byte[128];
        if (this.getSize() < 4096) {
            result[0] = 48;
            result[1] = 126;
            result[2] = 0;
            result[3] = 0;
        } else {
            result[0] = 48;
            result[1] = 0;
            result[2] = 0;
            result[3] = 124;
        }
        result[4] = result[5] = (zero = 0);
        result[6] = result[7] = zero;
        Calendar cal = Calendar.getInstance();
        int cen = cal.get(1);
        int year = cen - 2000;
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        result[8] = result[22] = (byte)(year / 10 + 48);
        result[9] = result[23] = (byte)(year % 10 + 48);
        result[10] = result[24] = (byte)(month / 10 + 48);
        result[11] = result[25] = (byte)(month % 10 + 48);
        result[12] = result[26] = (byte)(date / 10 + 48);
        result[13] = result[27] = (byte)(date % 10 + 48);
        result[14] = result[28] = (byte)(hour / 10 + 48);
        result[15] = result[29] = (byte)(hour % 10 + 48);
        result[16] = result[30] = (byte)(min / 10 + 48);
        result[17] = result[31] = (byte)(min % 10 + 48);
        result[18] = result[32] = (byte)(sec / 10 + 48);
        result[19] = result[33] = (byte)(sec % 10 + 48);
        result[20] = result[34] = (byte)(cen / 10 + 48);
        result[21] = result[35] = (byte)(cen % 10 + 48);
        result[36] = 0;
        result[37] = 62;
        result[38] = zero;
        result[39] = 3;
        result[40] = zero;
        result[41] = 0;
        result[42] = zero;
        result[43] = 3;
        for (i = 44; i < 48; ++i) {
            result[i] = zero;
        }
        result[48] = (byte)(this.variable() ? 1 : 0);
        for (i = 49; i < 56; ++i) {
            result[i] = zero;
        }
        result[56] = (byte)(this.maximum / 256);
        result[57] = (byte)(this.maximum & 0xFF);
        result[58] = zero;
        result[59] = zero;
        result[60] = (byte)(this.minimum / 256);
        result[61] = (byte)(this.minimum & 0xFF);
        for (i = 62; i < 108; ++i) {
            result[i] = zero;
        }
        result[108] = 67;
        result[109] = 0;
        result[110] = 31;
        result[111] = -9;
        for (i = 112; i < 128; ++i) {
            result[i] = zero;
        }
        return result;
    }

    private boolean MF_header(byte[] parse) {
        if (parse[39] != 3) {
            return false;
        }
        if (parse[41] != 0) {
            return false;
        }
        if (parse[42] != 3) {
            return false;
        }
        this.maximum = (parse[56] & 0xFF) * 256 | parse[57] & 0xFF;
        this.minimum = (parse[60] & 0xFF) * 256 | parse[61] & 0xFF;
        return this.minimum <= this.maximum;
    }

    @Override
    public void unlock() {
        try {
            this.lockRecord.unlockAll();
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return;
        }
    }

    public void exclusive() {
        try {
            while (!this.lockRecord.exclusive()) {
                this.iostatus(-93);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return;
        }
    }

    public void exclusiveConditionally() {
        try {
            if (this.lockRecord.exclusive()) {
                this.iostatus(0);
            } else {
                this.iostatus(-93);
            }
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return;
        }
    }

    public void unexclusive() {
        try {
            this.lockRecord.unexclusive();
            this.iostatus(0);
        }
        catch (Throwable javaException) {
            this.iostatus(-98);
            return;
        }
    }

    public void flushCache() {
    }

    public relFile setPassword(Variable identifier) {
        return this;
    }

    public relFile clone() {
        throw new RuntimeException("Multi browser sessions not supported by this file type.");
    }

    protected LastOp getLastOp() {
        return this.lastOp;
    }

    protected void setLastOp(LastOp lastOp) {
        this.lastOp = lastOp;
    }

    static {
        spaces = new byte[80];
        int spaceByte = 32;
        for (int i = 0; i < 80; ++i) {
            relFile.spaces[i] = spaceByte;
        }
    }

    protected static enum LastOp {
        START,
        OPEN,
        CLOSE,
        READNEXT,
        READPREV,
        REWRITE,
        DELETE,
        WRITE;

    }
}

