/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.FileConstants;
import com.heirloomcomputing.ecs.exec.FileProtocol;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import java.awt.FileDialog;
import java.awt.Frame;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class smartFile
implements FileConstants {
    private static final String PGM = "smartFile";
    public static String lineSeparator = "\r\n";
    public static byte[] lineSeparatorBytes = new byte[]{13, 10};
    public static int lineSeparatorLength = 2;
    private static int fileStatusCodes = -1;
    private static final byte[] emptyBytes = new byte[0];
    private static byte[] carriageReturn = new byte[]{13};
    private static final Hashtable<String, Class<?>> protocolRegistry = new Hashtable();
    private static final Hashtable<String, String> dialogFiles = new Hashtable();
    private static Charset defaultDataCharset;
    private Charset dataCharset = null;
    public boolean justRead;
    public boolean readError;
    public boolean newFile;
    private FileProtocol handler;
    private int recordSize = -1;
    private String filename;
    private boolean lineSequential;
    private boolean lock;
    private boolean trackStats;
    private int lines = 1;
    private int pages;
    private int cols;
    private int lineLength = -1;
    private int pageLength = 66;
    private int top = 0;
    private int bottom = 0;
    private int footer = -1;
    private int linage = 0;
    private Variable topVar;
    private Variable bottomVar;
    private Variable footerVar;
    private Variable linageVar;
    private boolean multi;
    private boolean usingDefaultProtocol = false;

    public static final int fileStatus(int value, int second) {
        switch (fileStatusCodes) {
            default: {
                return value;
            }
            case 55: {
                switch (value) {
                    case 5: {
                        return 0;
                    }
                    case 7: {
                        return 0;
                    }
                    case 14: {
                        return 0;
                    }
                    case 24: {
                        if (second != 1) break;
                        return 0;
                    }
                    case 35: {
                        return 94;
                    }
                    case 37: {
                        switch (second) {
                            case 1: {
                                return 95;
                            }
                            case 7: {
                                return 90;
                            }
                            case 8: {
                                return 95;
                            }
                            case 99: {
                                return 37;
                            }
                        }
                        return 95;
                    }
                    case 38: {
                        return 93;
                    }
                    case 39: {
                        return 94;
                    }
                    case 41: {
                        return 92;
                    }
                    case 42: {
                        return 91;
                    }
                    case 43: {
                        return 90;
                    }
                    case 44: {
                        return 97;
                    }
                    case 46: {
                        return 96;
                    }
                    case 47: {
                        switch (second) {
                            case 1: {
                                return 90;
                            }
                            case 2: {
                                return 91;
                            }
                        }
                        return 47;
                    }
                    case 48: {
                        switch (second) {
                            case 1: {
                                return 90;
                            }
                            case 2: {
                                return 91;
                            }
                        }
                        return 48;
                    }
                    case 49: {
                        switch (second) {
                            case 1: {
                                return 90;
                            }
                            case 2: {
                                return 91;
                            }
                        }
                        return 49;
                    }
                }
                return value;
            }
            case 86: {
                switch (value) {
                    case 10: {
                        return 13;
                    }
                    case 37: {
                        switch (second) {
                            case 1: {
                                return 37;
                            }
                            case 7: {
                                return 39;
                            }
                            case 8: {
                                return 37;
                            }
                            case 99: {
                                return 37;
                            }
                        }
                        return 37;
                    }
                    case 93: {
                        return 91;
                    }
                    case 94: {
                        switch (second) {
                            case 10: {
                                return 39;
                            }
                            case 62: {
                                return 39;
                            }
                            case 63: {
                                return 39;
                            }
                        }
                        return 39;
                    }
                    case 98: {
                        return 30;
                    }
                    case 99: {
                        return 92;
                    }
                }
                return value;
            }
            case 68: 
            case 73: {
                switch (value) {
                    case 2: {
                        return 0;
                    }
                    case 5: {
                        return 0;
                    }
                    case 7: {
                        return 0;
                    }
                    case 14: {
                        return 0;
                    }
                    case 24: {
                        if (second != 1) break;
                        return 0;
                    }
                    case 35: {
                        return 91;
                    }
                    case 37: {
                        switch (second) {
                            case 1: {
                                return 91;
                            }
                            case 7: {
                                return 91;
                            }
                            case 8: {
                                return 91;
                            }
                            case 99: {
                                return 37;
                            }
                        }
                        return 91;
                    }
                    case 38: {
                        return 92;
                    }
                    case 39: {
                        break;
                    }
                    case 41: {
                        return 91;
                    }
                    case 42: {
                        return 92;
                    }
                    case 43: {
                        return 92;
                    }
                    case 44: {
                        return 92;
                    }
                    case 46: {
                        return 92;
                    }
                    case 47: {
                        switch (second) {
                            case 1: {
                                return 92;
                            }
                            case 2: {
                                return 92;
                            }
                        }
                        return 92;
                    }
                    case 48: {
                        switch (second) {
                            case 1: {
                                return 92;
                            }
                            case 2: {
                                return 92;
                            }
                        }
                        return 92;
                    }
                    case 49: {
                        switch (second) {
                            case 1: {
                                return 92;
                            }
                            case 2: {
                                return 92;
                            }
                        }
                        return 92;
                    }
                    case 93: {
                        return 94;
                    }
                    case 94: {
                        switch (second) {
                            case 10: {
                                return 97;
                            }
                            case 62: {
                                return 92;
                            }
                            case 63: {
                                return 92;
                            }
                        }
                        return 92;
                    }
                    case 98: {
                        break;
                    }
                    case 99: {
                        return 94;
                    }
                }
                return value;
            }
            case -1: 
        }
        String status = RuntimeEnvironment.getGlobalParameter("FILE_STATUS_CODES");
        fileStatusCodes = status != null && status.length() > 0 ? (int)Character.toUpperCase(status.charAt(0)) : 0;
        return value;
    }

    private static void setLineSeparators() {
        try {
            lineSeparator = RuntimeEnvironment.getGlobalParameter("line.separator");
            lineSeparatorLength = lineSeparator.length();
        }
        catch (Throwable t) {
            lineSeparator = "\r\n";
            lineSeparatorLength = 2;
        }
        try {
            String checkCobolLineSeparator = RuntimeEnvironment.getGlobalParameter("COBOL.LINE.SEPARATOR");
            StringBuffer result = new StringBuffer();
            if (checkCobolLineSeparator != null) {
                StringTokenizer st = new StringTokenizer(checkCobolLineSeparator, "\t\n\r ,;:");
                while (st.hasMoreTokens()) {
                    String check = st.nextToken();
                    if (check == null) continue;
                    try {
                        int i = ConvertData.parseInt(check);
                        if (i < 0 || i >= 65535) continue;
                        result.append((char)i);
                    }
                    catch (Exception exception) {}
                }
            }
            if (result.length() > 0) {
                lineSeparator = result.toString();
                lineSeparatorLength = lineSeparator.length();
            }
        }
        catch (Throwable checkCobolLineSeparator) {
            // empty catch block
        }
        try {
            lineSeparatorBytes = new byte[lineSeparatorLength];
            for (int i = 0; i < lineSeparatorLength; ++i) {
                smartFile.lineSeparatorBytes[i] = (byte)lineSeparator.charAt(i);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setCharsets() {
        try {
            defaultDataCharset = Charset.forName(System.getProperty("file.encoding"));
            if (defaultDataCharset == Charset.forName("UTF-8")) {
                defaultDataCharset = Charset.forName("ISO-8859-1");
            }
        }
        catch (IllegalCharsetNameException e) {
            defaultDataCharset = Charset.defaultCharset();
        }
        catch (IllegalArgumentException e) {
            defaultDataCharset = Charset.defaultCharset();
        }
    }

    public static final void setFileCharacter(String s0) {
        Context.setGlobalFileCharacter(s0);
    }

    public static final void setFileCharacter(char c0) {
        Context.setGlobalFileCharacter(c0);
    }

    public static final void setFileCharacter() {
        Context.setGlobalFileCharacter('\uffff');
    }

    public static String convertFilename(String f) {
        return Context.globalConvertFilename(f);
    }

    public final void setTrackStats() {
        this.trackStats = true;
    }

    public final boolean isTrackStats() {
        return this.trackStats;
    }

    public final void setTop(int lines) {
        this.top = lines;
    }

    public final void setTop(Variable lines) {
        this.topVar = lines;
    }

    public final void setBottom(int lines) {
        this.bottom = lines;
    }

    public final void setBottom(Variable lines) {
        this.bottomVar = lines;
    }

    public final void setFooter(int lineNumber) {
        this.footer = lineNumber;
    }

    public final void setFooter(Variable lines) {
        this.footerVar = lines;
    }

    public final void setLinage(int lines) {
        this.linage = lines;
        this.trackStats = true;
        this.lineSequential = true;
    }

    public final void setLinage(Variable lines) {
        this.linageVar = lines;
        this.trackStats = true;
        this.lineSequential = true;
    }

    private final void updateLinageVariables() {
        if (this.topVar != null) {
            this.top = this.topVar.toInt();
        }
        if (this.bottomVar != null) {
            this.bottom = this.bottomVar.toInt();
        }
        if (this.footerVar != null) {
            this.footer = this.footerVar.toInt();
        }
        if (this.linageVar != null) {
            this.linage = this.linageVar.toInt();
        }
    }

    public final int getTop() {
        return this.top >= 0 ? this.top : 0;
    }

    public final int getBottom() {
        return this.bottom >= 0 ? this.bottom : 0;
    }

    public final int getFooter() {
        return this.footer <= 0 ? this.getPageBody() : this.footer;
    }

    public final int getFooterAbsolute() {
        return this.getFooter() + this.getTop();
    }

    public final int getPageBody() {
        return this.linage < 1 ? 1 : this.linage + 1;
    }

    public final int getPageLength() {
        this.pageLength = this.getPageBody() + this.getTop() + this.getBottom();
        return this.pageLength;
    }

    public final int getLines() {
        return this.lines;
    }

    public final int getPages() {
        return this.pages;
    }

    public final int getCols() {
        return this.cols;
    }

    public final int getLinage() {
        int vline;
        int top = this.getTop();
        if (this.lines < 0) {
            this.lines = 1;
        }
        if ((vline = this.lines - top) < 1) {
            vline = 1;
        }
        return vline;
    }

    public final void setLines(int lines) {
        this.lines = lines;
    }

    public final boolean advanceLines() {
        return this.advanceLines(1);
    }

    public final boolean advanceLines(int n) {
        boolean overflow = false;
        for (int i = 0; i < n; ++i) {
            ++this.lines;
            if (this.lines == this.getFooterAbsolute()) {
                overflow = true;
            }
            if (this.lines != this.getPageLength()) continue;
            overflow = true;
            this.setLines(1);
            this.updateLinageVariables();
            ++this.pages;
        }
        return overflow;
    }

    public final void resetLines() {
        this.lines = 1;
    }

    public final void resetPages() {
        this.pages = 0;
    }

    public final void resetCols() {
        this.cols = 0;
    }

    public final int linesRemainingOnPage() {
        int vline = this.lines;
        if (vline < this.top) {
            vline = this.top;
        }
        int n = this.getPageBody() - vline;
        return n;
    }

    public final void setColumns(int columns) {
        this.lineLength = columns;
    }

    public final int getColumns() {
        if (this.lineLength == -1) {
            return 132;
        }
        return this.lineLength;
    }

    public final boolean isStream() {
        try {
            return this.handler.isStream();
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean isSeekable() {
        return this.handler.isSeekable();
    }

    public final boolean isOpen() {
        return this.handler.isOpen();
    }

    public final int backup() {
        return this.handler.backup();
    }

    public final void setRecordSize(int recordSize) {
        this.recordSize = recordSize;
    }

    public final void setRecordSize(int minRecordSize, int recordSize) {
        this.recordSize = recordSize;
    }

    public final boolean isLineSequential() {
        return this.lineSequential;
    }

    public final boolean setFilename(String filename) {
        return this.setFilename(filename, false);
    }

    public final boolean setFilename(String filename, boolean passLineSequential) {
        String func = "smartFile.setFilename(String filename,boolean passLineSequential): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("smartFile.setFilename(String filename,boolean passLineSequential): 0. filename=" + filename + ". passLineSequential=" + passLineSequential + ". ");
        }
        if ("PRINTER?".equalsIgnoreCase(filename)) {
            filename = "printer:";
        }
        try {
            Class<?> handlerClass;
            int i;
            boolean continueParsing;
            this.lineSequential = passLineSequential;
            if (filename == null) {
                filename = "loaddialog:";
            }
            String SEPARATOR_STRING = "**";
            int SEPARATOR_STRING_LENGTH = "**".length();
            int separator = filename.indexOf("**");
            if (separator >= 0) {
                filename = filename.length() <= SEPARATOR_STRING_LENGTH ? "" : (separator == 0 ? filename.substring(SEPARATOR_STRING_LENGTH) : (separator == filename.length() - SEPARATOR_STRING_LENGTH ? filename.substring(0, separator) : filename.substring(0, separator) + filename.substring(separator + SEPARATOR_STRING_LENGTH)));
            }
            String protocol = null;
            do {
                URL url22;
                FileDialog fileDialog;
                Frame fileDialogFrame2;
                String dialogDirectory;
                String dialogTitle;
                String dialogFilename;
                if (filename.length() > 0) {
                    switch (filename.charAt(0)) {
                        case '<': 
                        case '>': 
                        case '|': {
                            filename = "ipcio:" + filename.substring(1);
                            break;
                        }
                        case '-': {
                            if (filename.startsWith("-p ") || filename.startsWith("-P ")) {
                                filename = "ipcio:" + filename.substring(2).trim();
                                break;
                            }
                            if (!filename.startsWith("-f ") && !filename.startsWith("-F ") && !filename.startsWith("-d ") && !filename.startsWith("-D ")) break;
                            filename = filename.substring(2).trim();
                        }
                    }
                }
                String parseFilename = filename.toLowerCase();
                continueParsing = true;
                if (parseFilename.startsWith("env:")) {
                    String envname = filename.substring(4);
                    if ((filename = RuntimeEnvironment.getGlobalParameter(envname)) != null) continue;
                    filename = envname;
                    continue;
                }
                if (parseFilename.startsWith("line:")) {
                    this.lineSequential = true;
                    filename = filename.substring(5);
                    continue;
                }
                if (parseFilename.startsWith("ro:")) {
                    filename = filename.substring(3);
                    continue;
                }
                if (parseFilename.startsWith("wo:")) {
                    filename = filename.substring(3);
                    continue;
                }
                if (parseFilename.startsWith("savedialog:")) {
                    protocol = "file";
                    continueParsing = false;
                    i = filename.indexOf(47);
                    dialogFilename = null;
                    dialogTitle = null;
                    dialogDirectory = null;
                    try {
                        if (i >= 0) {
                            dialogFilename = filename.substring(11, i);
                            if ((i = (filename = filename.substring(i + 1)).indexOf(47)) >= 0) {
                                dialogTitle = filename.substring(0, i);
                                if ((i = (filename = filename.substring(i + 1)).indexOf(47)) >= 0) {
                                    dialogDirectory = filename = filename.substring(i + 1);
                                }
                            } else {
                                dialogTitle = filename;
                            }
                        } else {
                            dialogFilename = filename.substring(11);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (dialogFiles.containsKey(dialogFilename)) {
                        filename = dialogFiles.get(dialogFilename);
                        continue;
                    }
                    fileDialogFrame2 = new Frame("Save File Dialog");
                    if (dialogTitle == null) {
                        dialogTitle = "Save File...";
                    }
                    fileDialog = new FileDialog(fileDialogFrame2, dialogTitle, 1);
                    fileDialog.setTitle(dialogTitle);
                    if (dialogDirectory != null) {
                        fileDialog.setDirectory(dialogDirectory);
                    }
                    if (dialogFilename != null) {
                        fileDialog.setFile(dialogFilename);
                    }
                    fileDialog.setVisible(true);
                    filename = fileDialog.getFile();
                    if (filename == null) {
                        this.filename = "~default.tmp";
                        return false;
                    }
                    fileDialogFrame2.dispose();
                    fileDialogFrame2 = null;
                    if (dialogFilename == null || dialogFilename.equalsIgnoreCase("dynamic")) continue;
                    dialogFiles.put(dialogFilename, filename);
                    continue;
                }
                if (parseFilename.startsWith("loaddialog:") || parseFilename.startsWith("opendialog:")) {
                    protocol = "file";
                    continueParsing = false;
                    i = filename.indexOf(47);
                    dialogFilename = null;
                    dialogTitle = null;
                    dialogDirectory = null;
                    try {
                        if (i >= 0) {
                            dialogFilename = filename.substring(11, i);
                            if ((i = (filename = filename.substring(i + 1)).indexOf(47)) >= 0) {
                                dialogTitle = filename.substring(0, i);
                                if ((i = (filename = filename.substring(i + 1)).indexOf(47)) >= 0) {
                                    dialogDirectory = filename = filename.substring(i + 1);
                                }
                            } else {
                                dialogTitle = filename;
                            }
                        } else {
                            dialogFilename = filename.substring(11);
                        }
                    }
                    catch (Exception fileDialogFrame2) {
                        // empty catch block
                    }
                    if (dialogFiles.containsKey(dialogFilename)) {
                        filename = dialogFiles.get(dialogFilename);
                        continue;
                    }
                    fileDialogFrame2 = new Frame("Open File Dialog");
                    if (dialogTitle == null) {
                        dialogTitle = "Open File...";
                    }
                    fileDialog = new FileDialog(fileDialogFrame2, dialogTitle, 0);
                    if (dialogDirectory != null) {
                        fileDialog.setDirectory(dialogDirectory);
                    }
                    if (dialogFilename != null) {
                        fileDialog.setFile(dialogFilename);
                    }
                    fileDialog.setVisible(true);
                    filename = fileDialog.getFile();
                    if (filename == null) {
                        this.filename = "~default.tmp";
                        return false;
                    }
                    fileDialogFrame2.dispose();
                    fileDialogFrame2 = null;
                    if (dialogFilename == null || dialogFilename.equalsIgnoreCase("dynamic")) continue;
                    dialogFiles.put(dialogFilename, filename);
                    continue;
                }
                if (parseFilename.startsWith("file:")) {
                    filename = filename.substring(5);
                    protocol = "file";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("http:")) {
                    try {
                        url22 = new URL(filename);
                        filename = url22.toString();
                    }
                    catch (Exception url22) {
                        // empty catch block
                    }
                    protocol = "http";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("documentbase:")) {
                    filename = "http:" + filename.substring(13);
                    try {
                        url22 = new URL(Utilities.getDocumentBase(), filename);
                        filename = url22.toString();
                    }
                    catch (Exception url3) {
                        // empty catch block
                    }
                    protocol = "http";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("codebase:")) {
                    filename = "http:" + filename.substring(9);
                    try {
                        url22 = new URL(Utilities.getCodeBase(), filename);
                        filename = url22.toString();
                    }
                    catch (Exception url4) {
                        // empty catch block
                    }
                    protocol = "http";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("console:")) {
                    filename = filename.substring(8);
                    this.recordSize = 80;
                    protocol = "console";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("system:")) {
                    filename = filename.substring(7);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("sys:")) {
                    filename = filename.substring(4);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("sysout:")) {
                    filename = filename.substring(7);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("sysin:")) {
                    filename = filename.substring(6);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("stdout:")) {
                    filename = filename.substring(7);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("stdin:")) {
                    filename = filename.substring(6);
                    protocol = "system";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("syserr:")) {
                    filename = filename.substring(7);
                    protocol = "syserr";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("printer:")) {
                    filename = filename.substring(8);
                    this.recordSize = 132;
                    this.lineSequential = true;
                    protocol = "printer";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("oldprinter:")) {
                    filename = filename.substring(11);
                    this.recordSize = 132;
                    this.lineSequential = true;
                    protocol = "printer";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("copy:")) {
                    filename = filename.substring(5);
                    this.recordSize = 256;
                    protocol = "clipboard";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("paste:")) {
                    filename = filename.substring(6);
                    this.recordSize = 256;
                    protocol = "clipboard";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("socket:")) {
                    filename = filename.substring(7);
                    this.recordSize = 256;
                    protocol = "socket";
                    continueParsing = false;
                    continue;
                }
                if (parseFilename.startsWith("server:")) {
                    filename = filename.substring(7);
                    this.recordSize = 256;
                    protocol = "server";
                    continueParsing = false;
                    continue;
                }
                continueParsing = false;
            } while (continueParsing);
            String originalFilename = filename;
            if (protocol == null) {
                i = filename.indexOf(58);
                if (i >= 2) {
                    protocol = filename.substring(0, i);
                    filename = filename.substring(i + 1);
                } else {
                    this.usingDefaultProtocol = true;
                    protocol = "file";
                }
            }
            if ((handlerClass = this.findProtocol(protocol)) == null) {
                handlerClass = protocol != null && protocol.length() > 1 ? this.findProtocol("url") : this.findProtocol("file");
                filename = originalFilename;
            }
            if (handlerClass == null) {
                return false;
            }
            try {
                this.handler = (FileProtocol)handlerClass.newInstance();
            }
            catch (Exception e) {
                return false;
            }
            String tempFilename = filename;
            if (protocol != null && (protocol.equalsIgnoreCase("printer") || protocol.equalsIgnoreCase("oldprinter"))) {
                if (tempFilename != null) {
                    String ucase = tempFilename.toUpperCase();
                    if (ucase.indexOf("COLS=") == -1 && this.getColumns() > 1) {
                        tempFilename = tempFilename + "/COLS=" + this.getColumns();
                    }
                    if (ucase.indexOf("ROWS=") == -1 && this.getPageLength() > 1) {
                        tempFilename = tempFilename + "/ROWS=" + this.getPageLength();
                    }
                } else {
                    tempFilename = "";
                }
            }
            this.filename = tempFilename;
            return this.handler.init(tempFilename, this.lineSequential);
        }
        catch (Throwable throwableException) {
            return false;
        }
    }

    public final void setLineSequential(boolean state) {
        this.lineSequential = state;
        if (this.handler != null) {
            this.handler.setLineSequential(state);
        }
    }

    public final String getFilename() {
        return this.filename;
    }

    public final boolean isNewFile() {
        return this.newFile;
    }

    public final int open() {
        int defaultMode = 0;
        if (this.handler.isReadable()) {
            defaultMode = 1;
        }
        if (this.handler.isWritable()) {
            defaultMode |= 2;
        }
        return this.open(defaultMode);
    }

    public final int open(String filename) {
        return this.setFilename(filename) ? this.open() : -91;
    }

    public final int open(String filename, int mode) {
        return this.setFilename(filename) ? this.open(mode) : -91;
    }

    public final int open(int mode) {
        boolean bl = this.multi = (mode & 0x800) != 0;
        if (this.usingDefaultProtocol && Utilities.isApplet()) {
            this.usingDefaultProtocol = false;
            try {
                URL docBase = Utilities.getDocumentBase();
                String docBaseString = null;
                if (docBase != null) {
                    docBaseString = docBase.getHost();
                }
                if (docBaseString == null) {
                    docBaseString = "127.0.0.1";
                }
                this.filename = docBaseString + ":" + this.filename + ":6584";
                this.setFilename(this.filename);
            }
            catch (Exception e) {
                this.filename = "127.0.0.1:default";
                this.setFilename(this.filename);
            }
            this.usingDefaultProtocol = false;
        }
        if ((mode & 4) != 0) {
            int returnCode = this.inner_open(mode |= 2);
            return returnCode;
        }
        int returnCode = this.inner_open(mode);
        return returnCode;
    }

    public final int inner_open(int mode) {
        int error_ok = 0;
        this.pages = 0;
        this.readError = false;
        this.justRead = false;
        this.newFile = false;
        if (this.handler == null) {
            return -5;
        }
        this.updateLinageVariables();
        if ((mode & 0x800) == 0 && this.handler.isOpen()) {
            return -41;
        }
        if (this.lock) {
            return -38;
        }
        if ((mode & 1) != 0 && !this.handler.isReadable()) {
            return -37;
        }
        if ((mode & 2) != 0 && !this.handler.isWritable()) {
            return -37;
        }
        if ((mode & 0x20) != 0) {
            error_ok = -7;
        }
        this.resetLines();
        int returnCode = this.handler.open(mode);
        if (returnCode > 0) {
            this.newFile = true;
            returnCode = -returnCode;
        }
        if (returnCode == -8) {
            this.newFile = true;
            returnCode = error_ok;
        }
        if (returnCode == 0) {
            returnCode = error_ok;
        }
        return returnCode;
    }

    public final int close() {
        return this.close(0);
    }

    public final int close(int mode) {
        if (this.handler == null) {
            return -5;
        }
        if (!this.handler.isOpen()) {
            return -42;
        }
        if ((mode & 0x20) != 0) {
            return -7;
        }
        if ((mode & 0x10) != 0) {
            this.lock = true;
        }
        return this.handler.close(mode);
    }

    public final int seekRecord(int position) {
        return this.seek(position * this.recordSize);
    }

    public final int seek(int position) {
        if (this.handler == null) {
            return -5;
        }
        return this.handler.seek(position);
    }

    public final int seek(long position) {
        if (this.handler == null) {
            return -5;
        }
        return this.handler.seek(position);
    }

    public final long length() {
        if (this.handler == null) {
            return -5L;
        }
        return this.handler.length();
    }

    public final long getFilePointer() {
        if (this.handler == null) {
            return -5L;
        }
        return this.handler.getFilePointer();
    }

    public final void clearReadError() {
        this.readError = false;
    }

    public final byte[] read() {
        byte[] data = new byte[this.recordSize];
        int result = this.read(data, 0, 0);
        if (result < 0) {
            data = null;
        }
        return data;
    }

    public final int read(byte[] data) {
        return this.read(data, 0, data.length);
    }

    public final int read(byte[] data, int offset) {
        return this.read(data, offset, data.length - offset);
    }

    public final int read(byte[] data, int offset, int length) {
        return this.read(data, offset, length, false);
    }

    public final int read(byte[] data, int offset, int length, boolean lowlevel) {
        if (length <= 0) {
            length = data.length - offset;
        }
        if (this.readError) {
            this.justRead = false;
            return -46;
        }
        if (!lowlevel && !this.handler.isReadable()) {
            this.readError = true;
            this.justRead = false;
            return -47;
        }
        int returnCode = this.handler.read(data, offset, length);
        if (returnCode >= 0) {
            if (this.dataCharset != null && Variable.memoryCharset != null && Variable.memoryCharset != this.dataCharset) {
                byte[] tmp = new String(data, this.dataCharset).getBytes(Variable.memoryCharset);
                if (tmp.length != data.length && LogSetup.IS_LOGGING) {
                    LogSetup.LOGGER.warning("Error: Encoding/Decoding error when reading file data, -Dfile.encoding=" + this.dataCharset.toString() + " and -DBE=" + Variable.memoryCharset.toString() + " must both be single byte charsets");
                }
                System.arraycopy(tmp, 0, data, 0, tmp.length);
            }
            this.readError = false;
            this.justRead = true;
        } else {
            this.readError = true;
            this.justRead = false;
        }
        return returnCode;
    }

    public final int advance(int lines) {
        if (lines == 0) {
            return this.writeNoControl(carriageReturn, 0, 1);
        }
        int bufferLength = lineSeparatorLength * lines;
        byte[] buffer = new byte[bufferLength];
        for (int group = 0; group < bufferLength; group += lineSeparatorLength) {
            for (int part = 0; part < lineSeparatorLength; ++part) {
                buffer[group + part] = lineSeparatorBytes[part];
            }
        }
        return this.writeNoControl(buffer, 0, bufferLength);
    }

    public final int write(byte[] data) {
        return this.write(data, 0, data.length);
    }

    public final int write(byte[] data, int offset) {
        return this.write(data, offset, data.length - offset);
    }

    public final int write(byte[] data, int offset, int length) {
        if (data == null) {
            return 0;
        }
        int returnCode = 0;
        if (length < 0) {
            length = data.length - offset;
        }
        if (offset < 0) {
            offset = 0;
        }
        this.justRead = false;
        int WRITE_ERROR_OK = 0;
        if (this.trackStats) {
            int j;
            int i;
            int deficit;
            if (this.getLines() == 1) {
                deficit = this.getTop();
                if (this.lineSequential) {
                    int topLinesSize = deficit * lineSeparatorLength;
                    byte[] topArray = new byte[topLinesSize + length];
                    for (i = 0; i < deficit; ++i) {
                        for (j = 0; j < lineSeparatorLength; ++j) {
                            topArray[i * smartFile.lineSeparatorLength + j] = lineSeparatorBytes[j];
                        }
                    }
                    System.arraycopy(data, offset, topArray, topLinesSize, length);
                    data = topArray;
                    offset = 0;
                    length += topLinesSize;
                } else if (this.advanceLines(deficit)) {
                    WRITE_ERROR_OK = -9;
                }
            }
            if (this.getLines() == this.getPageLength() - this.getBottom()) {
                deficit = this.getBottom();
                if (this.lineSequential) {
                    int bottomLinesSize = deficit * lineSeparatorLength;
                    byte[] botArray = new byte[bottomLinesSize + length];
                    for (i = 0; i < deficit; ++i) {
                        for (j = 0; j < lineSeparatorLength; ++j) {
                            botArray[length + i * smartFile.lineSeparatorLength + j] = lineSeparatorBytes[j];
                        }
                    }
                    System.arraycopy(data, offset, botArray, 0, length);
                    data = botArray;
                    offset = 0;
                    length += bottomLinesSize;
                } else if (this.advanceLines(deficit)) {
                    WRITE_ERROR_OK = -9;
                }
            }
            int checkCols = this.getColumns();
            this.cols = 0;
            block8: for (int i2 = 0; i2 < length; ++i2) {
                switch (data[offset + i2]) {
                    case 13: {
                        this.cols = 0;
                        continue block8;
                    }
                    case 10: {
                        this.cols = 0;
                        if (!this.advanceLines()) continue block8;
                        WRITE_ERROR_OK = -9;
                        continue block8;
                    }
                    default: {
                        ++this.cols;
                        if (this.cols <= checkCols) continue block8;
                        this.cols = 0;
                        if (!this.advanceLines()) continue block8;
                        WRITE_ERROR_OK = -9;
                    }
                }
            }
        }
        if (length == 0) {
            return WRITE_ERROR_OK;
        }
        if (this.dataCharset != null && Variable.memoryCharset != null && Variable.memoryCharset != this.dataCharset) {
            byte[] tmp = new String(data, Variable.memoryCharset).getBytes(this.dataCharset);
            if (tmp.length != data.length && LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.warning("Error: Encoding/Decoding error when writing file data, -Dfile.encoding=" + this.dataCharset.toString() + " and -DBE=" + Variable.memoryCharset.toString() + " must both be single byte charsets");
            }
            data = tmp;
        }
        if ((returnCode = this.handler.write(data, offset, length)) == 0) {
            returnCode = WRITE_ERROR_OK;
        }
        if (this.trackStats && returnCode == WRITE_ERROR_OK && this.getLines() == this.getPageLength() - this.getBottom()) {
            int deficit = this.getBottom();
            if (this.lineSequential) {
                this.writeNoControl(emptyBytes, 0, 0);
            } else if (this.advanceLines(deficit)) {
                WRITE_ERROR_OK = -9;
            }
        }
        return returnCode;
    }

    public final int writeNoControl(byte[] data) {
        return this.writeNoControl(data, 0, data.length);
    }

    public final int writeNoControl(byte[] data, int offset) {
        return this.writeNoControl(data, offset, data.length - offset);
    }

    public final int writeNoControl(byte[] data, int offset, int length) {
        int deficit;
        if (data == null) {
            return 0;
        }
        int returnCode = 0;
        if (length < 0) {
            length = data.length - offset;
        }
        if (offset < 0) {
            offset = 0;
        }
        this.justRead = false;
        int WRITE_ERROR_OK = 0;
        if (this.trackStats) {
            int j;
            int i;
            if (this.getLines() == 1) {
                deficit = this.getTop();
                if (this.lineSequential) {
                    int topLinesSize = deficit * lineSeparatorLength;
                    byte[] topArray = new byte[topLinesSize + length];
                    for (i = 0; i < deficit; ++i) {
                        for (j = 0; j < lineSeparatorLength; ++j) {
                            topArray[i * smartFile.lineSeparatorLength + j] = lineSeparatorBytes[j];
                        }
                    }
                    System.arraycopy(data, offset, topArray, topLinesSize, length);
                    data = topArray;
                    offset = 0;
                    length += topLinesSize;
                } else if (this.advanceLines(deficit)) {
                    WRITE_ERROR_OK = -9;
                }
            }
            if (this.getLines() == this.getPageLength() - this.getBottom()) {
                deficit = this.getBottom();
                if (this.lineSequential) {
                    int bottomLinesSize = deficit * lineSeparatorLength;
                    byte[] botArray = new byte[bottomLinesSize + length];
                    for (i = 0; i < deficit; ++i) {
                        for (j = 0; j < lineSeparatorLength; ++j) {
                            botArray[length + i * smartFile.lineSeparatorLength + j] = lineSeparatorBytes[j];
                        }
                    }
                    System.arraycopy(data, offset, botArray, 0, length);
                    data = botArray;
                    offset = 0;
                    length += bottomLinesSize;
                } else if (this.advanceLines(deficit)) {
                    WRITE_ERROR_OK = -9;
                }
            }
            int checkCols = this.getColumns();
            this.cols = 0;
            block8: for (int i2 = 0; i2 < length; ++i2) {
                switch (data[offset + i2]) {
                    case 13: {
                        this.cols = 0;
                        continue block8;
                    }
                    case 10: {
                        this.cols = 0;
                        if (!this.advanceLines()) continue block8;
                        WRITE_ERROR_OK = -9;
                        continue block8;
                    }
                    default: {
                        ++this.cols;
                        if (this.cols <= checkCols) continue block8;
                        this.cols = 0;
                        if (!this.advanceLines()) continue block8;
                        WRITE_ERROR_OK = -9;
                    }
                }
            }
        }
        if (length == 0) {
            return WRITE_ERROR_OK;
        }
        if (this.dataCharset != null && Variable.memoryCharset != null && Variable.memoryCharset != this.dataCharset) {
            data = new String(data, this.dataCharset).getBytes(Variable.memoryCharset);
        }
        if ((returnCode = this.handler.write(data, offset, length)) == 0) {
            returnCode = WRITE_ERROR_OK;
        }
        if (this.trackStats && returnCode == WRITE_ERROR_OK) {
            deficit = this.getBottom();
            if (this.getLines() == this.getPageLength() - deficit) {
                if (this.lineSequential) {
                    this.writeNoControl(emptyBytes, 0, 0);
                } else if (this.advanceLines(deficit)) {
                    WRITE_ERROR_OK = -9;
                }
            }
        }
        return returnCode;
    }

    private final Class<?> findProtocol(String protocol) {
        Class<?> c;
        protocol = protocol.toLowerCase();
        try {
            c = protocolRegistry.get(protocol);
            if (c != null) {
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        try {
            c = Class.forName("com.heirloomcomputing.ecs.exec.fileprotocol." + protocol);
            if (c != null) {
                protocolRegistry.put(protocol, c);
                return c;
            }
        }
        catch (Exception e) {
            c = null;
        }
        return null;
    }

    public final int readLock(long offset, int length) {
        if (this.multi) {
            return this.handler.readLock(offset, length);
        }
        return 0;
    }

    public final boolean readUnlock(long offset, int length) {
        if (this.multi) {
            return this.handler.readUnlock(offset, length);
        }
        return true;
    }

    public final boolean readUnlock(int handle) {
        if (this.multi) {
            return this.handler.readUnlock(handle);
        }
        return true;
    }

    public final int writeLock(long offset, int length) {
        if (this.multi) {
            return this.handler.writeLock(offset, length);
        }
        return 0;
    }

    public final boolean writeUnlock(long offset, int length) {
        if (this.multi) {
            return this.handler.writeUnlock(offset, length);
        }
        return true;
    }

    public final boolean writeUnlock(int handle) {
        if (this.multi) {
            return this.handler.writeUnlock(handle);
        }
        return true;
    }

    public final Object getObject() {
        if (this.handler != null) {
            return this.handler.getObject();
        }
        return null;
    }

    public static final void unlockAll() {
    }

    public final void flush() {
        if (this.handler != null) {
            this.handler.flush();
        }
    }

    public final void setBlockSize(int n) {
        if (this.handler != null) {
            this.handler.setBlockSize(n);
        }
    }

    public final void setCharset(String charsetName) {
        if (charsetName == null) {
            this.dataCharset = null;
        } else {
            try {
                this.dataCharset = Charset.forName(charsetName);
                if (this.dataCharset != defaultDataCharset && Variable.memoryCharset == null) {
                    Variable.memoryCharset = defaultDataCharset;
                }
            }
            catch (IllegalCharsetNameException e) {
                this.dataCharset = null;
            }
            catch (IllegalArgumentException e) {
                this.dataCharset = null;
            }
        }
    }

    public final Charset getCharset() {
        return this.dataCharset;
    }

    static {
        smartFile.setCharsets();
        smartFile.setLineSeparators();
    }
}

