/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.exec.smartheap;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.smartheap.SmartHeap;
import com.heirloomcomputing.ecs.exec.smartheap.SmartHeapVectorOptimized;

public class SmartHeapManager {
    private static final ThreadLocal<SmartHeap> SH = new ThreadLocal<SmartHeap>(){

        @Override
        protected SmartHeap initialValue() {
            return SmartHeapManager.createNewInstance();
        }
    };

    private static SmartHeap createNewInstance() {
        SmartHeap instance = null;
        String smartHeapClassName = RuntimeEnvironment.getGlobalParameter("SMART_HEAP_IMPL");
        if (smartHeapClassName != null && !smartHeapClassName.trim().equals("")) {
            try {
                Class<?> smartHeapClass = Class.forName(smartHeapClassName);
                instance = (SmartHeap)smartHeapClass.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError e) {
                e.printStackTrace();
                LogSetup.LOGGER.warning("Cannot create SmartHeap Implementation for " + smartHeapClassName + ". Error: " + e.getMessage());
            }
        }
        if (instance == null) {
            instance = new SmartHeapVectorOptimized();
        }
        return instance;
    }

    public static synchronized SmartHeap get() {
        SmartHeap ourSmartHeap = SH.get();
        return ourSmartHeap;
    }

    public static synchronized void release() {
        SH.remove();
    }
}

