/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.ezasoket;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.DataPointer;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

public class EzasoketContext {
    private static final int connectTimeoutDefault = 10000;
    private static final int readTimeoutDefault = 10000;
    private static final int closeTimeoutDefault = 10;
    private static final boolean keepAliveDefault = false;
    private final Map<Integer, Socket> socketHandles = new IdentityHashMap<Integer, Socket>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private int closeTimeout = 10;
    private boolean keepAlive = false;

    public EzasoketContext() {
        try {
            this.connectTimeout = Optional.ofNullable(System.getProperty("ezasoket-connectTimeout")).map(s -> Integer.valueOf(s)).orElse(10000);
            this.readTimeout = Optional.ofNullable(System.getProperty("ezasoket-readTimeout")).map(s -> Integer.valueOf(s)).orElse(10000);
            this.closeTimeout = Optional.ofNullable(System.getProperty("ezasoket-closeTimeout")).map(s -> Integer.valueOf(s)).orElse(10);
            this.keepAlive = Optional.ofNullable(System.getProperty("ezasoket-keepAlive")).map(s -> Boolean.valueOf(s)).orElse(false);
        }
        catch (Exception e) {
            this.connectTimeout = 10000;
            this.readTimeout = 10000;
            this.closeTimeout = 10;
            this.keepAlive = false;
        }
    }

    public int setTimeouts(int connectTimeout, int readTimeout, int closeTimeout, boolean keepAlive) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.closeTimeout = closeTimeout;
        this.keepAlive = keepAlive;
        return 0;
    }

    public int getSocket() throws IOException {
        int id = this.socketHandles.size() + 1;
        this.socketHandles.put(id, SocketChannel.open().socket());
        Socket s = this.socketHandles.get(id);
        if (this.readTimeout >= 0) {
            s.setSoTimeout(this.readTimeout);
        }
        if (this.closeTimeout >= 0) {
            s.setSoLinger(true, this.closeTimeout);
        } else {
            s.setSoLinger(false, -1);
        }
        if (this.keepAlive) {
            s.setKeepAlive(this.keepAlive);
        }
        return id;
    }

    public Socket getSocket(Integer id) {
        return this.socketHandles.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int closeSocket(int descriptor) {
        int rc = 0;
        try {
            Socket s = this.getSocket(descriptor);
            if (s != null && !s.isClosed()) {
                s.close();
            } else {
                rc = 10220;
            }
        }
        catch (IOException ioe) {
            rc = 42;
        }
        catch (Exception e) {
            rc = 1;
        }
        finally {
            this.removeDescriptor(descriptor);
        }
        return rc;
    }

    public int connectSocket(int descriptor, IDatatype iName) {
        int rc;
        block9: {
            rc = 0;
            byte[] iNameBytes = iName.toByteArray();
            int family = new BigInteger(Arrays.copyOfRange(iNameBytes, 0, 2)).intValue();
            int port = new BigInteger(Arrays.copyOfRange(iNameBytes, 2, 4)).intValue();
            byte[] addr = Arrays.copyOfRange(iNameBytes, 4, 8);
            if (family == 2) {
                try {
                    Socket s = this.getSocket(descriptor);
                    if (s != null) {
                        InetAddress inetAddress = InetAddress.getByAddress(addr);
                        InetSocketAddress endpoint = new InetSocketAddress(inetAddress, port);
                        if (this.connectTimeout >= 0) {
                            s.connect(endpoint, this.connectTimeout);
                        } else {
                            s.connect(endpoint);
                        }
                        break block9;
                    }
                    rc = 10220;
                }
                catch (UnknownHostException uhe) {
                    rc = 6;
                }
                catch (IOException ioe) {
                    rc = 5;
                }
                catch (Exception e) {
                    rc = 1;
                }
            } else {
                rc = 10221;
            }
        }
        return rc;
    }

    public int getHostByName(String host, IDatatype iHostEnt) {
        int rc = 0;
        Hostent hostent = new Hostent();
        hostent.doInitializations();
        hostent.doDeclarations();
        rc = hostent.setHostent(host, iHostEnt);
        hostent.setPointers(iHostEnt);
        return rc;
    }

    public int getNextHostEnt(Object[] params) {
        int rc = 0;
        Hostent hostent = new Hostent();
        hostent.doInitializations();
        hostent.doDeclarations();
        rc = hostent.getHostEnt(params);
        return rc;
    }

    public int getHostId(IDatatype iRetCode) {
        int rc = 0;
        String ip = null;
        try {
            InetAddress localIp = InetAddress.getLocalHost();
            ip = localIp.getHostAddress();
            byte[] ipBytes = EzasoketContext.getIpBytes(ip);
            iRetCode.fromByteArray(ipBytes);
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            rc = -1;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            rc = -1;
        }
        return rc;
    }

    public int recvFromSocket(int descriptor, int nBytes, IDatatype iBuffer, IDatatype iRetCode) {
        int rc = 0;
        Socket s = this.getSocket(descriptor);
        if (s != null && s.isConnected() & !s.isClosed()) {
            try {
                DataInputStream input = new DataInputStream(s.getInputStream());
                byte[] buf = new byte[nBytes];
                int bytesRead = input.read(buf);
                iRetCode.fromInt(bytesRead);
                iBuffer.fromByteArray(buf);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                rc = 10666;
                this.removeDescriptor(descriptor);
            }
        } else {
            rc = 10217;
            this.removeDescriptor(descriptor);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(Object[] params) {
        int rc = 0;
        IDatatype iMaxSoc = (IDatatype)params[1];
        IDatatype iTimeout = (IDatatype)params[2];
        Variable iReadSendMask = (Variable)params[3];
        Variable iWriteSendMask = (Variable)params[4];
        IDatatype iErrNo = (IDatatype)params[9];
        IDatatype iRetCode = (IDatatype)params[10];
        int rsndmsk = new BigInteger(iReadSendMask.getBytes()).intValue();
        int wsndmsk = new BigInteger(iWriteSendMask.getBytes()).intValue();
        byte[] iTimeoutBytes = iTimeout.toByteArray();
        BigDecimal decSec = new BigDecimal(new BigInteger(Arrays.copyOfRange(iTimeoutBytes, 0, 4)));
        BigDecimal decMicro = new BigDecimal(new BigInteger(Arrays.copyOfRange(iTimeoutBytes, 4, 8))).divide(new BigDecimal(1000000));
        long timeOut = decSec.add(decMicro).multiply(new BigDecimal(1000)).longValue();
        int readyCount = 0;
        int descriptor = iMaxSoc.toInt() - 1;
        SocketChannel socketChannel = this.getSocket(descriptor).getChannel();
        if (socketChannel != null) {
            try {
                socketChannel.configureBlocking(false);
                Selector selector = Selector.open();
                if (rsndmsk > 0) {
                    if (wsndmsk > 0) {
                        socketChannel.register(selector, 5);
                    } else {
                        socketChannel.register(selector, 1);
                    }
                } else if (wsndmsk > 0) {
                    socketChannel.register(selector, 4);
                }
                readyCount = timeOut < 0L ? selector.select() : (timeOut > 0L ? selector.select(timeOut) : selector.selectNow());
                selector.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                readyCount = -1;
                iErrNo.fromText("00001");
            }
            finally {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException) {}
            }
        } else {
            readyCount = -1;
            if (descriptor <= 0) {
                iErrNo.fromText("10167");
            } else {
                iErrNo.fromText("10169");
            }
        }
        iRetCode.fromInt(readyCount);
        return rc;
    }

    public int writeToSocket(int descriptor, int nBytes, IDatatype iBuffer, IDatatype iRetCode) {
        int rc = 0;
        Socket s = this.getSocket(descriptor);
        if (s != null && s.isConnected()) {
            try {
                DataOutputStream output = new DataOutputStream(s.getOutputStream());
                output.write(iBuffer.toByteArray(), 0, nBytes);
                iRetCode.fromInt(output.size());
            }
            catch (IOException ioe) {
                rc = 5;
                this.removeDescriptor(descriptor);
            }
        } else {
            rc = 10217;
            this.removeDescriptor(descriptor);
        }
        return rc;
    }

    private void removeDescriptor(int id) {
        this.socketHandles.remove(id);
    }

    private static byte[] getIpBytes(String ip) {
        String[] ipNodes = ip.split("\\.");
        byte[] ipBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipBytes[i] = (byte)Integer.parseInt(ipNodes[i]);
        }
        return ipBytes;
    }

    class Hostent {
        private static final int ALIAS_LIMIT_MINUS_ONE = 9;
        private static final int ALIAS_LIMIT_PLUS_ONE = 11;
        private static final int ADDR_LIMIT_PLUS_ONE = 11;
        private int offset = 0;
        public DataPointer hostent_ptr;
        public DataPointer hostname_ptr;
        public DataPointer alias_list_ptr;
        public Binary hostent_family;
        public Binary host_addr_length;
        public DataPointer host_addr_list_ptr;
        public Variable hostent_structure;
        public DataPointer alias_name_ptr;
        public Variable alias_names_grp_ptrs;
        public DataPointer host_addr_ptr;
        public Variable host_addr_grp_ptrs;
        public Variable hostname;
        public Variable alias_name;
        public Variable alias_names_grp;
        public Binary host_addr;
        public Variable host_addr_grp;
        public DataPointer[] alias_name_ptr__1;
        public Variable[] alias_name__1;
        public DataPointer[] host_addr_ptr__1;
        public Numeric[] host_addr__1;

        private Hostent() {
        }

        private void doInitializations() {
            this.hostent_ptr = new DataPointer();
            this.hostname_ptr = new DataPointer();
            this.alias_list_ptr = new DataPointer();
            this.hostent_family = new Binary();
            this.host_addr_length = new Binary();
            this.host_addr_list_ptr = new DataPointer();
            this.hostent_structure = new Variable();
            this.alias_name_ptr = new DataPointer();
            this.alias_names_grp_ptrs = new Variable();
            this.host_addr_ptr = new DataPointer();
            this.host_addr_grp_ptrs = new Variable();
            this.hostname = new Variable();
            this.alias_name = new Variable();
            this.alias_names_grp = new Variable();
            this.host_addr = new Binary();
            this.host_addr_grp = new Variable();
        }

        private void doDeclarations() {
            UnbufferedMemory _memory = new UnbufferedMemory(2949, "hostent.Wrk");
            this.offset = 0;
            this.offset += 0;
            this.hostent_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, null, null, this.hostent_structure, 0);
            this.offset += 4;
            this.hostname_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, this.hostent_structure, null, (Variable)this.alias_list_ptr, 0);
            this.offset += 4;
            this.alias_list_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, this.hostent_structure, null, (Variable)this.hostent_family, 0);
            this.offset += 4;
            this.hostent_family.declare((Memory)_memory, this.offset, 4, null, 8, "\u0000\u0000\u0000\u0002", this.hostent_structure, null, (Variable)this.host_addr_length, 0x4000000);
            this.offset += 4;
            this.host_addr_length.declare((Memory)_memory, this.offset, 4, null, 8, "\u0000\u0000\u0000\u0004", this.hostent_structure, null, (Variable)this.host_addr_list_ptr, 0x4000000);
            this.offset += 4;
            this.host_addr_list_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, this.hostent_structure, null, null, 0);
            this.offset += -16;
            this.hostent_structure.declare((Memory)_memory, this.offset, 20, null, null, null, null, (Variable)this.hostname_ptr, this.alias_names_grp_ptrs, 0);
            this.offset += 20;
            this.alias_name_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, this.alias_names_grp_ptrs, null, null, 0, 1, 10, null);
            this.offset += 0;
            this.alias_names_grp_ptrs.declare((Memory)_memory, this.offset, 40, null, null, null, null, (Variable)this.alias_name_ptr, this.host_addr_grp_ptrs, 0);
            this.offset += 40;
            this.host_addr_ptr.declare((Memory)_memory, this.offset, 4, null, null, null, this.host_addr_grp_ptrs, null, null, 0, 1, 10, null);
            this.offset += 0;
            this.host_addr_grp_ptrs.declare((Memory)_memory, this.offset, 40, null, null, null, null, (Variable)this.host_addr_ptr, this.hostname, 0);
            this.offset += 40;
            this.hostname.declare((Memory)_memory, this.offset, 255, null, null, null, null, null, this.alias_names_grp, 0);
            this.offset += 255;
            this.alias_name.declare((Memory)_memory, this.offset, 255, null, null, null, this.alias_names_grp, null, null, 0, 1, 10, null);
            this.offset += 0;
            this.alias_names_grp.declare((Memory)_memory, this.offset, 2550, null, null, null, null, this.alias_name, this.host_addr_grp, 0);
            this.offset += 2550;
            this.host_addr.declare((Memory)_memory, this.offset, 4, null, 8, null, this.host_addr_grp, null, null, 0x4000000, 1, 10, null);
            this.offset += 0;
            this.host_addr_grp.declare((Memory)_memory, this.offset, 40, null, null, null, null, (Variable)this.host_addr, null, 0);
            this.alias_name_ptr__1 = this.alias_name_ptr.createArray1();
            this.alias_name__1 = this.alias_name.createArray1();
            this.host_addr_ptr__1 = this.host_addr_ptr.createArray1();
            this.host_addr__1 = this.host_addr.createNumericArray1();
        }

        private int getHostEnt(Object[] params) {
            int addrCnt;
            int aliasCnt;
            int rc = 0;
            IDatatype iHostEnt = (IDatatype)params[0];
            IDatatype iHostNameLength = (IDatatype)params[1];
            IDatatype iHostNameValue = (IDatatype)params[2];
            IDatatype iHostAliasCount = (IDatatype)params[3];
            IDatatype iHostAliasSeq = (IDatatype)params[4];
            IDatatype iHostAliasLength = (IDatatype)params[5];
            IDatatype iHostAliasValue = (IDatatype)params[6];
            IDatatype iHostAddrType = (IDatatype)params[7];
            IDatatype iHostAddrLength = (IDatatype)params[8];
            IDatatype iHostAddrCount = (IDatatype)params[9];
            IDatatype iHostAddrSeq = (IDatatype)params[10];
            IDatatype iHostAddrValue = (IDatatype)params[11];
            this.hostent_ptr.setAddressToAddress((Variable)iHostEnt);
            this.hostent_structure.setAddressToPointer(this.hostent_ptr);
            this.hostname.setAddressToPointer(this.hostname_ptr);
            String hoststr = this.hostname.toString().trim();
            iHostNameValue.fromText(hoststr);
            iHostNameLength.fromInt(hoststr.length());
            this.alias_names_grp_ptrs.setAddressToPointer(this.alias_list_ptr);
            for (aliasCnt = 1; aliasCnt < 11 && !this.alias_name_ptr__1[aliasCnt].isNullPointer(); ++aliasCnt) {
            }
            if (--aliasCnt == 0) {
                rc = -1;
            }
            iHostAliasCount.fromInt(aliasCnt);
            int aliasEntryNum = iHostAliasSeq.toInt();
            if (++aliasEntryNum <= aliasCnt) {
                this.alias_name__1[aliasEntryNum].setAddressToPointer(this.alias_name_ptr__1[aliasEntryNum]);
                iHostAliasValue.fromByteArray(this.alias_name__1[aliasEntryNum].getBytes());
                iHostAliasLength.fromInt(this.alias_name__1[aliasEntryNum].toString().trim().length());
                iHostAliasSeq.fromInt(aliasEntryNum);
            } else {
                iHostAliasLength.fromInt(0);
            }
            this.host_addr_grp_ptrs.setAddressToPointer(this.host_addr_list_ptr);
            for (addrCnt = 1; addrCnt < 11 && !this.host_addr_ptr__1[addrCnt].isNullPointer(); ++addrCnt) {
            }
            if (--addrCnt == 0) {
                rc = -1;
            }
            iHostAddrCount.fromInt(addrCnt);
            iHostAddrType.fromInt(2);
            iHostAddrLength.fromInt(4);
            int addrEntryNum = iHostAddrSeq.toInt();
            if (++addrEntryNum <= addrCnt) {
                this.host_addr__1[addrEntryNum].setAddressToPointer(this.host_addr_ptr__1[addrEntryNum]);
                iHostAddrValue.fromByteArray(this.host_addr__1[addrEntryNum].getBytes());
                iHostAddrSeq.fromInt(addrEntryNum);
            } else {
                iHostAddrLength.fromInt(0);
            }
            return rc;
        }

        private int setHostent(String host, IDatatype iHostEnt) {
            int rc = 0;
            try {
                InetAddress[] ipAddress = InetAddress.getAllByName(host);
                this.hostname.fromText(host);
                int entryNum = 0;
                for (InetAddress ip : ipAddress) {
                    if (ip instanceof Inet6Address) continue;
                    this.alias_name__1[++entryNum].fromText(ip.getCanonicalHostName());
                    this.host_addr__1[entryNum].fromByteArray(EzasoketContext.getIpBytes(ip.getHostAddress()));
                    if (entryNum > 9) break;
                }
                while (++entryNum < 11) {
                    this.alias_name__1[entryNum].fromText("\u0000\u0000");
                    this.host_addr__1[entryNum].fromText("\u0000\u0000\u0000\u0000");
                }
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
                rc = -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                rc = -1;
            }
            return rc;
        }

        private void setPointers(IDatatype iHostEnt) {
            this.hostent_ptr.setAddressToAddress((Variable)iHostEnt);
            iHostEnt = this.hostent_ptr;
            this.hostent_ptr.setPointerToAddress(this.hostent_structure);
            this.hostname_ptr.setPointerToAddress(this.hostname);
            this.alias_list_ptr.setPointerToAddress(this.alias_names_grp_ptrs);
            this.host_addr_list_ptr.setPointerToAddress(this.host_addr_grp_ptrs);
            for (int i = 1; i < 11; ++i) {
                this.alias_name_ptr__1[i].setPointerToAddress(this.alias_name__1[i]);
                this.host_addr_ptr__1[i].setPointerToAddress(this.host_addr__1[i]);
            }
            ((DataPointer)iHostEnt).setPointerToAddress(this.hostent_structure);
        }
    }
}

