/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.Binary;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.RecordFile;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.VariableList;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.exec.relFile;
import com.heirloomcomputing.ecs.exec.seqFile;
import com.heirloomcomputing.ecs.isamsql.DCB;
import com.heirloomcomputing.ecs.isamsql.DCBDB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import com.heirloomcomputing.ecs.isamsql.VDBIndexedFile;
import com.heirloomcomputing.ecs.isamsql.VDBRelativeFile;
import com.heirloomcomputing.ecs.isamsql.VDBSequentialFile;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class COBOLFile {
    private Mode mode;
    private int access;
    private boolean isOpen;
    private boolean isDamaged;
    private boolean hasRead;
    private boolean hasStarted;
    private DCB baseDCB;
    private DCB indexDCB;
    private Context _context;
    private Memory _memory;
    private Variable _record;
    private Variable _key;
    private Variable _primkey;
    private LinkedList<Variable> _altkeys;
    private Binary _occurs;
    private Variable _status;
    private idxFile _ifile;
    private relFile _rfile;
    private seqFile _sfile;
    private HashMap<String, Variable> _fields = new HashMap();
    private Variable sibling = null;
    private Connection sqlConnection;
    private int readMode;
    int tmp = 0;

    public COBOLFile(COBOLFile cpy) {
        this.mode = cpy.mode;
        this.access = cpy.access;
        this.isOpen = cpy.isOpen;
        this.isDamaged = cpy.isDamaged;
        this.hasRead = cpy.hasRead;
        this.hasStarted = cpy.hasStarted;
        this.sqlConnection = cpy.sqlConnection;
        this.readMode = cpy.readMode;
        if (cpy.baseDCB != null) {
            this.baseDCB = DCBFactory.getInstance(cpy.baseDCB);
        }
        if (cpy.indexDCB != null) {
            this.indexDCB = DCBFactory.getInstance(cpy.indexDCB);
        }
        if (cpy._context != null) {
            this._context = new Context(cpy._context);
        }
        if (cpy._memory != null) {
            this._memory = new Memory(cpy._memory.getTopOfMemory(), new String[0]);
        }
        if (cpy._record != null) {
            this._record = new Variable();
            this._record.declare(this._memory, cpy._record.getAddress(), cpy._record.getSize(), "The Record", null, null, null, null, null, 0);
        }
        Variable sibling = null;
        this._fields.clear();
        if (cpy._primkey != null) {
            if (cpy._primkey instanceof VariableList) {
                Variable[] cpyVarsList = ((VariableList)cpy._primkey).getList();
                Variable[] varsList = new Variable[cpyVarsList.length];
                for (int i = 0; i < cpyVarsList.length; ++i) {
                    varsList[i] = new Variable();
                    varsList[i].declare(this._memory, cpyVarsList[i].getAddress(), cpyVarsList[i].getSize(), "idx" + cpyVarsList[i].getRecordPosition() + "_" + cpyVarsList[i].getSize(), null, null, this._record, null, sibling, 0);
                    this._fields.put(varsList[i].getAddress() + ":" + varsList[i].getSize(), varsList[i]);
                    sibling = varsList[i];
                }
                this._primkey = new VariableList(varsList);
            } else {
                this._primkey = new Variable();
                this._primkey.declare(this._memory, cpy._primkey.getAddress(), cpy._primkey.getSize(), "idx" + cpy._primkey.getRecordPosition() + "_" + cpy._primkey.getSize(), null, null, this._record, null, null, 0);
                sibling = this._primkey;
            }
            if (cpy._key == cpy._primkey) {
                this._key = this._primkey;
            }
        }
        if (cpy._altkeys != null) {
            this._altkeys = new LinkedList();
            for (Variable cpyAltKey : cpy._altkeys) {
                Variable newAltKey;
                if (cpyAltKey instanceof VariableList) {
                    Variable[] cpyVarsList = ((VariableList)cpyAltKey).getList();
                    Variable[] varsList = new Variable[cpyVarsList.length];
                    for (int i = 0; i < cpyVarsList.length; ++i) {
                        varsList[i] = this._fields.get(cpyVarsList[i].getAddress() + ":" + cpyVarsList[i].getSize());
                        if (varsList[i] != null) continue;
                        varsList[i] = new Variable();
                        varsList[i].declare(this._memory, cpyVarsList[i].getAddress(), cpyVarsList[i].getSize(), "idx" + cpyVarsList[i].getRecordPosition() + "_" + cpyVarsList[i].getSize(), null, null, this._record, null, sibling, 0);
                        this._fields.put(varsList[i].getAddress() + ":" + varsList[i].getSize(), varsList[i]);
                        sibling = varsList[i];
                    }
                    newAltKey = new VariableList(varsList);
                    newAltKey.setScale(cpyAltKey.getScale());
                } else {
                    newAltKey = this._fields.get(cpyAltKey.getAddress() + ":" + cpyAltKey.getSize());
                    if (newAltKey == null) {
                        newAltKey = new Variable();
                        newAltKey.declare(this._memory, cpyAltKey.getAddress(), cpyAltKey.getSize(), "idx" + cpyAltKey.getRecordPosition() + "_" + cpyAltKey.getSize(), null, null, this._record, null, sibling, 0);
                        newAltKey.setScale(cpyAltKey.getScale());
                        this._fields.put(newAltKey.getAddress() + ":" + newAltKey.getSize(), newAltKey);
                        sibling = newAltKey;
                    }
                }
                this._altkeys.add(newAltKey);
                if (cpy._key != cpyAltKey) continue;
                this._key = newAltKey;
            }
        }
        if (cpy._occurs != null) {
            this._occurs = new Binary();
            this._occurs.declare(this._memory, cpy._occurs.getAddress(), cpy._occurs.getSize(), cpy._occurs.getName(), null, null, null, null, null, 0);
        }
        if (cpy._status != null) {
            this._status = new Variable();
            this._status.declare(this._memory, cpy._status.getAddress(), cpy._status.getSize(), cpy._status.getName(), null, null, null, null, null, 0);
        }
        if (cpy._ifile != null) {
            this._ifile = cpy._ifile.clone();
            if (this._ifile instanceof VDBIndexedFile) {
                ((VDBIndexedFile)this._ifile).swap(cpy._status, this._status);
                ((VDBIndexedFile)this._ifile).swap(cpy._primkey, this._primkey);
                ((VDBIndexedFile)this._ifile).swap(cpy._occurs, this._occurs);
                if (cpy._altkeys != null) {
                    for (int i = 0; i < cpy._altkeys.size(); ++i) {
                        ((VDBIndexedFile)this._ifile).swap(cpy._altkeys.get(i), this._altkeys.get(i));
                    }
                }
            }
        }
        if (cpy._rfile != null) {
            this._rfile = cpy._rfile.clone();
            if (this._rfile instanceof VDBRelativeFile) {
                ((VDBRelativeFile)this._rfile).swap(cpy._status, this._status);
                ((VDBRelativeFile)this._rfile).swap(cpy._primkey, this._primkey);
                ((VDBRelativeFile)this._rfile).swap(cpy._occurs, this._occurs);
            }
        }
        if (cpy._sfile != null) {
            this._sfile = cpy._sfile.clone();
            if (this._sfile instanceof VDBSequentialFile) {
                ((VDBSequentialFile)this._sfile).swap(cpy._status, this._status);
                ((VDBSequentialFile)this._sfile).swap(cpy._occurs, this._occurs);
            }
        }
    }

    public COBOLFile(DCB.Orientation hasOrient, DCB.RecordFormat recfm, String proto, String theDSNPath, int recordMin, int recordMax, Integer[] keyOff, Integer[] keyLen) throws NoClassDefFoundError {
        this.isDamaged = true;
        this.init(hasOrient, recfm, proto, theDSNPath, recordMin, recordMax, keyOff, keyLen, null, null, null, null);
    }

    public COBOLFile(DCB.Orientation hasOrient, String proto, String theDSNPath, int recordMax, Integer[] keyOff, Integer[] keyLen) throws NoClassDefFoundError {
        this.isDamaged = true;
        this.init(hasOrient, DCB.RecordFormat.F, proto, theDSNPath, recordMax, recordMax, keyOff, keyLen, null, null, null, null);
    }

    public COBOLFile(DCB.Orientation hasOrient, DCB.RecordFormat recfm, String proto, String theDSNPath, int recordMin, int recordMax) throws NoClassDefFoundError {
        this.isDamaged = true;
        if (recfm == DCB.RecordFormat.F || recfm == DCB.RecordFormat.FB || recfm == DCB.RecordFormat.FBS || recfm == DCB.RecordFormat.FBA) {
            recordMin = recordMax;
        }
        this.init(hasOrient, recfm, proto, theDSNPath, recordMin, recordMax, new Integer[]{0}, new Integer[]{64}, null, null, null, null);
    }

    public COBOLFile(DCB.Orientation hasOrient, String proto, String theDSNPath, int recordMax) throws NoClassDefFoundError {
        this.isDamaged = true;
        this.init(hasOrient, DCB.RecordFormat.V, proto, theDSNPath, 1, recordMax, new Integer[]{0}, new Integer[]{64}, null, null, null, null);
    }

    public COBOLFile(String theDSNPath, int recordMax) throws NoClassDefFoundError {
        this.isDamaged = true;
        this.init(DCB.Orientation.LINESEQUENTIAL, DCB.RecordFormat.V, null, theDSNPath, 1, recordMax, new Integer[]{0}, new Integer[]{64}, null, null, null, null);
    }

    public COBOLFile(DCB dcb) throws NoClassDefFoundError {
        this.setDCB(dcb);
    }

    public COBOLFile(DCBDB dcb) throws NoClassDefFoundError {
        this.setDCB(dcb);
    }

    public void setDCB(DCB dcb) {
        this.isDamaged = true;
        if (dcb == null) {
            return;
        }
        if (dcb.getDatasetName() == null) {
            return;
        }
        if (dcb.getRelate() != null) {
            String baseDatasetNamePath;
            String baseDatasetName = dcb.getRelate();
            if (DCB.exists(baseDatasetName, baseDatasetNamePath = dcb.getDatasetNamePath().replace(dcb.getDatasetName(), dcb.getRelate()))) {
                this.baseDCB = DCBFactory.getInstance(baseDatasetName, baseDatasetNamePath);
                if (Utilities.isCurrentEnviromentCICS()) {
                    if (this.baseDCB instanceof DCBDB) {
                        this.baseDCB.loadDCB(false);
                    } else {
                        this.baseDCB.loadDCBFromSystemProp(baseDatasetName);
                    }
                } else {
                    this.baseDCB.loadDCB(false);
                }
                this.baseDCB.setAssociates(dcb.getAssociates());
                this.indexDCB = dcb;
            } else {
                this.baseDCB = dcb;
            }
        } else {
            this.baseDCB = dcb;
            this.indexDCB = null;
        }
        this.init();
        this.orderbykey(dcb.getKeyOffset(), dcb.getKeyLength());
    }

    public String toString() {
        String info = "COBOLFile ";
        if (this.indexDCB != null) {
            info = info + "INDEX DATASET='" + this.indexDCB.getDatasetName() + "'; PROTOCOL=" + this.indexDCB.toString(this.indexDCB.getProtocols()) + "; DSORG=" + this.indexDCB.toString(this.indexDCB.getOrganization()) + "; ORG=" + this.indexDCB.toString(this.indexDCB.getOrientation()) + ";\n\t\tRECFM=" + this.indexDCB.toString(this.indexDCB.getRecordFormat());
            if (this.indexDCB.getKeyOffset() != null) {
                info = info + "; KEY OFFSET=" + this.indexDCB.getKeyOffset()[0];
            }
            if (this.indexDCB.getKeyLength() != null) {
                info = info + "; KEY LENGTH=" + this.indexDCB.getKeyLength()[0];
            }
            info = info + ";\n\t";
        }
        if (this.baseDCB != null) {
            info = info + "BASE DATASET='" + this.baseDCB.getDatasetName() + "'; PROTOCOL=" + this.baseDCB.toString(this.baseDCB.getProtocols()) + "; DSORG=" + this.baseDCB.toString(this.baseDCB.getOrganization()) + "; ORG=" + this.baseDCB.toString(this.baseDCB.getOrientation()) + ";\n\t\tRECFM=" + this.baseDCB.toString(this.baseDCB.getRecordFormat());
            if (this.baseDCB.getKeyOffset() != null) {
                info = info + "; KEY OFFSET=" + this.baseDCB.getKeyOffset()[0];
            }
            if (this.baseDCB.getKeyLength() != null) {
                info = info + "; KEY LENGTH=" + this.baseDCB.getKeyLength()[0];
            }
            info = info + ";\n\t";
        }
        info = info + "OPEN=" + this.isOpen;
        if (this.mode != null) {
            info = info + "; MODE=" + (Object)((Object)this.mode);
        }
        return info;
    }

    public DCB getDCB() {
        if (this.indexDCB != null) {
            return this.indexDCB;
        }
        return this.baseDCB;
    }

    private void init(DCB.Orientation hasOrient, DCB.RecordFormat recfm, String proto, String theDSNPath, Integer recordMin, Integer recordMax, Integer[] keyOff, Integer[] keyLen, Integer[] altKeyOffs, Integer[] altKeyLens, Boolean[] altKeyDups, Integer[] altKeyGroups) throws NoClassDefFoundError {
        if (this.baseDCB == null && theDSNPath != null) {
            this.baseDCB = DCBFactory.getInstance(null, theDSNPath);
            if (DCB.exists(this.baseDCB.getDatasetName(), this.baseDCB.getDatasetNamePath())) {
                this.baseDCB.loadDCB(false);
                if (hasOrient == null && this.baseDCB.getOrientation() != null) {
                    hasOrient = this.baseDCB.getOrientation();
                }
                if (recfm == null && this.baseDCB.getRecordFormat() != null) {
                    recfm = this.baseDCB.getRecordFormat();
                }
                if (proto == null && !this.baseDCB.getProtocol().isEmpty()) {
                    proto = this.baseDCB.getProtocol();
                }
                if (recordMin != null && recordMin < 0 && this.baseDCB.getRecordMinimum() != null) {
                    recordMin = this.baseDCB.getRecordMinimum();
                }
                if (recordMax != null && recordMax < 0 && this.baseDCB.getLrecl() != null) {
                    recordMax = this.baseDCB.getLrecl();
                }
                if (keyOff != null && this.baseDCB.getKeyOffset() != null) {
                    keyOff = this.baseDCB.getKeyOffset();
                }
                if (keyLen != null && this.baseDCB.getKeyLength() != null) {
                    keyLen = this.baseDCB.getKeyLength();
                }
                if (altKeyOffs != null && this.baseDCB.getAltKeyOffsets() != null) {
                    altKeyOffs = this.baseDCB.getAltKeyOffsets();
                }
                if (altKeyLens != null && this.baseDCB.getAltKeyLengths() != null) {
                    altKeyLens = this.baseDCB.getAltKeyLengths();
                }
                if (altKeyGroups != null && this.baseDCB.getAltKeyGroups() != null) {
                    altKeyGroups = this.baseDCB.getAltKeyGroups();
                }
            }
        }
        if (recordMin == null) {
            recordMin = this.baseDCB.getOrganization() == DCB.Organization.VS ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        if (recordMax == null) {
            recordMax = 16384;
        }
        if (hasOrient == null) {
            if (keyOff != null && keyLen != null) {
                this.baseDCB.setOrientation(DCB.Orientation.INDEXED);
            } else {
                this.baseDCB.setOrientation(DCB.Orientation.LINESEQUENTIAL);
            }
        } else {
            this.baseDCB.setOrientation(hasOrient);
        }
        if (recfm == null) {
            if (recordMin == recordMax) {
                this.baseDCB.setRecordFormat(DCB.RecordFormat.F);
            } else {
                this.baseDCB.setRecordFormat(DCB.RecordFormat.V);
            }
        } else {
            this.baseDCB.setRecordFormat(recfm);
        }
        try {
            this.baseDCB.setProtocol(proto);
        }
        catch (DCB.InvalidDCBException invalidDCBException) {
            // empty catch block
        }
        String protoFromConstructor = this.baseDCB.getProtocol();
        this.baseDCB.setDatasetNamePath(theDSNPath);
        String protoFromDSNPath = this.baseDCB.getProtocol();
        try {
            if (protoFromDSNPath.isEmpty() && !protoFromConstructor.isEmpty()) {
                this.baseDCB.setProtocol(protoFromConstructor.replace(",", ""));
            } else if (!protoFromDSNPath.isEmpty() && !protoFromConstructor.isEmpty()) {
                this.baseDCB.setProtocol(protoFromDSNPath.replace(",", "") + protoFromConstructor.replace(",", ""));
            }
        }
        catch (DCB.InvalidDCBException invalidDCBException) {
            // empty catch block
        }
        if (this.baseDCB.isFixed()) {
            this.baseDCB.setRecordMaximum(recordMax);
            this.baseDCB.setRecordMinimum(recordMax);
        } else if (recordMin >= recordMax) {
            this.baseDCB.setRecordFormat(DCB.RecordFormat.F);
            this.baseDCB.setRecordMaximum(recordMax);
            this.baseDCB.setRecordMinimum(recordMax);
        } else {
            this.baseDCB.setRecordFormat(DCB.RecordFormat.V);
            this.baseDCB.setRecordMaximum(recordMax);
            this.baseDCB.setRecordMinimum(recordMin);
        }
        if (this.baseDCB.getOrientation() == DCB.Orientation.INDEXED) {
            this.baseDCB.setKeyOffset(keyOff);
            this.baseDCB.setKeyLength(keyLen);
            if (altKeyOffs != null && altKeyLens != null && altKeyDups != null && altKeyOffs.length == altKeyLens.length && altKeyOffs.length == altKeyDups.length) {
                this.baseDCB.setAltKeyOffsets(altKeyOffs);
                this.baseDCB.setAltKeyLengths(altKeyLens);
                this.baseDCB.setAltKeyDuplicates(altKeyDups);
                this.baseDCB.setAltKeyGroups(altKeyGroups);
            }
        }
        this.init();
    }

    private void init() {
        if (this.baseDCB.getRecordMinimum() == null) {
            if (this.baseDCB.isFixed()) {
                this.baseDCB.setRecordMinimum(this.baseDCB.getRecordMaximum());
            } else if (this.baseDCB.getOrganization() == DCB.Organization.VS) {
                this.baseDCB.setRecordMinimum(1);
            } else {
                this.baseDCB.setRecordMinimum(0);
            }
        }
        if (this.baseDCB.getRecordMaximum() == null) {
            this.baseDCB.setRecordMaximum(16384);
        }
        if (this.baseDCB.getOrientation() == null) {
            if (this.baseDCB.getKeyOffset() != null && this.baseDCB.getKeyLength() != null) {
                this.baseDCB.setOrientation(DCB.Orientation.INDEXED);
            } else {
                this.baseDCB.setOrientation(DCB.Orientation.LINESEQUENTIAL);
            }
        }
        if (this.baseDCB.getRecordFormat() == null) {
            if (this.baseDCB.getRecordMinimum() == this.baseDCB.getRecordMaximum()) {
                this.baseDCB.setRecordFormat(DCB.RecordFormat.F);
            } else {
                this.baseDCB.setRecordFormat(DCB.RecordFormat.V);
            }
        }
        this._context = new Context();
        int separateKeySize = this.baseDCB.getOrientation() == DCB.Orientation.NUMBERED ? 8 : 0;
        this._memory = new Memory(this.baseDCB.getLrecl() + 6 + separateKeySize, new String[0]);
        this._status = new Variable();
        this._status.declare(this._memory, 0, 2, "File Status", 2, null, null, null, null, 0x4000000);
        if (this.baseDCB.isVariable()) {
            this._occurs = new Binary();
            this._occurs.declare(this._memory, 2, 4, "Record Length", 8, null, null, null, null, 0x4000000);
        } else {
            this._occurs = null;
        }
        this._record = new Variable();
        this.sibling = null;
        if (this.baseDCB.getOrientation() == DCB.Orientation.INDEXED) {
            if (this.baseDCB.getKeyOffset().length == 1) {
                this._key = this._primkey = new Variable();
                this._primkey.declare(this._memory, this.baseDCB.getKeyOffset()[0] + 6, (int)this.baseDCB.getKeyLength()[0], "idx" + this.baseDCB.getKeyOffset()[0] + "_" + this.baseDCB.getKeyLength()[0], null, null, this._record, null, this.sibling, 0);
                this.sibling = this._primkey;
            } else {
                Variable[] varsList = new Variable[this.baseDCB.getKeyOffset().length];
                for (int i = 0; i < this.baseDCB.getKeyOffset().length; ++i) {
                    varsList[i] = this._fields.get(this.baseDCB.getKeyOffset()[i] + ":" + this.baseDCB.getKeyLength()[i]);
                    if (varsList[i] != null) continue;
                    varsList[i] = new Variable();
                    varsList[i].declare(this._memory, this.baseDCB.getKeyOffset()[i] + 6, (int)this.baseDCB.getKeyLength()[i], "idx" + this.baseDCB.getKeyOffset()[i] + "_" + this.baseDCB.getKeyLength()[i], null, null, this._record, null, this.sibling, 0);
                    this._fields.put(this.baseDCB.getKeyOffset()[i] + ":" + this.baseDCB.getKeyLength()[i], varsList[i]);
                    this.sibling = varsList[i];
                }
                this._key = this._primkey = new VariableList(varsList);
            }
        } else if (this.baseDCB.getOrientation() == DCB.Orientation.NUMBERED) {
            this._key = this._primkey = new Binary();
            this._primkey.declare(this._memory, 6, separateKeySize, "rel", separateKeySize, null, null, null, null, 0x4000000);
        } else {
            this._primkey = null;
            this._key = null;
        }
        if (this.baseDCB.getAltKeyOffsets() != null && this.baseDCB.getAltKeyLengths() != null && this.baseDCB.getAltKeyDuplicates() != null && this.baseDCB.getAltKeyOffsets().length == this.baseDCB.getAltKeyLengths().length && this.baseDCB.getAltKeyOffsets().length == this.baseDCB.getAltKeyDuplicates().length) {
            this._altkeys = null;
            int lastGroup = -1;
            int begGroup = -1;
            for (int i = 0; i < this.baseDCB.getAltKeyOffsets().length; ++i) {
                if (this.baseDCB.getAltKeyGroups()[i] == lastGroup && this.baseDCB.getAltKeyGroups()[i] != -1) continue;
                if (lastGroup != -1) {
                    this.addSplitkey(Arrays.copyOfRange(this.baseDCB.getAltKeyOffsets(), begGroup, i), Arrays.copyOfRange(this.baseDCB.getAltKeyLengths(), begGroup, i), this.baseDCB.getAltKeyDuplicates()[begGroup]);
                }
                if (this.baseDCB.getAltKeyGroups()[i] == -1) {
                    this.addkey(this.baseDCB.getAltKeyOffsets()[i], this.baseDCB.getAltKeyLengths()[i], this.baseDCB.getAltKeyDuplicates()[i]);
                } else {
                    begGroup = i;
                }
                lastGroup = this.baseDCB.getAltKeyGroups()[i];
            }
            if (lastGroup != -1) {
                this.addSplitkey(Arrays.copyOfRange(this.baseDCB.getAltKeyOffsets(), begGroup, this.baseDCB.getAltKeyOffsets().length), Arrays.copyOfRange(this.baseDCB.getAltKeyLengths(), begGroup, this.baseDCB.getAltKeyOffsets().length), this.baseDCB.getAltKeyDuplicates()[begGroup]);
            }
        }
        this._record.declare(this._memory, 6 + separateKeySize, (int)this.baseDCB.getLrecl(), "The Record", null, null, null, this._primkey, null, 0);
        this.sqlConnection = null;
        this.hasStarted = false;
        this.hasRead = false;
        this.isDamaged = false;
        this.isOpen = false;
        this.readMode = 1;
    }

    public void addkey(Integer keyoff, Integer keylen, Boolean duplicates) {
        Variable aKey;
        if (this._altkeys == null) {
            this._altkeys = new LinkedList();
        }
        if ((aKey = this._fields.get(keyoff + ":" + keylen)) == null) {
            aKey = new Variable();
            aKey.setScale(duplicates != false ? 1 : 0);
            aKey.declare(this._memory, keyoff + 6, (int)keylen, "idx" + keyoff + "_" + keylen, null, null, this._record, null, this.sibling, 0);
            this._fields.put(keyoff + ":" + keylen, aKey);
            this.sibling = aKey;
        } else {
            aKey.setScale(duplicates != false ? 1 : 0);
        }
        this._altkeys.add(aKey);
    }

    public void addSplitkey(Integer[] keyoff, Integer[] keylen, Boolean duplicates) {
        if (this._altkeys == null) {
            this._altkeys = new LinkedList();
        }
        Variable[] varsList = new Variable[keyoff.length];
        for (int i = 0; i < keyoff.length; ++i) {
            varsList[i] = this._fields.get(keyoff[i] + ":" + keylen[i]);
            if (varsList[i] != null) continue;
            varsList[i] = new Variable();
            varsList[i].declare(this._memory, keyoff[i] + 6, (int)keylen[i], "idx" + keyoff[i] + "_" + keylen[i], null, null, this._record, null, this.sibling, 0);
            this._fields.put(keyoff[i] + ":" + keylen[i], varsList[i]);
            this.sibling = varsList[i];
        }
        VariableList aSplitKey = new VariableList(varsList);
        aSplitKey.setScale(duplicates != false ? 1 : 0);
        this._altkeys.add(aSplitKey);
    }

    public void orderbykey(Integer[] keyoff, Integer[] keylen) {
        if (this._key != null) {
            this._key.clearPreferredKey();
        }
        this._key = this._primkey;
        if (this._altkeys != null) {
            for (Variable aKey : this._altkeys) {
                if (aKey instanceof VariableList) {
                    int j = 0;
                    for (Variable var : ((VariableList)aKey).getList()) {
                        if (var.getRecordPosition() != keyoff[j].intValue() || var.getSize() != keylen[j].intValue()) break;
                        ++j;
                    }
                    if (j != ((VariableList)aKey).getList().length) continue;
                    this._key = aKey;
                    this.hasRead = false;
                    break;
                }
                if (aKey.getRecordPosition() != keyoff[0].intValue() || aKey.getSize() != keylen[0].intValue()) continue;
                this._key = aKey;
                this.hasRead = false;
                break;
            }
        }
        if (this._key != null) {
            this._key.setPreferredKey();
        }
    }

    public String getStatus() {
        return this._status == null ? "35" : this._status.toText();
    }

    public boolean open() {
        return this.open(Mode.READ, null);
    }

    public boolean open(Mode mode) {
        return this.open(mode, null);
    }

    public boolean open(String mode, Boolean accessRandom) {
        if (mode.equals("READ")) {
            return this.open(Mode.READ, accessRandom);
        }
        if (mode.equals("WRITE")) {
            return this.open(Mode.WRITE, accessRandom);
        }
        if (mode.equals("EXTEND")) {
            return this.open(Mode.EXTEND, accessRandom);
        }
        if (mode.equals("READWRITE")) {
            return this.open(Mode.READWRITE, accessRandom);
        }
        if (mode.equals("REMOVEWRITE")) {
            return this.open(Mode.REMOVEWRITE, accessRandom);
        }
        if (mode.equals("QUERY")) {
            return this.open(Mode.QUERY, accessRandom);
        }
        if (mode.equals("FOR_REMOVAL")) {
            return this.open(Mode.FOR_REMOVAL, accessRandom);
        }
        System.out.println("Invalid Open Mode:" + mode);
        return false;
    }

    public boolean open(Mode mode, Boolean accessRandom) {
        if (this.isOpen || this.isDamaged) {
            return false;
        }
        this.mode = mode;
        this.access = accessRandom == null ? 4 : (accessRandom == true ? 2 : 1);
        int intRecMode = 0;
        if (this.baseDCB.getRecordMinimum() == null) {
            this.baseDCB.setRecordMinimum(this.baseDCB.getLrecl());
        }
        if (this.baseDCB.isFixed()) {
            intRecMode = 1;
        } else if (this.baseDCB.isVariable()) {
            intRecMode = 2;
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._ifile = RecordFile.getIdxFile(this._context, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath());
                this._ifile.declare(false, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath(), 0, this._status, this.access, this._primkey, this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), false, (int)this.baseDCB.getRecordMinimum(), (int)this.baseDCB.getLrecl(), (Variable)this._occurs, intRecMode);
                if (this._altkeys != null) {
                    Iterator iterator = this._altkeys.iterator();
                    while (iterator.hasNext()) {
                        Variable aKey;
                        this._ifile.alternateKey(aKey, (aKey = (Variable)iterator.next()).getScale() == 0 ? 0 : 512);
                    }
                }
                this._ifile.endDeclare();
                break;
            }
            case NUMBERED: {
                this._rfile = RecordFile.getRelFile(this._context, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath());
                this._rfile.declare(false, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath(), 0, this._status, this.access, this._primkey, this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), false, (int)this.baseDCB.getRecordMinimum(), (int)this.baseDCB.getLrecl(), (Variable)this._occurs, intRecMode);
                this._rfile.endDeclare();
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                if ("FBA".equalsIgnoreCase(this.baseDCB.getRecordFormat().name()) || "FBA".equalsIgnoreCase(this.baseDCB.getRecordFormat().name())) {
                    System.setProperty(this.baseDCB.getDatasetNamePath() + ".recfm", this.baseDCB.getRecordFormat().name().toLowerCase());
                }
                this._sfile = RecordFile.getSeqFile(this._context, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath());
                this._sfile.declare(false, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath(), 0, null, '\u0000', this._status, this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), false, (int)this.baseDCB.getRecordMinimum(), (int)this.baseDCB.getLrecl(), (Variable)this._occurs, false, null, 0, null, 0, null, 0, null, 0, null, intRecMode);
                this._sfile.setLineSequential(this.baseDCB.getOrientation() == DCB.Orientation.LINESEQUENTIAL);
                this._sfile.endDeclare();
            }
        }
        int rw = 0;
        switch (mode) {
            case WRITE: {
                rw = 10;
                break;
            }
            case READ: {
                rw = 1;
                break;
            }
            case EXTEND: {
                rw = 14;
                break;
            }
            case READWRITE: {
                rw = 11;
                break;
            }
            case QUERY: {
                rw = 0;
                break;
            }
            case REMOVEWRITE: {
                rw = 138;
                break;
            }
            case FOR_REMOVAL: {
                rw = 128;
            }
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (this.sqlConnection != null && this._ifile instanceof VDBIndexedFile) {
                    ((VDBIndexedFile)this._ifile).setConnection(this.sqlConnection);
                }
                if (this.baseDCB.getAssociates() != null && this._ifile instanceof VDBIndexedFile) {
                    ((VDBIndexedFile)this._ifile).setAixOrPathName(this.baseDCB.getAssociates()[0]);
                }
                this.isOpen = this._ifile.open(rw);
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                if (this.sqlConnection != null && this._sfile instanceof VDBSequentialFile) {
                    ((VDBSequentialFile)this._sfile).setConnection(this.sqlConnection);
                }
                this.isOpen = this._sfile.open(rw);
                break;
            }
            case NUMBERED: {
                if (this.sqlConnection != null && this._rfile instanceof VDBRelativeFile) {
                    ((VDBRelativeFile)this._rfile).setConnection(this.sqlConnection);
                }
                this.isOpen = this._rfile.open(rw);
            }
        }
        return this.isOpen;
    }

    public byte[] read(byte[] key, boolean genericFromKeyAllowed) {
        return this.readImpl(key, 0, genericFromKeyAllowed);
    }

    public byte[] read(byte[] key) {
        return this.read(key, 0);
    }

    public void executeSQL(String sqlStmt) {
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (!(this._ifile instanceof VDBIndexedFile)) break;
                ((VDBIndexedFile)this._ifile).executeSql(sqlStmt);
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                if (!(this._sfile instanceof VDBSequentialFile)) break;
                ((VDBSequentialFile)this._sfile).executeSql(sqlStmt);
                break;
            }
            case NUMBERED: {
                if (!(this._rfile instanceof VDBRelativeFile)) break;
                ((VDBRelativeFile)this._rfile).executeSql(sqlStmt);
            }
        }
    }

    public byte[] read(byte[] key, int compareMode) {
        return this.readImpl(key, compareMode, false);
    }

    private byte[] readImpl(byte[] key, int compareMode, boolean genericFromKeyAllowed) {
        if (this.readMode != 1) {
            compareMode |= this.readMode << 8;
        }
        if (!this.isOpen || this.isDamaged) {
            return null;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return null;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._key.moveLowValues();
                this._key.move(key);
                if (this._key.getLength() > key.length) {
                    this._key.setGroupSize(key.length);
                }
                rc = this._ifile.read(null, null, null, this._record, this._key, compareMode, null, genericFromKeyAllowed);
                if (this._key.getLength() < key.length) break;
                this._key.resetGroupSize();
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                rc = this._sfile.read(this._record, compareMode, null);
                break;
            }
            case NUMBERED: {
                this._key.moveLowValues();
                this._key.fromByteArray(key, 0, key.length);
                rc = this._rfile.read(null, null, null, this._record, compareMode, null);
                break;
            }
            default: {
                rc = true;
            }
        }
        if (rc) {
            return null;
        }
        int lenRead = this._occurs == null ? this.baseDCB.getLrecl().intValue() : this._occurs.toInt();
        byte[] rec = new byte[lenRead];
        System.arraycopy(this._record.getBytes(), 0, rec, 0, lenRead);
        this.hasRead = true;
        return rec;
    }

    public boolean isVsamPrimaryKey() {
        return this.baseDCB != null && this.baseDCB.getOrganization() == DCB.Organization.VS && this._key != null && this._primkey != null && this._key.getName().equals(this._primkey.getName());
    }

    public byte[] read(boolean genericFromKeyAllowed) {
        return this.readImpl(genericFromKeyAllowed);
    }

    public byte[] read() {
        return this.readImpl(false);
    }

    private byte[] readImpl(boolean genericFromKeyAllowed) {
        if (!this.isOpen || this.isDamaged) {
            return null;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return null;
        }
        if (this.access == 2) {
            return null;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (!this.hasRead && !this.hasStarted) {
                    this._key.moveLowValues();
                    rc = this._ifile.start(1, this._key);
                }
                rc = this._ifile.readNext(this._record, genericFromKeyAllowed);
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                if (this.sqlConnection != null && this._sfile instanceof VDBSequentialFile) {
                    rc = ((VDBSequentialFile)this._sfile).readNext(this._record);
                    break;
                }
                rc = this._sfile.readNext(this._record);
                break;
            }
            case NUMBERED: {
                if (this.sqlConnection != null && this._rfile instanceof VDBRelativeFile) {
                    ((VDBRelativeFile)this._rfile).readNext(this._record);
                    break;
                }
                rc = this._rfile.readNext(this._record);
                break;
            }
            default: {
                rc = true;
            }
        }
        if (rc) {
            return null;
        }
        int lenRead = this._occurs == null ? this.baseDCB.getLrecl().intValue() : this._occurs.toInt();
        byte[] rec = new byte[lenRead];
        System.arraycopy(this._record.getBytes(), 0, rec, 0, lenRead);
        this.hasRead = true;
        return rec;
    }

    public Variable getKeyByteVar() {
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                return this._primkey;
            }
            case NUMBERED: {
                return this._key;
            }
        }
        return null;
    }

    public byte[] getKeyByteArray() {
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                return this._primkey.toByteArray();
            }
            case NUMBERED: {
                return this._key.toByteArray();
            }
        }
        return null;
    }

    public void setKeyByteArray(byte[] theKey) {
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._primkey.fromByteArray(theKey);
                break;
            }
            case NUMBERED: {
                this._key.fromByteArray(theKey);
                break;
            }
            default: {
                return;
            }
        }
    }

    public int getReadMode() {
        return this.readMode;
    }

    public void setReadMode(int readMode) {
        this.readMode = readMode >= 1 && readMode <= 4 ? readMode : 1;
    }

    public byte[] start() {
        if (!this.isOpen || this.isDamaged) {
            return null;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return null;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._key.move(new byte[this._key.getSize()]);
                rc = this._ifile.start(1, this._key);
                rc = this._ifile.readNext(this._record);
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                this.close();
                try {
                    this.open(Mode.READ, (Boolean)false);
                    rc = this._sfile.read(this._record);
                }
                catch (Exception e) {
                    rc = true;
                }
                break;
            }
            case NUMBERED: {
                this.close();
                try {
                    this.open(Mode.READ, (Boolean)false);
                    rc = this._rfile.read(this._record);
                }
                catch (Exception e) {
                    rc = true;
                }
                break;
            }
            default: {
                rc = true;
            }
        }
        if (rc) {
            return null;
        }
        int lenRead = this._occurs == null ? this.baseDCB.getLrecl().intValue() : this._occurs.toInt();
        byte[] rec = new byte[lenRead];
        System.arraycopy(this._record.getBytes(), 0, rec, 0, lenRead);
        this.hasStarted = true;
        this.hasRead = true;
        return rec;
    }

    public boolean start(int op, byte[] _srchKey) {
        if (!this.isOpen || this.isDamaged) {
            return false;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return false;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (op == 0 && _srchKey.length < this._key.getSize()) {
                    this._key.setGroupSize(_srchKey.length);
                }
                this._key.fromByteArray(_srchKey);
                rc = this._ifile.start(op, this._key);
                if (op != 0 || _srchKey.length >= this._key.getSize()) break;
                this._key.resetGroupSize();
                break;
            }
            case NONINDEXED: {
                this.close();
                this.open(Mode.READ, (Boolean)false);
                this._record.fromByteArray(_srchKey);
                rc = false;
                break;
            }
            case NUMBERED: {
                this._key.fromByteArray(_srchKey);
                rc = this._rfile.start(op, this._key);
                break;
            }
            default: {
                rc = true;
            }
        }
        this.hasStarted = true;
        return !rc;
    }

    public boolean start(int op, Variable _srchVar) {
        if (!this.isOpen || this.isDamaged) {
            return false;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return false;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (op == 0 && _srchVar.getSize() < this._key.getSize()) {
                    this._key.setGroupSize(_srchVar.getSize());
                }
                this._key.move(_srchVar);
                rc = this._ifile.start(op, this._key);
                if (op != 0 || _srchVar.getSize() >= this._key.getSize()) break;
                this._key.resetGroupSize();
                break;
            }
            case NUMBERED: {
                this._key.move(_srchVar);
                rc = this._rfile.start(op, this._key);
                break;
            }
            default: {
                rc = true;
            }
        }
        this.hasStarted = true;
        return !rc;
    }

    public boolean start(int op, String pic, String val) {
        return this.start(op, new Variable(pic, val));
    }

    public boolean end() {
        if (this._ifile != null && this._ifile instanceof VDBIndexedFile) {
            ((VDBIndexedFile)this._ifile).end();
        } else if (this._rfile != null && this._rfile instanceof VDBRelativeFile) {
            ((VDBRelativeFile)this._rfile).end();
        }
        return false;
    }

    public boolean is_VDB_ESDS() {
        return this._sfile != null && this._sfile instanceof VDBSequentialFile;
    }

    public void setESDSKey(int esdsKey) {
        ((VDBSequentialFile)this._sfile).vdb.setESDSKey(esdsKey);
    }

    public int getESDSKey() {
        return ((VDBSequentialFile)this._sfile).vdb.esdsKey;
    }

    public void resetVDBFetchSize(int fetchsize) {
        if (this._ifile != null && this._ifile instanceof VDBIndexedFile) {
            ((VDBIndexedFile)this._ifile).resetDefaultAndGlobalFetchSize(fetchsize);
        } else if (this._rfile != null && this._rfile instanceof VDBRelativeFile) {
            ((VDBRelativeFile)this._rfile).resetDefaultAndGlobalFetchSize(fetchsize);
        } else if (this._sfile != null && this._sfile instanceof VDBSequentialFile) {
            ((VDBSequentialFile)this._sfile).resetDefaultAndGlobalFetchSize(fetchsize);
        }
    }

    public byte[] readPrev() {
        if (!this.isOpen || this.isDamaged) {
            return null;
        }
        if (this.mode == Mode.WRITE || this.mode == Mode.EXTEND) {
            return null;
        }
        if (this.access == 2) {
            return null;
        }
        boolean rc = false;
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                rc = this._ifile.readPrevious(this._record);
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                rc = this._sfile.readPrevious(this._record);
                break;
            }
            case NUMBERED: {
                rc = this._rfile.readPrevious(this._record);
                break;
            }
            default: {
                rc = true;
            }
        }
        if (rc) {
            return null;
        }
        int lenRead = this._occurs == null ? this.baseDCB.getLrecl().intValue() : this._occurs.toInt();
        byte[] rec = new byte[lenRead];
        System.arraycopy(this._record.getBytes(), 0, rec, 0, lenRead);
        return rec;
    }

    public boolean isOpen() {
        if (this.isOpen) {
            try {
                if (this.sqlConnection != null && this.sqlConnection.isClosed()) {
                    this.isOpen = false;
                }
            }
            catch (SQLException e) {
                this.isOpen = false;
            }
        }
        return this.isOpen;
    }

    public boolean write(byte[] record, long rrn) {
        return this.write(record, ("" + rrn).getBytes());
    }

    public boolean write(byte[] record) {
        return this.write(record, null);
    }

    public boolean write(byte[] record, byte[] externalKey) {
        if (!this.isOpen || this.isDamaged) {
            return false;
        }
        if (this.mode == Mode.READ) {
            return false;
        }
        if (record == null) {
            return false;
        }
        if (this._occurs != null) {
            if (record.length > this.baseDCB.getLrecl()) {
                this._occurs.move(this.baseDCB.getLrecl());
            } else {
                this._occurs.move(record.length);
            }
        }
        if (this._record.getLength() != record.length) {
            this._record.moveSpaces();
        }
        this._record.move(record);
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                return !this._ifile.write(null, null, null, this._record, 0, null);
            }
            case LINESEQUENTIAL: {
                return !this._sfile.write(this._record, 0, null, true);
            }
            case NONINDEXED: 
            case LINEAR: {
                return !this._sfile.write(this._record, 0, null);
            }
            case NUMBERED: {
                if (externalKey != null) {
                    this._key.move(externalKey);
                }
                return !this._rfile.write(null, null, null, this._record, 0, null);
            }
        }
        return false;
    }

    public boolean rewrite(byte[] record) {
        if (!this.isOpen || this.isDamaged || !this.hasRead && !this.baseDCB.isOrientation(DCB.Orientation.INDEXED)) {
            return false;
        }
        if (this.mode != Mode.READWRITE) {
            return false;
        }
        if (record == null || record.length == 0) {
            return false;
        }
        if (this._occurs != null) {
            if (record.length > this.baseDCB.getLrecl()) {
                this._occurs.move(this.baseDCB.getLrecl());
            } else {
                this._occurs.move(record.length);
            }
        }
        if (this._record.getLength() != record.length) {
            this._record.moveSpaces();
        }
        this._record.move(record);
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                return !this._ifile.rewrite(null, null, null, this._record, 0, null);
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                return !this._sfile.rewrite(this._record, 0, null);
            }
            case NUMBERED: {
                return !this._rfile.rewrite(null, null, null, this._record, 0, null);
            }
        }
        return false;
    }

    public boolean deleteByPrimary(byte[] key) {
        if (!this.isOpen || this.isDamaged || this.mode != Mode.READWRITE) {
            return false;
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._primkey.fromByteArray(key);
                return !this._ifile.delete();
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                return false;
            }
            case NUMBERED: {
                this._key.fromByteArray(key);
                return !this._rfile.delete();
            }
        }
        return false;
    }

    public boolean deleteByKey(byte[] key, boolean generic) {
        if (!this.isOpen || this.isDamaged || this.mode != Mode.READWRITE) {
            return false;
        }
        if (key == null) {
            if (this._key != null) {
                key = this._key.toByteArray();
            } else {
                return false;
            }
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._key.fromByteArray(key);
                return !this._ifile.delete(null, this._key, key, 0, 0.0, generic);
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                return false;
            }
            case NUMBERED: {
                this._key.fromByteArray(key);
                return !this._rfile.delete();
            }
        }
        return false;
    }

    public boolean delete() {
        if (!this.isOpen || this.isDamaged || !this.hasRead || this.mode != Mode.READWRITE) {
            return false;
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                return !this._ifile.delete();
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                return false;
            }
            case NUMBERED: {
                return !this._rfile.delete();
            }
        }
        return false;
    }

    public void close() {
        if (!this.isOpen || this.isDamaged) {
            return;
        }
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                this._ifile.close();
                break;
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                this._sfile.close();
                break;
            }
            case NUMBERED: {
                this._rfile.close();
                break;
            }
        }
        this.hasRead = false;
        this.isOpen = false;
    }

    public boolean deleteFile() {
        switch (this.baseDCB.getOrientation()) {
            case INDEXED: {
                if (this._ifile == null) {
                    return false;
                }
                if (this.baseDCB.getAssociates() != null) {
                    for (String anAssociate : this.baseDCB.getAssociates()) {
                        idxFile _associate = RecordFile.getIdxFile(this._context, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath().replace(this.baseDCB.getDatasetName(), anAssociate));
                        _associate.declare(false, this.baseDCB.toString(this.baseDCB.getProtocols()) + this.baseDCB.getDatasetNamePath().replace(this.baseDCB.getDatasetName(), anAssociate), 0, this._status, this.access, this._primkey, this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), this.baseDCB.getBlksize() == null ? 0 : this.baseDCB.getBlksize(), false, (int)this.baseDCB.getRecordMinimum(), (int)this.baseDCB.getLrecl(), (Variable)this._occurs, this.baseDCB.isFixed() ? 1 : (this.baseDCB.isVariable() ? 2 : 0));
                        _associate.endDeclare();
                        if (!_associate.open(0)) continue;
                        _associate.deleteFile();
                    }
                }
                return this._ifile.deleteFile();
            }
            case NONINDEXED: 
            case LINESEQUENTIAL: 
            case LINEAR: {
                if (this._sfile == null) {
                    return false;
                }
                return this._sfile.deleteFile();
            }
            case NUMBERED: {
                if (this._rfile == null) {
                    return false;
                }
                return this._rfile.deleteFile();
            }
        }
        return false;
    }

    public void setConnection(Connection con) {
        this.sqlConnection = con;
    }

    public void begin() {
        if (this._ifile != null) {
            this._ifile.begin();
        }
        if (this._rfile != null) {
            this._rfile.begin();
        }
        if (this._sfile != null) {
            this._sfile.begin();
        }
    }

    public void rollback() {
        if (this._ifile != null) {
            this._ifile.rollback();
        }
        if (this._rfile != null) {
            this._rfile.rollback();
        }
        if (this._sfile != null) {
            this._sfile.rollback();
        }
    }

    public void commit() {
        if (this._ifile != null) {
            this._ifile.commit();
        }
        if (this._rfile != null) {
            this._rfile.commit();
        }
        if (this._sfile != null) {
            this._sfile.commit();
        }
    }

    public static void main(String[] args) {
        int maxRecSize;
        int minRecSize;
        DCB.RecordFormat recordformat;
        int keySize;
        DCB.Orientation orientation;
        boolean testRead = false;
        boolean testWrite = false;
        boolean testIndexed = false;
        boolean testSequential = false;
        boolean testLineSequential = false;
        boolean testFixed = false;
        boolean testVariable = false;
        String fname = null;
        System.out.println("COBOLFile - test COBOL index file API");
        for (String flag : args) {
            if (flag.equals("-r")) {
                testRead = true;
                continue;
            }
            if (flag.equals("-w")) {
                testWrite = true;
                continue;
            }
            if (flag.equals("-i")) {
                testIndexed = true;
                testSequential = false;
                testLineSequential = false;
                continue;
            }
            if (flag.equals("-s")) {
                testIndexed = false;
                testSequential = true;
                testLineSequential = false;
                continue;
            }
            if (flag.equals("-l")) {
                testIndexed = false;
                testSequential = false;
                testLineSequential = true;
                continue;
            }
            if (flag.equals("-f")) {
                testFixed = true;
                testVariable = false;
                continue;
            }
            if (flag.equals("-v")) {
                testFixed = false;
                testVariable = true;
                continue;
            }
            if (fname == null && flag.charAt(0) != '-') {
                fname = flag;
                continue;
            }
            System.out.println("java COBOLFile [-r] [-w] [-i|s|l] [-f|v] my-test-file.dat");
            System.out.println("   -r   -- read the file");
            System.out.println("   -w   -- write the file");
            System.out.println("   -i|s|l -- index or sequentail or line-sequential test");
            System.out.println("   -f|v -- fixed or variable test");
            System.exit(1);
        }
        if (!testRead && !testWrite) {
            testWrite = true;
            testRead = true;
        }
        if (!(testIndexed || testSequential || testLineSequential)) {
            testIndexed = true;
        }
        if (!testFixed && !testVariable) {
            testVariable = true;
        }
        if (fname == null) {
            fname = "test-cobol-file.dat";
        }
        if (testIndexed) {
            orientation = DCB.Orientation.INDEXED;
            keySize = 8;
        } else if (testSequential) {
            orientation = DCB.Orientation.NONINDEXED;
            keySize = 0;
        } else if (testLineSequential) {
            orientation = DCB.Orientation.LINESEQUENTIAL;
            keySize = 0;
        } else {
            orientation = DCB.Orientation.LINEAR;
            keySize = 0;
        }
        if (testFixed) {
            recordformat = DCB.RecordFormat.F;
            minRecSize = 80;
            maxRecSize = 80;
        } else if (testVariable) {
            recordformat = DCB.RecordFormat.V;
            minRecSize = 1;
            maxRecSize = 80;
        } else {
            recordformat = DCB.RecordFormat.U;
            minRecSize = 1;
            maxRecSize = 1;
        }
        COBOLFile f = null;
        try {
            f = new COBOLFile(orientation, recordformat, null, fname, minRecSize, maxRecSize, new Integer[]{0}, new Integer[]{keySize});
        }
        catch (NoClassDefFoundError e) {
            System.out.println("FAIL: exception on open(write): " + e);
            System.exit(1);
        }
        if (testWrite) {
            f.open(Mode.WRITE);
            if (!f.write("12345678hi there".getBytes())) {
                System.out.println("FAIL: could not write record with key 12345678");
            }
            if (!f.write("87654321bye there".getBytes())) {
                System.out.println("FAIL: could not write record with key 87654321");
            }
            if (!f.write("00000000first record".getBytes())) {
                System.out.println("FAIL: could not write record with key 00000000");
            }
            f.close();
        }
        if (testRead) {
            String keymsg;
            byte[] buf;
            f.open(Mode.READ);
            if (orientation == DCB.Orientation.INDEXED) {
                buf = f.read("87654321".getBytes());
                keymsg = " with key 87654321=";
            } else {
                buf = f.read();
                keymsg = " is=";
            }
            if (buf != null) {
                System.out.println("PASS record length " + buf.length + keymsg + new String(buf));
            } else {
                System.out.println("FAIL: record 87654321 not found, status=" + f.getStatus());
            }
            if (orientation == DCB.Orientation.INDEXED) {
                buf = f.read("00000000".getBytes());
                keymsg = " with key 00000000=";
            } else {
                buf = f.read();
                keymsg = " is=";
            }
            if (buf != null) {
                System.out.println("PASS record length " + buf.length + keymsg + new String(buf));
            } else {
                System.out.println("FAIL: record 00000000 not found, status=" + f.getStatus());
            }
            if (orientation == DCB.Orientation.INDEXED) {
                buf = f.read("12345678".getBytes());
                keymsg = " with key 12345678=";
            } else {
                buf = f.read();
                keymsg = " is=";
            }
            if (buf != null) {
                System.out.println("PASS record length " + buf.length + keymsg + new String(buf));
            } else {
                System.out.println("FAIL: record 12345678 not found, status=" + f.getStatus());
            }
            if (orientation == DCB.Orientation.INDEXED) {
                buf = f.read("UNKNOWN".getBytes());
                keymsg = " with key UNKNOWN=";
            } else {
                buf = f.read();
                keymsg = " should have been EOF but was=";
            }
            if (buf != null) {
                System.out.println("FAIL record length " + buf.length + keymsg + new String(buf));
            } else {
                System.out.println("PASS: record UNKNOWN not found, status=" + f.getStatus());
            }
        }
    }

    public static enum Mode {
        READ,
        WRITE,
        EXTEND,
        READWRITE,
        REMOVEWRITE,
        QUERY,
        FOR_REMOVAL;

    }
}

