/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.isamsql.DCBDB;
import com.heirloomcomputing.ecs.isamsql.DCBFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class DCB {
    protected static final int STICKY_ORGANIZATION = 1;
    protected static final int STICKY_ORIENTATION = 2;
    protected static final int STICKY_RECORDFORMAT = 4;
    protected static final int STICKY_CHARSET = 8;
    protected static final String KEY_ORGANIZATION = "dsorg";
    protected static final String KEY_ORIENTATION = "orient";
    protected static final String KEY_RECORDFORMAT = "recfm";
    protected static final String KEY_PROTOCOL = "proto";
    protected static final String KEY_RECORDMINIMUM = "recmin";
    protected static final String KEY_RECORDAVERAGE = "recavg";
    protected static final String KEY_LRECL = "lrecl";
    protected static final String KEY_BLKSIZE = "blksize";
    protected static final String KEY_LIMIT = "limit";
    protected static final String KEY_KEYLENGTH = "keylen";
    protected static final String KEY_KEYOFFSET = "keyoff";
    protected static final String KEY_ALTKEYOFFSETS = "altkeyoffs";
    protected static final String KEY_ALTKEYLENGTHS = "altkeylens";
    protected static final String KEY_ALTKEYDUPLICATES = "altkeydups";
    protected static final String KEY_ALTKEYGROUPS = "altkeygroups";
    protected static final String KEY_LABEL = "label";
    protected static final String KEY_EXPDT = "expdt";
    protected static final String KEY_REUSE = "reuse";
    protected static final String KEY_RELATE = "relate";
    protected static final String KEY_ASSOCIATES = "associates";
    protected static final String KEY_CHARSET = "charset";
    protected static final String KEY_PATH = "path";
    public static String LastError = "";
    protected Organization organization;
    protected Orientation orientation;
    protected RecordFormat recordFormat;
    protected EnumSet<Protocol> protocols;
    protected Integer recordMinimum;
    protected Integer recordAverage;
    protected Integer lrecl;
    protected Integer blksize;
    protected transient Integer bufno;
    protected transient Integer bufsize;
    protected Integer limit;
    protected Integer[] keyOffset;
    protected Integer[] keyLength;
    protected Integer[] altKeyOffsets;
    protected Integer[] altKeyLengths;
    protected Boolean[] altKeyDuplicates;
    protected Integer[] altKeyGroups;
    protected String datasetName;
    protected String datasetNamePath;
    protected String dcbPath;
    protected String expdt;
    protected Boolean reuse;
    protected String relate;
    protected String[] associates;
    protected String path;
    protected Properties properties;
    protected FileLock fileLock;
    protected boolean onDisk;
    protected boolean changed;
    protected boolean isDamaged;
    protected Integer label;
    protected String charset;
    protected byte notSticky;
    private static final SimpleDateFormat HC_DT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private void init() {
        this.datasetName = null;
        this.datasetNamePath = null;
        this.organization = null;
        this.orientation = null;
        this.recordFormat = null;
        this.protocols = null;
        this.recordMinimum = null;
        this.recordAverage = null;
        this.lrecl = null;
        this.blksize = null;
        this.bufno = null;
        this.bufsize = null;
        this.limit = null;
        this.keyOffset = null;
        this.keyLength = null;
        this.altKeyOffsets = null;
        this.altKeyLengths = null;
        this.altKeyDuplicates = null;
        this.altKeyGroups = null;
        this.dcbPath = null;
        this.properties = null;
        this.label = null;
        this.expdt = null;
        this.reuse = null;
        this.relate = null;
        this.associates = null;
        this.path = null;
        this.fileLock = null;
        this.onDisk = false;
        this.isDamaged = false;
        this.changed = false;
        this.charset = null;
        this.notSticky = 0;
    }

    public DCB() {
        this.init();
    }

    public DCB(DCB cpy) {
        this.merge(cpy);
        this.dcbPath = cpy.dcbPath;
        this.properties = null;
        this.fileLock = null;
        this.onDisk = cpy.onDisk;
        this.isDamaged = cpy.isDamaged;
        this.changed = cpy.changed;
        this.notSticky = cpy.notSticky;
    }

    public void merge(DCB cpy) {
        if (cpy.datasetName != null) {
            this.datasetName = cpy.datasetName;
        }
        if (cpy.datasetNamePath != null) {
            this.datasetNamePath = cpy.datasetNamePath;
        }
        if (cpy.organization != null) {
            this.organization = cpy.organization;
        }
        if (cpy.orientation != null) {
            this.orientation = cpy.orientation;
        }
        if (cpy.recordFormat != null) {
            this.recordFormat = cpy.recordFormat;
        }
        if (cpy.protocols != null) {
            this.protocols = cpy.protocols;
        }
        if (cpy.recordMinimum != null) {
            this.recordMinimum = cpy.recordMinimum;
        }
        if (cpy.recordAverage != null) {
            this.recordAverage = cpy.recordAverage;
        }
        if (cpy.lrecl != null) {
            this.lrecl = cpy.lrecl;
        }
        if (cpy.blksize != null) {
            this.blksize = cpy.blksize;
        }
        if (cpy.bufno != null) {
            this.bufno = cpy.bufno;
        }
        if (cpy.limit != null) {
            this.limit = cpy.limit;
        }
        if (cpy.keyOffset != null) {
            this.keyOffset = new Integer[cpy.keyOffset.length];
            System.arraycopy(cpy.keyOffset, 0, this.keyOffset, 0, cpy.keyOffset.length);
        }
        if (cpy.keyLength != null) {
            this.keyLength = new Integer[cpy.keyLength.length];
            System.arraycopy(cpy.keyLength, 0, this.keyLength, 0, cpy.keyLength.length);
        }
        if (cpy.altKeyOffsets != null) {
            this.altKeyOffsets = new Integer[cpy.altKeyOffsets.length];
            System.arraycopy(cpy.altKeyOffsets, 0, this.altKeyOffsets, 0, cpy.altKeyOffsets.length);
        }
        if (cpy.altKeyLengths != null) {
            this.altKeyLengths = new Integer[cpy.altKeyLengths.length];
            System.arraycopy(cpy.altKeyLengths, 0, this.altKeyLengths, 0, cpy.altKeyLengths.length);
        }
        if (cpy.altKeyDuplicates != null) {
            this.altKeyDuplicates = new Boolean[cpy.altKeyDuplicates.length];
            System.arraycopy(cpy.altKeyDuplicates, 0, this.altKeyDuplicates, 0, cpy.altKeyDuplicates.length);
        }
        if (cpy.altKeyGroups != null) {
            this.altKeyGroups = new Integer[cpy.altKeyGroups.length];
            System.arraycopy(cpy.altKeyGroups, 0, this.altKeyGroups, 0, cpy.altKeyGroups.length);
        }
        if (cpy.label != null) {
            this.label = cpy.label;
        }
        if (cpy.expdt != null) {
            this.expdt = cpy.expdt;
        }
        if (cpy.reuse != null) {
            this.reuse = cpy.reuse;
        }
        if (cpy.relate != null) {
            this.relate = cpy.relate;
        }
        if (cpy.path != null) {
            this.path = cpy.path;
        }
        if (cpy.associates != null) {
            this.associates = new String[cpy.associates.length];
            System.arraycopy(cpy.associates, 0, this.associates, 0, cpy.associates.length);
        }
        if (cpy.dcbPath != null) {
            this.dcbPath = cpy.dcbPath;
        }
        if (cpy.charset != null) {
            this.charset = cpy.charset;
        }
    }

    public void merge2(DCB cpy) {
        if (this.datasetName == null && cpy.datasetName != null) {
            this.datasetName = cpy.datasetName;
        }
        if (this.datasetNamePath == null && cpy.datasetNamePath != null) {
            this.datasetNamePath = cpy.datasetNamePath;
        }
        if (this.organization == null && cpy.organization != null) {
            this.organization = cpy.organization;
        }
        if (this.orientation == null && cpy.orientation != null) {
            this.orientation = cpy.orientation;
        }
        if (this.recordFormat == null && cpy.recordFormat != null) {
            this.recordFormat = cpy.recordFormat;
        }
        if (this.protocols == null && cpy.protocols != null) {
            this.protocols = cpy.protocols;
        }
        if (this.recordMinimum == null && cpy.recordMinimum != null) {
            this.recordMinimum = cpy.recordMinimum;
        }
        if (this.recordAverage == null && cpy.recordAverage != null) {
            this.recordAverage = cpy.recordAverage;
        }
        if (this.lrecl == null && cpy.lrecl != null) {
            this.lrecl = cpy.lrecl;
        }
        if (this.blksize == null && cpy.blksize != null) {
            this.blksize = cpy.blksize;
        }
        if (this.bufno == null && cpy.bufno != null) {
            this.bufno = cpy.bufno;
        }
        if (this.limit == null && cpy.limit != null) {
            this.limit = cpy.limit;
        }
        if (this.keyOffset == null && cpy.keyOffset != null) {
            this.keyOffset = new Integer[cpy.keyOffset.length];
            System.arraycopy(cpy.keyOffset, 0, this.keyOffset, 0, cpy.keyOffset.length);
        }
        if (this.keyLength == null && cpy.keyLength != null) {
            this.keyLength = new Integer[cpy.keyLength.length];
            System.arraycopy(cpy.keyLength, 0, this.keyLength, 0, cpy.keyLength.length);
        }
        if (this.altKeyOffsets == null && cpy.altKeyOffsets != null) {
            this.altKeyOffsets = new Integer[cpy.altKeyOffsets.length];
            System.arraycopy(cpy.altKeyOffsets, 0, this.altKeyOffsets, 0, cpy.altKeyOffsets.length);
        }
        if (this.altKeyLengths == null && cpy.altKeyLengths != null) {
            this.altKeyLengths = new Integer[cpy.altKeyLengths.length];
            System.arraycopy(cpy.altKeyLengths, 0, this.altKeyLengths, 0, cpy.altKeyLengths.length);
        }
        if (this.altKeyDuplicates == null && cpy.altKeyDuplicates != null) {
            this.altKeyDuplicates = new Boolean[cpy.altKeyDuplicates.length];
            System.arraycopy(cpy.altKeyDuplicates, 0, this.altKeyDuplicates, 0, cpy.altKeyDuplicates.length);
        }
        if (this.altKeyGroups == null && cpy.altKeyGroups != null) {
            this.altKeyGroups = new Integer[cpy.altKeyGroups.length];
            System.arraycopy(cpy.altKeyGroups, 0, this.altKeyGroups, 0, cpy.altKeyGroups.length);
        }
        if (this.label == null && cpy.label != null) {
            this.label = cpy.label;
        }
        if (this.expdt == null && cpy.expdt != null) {
            this.expdt = cpy.expdt;
        }
        if (this.reuse == null && cpy.reuse != null) {
            this.reuse = cpy.reuse;
        }
        if (this.relate == null && cpy.relate != null) {
            this.relate = cpy.relate;
        }
        if (this.path == null && cpy.path != null) {
            this.path = cpy.path;
        }
        if (this.associates == null && cpy.associates != null) {
            this.associates = new String[cpy.associates.length];
            System.arraycopy(cpy.associates, 0, this.associates, 0, cpy.associates.length);
        }
        if (this.dcbPath == null && cpy.dcbPath != null) {
            this.dcbPath = cpy.dcbPath;
        }
        if (this.charset == null && cpy.charset != null) {
            this.charset = cpy.charset;
        }
    }

    public void merge(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
        String sw = this.datasetName + "-";
        Enumeration<Object> keys = this.properties.keys();
        ArrayList<Object> list = Collections.list(keys);
        Collections.sort(list);
        for (String string2 : list) {
            if (!string2.startsWith(sw)) continue;
            try {
                if (this.organization == null && string2.endsWith(KEY_ORGANIZATION)) {
                    this.setOrganization(this.properties.getProperty(string2));
                    continue;
                }
                if (this.orientation == null && string2.endsWith(KEY_ORIENTATION)) {
                    this.setOrientation(this.properties.getProperty(string2));
                    continue;
                }
                if (this.recordFormat == null && string2.endsWith(KEY_RECORDFORMAT)) {
                    this.setRecordFormat(this.properties.getProperty(string2));
                    continue;
                }
                if (this.protocols == null && string2.endsWith(KEY_PROTOCOL)) {
                    this.setProtocol(this.properties.getProperty(string2));
                    continue;
                }
                if (this.recordMinimum == null && string2.endsWith(KEY_RECORDMINIMUM)) {
                    this.setRecordMinimum(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.recordAverage == null && string2.endsWith(KEY_RECORDAVERAGE)) {
                    this.setRecordAverage(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.lrecl == null && string2.endsWith(KEY_LRECL)) {
                    this.setLrecl(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.blksize == null && string2.endsWith(KEY_BLKSIZE)) {
                    this.setBlksize(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.limit == null && string2.endsWith(KEY_LIMIT)) {
                    this.setLimit(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.keyLength == null && string2.endsWith(KEY_KEYLENGTH)) {
                    this.setKeyLength(DCB.toIntegerArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.keyOffset == null && string2.endsWith(KEY_KEYOFFSET)) {
                    this.setKeyOffset(DCB.toIntegerArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyOffsets == null && string2.endsWith(KEY_ALTKEYOFFSETS)) {
                    this.setAltKeyOffsets(DCB.toIntegerArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyLengths == null && string2.endsWith(KEY_ALTKEYLENGTHS)) {
                    this.setAltKeyLengths(DCB.toIntegerArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyDuplicates == null && string2.endsWith(KEY_ALTKEYDUPLICATES)) {
                    this.setAltKeyDuplicates(DCB.toBooleanArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyGroups == null && string2.endsWith(KEY_ALTKEYGROUPS)) {
                    this.setAltKeyGroups(DCB.toIntegerArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.label == null && string2.endsWith(KEY_LABEL)) {
                    this.setLabel(Integer.parseInt(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.expdt == null && string2.endsWith(KEY_EXPDT)) {
                    this.setExpdt(this.properties.getProperty(string2));
                    continue;
                }
                if (this.reuse == null && string2.endsWith(KEY_REUSE)) {
                    this.setReuse("true".equals(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.relate == null && string2.endsWith(KEY_RELATE)) {
                    this.setRelate(this.properties.getProperty(string2));
                    continue;
                }
                if (this.path == null && string2.endsWith(KEY_PATH)) {
                    this.setPath(this.properties.getProperty(string2));
                    continue;
                }
                if (this.associates == null && string2.endsWith(KEY_ASSOCIATES)) {
                    this.setAssociates(DCB.toStringArray(this.properties.getProperty(string2)));
                    continue;
                }
                if (this.charset != null || !string2.endsWith(KEY_CHARSET)) continue;
                this.setCharset(this.properties.getProperty(string2));
            }
            catch (InvalidDCBException invalidDCBException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (this.altKeyOffsets != null && this.altKeyGroups == null) {
            Object[] groups = new Integer[this.altKeyOffsets.length];
            Arrays.fill(groups, (Object)-1);
            this.setAltKeyGroups((Integer[])groups);
        }
    }

    protected void setDefaultAttributes() {
        if (this.organization == null) {
            this.setOrganization(Organization.PS);
            this.notSticky = (byte)(this.notSticky | 1);
        }
        if (this.orientation == null) {
            this.setOrientation(Orientation.LINESEQUENTIAL);
            this.notSticky = (byte)(this.notSticky | 2);
        }
        if (this.recordFormat == null) {
            this.setRecordFormat(RecordFormat.V);
            this.notSticky = (byte)(this.notSticky | 4);
        }
        if (this.charset == null) {
            this.setCharset("ISO-8859-1");
            this.notSticky = (byte)(this.notSticky | 8);
        }
    }

    public void mergeDefaultAttributes(Properties props) {
        Enumeration<Object> keys = props.keys();
        ArrayList<Object> list = Collections.list(keys);
        list.sort(null);
        for (String prefix : new String[]{this.datasetName + "-", "DEFAULT-"}) {
            for (String string2 : list) {
                if (!string2.startsWith(prefix)) continue;
                try {
                    if ((this.organization == null || (this.notSticky & 1) == 1) && string2.endsWith(KEY_ORGANIZATION)) {
                        this.setOrganization(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if ((this.orientation == null || (this.notSticky & 2) == 2) && string2.endsWith(KEY_ORIENTATION)) {
                        this.setOrientation(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if ((this.recordFormat == null || (this.notSticky & 4) == 4) && string2.endsWith(KEY_RECORDFORMAT)) {
                        this.setRecordFormat(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.protocols == null && string2.endsWith(KEY_PROTOCOL)) {
                        this.setProtocol(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.recordMinimum == null && string2.endsWith(KEY_RECORDMINIMUM)) {
                        this.setRecordMinimum(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.recordAverage == null && string2.endsWith(KEY_RECORDAVERAGE)) {
                        this.setRecordAverage(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.lrecl == null && string2.endsWith(KEY_LRECL)) {
                        this.setLrecl(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.blksize == null && string2.endsWith(KEY_BLKSIZE)) {
                        this.setBlksize(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.limit == null && string2.endsWith(KEY_LIMIT)) {
                        this.setLimit(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.keyLength == null && string2.endsWith(KEY_KEYLENGTH)) {
                        this.setKeyLength(DCB.toIntegerArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.keyOffset == null && string2.endsWith(KEY_KEYOFFSET)) {
                        this.setKeyOffset(DCB.toIntegerArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.altKeyOffsets == null && string2.endsWith(KEY_ALTKEYOFFSETS)) {
                        this.setAltKeyOffsets(DCB.toIntegerArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.altKeyLengths == null && string2.endsWith(KEY_ALTKEYLENGTHS)) {
                        this.setAltKeyLengths(DCB.toIntegerArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.altKeyDuplicates == null && string2.endsWith(KEY_ALTKEYDUPLICATES)) {
                        this.setAltKeyDuplicates(DCB.toBooleanArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.altKeyGroups == null && string2.endsWith(KEY_ALTKEYGROUPS)) {
                        this.setAltKeyGroups(DCB.toIntegerArray(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.label == null && string2.endsWith(KEY_LABEL)) {
                        this.setLabel(Integer.parseInt(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.expdt == null && string2.endsWith(KEY_EXPDT)) {
                        this.setExpdt(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.reuse == null && string2.endsWith(KEY_REUSE)) {
                        this.setReuse("true".equals(props.getProperty(string2)));
                        this.changed = true;
                        continue;
                    }
                    if (this.relate == null && string2.endsWith(KEY_RELATE)) {
                        this.setRelate(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.path == null && string2.endsWith(KEY_PATH)) {
                        this.setPath(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.associates == null && string2.endsWith(KEY_ASSOCIATES)) {
                        this.setPath(props.getProperty(string2));
                        this.changed = true;
                        continue;
                    }
                    if (this.charset != null && (this.notSticky & 8) != 8 || !string2.endsWith(KEY_CHARSET)) continue;
                    this.setCharset(props.getProperty(string2));
                    this.changed = true;
                }
                catch (InvalidDCBException invalidDCBException) {
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public DCB(String dsn, String dsnPath) {
        this.init();
        this.properties = new Properties();
        this.datasetName = dsn;
        this.datasetNamePath = DCB.extractPath(dsnPath);
        try {
            this.setProtocol(DCB.extractProtocols(dsnPath));
        }
        catch (InvalidDCBException invalidDCBException) {
            // empty catch block
        }
        if (this.datasetName == null) {
            this.deriveDatasetName();
        }
    }

    public DCB(String dsn, String dsnPath, boolean forUpdate) {
        this.init();
        this.datasetName = dsn;
        this.datasetNamePath = DCB.extractPath(dsnPath);
        if (this.datasetName == null) {
            this.deriveDatasetName();
        }
        this.loadDCB(forUpdate);
        if (this.protocols == null || this.protocols.size() == 0) {
            try {
                this.setProtocol(DCB.extractProtocols(dsnPath));
            }
            catch (InvalidDCBException invalidDCBException) {
                // empty catch block
            }
        }
        if (this.lrecl == null && LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("DataSet Name not found in dcb using defaults : " + this.datasetName);
            LogSetup.LOGGER.warning("looked in  : " + dsnPath);
        }
    }

    public static synchronized boolean exists(String dsn, String dsnPath) {
        if (System.getProperty(dsn + "-" + KEY_ORGANIZATION) != null || System.getProperty(dsn + "-" + KEY_PROTOCOL) != null) {
            return true;
        }
        if (DCBFactory.isModeDcbDB().booleanValue()) {
            return DCBDB.exists(dsn, dsnPath);
        }
        DCB tmp = DCBFactory.getInstance();
        tmp.init();
        tmp.datasetName = dsn;
        tmp.datasetNamePath = DCB.extractPath(dsnPath);
        try {
            tmp.setProtocol(DCB.extractProtocols(dsnPath));
        }
        catch (InvalidDCBException invalidDCBException) {
            // empty catch block
        }
        if (tmp.datasetName == null) {
            tmp.deriveDatasetName();
        }
        if (tmp.datasetNamePath == null) {
            return false;
        }
        tmp.properties = new Properties();
        File dsnFile = new File(tmp.datasetNamePath);
        File dcbFile = null;
        tmp.dcbPath = dsnFile.exists() ? (dsnFile.isDirectory() ? dsnFile.getAbsolutePath() + File.separator + ".dcb" : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb")) : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb");
        dcbFile = new File(tmp.dcbPath);
        if (!dcbFile.exists()) {
            return false;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(dcbFile, "r");
            FileChannel rafchan = randomAccessFile.getChannel();
            tmp.fileLock = rafchan.lock(0L, Long.MAX_VALUE, true);
            InputStream is = Channels.newInputStream(rafchan);
            tmp.properties.load(is);
            tmp.fileLock.release();
            tmp.fileLock = null;
            randomAccessFile.close();
            randomAccessFile = null;
        }
        catch (OverlappingFileLockException e) {
            return false;
        }
        catch (AsynchronousCloseException e) {
            return false;
        }
        catch (FileLockInterruptionException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        if (tmp.datasetName != null) {
            String sw = tmp.datasetName + "-";
            Enumeration<Object> keys = tmp.properties.keys();
            while (keys.hasMoreElements()) {
                String aKey = (String)keys.nextElement();
                if (!aKey.startsWith(sw)) continue;
                return true;
            }
        }
        return false;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat;
    }

    public EnumSet<Protocol> getProtocols() {
        return this.protocols;
    }

    public String getProtocol() {
        return this.toString(this.protocols);
    }

    public Integer getRecordMinimum() {
        return this.recordMinimum;
    }

    public Integer getRecordAverage() {
        return this.recordAverage;
    }

    public Integer getLrecl() {
        return this.lrecl;
    }

    public Integer getRecordMaximum() {
        return this.lrecl;
    }

    public Integer getBlksize() {
        return this.blksize;
    }

    public Integer getBufno() {
        return this.bufno;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getLabel() {
        return this.label;
    }

    public String getExpdt() {
        return this.expdt;
    }

    public Integer[] getKeyOffset() {
        return this.keyOffset;
    }

    public Integer[] getKeyLength() {
        return this.keyLength;
    }

    public Integer[] getAltKeyOffsets() {
        return this.altKeyOffsets;
    }

    public Integer[] getAltKeyLengths() {
        return this.altKeyLengths;
    }

    public Boolean[] getAltKeyDuplicates() {
        return this.altKeyDuplicates;
    }

    public Integer[] getAltKeyGroups() {
        return this.altKeyGroups;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public boolean isReuseable() {
        return this.reuse != null && this.reuse != false;
    }

    public String getRelate() {
        return this.relate;
    }

    public String getPath() {
        return this.path;
    }

    public String[] getAssociates() {
        return this.associates;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public String getDatasetNamePath() {
        return this.datasetNamePath;
    }

    public String getDcbPath() {
        return this.dcbPath;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setDatasetName(String x) {
        this.datasetName = x;
    }

    public void setDatasetNamePath(String x) {
        try {
            this.setProtocol(DCB.extractProtocols(x));
        }
        catch (InvalidDCBException invalidDCBException) {
            // empty catch block
        }
        x = DCB.extractPath(x);
        this.changed = true;
        this.datasetNamePath = x;
    }

    public void setOrganization(Organization x) {
        if (this.organization != x) {
            this.changed = true;
            this.organization = x;
            if (this.organization != Organization.VS) {
                this.keyLength = null;
                this.keyOffset = null;
            }
            if (this.organization != Organization.GDG) {
                this.limit = null;
            }
        }
    }

    public void setOrientation(Orientation x) {
        if (this.orientation != x) {
            this.changed = true;
            this.orientation = x;
            switch (this.orientation) {
                case INDEXED: {
                    this.setOrganization(Organization.VS);
                    this.limit = null;
                    break;
                }
                case LINEAR: {
                    this.setOrganization(Organization.VS);
                    this.limit = null;
                    this.keyLength = null;
                    this.keyOffset = null;
                    break;
                }
                case LINESEQUENTIAL: {
                    this.keyLength = null;
                    this.keyOffset = null;
                    break;
                }
                case NONINDEXED: {
                    this.keyLength = null;
                    this.keyOffset = null;
                    break;
                }
                case NUMBERED: {
                    this.setOrganization(Organization.VS);
                    this.limit = null;
                    this.keyOffset = null;
                }
            }
        }
    }

    public void setRecordFormat(RecordFormat x) {
        if (this.recordFormat != x) {
            this.changed = true;
            this.recordFormat = x;
            if (this.isFixed()) {
                if (this.recordMinimum != null) {
                    this.recordMinimum = this.lrecl;
                }
                if (this.orientation == null || this.orientation == Orientation.LINESEQUENTIAL) {
                    this.setOrientation(Orientation.NONINDEXED);
                }
            }
            if (this.hasProtocol(Protocol.IBMV) && this.recordFormat == RecordFormat.VB) {
                this.removeProtocol(Protocol.IBMV);
                this.addProtocol(Protocol.IBMVB);
            } else if (this.hasProtocol(Protocol.IBMVB) && this.recordFormat == RecordFormat.V) {
                this.removeProtocol(Protocol.IBMVB);
                this.addProtocol(Protocol.IBMV);
            }
        }
    }

    public void setLabel(Integer l) {
        if (this.label != l) {
            this.label = l;
            this.changed = true;
        }
    }

    public void setExpdt(String s) {
        if (s != null) {
            Date d = new Date();
            if (s.startsWith("RETPD=")) {
                Calendar c = Calendar.getInstance();
                try {
                    c.add(5, Integer.parseInt(s.substring(6)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                d = c.getTime();
            } else {
                if (s.startsWith("EXPDT=")) {
                    s = s.substring(6);
                }
                if (s.length() == 5) {
                    s = s.substring(0, 2) + "/" + s.substring(2);
                } else if (s.length() == 7) {
                    s = s.substring(0, 2) + "/" + s.substring(2);
                }
                try {
                    if (s.length() > 16) {
                        SimpleDateFormat sdf = new SimpleDateFormat("y-M-d h:m:s");
                        sdf.setTimeZone(TimeZone.getDefault());
                        d = sdf.parse(s);
                    } else {
                        d = new SimpleDateFormat("y/D").parse(s);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.expdt = DCB.getDateTime(d);
            this.changed = true;
        }
    }

    public void setReuse(Boolean reuse) {
        if (this.reuse != null && this.reuse != reuse) {
            this.reuse = reuse;
            this.changed = true;
        }
    }

    public void setRelate(String relate) {
        this.relate = relate;
        this.changed = true;
    }

    public void setPath(String path) {
        this.path = path;
        this.changed = true;
    }

    public void setAssociates(String[] associates) {
        if (associates == null) {
            this.associates = null;
        } else {
            this.associates = new String[associates.length];
            System.arraycopy(associates, 0, this.associates, 0, associates.length);
        }
        this.changed = true;
    }

    public void addAssociate(String associate) {
        if (associate == null) {
            this.associates = null;
        } else {
            if (this.associates == null) {
                this.associates = new String[1];
            } else {
                for (String assc : this.associates) {
                    if (!assc.equalsIgnoreCase(associate)) continue;
                    return;
                }
                String[] tmp = new String[this.associates.length + 1];
                System.arraycopy(this.associates, 0, tmp, 1, this.associates.length);
                this.associates = tmp;
            }
            this.associates[0] = associate;
        }
        this.changed = true;
    }

    public void setCharset(String chset) {
        if (this.charset == null && chset != null || chset == null && this.charset != null || !this.charset.equalsIgnoreCase(chset)) {
            this.charset = chset;
            this.changed = true;
        }
    }

    public boolean isDamaged() {
        return this.isDamaged;
    }

    public boolean onDisk() {
        return this.onDisk;
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isOrganization(Organization x) {
        return this.organization == x;
    }

    public boolean isOrientation(Orientation x) {
        return this.orientation == x;
    }

    public boolean isIndexed() {
        return this.orientation == Orientation.INDEXED;
    }

    public boolean isNumbered() {
        return this.orientation == Orientation.NUMBERED;
    }

    public boolean isFixed() {
        if (this.recordFormat == null) {
            return false;
        }
        return this.recordFormat == RecordFormat.F || this.recordFormat == RecordFormat.FB || this.recordFormat == RecordFormat.FBS || this.recordFormat == RecordFormat.FBA;
    }

    public boolean isVariable() {
        if (this.recordFormat == null) {
            return false;
        }
        if (this.recordFormat == RecordFormat.U) {
            return true;
        }
        return !this.isFixed();
    }

    public boolean isCharset(String x) {
        if ((x.equalsIgnoreCase("IBM1047") || x.equalsIgnoreCase("IBM-1047") || x.equalsIgnoreCase("Cp1047")) && (this.charset.equalsIgnoreCase("IBM1047") || this.charset.equalsIgnoreCase("IBM-1047") || this.charset.equalsIgnoreCase("Cp1047"))) {
            return true;
        }
        return this.charset.equalsIgnoreCase(x);
    }

    public boolean hasProtocol(Protocol x) {
        if (this.protocols == null) {
            return false;
        }
        return this.protocols.contains((Object)x);
    }

    public void addProtocol(Protocol x) {
        if (this.protocols == null) {
            this.protocols = EnumSet.noneOf(Protocol.class);
        }
        this.protocols.add(x);
        this.changed = true;
        if (x != Protocol.ENV && x != Protocol.REMOTE && (this.orientation == null || this.orientation == Orientation.LINESEQUENTIAL)) {
            this.orientation = Orientation.NONINDEXED;
        }
    }

    public void removeProtocol(Protocol x) {
        if (this.protocols != null) {
            this.protocols.remove((Object)x);
            if (this.protocols.isEmpty()) {
                this.protocols = null;
            }
            this.changed = true;
        }
    }

    public void removeProtocol(String x) throws InvalidDCBException {
        if ("EC".equalsIgnoreCase(x) || "ECOBOL".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.EC);
        } else if ("MF".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.MF);
        } else if ("MF3".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.MF3);
        } else if ("MF8".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.MF8);
        } else if ("ENV".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.ENV);
        } else if ("REMOTE".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.REMOTE);
        } else if ("IBM".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.IBM);
        } else if ("IBMV".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.IBMV);
        } else if ("IBMVB".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.IBMVB);
        } else if ("SYNC".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.SYNC);
        } else if ("CISAM".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.CISAM);
        } else if ("DISAM".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.DISAM);
        } else if ("EISAM".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.EISAM);
        } else if ("AS400".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.AS400);
        } else if ("CB".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.CB);
        } else if ("ROX".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.ROX);
        } else if ("VSQL".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.VSQL);
        } else if ("VDB".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.VDB);
        } else if ("ACU".equalsIgnoreCase(x) || "VIS4".equalsIgnoreCase(x) || "VISUAL4".equalsIgnoreCase(x) || "VIS".equalsIgnoreCase(x) || "VISUAL".equalsIgnoreCase(x)) {
            this.removeProtocol(Protocol.ACU);
        } else {
            throw new InvalidDCBException();
        }
    }

    public void clearProtocol() {
        if (this.protocols != null) {
            this.protocols = null;
            this.changed = true;
        }
    }

    public void setRecordMinimum(Integer x) {
        if (!(this.recordMinimum == x || this.recordMinimum != null && this.recordMinimum.equals(x))) {
            this.changed = true;
            this.recordMinimum = x;
            if (this.recordFormat != null) {
                switch (this.recordFormat) {
                    case F: 
                    case FB: 
                    case FBA: 
                    case FBS: {
                        if (this.lrecl == this.recordMinimum) break;
                        this.lrecl = this.recordMinimum;
                        break;
                    }
                }
            }
        }
    }

    public void setRecordAverage(Integer x) {
        if (!(this.recordAverage == x || this.recordAverage != null && this.recordAverage.equals(x))) {
            this.changed = true;
            this.recordAverage = x;
            if (this.recordFormat != null) {
                switch (this.recordFormat) {
                    case F: 
                    case FB: 
                    case FBA: 
                    case FBS: {
                        if (this.recordAverage == this.lrecl || this.recordAverage != null && this.recordAverage.equals(this.lrecl)) break;
                        this.lrecl = this.recordMinimum = this.recordAverage;
                        break;
                    }
                }
            }
        }
    }

    public void setRecordMaximum(Integer x) {
        if (!(this.lrecl == x || this.lrecl != null && this.lrecl.equals(x))) {
            this.changed = true;
            this.lrecl = x;
        }
    }

    public void setLrecl(Integer x) {
        if (!(this.lrecl == x || this.lrecl != null && this.lrecl.equals(x))) {
            this.changed = true;
            this.lrecl = x;
        }
    }

    public void setBlksize(Integer x) {
        if (!(this.blksize == x || this.blksize != null && this.blksize.equals(x))) {
            this.changed = true;
            this.blksize = x;
        }
    }

    public void setBufno(Integer x) {
        if (!(this.bufno == x || this.bufno != null && this.bufno.equals(x))) {
            this.bufno = x;
        }
    }

    public void setLimit(Integer x) {
        if (!(this.limit == x || this.limit != null && this.limit.equals(x))) {
            this.changed = true;
            this.limit = x;
            this.setOrganization(Organization.GDG);
        }
    }

    public void setKeyOffset(Integer[] x) {
        if (x != null) {
            this.changed = true;
            this.keyOffset = new Integer[x.length];
            System.arraycopy(x, 0, this.keyOffset, 0, x.length);
            this.setOrganization(Organization.VS);
            this.setOrientation(Orientation.INDEXED);
        } else if (this.keyOffset != null) {
            this.changed = true;
            this.keyOffset = null;
        }
    }

    public void setKeyLength(Integer[] x) {
        if (x != null) {
            this.changed = true;
            this.keyLength = new Integer[x.length];
            System.arraycopy(x, 0, this.keyLength, 0, x.length);
            this.setOrganization(Organization.VS);
        } else if (this.keyLength != null) {
            this.changed = true;
            this.keyLength = null;
        }
    }

    public void setAltKeyOffsets(Integer[] x) {
        if (x != null) {
            this.changed = true;
            this.altKeyOffsets = new Integer[x.length];
            System.arraycopy(x, 0, this.altKeyOffsets, 0, x.length);
            this.setOrganization(Organization.VS);
            this.setOrientation(Orientation.INDEXED);
        } else if (this.altKeyOffsets != null) {
            this.changed = true;
            this.altKeyOffsets = x;
        }
    }

    public void setAltKeyLengths(Integer[] x) {
        if (x != null) {
            this.changed = true;
            this.altKeyLengths = new Integer[x.length];
            System.arraycopy(x, 0, this.altKeyLengths, 0, x.length);
            this.setOrganization(Organization.VS);
            this.setOrientation(Orientation.INDEXED);
        } else if (this.altKeyLengths != null) {
            this.changed = true;
            this.altKeyLengths = x;
        }
    }

    public void setAltKeyDuplicates(Boolean[] x) {
        if (x != null) {
            this.changed = true;
            this.altKeyDuplicates = new Boolean[x.length];
            System.arraycopy(x, 0, this.altKeyDuplicates, 0, x.length);
            this.setOrganization(Organization.VS);
            this.setOrientation(Orientation.INDEXED);
        } else if (this.altKeyDuplicates != null) {
            this.changed = true;
            this.altKeyDuplicates = x;
        }
    }

    public void setAltKeyGroups(Integer[] x) {
        if (x != null) {
            this.changed = true;
            this.altKeyGroups = new Integer[x.length];
            System.arraycopy(x, 0, this.altKeyGroups, 0, x.length);
            this.setOrganization(Organization.VS);
            this.setOrientation(Orientation.INDEXED);
        } else if (this.altKeyGroups != null) {
            this.changed = true;
            this.altKeyGroups = x;
        }
    }

    public void setOrganization(String x) throws InvalidDCBException {
        Organization xx = null;
        if ("PS".equalsIgnoreCase(x)) {
            xx = Organization.PS;
        } else if ("PO".equalsIgnoreCase(x)) {
            xx = Organization.PO;
        } else if ("GDG".equalsIgnoreCase(x)) {
            xx = Organization.GDG;
        } else if ("TAPE".equalsIgnoreCase(x)) {
            xx = Organization.TAPE;
        } else if ("VS".equalsIgnoreCase(x)) {
            xx = Organization.VS;
        } else {
            throw new InvalidDCBException();
        }
        this.setOrganization(xx);
    }

    public void setOrientation(String x) throws InvalidDCBException {
        Orientation xx = null;
        if ("INDEXED".equalsIgnoreCase(x)) {
            xx = Orientation.INDEXED;
        } else if ("NONINDEXED".equalsIgnoreCase(x)) {
            xx = Orientation.NONINDEXED;
        } else if ("LINEAR".equalsIgnoreCase(x)) {
            xx = Orientation.LINEAR;
        } else if ("NUMBERED".equalsIgnoreCase(x)) {
            xx = Orientation.NUMBERED;
        } else if ("LINESEQUENTIAL".equalsIgnoreCase(x)) {
            xx = Orientation.LINESEQUENTIAL;
        } else {
            throw new InvalidDCBException();
        }
        this.setOrientation(xx);
    }

    public void setRecordFormat(String x) throws InvalidDCBException {
        RecordFormat xx = null;
        if ("F".equals(x)) {
            xx = RecordFormat.F;
        } else if ("FB".equals(x)) {
            xx = RecordFormat.FB;
        } else if ("FBS".equals(x)) {
            xx = RecordFormat.FBS;
        } else if ("FBA".equals(x)) {
            xx = RecordFormat.FBA;
        } else if ("V".equals(x)) {
            xx = RecordFormat.V;
        } else if ("VB".equals(x)) {
            xx = RecordFormat.VB;
        } else if ("VBS".equals(x)) {
            xx = RecordFormat.VBS;
        } else if ("VBA".equals(x)) {
            xx = RecordFormat.VBA;
        } else if ("U".equals(x)) {
            xx = RecordFormat.U;
        } else {
            throw new InvalidDCBException();
        }
        this.setRecordFormat(xx);
    }

    public void addProtocol(String x) throws InvalidDCBException {
        if (x == null || x.isEmpty()) {
            this.clearProtocol();
        } else {
            if ("EC".equalsIgnoreCase(x) || "ECOBOL".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.EC);
            } else if ("MF".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.MF);
            } else if ("MF3".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.MF3);
            } else if ("MF8".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.MF8);
            } else if ("ENV".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.ENV);
            } else if ("REMOTE".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.REMOTE);
            } else if ("IBM".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.IBM);
            } else if ("IBMV".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.IBMV);
            } else if ("IBMVB".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.IBMVB);
            } else if ("SYNC".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.SYNC);
            } else if ("CISAM".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.CISAM);
            } else if ("DISAM".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.DISAM);
            } else if ("EISAM".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.EISAM);
            } else if ("AS400".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.AS400);
            } else if ("CB".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.CB);
            } else if ("ROX".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.ROX);
            } else if ("VSQL".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.VSQL);
                this.setOrganization(Organization.VS);
                this.setOrientation(Orientation.INDEXED);
            } else if ("VDB".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.VDB);
                this.setOrganization(Organization.VS);
                if (this.getOrganization() == null) {
                    this.setOrientation(Orientation.INDEXED);
                }
            } else if ("ACU".equalsIgnoreCase(x) || "VIS4".equalsIgnoreCase(x) || "VISUAL4".equalsIgnoreCase(x) || "VIS".equalsIgnoreCase(x) || "VISUAL".equalsIgnoreCase(x)) {
                this.addProtocol(Protocol.ACU);
            } else {
                throw new InvalidDCBException();
            }
            if (this.hasProtocol(Protocol.IBMV) && this.getRecordFormat() == null) {
                this.setRecordFormat(RecordFormat.V);
            } else if (this.hasProtocol(Protocol.IBMVB) && this.getRecordFormat() == null) {
                this.setRecordFormat(RecordFormat.VB);
            }
            if (this.hasProtocol(Protocol.IBMV)) {
                if (this.recordFormat != RecordFormat.V) {
                    this.removeProtocol(Protocol.IBMV);
                }
                if (this.recordFormat == RecordFormat.VB) {
                    this.addProtocol(Protocol.IBMVB);
                }
            } else if (this.hasProtocol(Protocol.IBMVB)) {
                if (this.recordFormat != RecordFormat.VB) {
                    this.removeProtocol(Protocol.IBMVB);
                }
                if (this.recordFormat == RecordFormat.V) {
                    this.addProtocol(Protocol.IBMV);
                }
            }
        }
    }

    public void setProtocol(String xxx) throws InvalidDCBException {
        this.clearProtocol();
        if (xxx != null) {
            for (String x : xxx.split(":")) {
                this.addProtocol(x);
            }
        }
    }

    public String toString() {
        int i;
        if (this.isDamaged()) {
            return "DCB is not to be trusted!";
        }
        String rc = "DCB: ";
        if (this.datasetName != null) {
            rc = rc + this.datasetName + "\n";
        }
        if (this.datasetNamePath != null) {
            rc = rc + this.datasetNamePath + "\n";
        }
        if (this.organization != null) {
            rc = rc + this.toString(this.organization) + " ";
        }
        if (this.orientation != null) {
            rc = rc + this.toString(this.orientation) + " ";
        }
        if (this.recordFormat != null) {
            rc = rc + this.toString(this.recordFormat) + " ";
        }
        rc = rc + "\n";
        if (this.protocols != null) {
            rc = rc + "PROTOCOL(" + this.toString(this.protocols) + ") ";
        }
        if (this.lrecl != null || this.recordMinimum != null || this.recordAverage != null) {
            rc = rc + "RECSIZE(";
        }
        if (this.recordMinimum != null) {
            rc = rc + this.recordMinimum;
        }
        if (this.recordAverage != null) {
            rc = rc + "," + this.recordAverage;
        }
        if (this.lrecl != null) {
            rc = rc + "," + this.lrecl;
        }
        if (this.lrecl != null || this.recordMinimum != null || this.recordAverage != null) {
            rc = rc + ") ";
        }
        if (this.lrecl != null) {
            rc = rc + "LRECL(" + this.lrecl + ") ";
        }
        if (this.blksize != null) {
            rc = rc + "BLKSIZE(" + this.blksize + ") ";
        }
        if (this.bufno != null) {
            rc = rc + "BUFNO(" + this.bufno + ") ";
        }
        rc = rc + "\n";
        if (this.keyLength != null && this.keyOffset != null && this.keyLength.length == this.keyOffset.length) {
            rc = rc + "KEY(";
            for (i = 0; i < this.keyLength.length; ++i) {
                rc = rc + "(" + this.keyLength[i] + "," + this.keyOffset[i] + ")";
            }
            rc = rc + ")\n";
        }
        if (this.altKeyOffsets != null && this.altKeyLengths != null && this.altKeyDuplicates != null && this.altKeyGroups != null && this.altKeyOffsets.length == this.altKeyLengths.length && this.altKeyOffsets.length == this.altKeyDuplicates.length && this.altKeyOffsets.length == this.altKeyGroups.length) {
            rc = rc + "ALTKEYS(";
            int lastSplitGroup = -1;
            for (int i2 = 0; i2 < this.altKeyOffsets.length; ++i2) {
                if (this.altKeyGroups[i2] != lastSplitGroup) {
                    rc = lastSplitGroup == -1 ? rc + "[" : (this.altKeyGroups[i2] == -1 ? rc + "]" : rc + "][");
                    lastSplitGroup = this.altKeyGroups[i2];
                }
                rc = rc + "(" + this.altKeyOffsets[i2] + "," + this.altKeyLengths[i2] + "," + this.altKeyDuplicates[i2] + ")";
                if (i2 + 1 >= this.altKeyOffsets.length) continue;
                rc = rc + ",";
            }
            if (lastSplitGroup != -1) {
                rc = rc + "]";
            }
            rc = rc + ")\n";
        }
        if (this.associates != null) {
            rc = rc + "ASSOCIATES(";
            for (i = 0; i < this.associates.length; ++i) {
                rc = rc + this.associates[i] + " ";
            }
            rc = rc + ")\n";
        }
        if (this.limit != null) {
            rc = rc + "LIMIT(" + this.limit + ") ";
        }
        if (this.label != null) {
            rc = rc + "LABEL(" + this.label + ") ";
        }
        if (this.expdt != null) {
            rc = rc + "EXPDT(" + this.expdt + ") ";
        }
        if (this.reuse != null) {
            rc = rc + (this.reuse != false ? "REUSE " : "NOREUSE ");
        }
        if (this.relate != null) {
            rc = rc + "RELATE(" + this.relate + ") ";
        }
        if (this.path != null) {
            rc = rc + "PATH(" + this.path + ") ";
        }
        if (this.charset != null) {
            rc = rc + "CHARSET(" + this.charset.toString() + ") ";
        }
        return rc;
    }

    public String[] toStringArray() {
        String[] result = new String[2];
        StringBuilder lbl = new StringBuilder(100).append("DCB Info :");
        if (this.getProtocol() != null) {
            lbl.append("Protocols=[").append(this.getProtocol()).append("], ");
        }
        if (this.organization != null) {
            lbl.append("Organization=").append(this.organization.toString()).append(", ");
        }
        if (this.orientation != null) {
            lbl.append("Orientation=").append(this.orientation.toString()).append(", ");
        }
        if (this.recordFormat != null) {
            lbl.append("Record Format=").append(this.recordFormat.toString()).append(", ");
        }
        lbl.append("Charset=").append(this.charset).append(", ");
        result[0] = lbl.toString();
        StringBuilder lbl2 = new StringBuilder(100).append("          ");
        if (this.recordMinimum != null) {
            lbl2.append("Rec Min=").append(this.recordMinimum.toString()).append(", ");
        }
        if (this.lrecl != null) {
            lbl2.append("Rec Max=").append(this.lrecl.toString()).append(", ");
        }
        if (this.isOrientation(Orientation.INDEXED)) {
            lbl2.append("Primary Key[Offset,Length]=>(");
            for (int i = 0; i < this.keyOffset.length; ++i) {
                lbl2.append("[");
                lbl2.append(this.keyOffset[i].toString()).append(",").append(this.keyLength[i].toString());
                if (i + 1 < this.keyOffset.length) {
                    lbl2.append(",");
                }
                lbl2.append("]");
            }
            lbl2.append(") ");
            if (this.altKeyOffsets != null && this.altKeyOffsets.length > 0) {
                lbl2.append("Alternate Key Info[Offset,Length,Duplicates]=>{");
                int lastSplitGroup = -1;
                for (int i = 0; i < this.altKeyOffsets.length; ++i) {
                    if (this.altKeyGroups[i] != lastSplitGroup) {
                        if (lastSplitGroup == -1) {
                            lbl2.append("[");
                        } else if (this.altKeyGroups[i] == -1) {
                            lbl2.append("]");
                        } else {
                            lbl2.append("][");
                        }
                        lastSplitGroup = this.altKeyGroups[i];
                    }
                    lbl2.append("(").append(this.altKeyOffsets[i]).append(",").append(this.altKeyLengths[i]).append(",").append(this.altKeyDuplicates[i]).append(")");
                }
                if (lastSplitGroup != -1) {
                    lbl2.append("]");
                }
                lbl2.append("}");
            }
        } else if (this.isOrientation(Orientation.NUMBERED)) {
            lbl2.append("Relative Key Length=").append(this.keyLength[0].toString()).append(")  ");
        }
        result[1] = lbl2.toString();
        return result;
    }

    public String toString(Integer x) {
        if (x == null) {
            return "";
        }
        return "" + x;
    }

    public String toString(Protocol proto) {
        switch (proto) {
            case EC: 
            case EISAM: {
                return "EC";
            }
            case MF: {
                return "MF";
            }
            case MF3: {
                return "MF3";
            }
            case MF8: {
                return "MF8";
            }
            case IBM: {
                return "IBM";
            }
            case IBMV: {
                return "IBMV";
            }
            case IBMVB: {
                return "IBMVB";
            }
            case SYNC: {
                return "SYNC";
            }
            case ACU: {
                return "ACU";
            }
            case AS400: {
                return "AS400";
            }
            case CISAM: {
                return "CISAM";
            }
            case DISAM: {
                return "DISAM";
            }
            case ENV: {
                return "ENV";
            }
            case REMOTE: {
                return "REMOTE";
            }
            case VSQL: {
                return "VSQL";
            }
            case VDB: {
                return "VDB";
            }
            case CB: {
                return "CB";
            }
            case ROX: {
                return "ROX";
            }
        }
        return "";
    }

    public String toString(EnumSet<Protocol> proto) {
        String protocol = "";
        if (proto != null) {
            for (Protocol p : proto) {
                protocol = protocol + this.toString(p) + ":";
            }
        }
        return protocol;
    }

    public String toString(Organization org) {
        switch (org) {
            case TAPE: {
                return "TAPE";
            }
            case GDG: {
                return "GDG";
            }
            case PO: {
                return "PO";
            }
            case PS: {
                return "PS";
            }
            case VS: {
                return "VS";
            }
        }
        return "";
    }

    public String toString(Orientation orient) {
        switch (orient) {
            case INDEXED: {
                return "INDEXED";
            }
            case NONINDEXED: {
                return "NONINDEXED";
            }
            case LINESEQUENTIAL: {
                return "LINESEQUENTIAL";
            }
            case NUMBERED: {
                return "NUMBERED";
            }
            case LINEAR: {
                return "LINEAR";
            }
        }
        return "";
    }

    public String toString(RecordFormat recfm) {
        switch (recfm) {
            case F: {
                return "F";
            }
            case FB: {
                return "FB";
            }
            case FBA: {
                return "FBA";
            }
            case FBS: {
                return "FBS";
            }
            case U: {
                return "U";
            }
            case V: {
                return "V";
            }
            case VB: {
                return "VB";
            }
            case VBA: {
                return "VBA";
            }
            case VBS: {
                return "VBS";
            }
        }
        return " ";
    }

    public String[][] expiredDSNs() {
        Date now = new Date();
        ArrayList<String[]> expDSNs = new ArrayList<String[]>();
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String aKey = (String)keys.nextElement();
            if (!aKey.endsWith(KEY_EXPDT)) continue;
            String expdt = this.properties.getProperty(aKey);
            SimpleDateFormat sdf = new SimpleDateFormat("Y-M-d H:m:s");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                Date d = sdf.parse(expdt);
                if (!d.before(now)) continue;
                expDSNs.add(new String[]{aKey.substring(0, aKey.length() - 6), expdt});
            }
            catch (ParseException parseException) {}
        }
        return (String[][])expDSNs.toArray((T[])new String[0][]);
    }

    public void removeDCB(String dsn) {
        String sw = dsn + "-";
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String aKey = (String)keys.nextElement();
            if (!aKey.startsWith(sw)) continue;
            this.properties.remove(aKey);
            this.changed = true;
        }
    }

    public synchronized RandomAccessFile loadDCB() {
        if (this.isDamaged || this.datasetNamePath == null) {
            return null;
        }
        this.properties = new Properties();
        if (this.datasetNamePath.startsWith("/dev") || this.datasetNamePath.equalsIgnoreCase("NUL:")) {
            return null;
        }
        File dsnFile = new File(this.datasetNamePath);
        File dcbFile = null;
        this.dcbPath = dsnFile.exists() ? (dsnFile.isDirectory() ? dsnFile.getAbsolutePath() + File.separator + ".dcb" : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb")) : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb");
        dcbFile = new File(this.dcbPath);
        if (!dcbFile.exists()) {
            this.mergeDefaultAttributes(System.getProperties());
            if (this.changed) {
                try {
                    dcbFile.createNewFile();
                    this.changed = true;
                }
                catch (IOException e) {
                    LastError = "Heirloom Computing runtime Error: Cannot create Data Control Block (DCB) to hold descriptive dataset information at " + this.dcbPath + ". Check directory permissions and ownership";
                    System.err.println(LastError);
                    this.onDisk = false;
                    return null;
                }
            } else {
                this.setDefaultAttributes();
                this.onDisk = false;
                return null;
            }
        }
        try {
            String mode = "rw";
            RandomAccessFile randomAccessFile = new RandomAccessFile(dcbFile, mode);
            FileChannel rafchan = randomAccessFile.getChannel();
            this.fileLock = rafchan.lock(0L, Long.MAX_VALUE, false);
            InputStream is = Channels.newInputStream(rafchan);
            this.properties.load(is);
            if (this.datasetName == null) {
                this.datasetName = dsnFile.getName();
            }
            if (this.datasetName != null) {
                this.merge(this.properties);
            }
            this.setDefaultAttributes();
            if (this.changed) {
                this.saveDCB(randomAccessFile);
            }
            this.onDisk = true;
            LastError = "";
            return randomAccessFile;
        }
        catch (FileNotFoundException e) {
            this.onDisk = false;
            return null;
        }
        catch (IOException e) {
            this.onDisk = false;
            return null;
        }
    }

    public synchronized void loadDCB(boolean forupdate) {
        if (this.isDamaged || this.datasetNamePath == null) {
            return;
        }
        this.properties = new Properties();
        if (this.datasetNamePath.startsWith("/dev") || this.datasetNamePath.equalsIgnoreCase("NUL:")) {
            return;
        }
        File dsnFile = new File(this.datasetNamePath);
        File dcbFile = null;
        this.dcbPath = dsnFile.exists() ? (dsnFile.isDirectory() ? dsnFile.getAbsolutePath() + File.separator + ".dcb" : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb")) : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb");
        dcbFile = new File(this.dcbPath);
        if (!dcbFile.exists()) {
            this.mergeDefaultAttributes(System.getProperties());
            if (forupdate || this.changed) {
                try {
                    dcbFile.createNewFile();
                    this.changed = true;
                }
                catch (IOException e) {
                    LastError = "Heirloom Computing runtime Error: Cannot create Data Control Block (DCB) to hold descriptive dataset information at " + this.dcbPath + ". Check directory permissions and ownership";
                    System.err.println(LastError);
                    this.onDisk = false;
                    return;
                }
            } else {
                this.setDefaultAttributes();
                this.onDisk = false;
                return;
            }
        }
        try {
            String mode = "rw";
            RandomAccessFile randomAccessFile = new RandomAccessFile(dcbFile, mode);
            FileChannel rafchan = randomAccessFile.getChannel();
            this.fileLock = rafchan.lock(0L, Long.MAX_VALUE, false);
            InputStream is = Channels.newInputStream(rafchan);
            this.properties.load(is);
            if (this.datasetName == null) {
                this.datasetName = dsnFile.getName();
            }
            if (this.datasetName != null) {
                this.merge(this.properties);
            }
            this.setDefaultAttributes();
            if (this.changed) {
                this.saveDCB(randomAccessFile);
            } else {
                this.fileLock.release();
                randomAccessFile.close();
            }
            this.onDisk = true;
            LastError = "";
        }
        catch (OverlappingFileLockException e) {
            this.isDamaged = true;
            this.onDisk = false;
            this.fileLock = null;
        }
        catch (NonWritableChannelException e) {
            this.onDisk = false;
            this.isDamaged = true;
            this.fileLock = null;
            return;
        }
        catch (FileNotFoundException e) {
            this.onDisk = false;
            this.isDamaged = true;
            this.fileLock = null;
            return;
        }
        catch (ClosedChannelException e) {
            this.onDisk = false;
            this.isDamaged = true;
            this.fileLock = null;
            return;
        }
        catch (IOException e) {
            this.onDisk = false;
            this.isDamaged = true;
            this.fileLock = null;
            return;
        }
    }

    public synchronized void saveDCB() {
        if (this.isDamaged) {
            return;
        }
        if (this.organization == Organization.PS && this.orientation == null && this.recordFormat == null && this.protocols == null && this.recordMinimum == null && this.recordAverage == null && this.lrecl == null && this.blksize == null && this.limit == null && this.keyOffset == null && this.keyLength == null && this.altKeyOffsets == null && this.altKeyLengths == null && this.altKeyDuplicates == null && this.altKeyGroups == null && this.expdt == null && this.label == null) {
            return;
        }
        try {
            File dsnFile = new File(this.datasetNamePath);
            File dcbFile = null;
            this.dcbPath = dsnFile.exists() ? (dsnFile.isDirectory() ? dsnFile.getAbsolutePath() + File.separator + ".dcb" : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb")) : (dsnFile.getParentFile() == null ? ".dcb" : dsnFile.getParentFile().getAbsolutePath() + File.separator + ".dcb");
            dcbFile = new File(this.dcbPath);
            RandomAccessFile randomAccessFile = new RandomAccessFile(dcbFile, "rw");
            FileChannel rafchan = randomAccessFile.getChannel();
            this.fileLock = rafchan.lock(0L, Long.MAX_VALUE, false);
            InputStream is = Channels.newInputStream(rafchan);
            this.properties = new Properties();
            this.properties.load(is);
            this.saveDCB(randomAccessFile);
        }
        catch (IOException e) {
            IOException iOException = e;
        }
    }

    public synchronized void saveDCB(RandomAccessFile randomAccessFile) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.datasetName != null) {
            String sw = this.datasetName + "-";
            if (this.organization != null) {
                this.properties.setProperty(sw + KEY_ORGANIZATION, this.toString(this.organization));
            } else {
                this.properties.remove(sw + KEY_ORGANIZATION);
            }
            if (this.orientation != null) {
                this.properties.setProperty(sw + KEY_ORIENTATION, this.toString(this.orientation));
            } else {
                this.properties.remove(sw + KEY_ORIENTATION);
            }
            if (this.recordFormat != null) {
                this.properties.setProperty(sw + KEY_RECORDFORMAT, this.toString(this.recordFormat));
            } else {
                this.properties.remove(sw + KEY_RECORDFORMAT);
            }
            if (this.protocols != null) {
                this.properties.setProperty(sw + KEY_PROTOCOL, this.toString(this.protocols));
            } else {
                this.properties.remove(sw + KEY_PROTOCOL);
            }
            if (this.recordMinimum != null) {
                this.properties.setProperty(sw + KEY_RECORDMINIMUM, this.toString(this.recordMinimum));
            } else {
                this.properties.remove(sw + KEY_RECORDMINIMUM);
            }
            if (this.recordAverage != null) {
                this.properties.setProperty(sw + KEY_RECORDAVERAGE, this.toString(this.recordAverage));
            } else {
                this.properties.remove(sw + KEY_RECORDAVERAGE);
            }
            if (this.lrecl != null) {
                this.properties.setProperty(sw + KEY_LRECL, this.toString(this.lrecl));
            } else {
                this.properties.remove(sw + KEY_LRECL);
            }
            if (this.blksize != null) {
                this.properties.setProperty(sw + KEY_BLKSIZE, this.toString(this.blksize));
            } else {
                this.properties.remove(sw + KEY_BLKSIZE);
            }
            if (this.limit != null) {
                this.properties.setProperty(sw + KEY_LIMIT, this.toString(this.limit));
            } else {
                this.properties.remove(sw + KEY_LIMIT);
            }
            if (this.keyLength != null) {
                this.properties.setProperty(sw + KEY_KEYLENGTH, DCB.toString(this.keyLength));
            } else {
                this.properties.remove(sw + KEY_KEYLENGTH);
            }
            if (this.keyOffset != null) {
                this.properties.setProperty(sw + KEY_KEYOFFSET, DCB.toString(this.keyOffset));
            } else {
                this.properties.remove(sw + KEY_KEYOFFSET);
            }
            if (this.altKeyLengths != null && this.altKeyLengths.length > 0) {
                this.properties.setProperty(sw + KEY_ALTKEYLENGTHS, DCB.toString(this.altKeyLengths));
            } else {
                this.properties.remove(sw + KEY_ALTKEYLENGTHS);
            }
            if (this.altKeyOffsets != null && this.altKeyOffsets.length > 0) {
                this.properties.setProperty(sw + KEY_ALTKEYOFFSETS, DCB.toString(this.altKeyOffsets));
            } else {
                this.properties.remove(sw + KEY_ALTKEYOFFSETS);
            }
            if (this.altKeyDuplicates != null && this.altKeyDuplicates.length > 0) {
                this.properties.setProperty(sw + KEY_ALTKEYDUPLICATES, DCB.toString(this.altKeyDuplicates));
            } else {
                this.properties.remove(sw + KEY_ALTKEYDUPLICATES);
            }
            if (this.altKeyGroups != null && this.altKeyGroups.length > 0) {
                this.properties.setProperty(sw + KEY_ALTKEYGROUPS, DCB.toString(this.altKeyGroups));
            } else {
                this.properties.remove(sw + KEY_ALTKEYGROUPS);
            }
            if (this.label != null) {
                this.properties.setProperty(sw + KEY_LABEL, this.toString(this.label));
            } else {
                this.properties.remove(sw + KEY_LABEL);
            }
            if (this.expdt != null) {
                this.properties.setProperty(sw + KEY_EXPDT, this.expdt);
            } else {
                this.properties.remove(sw + KEY_EXPDT);
            }
            if (this.reuse != null) {
                this.properties.setProperty(sw + KEY_REUSE, DCB.toString(this.reuse));
            } else {
                this.properties.remove(sw + KEY_REUSE);
            }
            if (this.relate != null) {
                this.properties.setProperty(sw + KEY_RELATE, this.relate);
            } else {
                this.properties.remove(sw + KEY_RELATE);
            }
            if (this.path != null) {
                this.properties.setProperty(sw + KEY_PATH, this.path);
            } else {
                this.properties.remove(sw + KEY_PATH);
            }
            if (this.associates != null && this.associates.length != 0) {
                this.properties.setProperty(sw + KEY_ASSOCIATES, DCB.toString(this.associates));
            } else {
                this.properties.remove(sw + KEY_ASSOCIATES);
            }
            if (this.charset != null) {
                this.properties.setProperty(sw + KEY_CHARSET, this.charset);
            } else {
                this.properties.remove(sw + KEY_CHARSET);
            }
        }
        try {
            if (randomAccessFile != null) {
                if (!this.properties.isEmpty()) {
                    randomAccessFile.setLength(0L);
                    OutputStream os = Channels.newOutputStream(randomAccessFile.getChannel());
                    this.properties.store(os, "Heirloom Computing, Inc. - Data Control Block");
                    os.flush();
                }
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.release();
                }
                randomAccessFile.close();
                if (this.properties.isEmpty()) {
                    File d = new File(this.dcbPath);
                    d.delete();
                }
            } else {
                DCB copy = DCBFactory.getInstance(this);
                RandomAccessFile raf = copy.loadDCB();
                if (copy.onDisk) {
                    copy.merge(this);
                    copy.saveDCB(raf);
                } else if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (OverlappingFileLockException e) {
            this.isDamaged = true;
            this.onDisk = false;
            this.fileLock = null;
        }
        catch (NonWritableChannelException e) {
            this.onDisk = false;
            this.isDamaged = true;
            return;
        }
        catch (ClosedChannelException e) {
            this.isDamaged = true;
            this.onDisk = false;
            this.fileLock = null;
        }
        catch (IOException e) {
            this.isDamaged = true;
            this.onDisk = false;
            return;
        }
        randomAccessFile = null;
        this.fileLock = null;
        this.onDisk = true;
        this.changed = false;
    }

    public synchronized void unlockDCB() {
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
        }
        catch (IOException e) {
            this.isDamaged = true;
            this.onDisk = false;
        }
        this.fileLock = null;
    }

    public synchronized void deleteDCB() {
        RandomAccessFile raf = this.loadDCB();
        if (raf != null && this.onDisk && !this.isDamaged) {
            this.organization = null;
            this.orientation = null;
            this.recordFormat = null;
            this.protocols = null;
            this.recordMinimum = null;
            this.recordAverage = null;
            this.lrecl = null;
            this.blksize = null;
            this.limit = null;
            this.keyOffset = null;
            this.keyLength = null;
            this.altKeyOffsets = null;
            this.altKeyLengths = null;
            this.altKeyDuplicates = null;
            this.altKeyGroups = null;
            this.expdt = null;
            this.reuse = null;
            this.relate = null;
            this.path = null;
            this.associates = null;
            this.charset = null;
            this.label = null;
            this.changed = true;
            ArrayList<String> allDCBstarts = new ArrayList<String>();
            Enumeration<Object> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String challenge = (String)keys.nextElement();
                if (!challenge.endsWith("-relate") || !this.datasetName.equals(this.properties.getProperty(challenge))) continue;
                allDCBstarts.add(challenge.substring(0, challenge.length() - 7) + "-");
            }
            allDCBstarts.add(this.datasetName + "-");
            for (String aDCBstart : allDCBstarts) {
                keys = this.properties.keys();
                while (keys.hasMoreElements()) {
                    String challenge = (String)keys.nextElement();
                    if (!challenge.startsWith(aDCBstart)) continue;
                    this.properties.remove(challenge);
                }
            }
            this.saveDCB(raf);
        }
    }

    private void deriveDatasetName() {
        if (this.datasetName == null && this.datasetNamePath != null) {
            File f = new File(this.datasetNamePath);
            this.dcbPath = f.getParentFile() == null ? ".dcb" : f.getParentFile().getAbsolutePath() + File.separator + ".dcb";
            File d = new File(this.dcbPath);
            Properties properties = new Properties();
            try {
                if (d.exists() && d.canRead()) {
                    FileInputStream fis = new FileInputStream(d);
                    properties.load(fis);
                    fis.close();
                }
                Enumeration<Object> keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String possibleDSN = ((String)keys.nextElement()).split("-")[0];
                    String checkDSNPath = this.datasetNamePath.toLowerCase().replace(File.separatorChar, '.');
                    if (!checkDSNPath.endsWith(possibleDSN.toLowerCase())) continue;
                    this.datasetName = possibleDSN;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                this.isDamaged = true;
            }
            catch (IOException e) {
                this.isDamaged = true;
            }
            if (this.datasetName == null) {
                this.datasetName = f.getName().toUpperCase();
            }
        } else {
            this.isDamaged = true;
        }
    }

    private static String extractPath(String dsnPath) {
        int i;
        if (dsnPath == null) {
            return null;
        }
        while ((i = dsnPath.indexOf(58)) > 1) {
            dsnPath = dsnPath.substring(i + 1);
        }
        return dsnPath;
    }

    private static String extractProtocols(String dsnPath) {
        int i;
        if (dsnPath == null) {
            return null;
        }
        String protocols = "";
        while ((i = dsnPath.indexOf(58)) > 1) {
            protocols = protocols + dsnPath.substring(0, i + 1);
            dsnPath = dsnPath.substring(i + 1);
        }
        return protocols;
    }

    private static Integer[] toIntegerArray(String x) {
        if (x == null) {
            return null;
        }
        String[] y = x.split(",");
        Integer[] z = new Integer[y.length];
        try {
            for (int i = 0; i < y.length; ++i) {
                z[i] = Integer.parseInt(y[i]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return z;
    }

    private static String[] toStringArray(String x) {
        if (x == null) {
            return null;
        }
        return x.split(",");
    }

    private static Boolean[] toBooleanArray(String x) {
        if (x == null) {
            return null;
        }
        String[] y = x.split(",");
        Boolean[] z = new Boolean[y.length];
        for (int i = 0; i < y.length; ++i) {
            z[i] = "true".equalsIgnoreCase(y[i]);
        }
        return z;
    }

    protected static String toString(Integer[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder y = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                y.append(",");
            }
            y.append(x[i]);
        }
        return y.toString();
    }

    protected static String toString(Boolean[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder y = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                y.append(",");
            }
            y.append(DCB.toString(x[i]));
        }
        return y.toString();
    }

    protected static String toString(String[] x) {
        if (x == null) {
            return null;
        }
        StringBuilder y = new StringBuilder();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                y.append(",");
            }
            y.append(x[i]);
        }
        return y.toString();
    }

    protected static String toString(Boolean x) {
        if (x == null) {
            return null;
        }
        return x != false ? "true" : "false";
    }

    public static String getDateTime(Date theDate) {
        if (theDate == null) {
            theDate = new Date();
        }
        return HC_DT_FORMAT.format(theDate);
    }

    public boolean loadDCBFromSystemProp(String filename) {
        boolean isLoad = false;
        Properties properties = System.getProperties();
        filename = filename + "-";
        Enumeration<Object> keys = properties.keys();
        ArrayList<Object> list = Collections.list(keys);
        Collections.sort(list);
        for (String string2 : list) {
            if (!string2.startsWith(filename)) continue;
            try {
                isLoad = true;
                if (this.organization == null && string2.endsWith(KEY_ORGANIZATION)) {
                    this.setOrganization(properties.getProperty(string2));
                    continue;
                }
                if (this.orientation == null && string2.endsWith(KEY_ORIENTATION)) {
                    this.setOrientation(properties.getProperty(string2));
                    continue;
                }
                if (this.recordFormat == null && string2.endsWith(KEY_RECORDFORMAT)) {
                    this.setRecordFormat(properties.getProperty(string2));
                    continue;
                }
                if (this.protocols == null && string2.endsWith(KEY_PROTOCOL)) {
                    this.setProtocol(properties.getProperty(string2));
                    continue;
                }
                if (this.recordMinimum == null && string2.endsWith(KEY_RECORDMINIMUM)) {
                    this.setRecordMinimum(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.recordAverage == null && string2.endsWith(KEY_RECORDAVERAGE)) {
                    this.setRecordAverage(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.lrecl == null && string2.endsWith(KEY_LRECL)) {
                    this.setLrecl(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.blksize == null && string2.endsWith(KEY_BLKSIZE)) {
                    this.setBlksize(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.limit == null && string2.endsWith(KEY_LIMIT)) {
                    this.setLimit(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.keyLength == null && string2.endsWith(KEY_KEYLENGTH)) {
                    this.setKeyLength(DCB.toIntegerArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.keyOffset == null && string2.endsWith(KEY_KEYOFFSET)) {
                    this.setKeyOffset(DCB.toIntegerArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyOffsets == null && string2.endsWith(KEY_ALTKEYOFFSETS)) {
                    this.setAltKeyOffsets(DCB.toIntegerArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyLengths == null && string2.endsWith(KEY_ALTKEYLENGTHS)) {
                    this.setAltKeyLengths(DCB.toIntegerArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyDuplicates == null && string2.endsWith(KEY_ALTKEYDUPLICATES)) {
                    this.setAltKeyDuplicates(DCB.toBooleanArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.altKeyGroups == null && string2.endsWith(KEY_ALTKEYGROUPS)) {
                    this.setAltKeyGroups(DCB.toIntegerArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.label == null && string2.endsWith(KEY_LABEL)) {
                    this.setLabel(Integer.parseInt(properties.getProperty(string2)));
                    continue;
                }
                if (this.expdt == null && string2.endsWith(KEY_EXPDT)) {
                    this.setExpdt(properties.getProperty(string2));
                    continue;
                }
                if (this.reuse == null && string2.endsWith(KEY_REUSE)) {
                    this.setReuse("true".equals(properties.getProperty(string2)));
                    continue;
                }
                if (this.relate == null && string2.endsWith(KEY_RELATE)) {
                    this.setRelate(properties.getProperty(string2));
                    continue;
                }
                if (this.path == null && string2.endsWith(KEY_PATH)) {
                    this.setPath(properties.getProperty(string2));
                    continue;
                }
                if (this.associates == null && string2.endsWith(KEY_ASSOCIATES)) {
                    this.setAssociates(DCB.toStringArray(properties.getProperty(string2)));
                    continue;
                }
                if (this.charset != null || !string2.endsWith(KEY_CHARSET)) continue;
                this.setCharset(properties.getProperty(string2));
            }
            catch (InvalidDCBException invalidDCBException) {
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!isLoad && LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.warning("Warning! System properties does not contain dcb info for : " + this.datasetName);
            LogSetup.LOGGER.warning("Warning! Possible corruption in Base DCB");
        }
        return isLoad;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public class InvalidDCBException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static enum Protocol {
        EC,
        MF,
        MF3,
        MF8,
        ENV,
        REMOTE,
        CISAM,
        DISAM,
        EISAM,
        AS400,
        ACU,
        IBM,
        IBMV,
        IBMVB,
        SYNC,
        VSQL,
        VDB,
        CB,
        ROX;

    }

    public static enum Orientation {
        INDEXED,
        NONINDEXED,
        LINEAR,
        NUMBERED,
        LINESEQUENTIAL;

    }

    public static enum Organization {
        PS,
        PO,
        GDG,
        VS,
        TAPE;

    }

    public static enum RecordFormat {
        F,
        V,
        U,
        FB,
        VB,
        FBS,
        VBS,
        FBA,
        VBA;

    }
}

