/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.isamsql;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.isamsql.SqlColumn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDatasetLoader
extends DefaultHandler {
    private static final String PGM = "XmlDatasetLoader";
    private String filename = null;
    private ArrayList<String> groupInfoList = new ArrayList();
    private List<Integer> occList = new ArrayList<Integer>(5);
    private List<Integer> occLenList = new ArrayList<Integer>(5);
    private HashMap<String, Vector<SqlColumn>> dbTables = new HashMap();
    private boolean isExtended = false;
    int ignoreRedefCntr = 0;
    LinkedHashMap<String, LinkedHashMap<String, Object>> dbTablesExt = new LinkedHashMap();
    ArrayList<LinkedHashMap<String, Object>> groupMap = new ArrayList();
    static ArrayList<String> redefinedItems = new ArrayList();
    LinkedHashMap<String, Object> currGroupLevel;
    LinkedHashMap<String, Object> lastGroupLevel;

    public XmlDatasetLoader(String filename) {
        this.filename = filename;
    }

    public static Vector<SqlColumn> XmlToFileTable(String file2) {
        HashMap<String, Vector<SqlColumn>> sqlTables = XmlDatasetLoader.XmlToTable(file2);
        Object firstKey = sqlTables.keySet().toArray()[0];
        return sqlTables.get(firstKey);
    }

    public static LinkedHashMap<String, LinkedHashMap<String, Object>> XmlToFileTableExt(String file2) {
        XmlDatasetLoader xl = new XmlDatasetLoader(file2);
        xl.isExtended = true;
        xl.loadToTable();
        return xl.dbTablesExt;
    }

    public static HashMap<String, Vector<SqlColumn>> XmlToTable(String file2) {
        XmlDatasetLoader xl = new XmlDatasetLoader(file2);
        HashMap<String, Vector<SqlColumn>> sqlTables = xl.loadToTable();
        return sqlTables;
    }

    public static HashMap<String, Vector<SqlColumn>> XmlToTable(ArrayList<String> filelist) {
        XmlDatasetLoader xl = new XmlDatasetLoader(null);
        HashMap<String, Vector<SqlColumn>> sqlTables = null;
        for (int i = 0; i < filelist.size(); ++i) {
            sqlTables = xl.loadToTable(filelist.get(i));
        }
        return sqlTables;
    }

    public HashMap<String, Vector<SqlColumn>> loadToTable() {
        return this.loadToTable(this.filename);
    }

    public HashMap<String, Vector<SqlColumn>> loadToTable(String file2) {
        InputStream in;
        block22: {
            this.filename = file2;
            if (file2 == null) {
                throw new IllegalArgumentException("file cannot be null");
            }
            in = null;
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            in = loader.getResourceAsStream(this.filename);
            if (in == null) {
                try {
                    in = new FileInputStream(new File(file2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (in == null) {
                    try {
                        in = new FileInputStream(new File(this.filename));
                    }
                    catch (Exception e) {
                        try {
                            in = new FileInputStream(new File("workdir" + File.separator + this.filename));
                        }
                        catch (Exception f) {
                            try {
                                in = new FileInputStream(new File("resources" + File.separator + this.filename));
                            }
                            catch (Exception g) {
                                try {
                                    in = new FileInputStream(new File(".." + File.separator + "resources" + File.separator + this.filename));
                                }
                                catch (Exception h) {
                                    in = this.getClass().getResourceAsStream(this.filename);
                                    if (in == null) {
                                        String str = "/listing/" + this.filename;
                                        in = this.getClass().getResourceAsStream(str);
                                        if (in == null) {
                                            str = "/resources/" + this.filename;
                                            in = this.getClass().getResourceAsStream(str);
                                            if (in == null) {
                                                str = "/workdir/" + this.filename;
                                                in = this.getClass().getResourceAsStream(str);
                                            }
                                        }
                                    }
                                    if (in != null) break block22;
                                    System.out.println("Abend at XmlDatasetLoader because VSAM-to-SQL mapping file '" + this.filename + "' cannot be found.\n File must be in classpath or JAR file from which the program is executed.");
                                    throw new RuntimeException("Abend at XmlDatasetLoader because VSAM-to-SQL mapping file '" + this.filename + "' cannot be found.\n File must be in classpath or JAR file from which the program is executed.");
                                }
                            }
                        }
                    }
                }
            }
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(in, (DefaultHandler)this);
            in.close();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("XmlDatasetLoader.loadToTable(): parse() is finished. dbTables.size()=" + this.dbTables.size());
            Set<String> s = this.dbTables.keySet();
            Iterator<String> it = s.iterator();
            while (it.hasNext()) {
                System.out.println(it.next() + "  ");
            }
        }
        return this.dbTables;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String redef;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("~ XmlDatasetLoader.startElement(): uri=" + uri + ". localName=" + localName + ". qName=" + qName + ".");
        }
        if (localName == null || localName.length() == 0) {
            localName = qName;
        }
        if (localName == null) {
            return;
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("~ XmlDatasetLoader.startElement(): localName=" + localName + ".");
        }
        if ("group".equals(localName)) {
            if (attributes.getValue("redefines") != null && !this.isExtended) {
                ++this.ignoreRedefCntr;
                return;
            }
            if (this.ignoreRedefCntr > 0) {
                ++this.ignoreRedefCntr;
                return;
            }
            if (this.isExtended) {
                redef = attributes.getValue("redefines");
                if (redef != null && !redefinedItems.contains(redef)) {
                    redefinedItems.add(redef);
                }
                if (this.dbTablesExt.get(attributes.getValue("table")) == null) {
                    redefinedItems.clear();
                    this.groupMap.clear();
                    LinkedHashMap currGroup = new LinkedHashMap();
                    this.dbTablesExt.put(attributes.getValue("table"), currGroup);
                    this.groupMap.add(currGroup);
                } else {
                    if (this.groupMap.size() == 0) {
                        throw new RuntimeException("Error parsing bad XFD xml:\nPossible duplicate group levels for =>" + attributes.getValue("name") + "\nTry rebuilding the xfd xml file");
                    }
                    LinkedHashMap currGroup = new LinkedHashMap();
                    if (redef != null) {
                        String delimit = String.valueOf('\u001d');
                        String sWhen = delimit + attributes.getValue("xfdop") + delimit + attributes.getValue("xfdarg1") + delimit + (attributes.getValue("xfdarg2") == null ? "" : attributes.getValue("xfdarg2")) + delimit + attributes.getValue("xfdvar");
                        this.groupMap.get(this.groupMap.size() - 1).put(attributes.getValue("name") + " redefines " + redef + sWhen, currGroup);
                    } else {
                        this.groupMap.get(this.groupMap.size() - 1).put(attributes.getValue("name"), currGroup);
                    }
                    this.groupMap.add(currGroup);
                }
            }
            if (attributes.getValue("occurs") != null) {
                this.groupInfoList.add(attributes.getValue("occurs") + "," + attributes.getValue("length"));
            } else {
                this.groupInfoList.add(null);
            }
        }
        if ("column".equals(localName)) {
            if (this.dbTablesExt.get(attributes.getValue("table")) == null) {
                redefinedItems.clear();
                this.groupMap.clear();
                LinkedHashMap currGroup = new LinkedHashMap();
                this.dbTablesExt.put(attributes.getValue("table"), currGroup);
                this.groupMap.add(currGroup);
            }
            if (attributes.getValue("redefines") != null && !this.isExtended) {
                return;
            }
            if (this.ignoreRedefCntr > 0) {
                return;
            }
            if (this.isExtended && (redef = attributes.getValue("redefines")) != null && !redefinedItems.contains(redef)) {
                redefinedItems.add(redef);
            }
            if (attributes.getValue("use_occurs") != null && attributes.getValue("use_occurs").equalsIgnoreCase("1")) {
                this.groupInfoList.add(attributes.getValue("occurs") + "," + attributes.getValue("length"));
            }
            this.setUpOccursValues();
            if (this.occList.size() == 0) {
                this.declareColumn(attributes, null, 0, 0);
            } else {
                this.declareOccursCols(this.occList, Integer.valueOf(attributes.getValue("offset")), this.occLenList, attributes.getValue("name"), attributes);
            }
            if (attributes.getValue("use_occurs") != null && attributes.getValue("use_occurs").equalsIgnoreCase("1")) {
                this.groupInfoList.remove(this.groupInfoList.size() - 1);
            }
            return;
        }
    }

    void declareOccursCols(List<Integer> currOccList, int offset, List<Integer> currOccLenList, String prefix, Attributes attributes) {
        if (currOccList.size() > 1) {
            for (int i = 1; i <= currOccList.get(0); ++i) {
                if (i > 1) {
                    offset += currOccLenList.get(0).intValue();
                }
                this.declareOccursCols(currOccList.subList(1, currOccList.size()), offset, currOccLenList.subList(1, currOccLenList.size()), prefix + "_" + i, attributes);
            }
        } else {
            for (int j = 1; j <= currOccList.get(0); ++j) {
                if (j > 1) {
                    offset += currOccLenList.get(0).intValue();
                }
                this.declareColumn(attributes, prefix + "_" + j, offset, currOccLenList.get(0));
            }
        }
    }

    private void setUpOccursValues() {
        this.occList.clear();
        this.occLenList.clear();
        for (String grpValues : this.groupInfoList) {
            if (grpValues == null) continue;
            String[] value = grpValues.split(",");
            this.occList.add(Integer.valueOf(value[0]));
            this.occLenList.add(Integer.valueOf(value[1]) / Integer.valueOf(value[0]));
        }
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if ("group".equals(arg2)) {
            if (this.ignoreRedefCntr > 0) {
                --this.ignoreRedefCntr;
                return;
            }
            if (this.isExtended) {
                if (this.groupMap.size() == 1) {
                    LinkedHashMap<String, Object> redefinedMap = new LinkedHashMap<String, Object>();
                    XmlDatasetLoader.updateMap(this.groupMap.get(0), redefinedMap);
                    this.groupMap.get(0).clear();
                    this.groupMap.get(0).putAll(redefinedMap);
                }
                this.groupMap.remove(this.groupMap.size() - 1);
            }
            this.groupInfoList.remove(this.groupInfoList.size() - 1);
        }
    }

    private static void updateMap(LinkedHashMap<String, Object> itr, LinkedHashMap<String, Object> currGroupCollection) {
        Set<Map.Entry<String, Object>> es = itr.entrySet();
        for (Map.Entry<String, Object> esValue : es) {
            if (esValue.getValue() instanceof SqlColumn) {
                currGroupCollection.put(esValue.getKey(), esValue.getValue());
                continue;
            }
            if (esValue.getKey().contains(" redefines ") || redefinedItems.contains(esValue.getKey())) {
                LinkedHashMap<String, Object> newGroup = new LinkedHashMap<String, Object>();
                currGroupCollection.put(esValue.getKey(), newGroup);
                XmlDatasetLoader.updateMap((LinkedHashMap)esValue.getValue(), newGroup);
                continue;
            }
            XmlDatasetLoader.updateMap((LinkedHashMap)esValue.getValue(), currGroupCollection);
        }
    }

    private void declareColumn(Attributes attributes, String newName, int newOffset, int newLength) {
        String table;
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("XmlDatasetLoader.declareColumn(): start method.");
        }
        SqlColumn column = new SqlColumn(attributes);
        if (newName != null) {
            column.setName(newName);
            column.setOffset(newOffset);
            if (attributes.getValue("use_occurs") != null && attributes.getValue("use_occurs").equalsIgnoreCase("1")) {
                column.setLength(newLength);
            }
        }
        if ((table = column.getTable()) == null) {
            return;
        }
        if (this.isExtended) {
            String redef;
            String _name = attributes.getValue("name");
            if (newName != null) {
                _name = newName;
            }
            if ((redef = attributes.getValue("redefines")) != null) {
                String delimit = String.valueOf('\u001d');
                String sWhen = delimit + attributes.getValue("xfdop") + delimit + attributes.getValue("xfdarg1") + delimit + (attributes.getValue("xfdarg2") == null ? "" : attributes.getValue("xfdarg2")) + delimit + attributes.getValue("xfdvar");
                this.groupMap.get(this.groupMap.size() - 1).put(_name + " redefines " + redef + sWhen, column);
            } else if (attributes.getValue("xfdop") != null) {
                String delimit = String.valueOf('\u001d');
                String sWhen = delimit + attributes.getValue("xfdop") + delimit + attributes.getValue("xfdarg1") + delimit + (attributes.getValue("xfdarg2") == null ? "" : attributes.getValue("xfdarg2"));
                if (this.groupMap.size() > 0) {
                    this.groupMap.get(this.groupMap.size() - 1).put(_name + sWhen, column);
                }
            } else if (this.groupMap.size() > 0) {
                this.groupMap.get(this.groupMap.size() - 1).put(_name, column);
            }
            return;
        }
        Vector<SqlColumn> tableColumns = this.dbTables.get(table);
        if (tableColumns == null) {
            tableColumns = new Vector();
            this.dbTables.put(table, tableColumns);
        }
        int offset = column.getOffset();
        int size = tableColumns.size();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.fine("XmlDatasetLoader.declareColumn(): offset=" + offset + ". size=" + size + ".");
        }
        if (size == 0) {
            tableColumns.addElement(column);
        } else {
            boolean inserted = false;
            for (int i = 0; i < size; ++i) {
                SqlColumn otherColumn = tableColumns.elementAt(i);
                if (offset >= otherColumn.getOffset()) continue;
                tableColumns.insertElementAt(column, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                tableColumns.addElement(column);
            }
        }
    }

    public static void main(String[] args) throws Throwable {
        String filename = "itable.xml";
        XmlDatasetLoader xl = new XmlDatasetLoader(filename);
        HashMap<String, Vector<SqlColumn>> tables = xl.loadToTable();
        Set<String> set = tables.keySet();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            System.out.println(it.next() + "   ");
        }
    }
}

