/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.api.ICallTarget;
import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.io.File;
import javax.swing.JOptionPane;

public class HelpSystem {
    public static final int ITEM_HELP = 0;
    public static final int HELP_CURSOR = 1;
    private static boolean initialized;
    private static ICallTarget helpProgram;
    private static Runnable helpProgramRunnable;

    private static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            String helpProgramName = RuntimeEnvironment.getGlobalParameter("HELP-PROGRAM");
            if (helpProgramName != null) {
                helpProgramName = helpProgramName.replace(File.separatorChar, '.');
                if ((helpProgramName = helpProgramName.replace('/', '.')).endsWith(".class")) {
                    helpProgramName = helpProgramName.substring(0, helpProgramName.length() - 6);
                } else if (helpProgramName.endsWith(".java")) {
                    helpProgramName = helpProgramName.substring(0, helpProgramName.length() - 5);
                }
                Object helpProgramObject = Class.forName(helpProgramName).newInstance();
                if (helpProgramObject != null) {
                    if (helpProgramObject instanceof ICallTarget) {
                        helpProgram = (ICallTarget)helpProgramObject;
                    } else if (helpProgramObject instanceof Runnable) {
                        helpProgramRunnable = (Runnable)helpProgramObject;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void itemHelp(AcceptEvent helpEvent, LComponent source) {
        HelpSystem.help(helpEvent, source, 0);
    }

    public static void helpCursor(AcceptEvent helpEvent, LComponent source) {
        HelpSystem.help(helpEvent, source, 1);
    }

    private static void help(AcceptEvent helpEvent, LComponent source, int type) {
        try {
            HelpSystem.init();
            if (helpProgram != null) {
                String helpString = source.getHelpString();
                Object[] param = new Object[]{new Integer(source.getHelpId()), new Integer(type), source, helpString != null ? helpString : " ", helpEvent};
                helpProgram.call(null, param);
            } else if (helpProgramRunnable != null) {
                helpProgramRunnable.run();
            } else {
                String helpString = null;
                if (source != null && (helpString = source.getHelpString()) != null) {
                    int messageType2 = 1;
                    String typeString = type == 0 ? "Item Help" : "Help Cursor";
                    JOptionPane.showMessageDialog(source, helpString, typeString, messageType2, null);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        helpProgram = null;
        helpProgramRunnable = null;
    }
}

