/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LBitmap;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;

public final class LBitmapIcon
implements Icon {
    private LBitmap bitmapReference;
    private int imageWidth;
    private int imageHeight;
    private int bitmapNumber;

    public String toString() {
        return "[LBitmapIcon: width=" + this.imageWidth + ", height=" + this.imageHeight + ", number " + this.bitmapNumber + " of " + this.bitmapReference + "]";
    }

    public LBitmapIcon(LBitmap copy, int bitmapNum, int bitmapWidth) {
        this.bitmapReference = copy;
        this.imageWidth = bitmapWidth;
        if (this.imageWidth <= 0) {
            this.imageWidth = copy.getIconWidth();
        }
        this.imageHeight = copy.getIconHeight();
        this.bitmapNumber = bitmapNum;
    }

    @Override
    public int getIconHeight() {
        return this.imageHeight;
    }

    @Override
    public int getIconWidth() {
        return this.imageWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Rectangle r = g.getClipBounds();
        g.clipRect(x, y, this.imageWidth, this.imageHeight);
        this.bitmapReference.paint(g, c, x, y, this.imageWidth, this.bitmapNumber);
        g.setClip(r);
    }
}

