/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.jfc.LCalendar;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.basic.BasicArrowButton;

public final class LCalendarField
extends LComponent
implements ActionListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DateFormat formatter1 = DateFormat.getDateInstance(3);
    private final DateFormat formatter2 = DateFormat.getDateInstance(2);
    private final DateFormat formatter3 = DateFormat.getDateInstance(1);
    private final DateFormat formatter4 = DateFormat.getDateInstance(0);
    private DateFormat formatter = this.formatter3;
    private BasicArrowButton calendarButton;
    private LCalendar calendar;
    private JPopupMenu popup;
    private JTextField field;
    private Calendar date;

    public void setFormat(int n) {
        switch (n) {
            case 1: {
                this.formatter = this.formatter1;
                break;
            }
            case 2: {
                this.formatter = this.formatter2;
                break;
            }
            case 3: {
                this.formatter = this.formatter3;
                break;
            }
            case 4: {
                this.formatter = this.formatter4;
                break;
            }
            default: {
                return;
            }
        }
        this.setField(this.date);
        this.repaint();
    }

    public int getFormat() {
        if (this.formatter == this.formatter1) {
            return 1;
        }
        if (this.formatter == this.formatter2) {
            return 2;
        }
        if (this.formatter == this.formatter3) {
            return 3;
        }
        if (this.formatter == this.formatter4) {
            return 4;
        }
        this.formatter = this.formatter3;
        return 3;
    }

    public Color getCellBackground() {
        return this.calendar.getCellBackground();
    }

    public int getCellBackgroundRGB() {
        return this.calendar.getCellBackgroundRGB();
    }

    public Color getCellForeground() {
        return this.calendar.getCellForeground();
    }

    public int getCellForegroundRGB() {
        return this.calendar.getCellForegroundRGB();
    }

    public Color getCellUnselected() {
        return this.calendar.getCellUnselected();
    }

    public void setCellBackground(Color c) {
        this.calendar.setCellBackground(c);
    }

    public void setCellBackgroundRGB(int rgb) {
        this.calendar.setCellBackgroundRGB(rgb);
    }

    public void setCellBackground(int color2) {
        this.calendar.setCellBackground(color2);
    }

    public void setCellForeground(Color c) {
        this.calendar.setCellForeground(c);
    }

    public void setCellForegroundRGB(int rgb) {
        this.calendar.setCellForegroundRGB(rgb);
    }

    public void setCellForeground(int color2) {
        this.calendar.setCellForeground(color2);
    }

    public void setCellUnselected(Color c) {
        this.calendar.setCellUnselected(c);
    }

    public void setCellUnselected(int color2) {
        this.calendar.setCellUnselected(color2);
    }

    public LCalendarField() {
        this(Calendar.getInstance());
    }

    public LCalendarField(Calendar date) {
        this.lines = 1.5;
        this.size = 16.0;
        this.setLayout(new BorderLayout());
        this.field = new JTextField();
        this.add("Center", this.field);
        this.field.setEditable(true);
        this.setBorder(this.field.getBorder());
        this.field.setBorder(null);
        this.calendarButton = new BasicArrowButton(5);
        this.add("East", this.calendarButton);
        this.calendar = new LCalendar(date, (ListSelectionModel)new DefaultListSelectionModel(), true, false);
        this.popup = new JPopupMenu();
        this.popup.add(this.calendar);
        this.setField(date);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.calendarButton) {
            this.field.requestFocus();
            this.getRootPane().setDefaultButton(null);
            if (!this.popup.isVisible()) {
                Dimension dim = this.calendarButton.getSize();
                this.calendar.setDate(this.date);
                this.popup.show(this.calendarButton, dim.width - this.popup.getPreferredSize().width, dim.height);
            } else {
                this.popup.setVisible(false);
                this.field.requestFocus();
            }
        } else if (source == this.field) {
            try {
                String userText = this.field.getText();
                Date d = this.formatter4.parse(userText.trim());
                this.date.setTime(d);
                this.setField(this.date);
                this.update();
            }
            catch (Exception settingDateFromField) {
                try {
                    String userText = this.field.getText();
                    Date d = this.formatter3.parse(userText.trim());
                    this.date.setTime(d);
                    this.setField(this.date);
                    this.update();
                }
                catch (Exception settingDateFromField2) {
                    try {
                        String userText = this.field.getText();
                        Date d = this.formatter2.parse(userText.trim());
                        this.date.setTime(d);
                        this.setField(this.date);
                        this.update();
                    }
                    catch (Exception settingDateFromField3) {
                        try {
                            String userText = this.field.getText();
                            Date d = this.formatter1.parse(userText.trim());
                            this.date.setTime(d);
                            this.setField(this.date);
                            this.update();
                        }
                        catch (Exception settingDateFromField4) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }
            }
        } else if (source == this.calendar) {
            this.setField(this.calendar.getDate());
            this.popup.setVisible(false);
            this.field.requestFocus();
            if (this.exceptionValue != 0) {
                this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
            } else if (this.terminationValue != 0) {
                this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
            } else {
                this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4, event));
            }
        }
    }

    private void setField(Calendar date) {
        this.date = date;
        this.field.setText(this.formatter.format(date.getTime()));
    }

    public Calendar getDate() {
        return this.calendar.getDate();
    }

    public void setDate(Calendar date) {
        this.calendar.setDate(date);
    }

    private void update() {
        this.field.setText(this.formatter.format(this.date.getTime()));
        this.calendar.setDate(this.date);
        this.calendar.repaint();
    }

    public void setDateFormat(DateFormat formatter) {
        this.formatter = formatter;
    }

    public int getDayOfMonth() {
        return this.date.get(5);
    }

    public int getDayOfWeek() {
        return this.date.get(7);
    }

    public int getDayOfWeekInMonth() {
        return this.date.get(8);
    }

    public int getDayOfYear() {
        return this.date.get(6);
    }

    public int getDstOffset() {
        return this.date.get(16);
    }

    public int getEra() {
        return this.date.get(0);
    }

    public int getMonth() {
        return this.date.get(2) + 1;
    }

    public int getWeekOfMonth() {
        return this.date.get(4);
    }

    public int getWeekOfYear() {
        return this.date.get(3);
    }

    public int getYear() {
        return this.date.get(1);
    }

    public int getZoneOffset() {
        return this.date.get(15);
    }

    public void setDayOfMonth(int val) {
        this.date.set(5, val);
        this.update();
    }

    public void setDayOfWeek(int val) {
        this.date.set(7, val);
        this.update();
    }

    public void setDayOfWeekInMonth(int val) {
        this.date.set(8, val);
        this.update();
    }

    public void setDayOfYear(int val) {
        this.date.set(6, val);
        this.update();
    }

    public void setDstOffset(int val) {
        this.date.set(16, val);
        this.update();
    }

    public void setEra(int val) {
        this.date.set(0, val);
        this.update();
    }

    public void setMonth(int val) {
        this.date.set(2, val - 1);
        this.update();
    }

    public void setWeekOfMonth(int val) {
        this.date.set(4, val);
        this.update();
    }

    public void setWeekOfYear(int val) {
        this.date.set(3, val);
        this.update();
    }

    public void setYear(int val) {
        this.date.set(1, val);
        this.update();
    }

    public void setZoneOffset(int val) {
        this.date.set(15, val);
        this.update();
    }

    public void nextMonth(boolean repaint) {
        this.calendar.nextMonth(repaint);
    }

    public void prevMonth(boolean repaint) {
        this.calendar.prevMonth(repaint);
    }

    public void nextYear(boolean repaint) {
        this.calendar.nextYear(repaint);
    }

    public void prevYear(boolean repaint) {
        this.calendar.prevYear(repaint);
    }

    @Override
    public Font getFont() {
        return this.field.getFont();
    }

    @Override
    public void setFont(Font f) {
        this.field.setFont(f);
        super.setFont(f);
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String text) {
        try {
            Date d = this.formatter4.parse(text.trim());
            this.date.setTime(d);
            this.setField(this.date);
            this.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addConstantListeners() {
        try {
            this.calendarButton.addActionListener(this);
            this.calendar.addActionListener(this);
            this.field.addActionListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.calendarButton.removeActionListener(this);
            this.calendar.removeActionListener(this);
            this.field.removeActionListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }
}

