/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LBitmapIcon;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

class LDynamicTreeNode
extends DefaultMutableTreeNode {
    static int lastIdentifier = 0;
    private int id;
    private Integer ID;
    private String hiddenData = "";
    private boolean alwaysParent = false;
    private int bitmapNumber = 0;
    private Icon bitmapIcon;

    public LDynamicTreeNode() {
        if (lastIdentifier < 0) {
            lastIdentifier = 0;
        }
        this.id = ++lastIdentifier;
        this.ID = new Integer(this.id);
    }

    public LDynamicTreeNode(String s) {
        super(s);
        if (lastIdentifier < 0) {
            lastIdentifier = 0;
        }
        this.id = ++lastIdentifier;
        this.ID = new Integer(this.id);
    }

    public LDynamicTreeNode(String s, int value) {
        super(s);
        this.id = value;
        this.ID = new Integer(this.id);
        this.alwaysParent = true;
    }

    public int getId() {
        return this.id;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setHiddenData(String value) {
        this.hiddenData = value;
    }

    public String getHiddenData() {
        return this.hiddenData;
    }

    public boolean getAlwaysParent() {
        return this.alwaysParent;
    }

    public void setAlwaysParent(boolean state) {
        this.alwaysParent = state;
    }

    public void addFirst(MutableTreeNode node) {
        this.insert(node, 0);
    }

    public void addLast(MutableTreeNode node) {
        if (node != null && node.getParent() == this) {
            this.insert(node, this.getChildCount() - 1);
        } else {
            this.insert(node, this.getChildCount());
        }
    }

    public void addSorted(MutableTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode mnode = (DefaultMutableTreeNode)node;
        String text = (String)mnode.getUserObject();
        DefaultMutableTreeNode comparison = null;
        String comparisonText = null;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            comparison = (DefaultMutableTreeNode)this.getChildAt(i);
            comparisonText = (String)comparison.getUserObject();
            if (comparisonText.compareTo(text) <= 0) continue;
            this.insert(node, i);
            return;
        }
        this.addLast(node);
    }

    @Override
    public boolean getAllowsChildren() {
        boolean val = false;
        if (!this.alwaysParent) {
            val = super.isLeaf();
        }
        return !val;
    }

    @Override
    public boolean isLeaf() {
        boolean val = false;
        if (!this.alwaysParent) {
            val = super.isLeaf();
        }
        return val;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (!(o instanceof LDynamicTreeNode)) {
            return result;
        }
        try {
            LDynamicTreeNode compare = (LDynamicTreeNode)o;
            return compare.id == this.id;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void setBitmapNumber(LBitmap bitmap, int value, int bitmapWidth) {
        this.bitmapNumber = value;
        this.bitmapIcon = value > 0 ? new LBitmapIcon(bitmap, value, bitmapWidth) : null;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public Icon getIcon() {
        return this.bitmapNumber > 0 ? this.bitmapIcon : null;
    }
}

