/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.api.IDatatype;
import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LSpinner;
import com.heirloomcomputing.ecs.jfc.SJTextArea;
import com.heirloomcomputing.ecs.jfc.SpinnerListener;
import com.heirloomcomputing.ecs.util.String2;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public final class LEntryField
extends LComponent
implements SpinnerListener,
FocusListener,
KeyListener,
ActionListener {
    private static final String PGM = "LEntryField";
    private static boolean EF_UPPER_WIDE = true;
    private static int EF_WIDE_SIZE = 5;
    private static int FONT_WIDE_SIZE_ADJUST = 4;
    private boolean blankWhenZero;
    private boolean focusListenersAdded;
    private SJTextArea textArea;
    private JScrollPane scrollPane;
    private Border originalBorder;
    private LSpinner spinnerControl;
    private Object[] multipleValues;
    private int valueLength;
    private boolean autospin;
    private boolean maxTextIsSet;
    private int maxLines;
    private int lastAction;
    private int selectionLength;
    private JFileChooser jFileChooser;
    private JButton browseButton;
    private String browseText = this.getResource("component.entry-field.browse", "Browse...");
    private boolean notified = false;
    private int minimumValue = 0;
    private int maximumValue = 0;
    private int horizontalAlignment = 2;

    public LEntryField() {
        this.textArea = new SJTextArea();
        this.spinnerControl = new LSpinner();
        this.spinnerControl.setVisible(false);
        this.scrollPane = new JScrollPane(this.textArea);
        super.setBackground(Color.blue);
        this.originalBorder = this.scrollPane.getBorder();
        this.textArea.setSelectOnFocus(true);
        this.textArea.setBorder(null);
        this.textArea.setWrapStyleWord(false);
        this.textArea.setLineWrap(false);
        this.textArea.setIncludeTabs(false);
        this.setIncludeReturn(false);
        this.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_NEVER);
        this.setHorizontalScrollBarPolicy(HORIZONTAL_SCROLLBAR_NEVER);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.spinnerControl, "East");
        this.lines = 1.0;
    }

    public void setBlinking() {
        this.setBlinking(true);
    }

    public void setBlinking(boolean state) {
        this.textArea.setBlinking(state);
    }

    public int getBlinking() {
        return this.textArea.getBlinking() ? 1 : 0;
    }

    public void setUnderline() {
        this.setUnderline(true);
    }

    public void setUnderline(boolean state) {
        this.textArea.setUnderline(state);
    }

    public int getUnderline() {
        return this.textArea.getUnderline() ? 1 : 0;
    }

    public void setJustified() {
        this.setJustified(true);
    }

    public void setJustified(boolean state) {
        if (state) {
            this.setRight();
        } else {
            this.setLeft();
        }
    }

    public int getJustified() {
        return this.isRight() ? 1 : 0;
    }

    public void setBlankWhenZero() {
        this.blankWhenZero = true;
    }

    public void setBlankWhenZero(boolean state) {
        this.blankWhenZero = state;
    }

    public int getBlankWhenZero() {
        return this.blankWhenZero ? 1 : 0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 37) {
            return;
        }
        if (keyCode == 39) {
            return;
        }
        if (keyCode == 36) {
            return;
        }
        if (keyCode == 35) {
            return;
        }
        if (event.getModifiers() == 0 && this.isUseReturn() && keyCode == 10) {
            return;
        }
        if (event.isControlDown()) {
            if (keyCode == 36) {
                return;
            }
            if (keyCode == 35) {
                return;
            }
        }
        if (this.isMultiline()) {
            if (keyCode == 38) {
                return;
            }
            if (keyCode == 40) {
                return;
            }
        }
        if (this.isUseTab() && keyCode == 9) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event == null) {
            return;
        }
        int code = event.getKeyCode();
        if (code != 0) {
            if (!this.isUseTab() && code == 9) {
                return;
            }
            if (code == 38) {
                return;
            }
            if (code == 40) {
                return;
            }
            if (code == 36 && event.isControlDown()) {
                return;
            }
            if (code == 35 && event.isControlDown()) {
                return;
            }
        } else {
            char c = event.getKeyChar();
            if (!this.isUseTab() && c == '\t') {
                return;
            }
        }
        if (this.isNotifyChange() && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4100, event, this.textArea.getCaretPosition() + 1))) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConstantListeners() {
        block5: {
            try {
                SJTextArea sJTextArea = this.textArea;
                synchronized (sJTextArea) {
                    this.textArea.addFocusListener(this);
                    this.focusListenersAdded = true;
                    this.spinnerControl.addSpinnerListener(this);
                    this.textArea.addKeyListener(this);
                }
            }
            catch (Throwable t) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch(Throwable t). ");
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConstantListeners() {
        block5: {
            try {
                SJTextArea sJTextArea = this.textArea;
                synchronized (sJTextArea) {
                    this.focusListenersAdded = false;
                    this.textArea.removeFocusListener(this);
                    this.spinnerControl.removeSpinnerListener(this);
                    this.textArea.removeKeyListener(this);
                }
            }
            catch (Throwable t) {
                if (!LogSetup.IS_LOGGING_INFO) break block5;
                LogSetup.LOGGER.info("catch(Throwable t). ");
                t.printStackTrace();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
        this.reformatData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        SJTextArea sJTextArea = this.textArea;
        synchronized (sJTextArea) {
            if (this.notified) {
                this.removeNotify();
            } else {
                this.notified = true;
            }
            super.addNotify();
            if (this.lines <= 1.0 && !this.maxTextIsSet) {
                this.setMaxText((int)Math.ceil(this.size));
            }
            this.addConstantListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        SJTextArea sJTextArea = this.textArea;
        synchronized (sJTextArea) {
            if (this.notified) {
                this.removeConstantListeners();
                super.removeNotify();
                this.notified = false;
            }
        }
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestChildFocus() {
        SJTextArea sJTextArea = this.textArea;
        synchronized (sJTextArea) {
            if (this.focusListenersAdded) {
                this.textArea.removeFocusListener(this);
                this.textArea.requestFocus();
                this.textArea.addFocusListener(this);
            } else {
                this.textArea.requestFocus();
            }
        }
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.textArea.hasFocus();
    }

    @Override
    protected int getDefaultUnitHeight(Font f) {
        int defaultHeight = LEntryField.getDefaultHeight(f);
        this.adjustLines = defaultHeight / 2;
        return defaultHeight;
    }

    @Override
    protected int getDefaultUnitHeight(Font f, FontMetrics fm) {
        int defaultHeight = LEntryField.getDefaultHeight(f, fm);
        this.adjustLines = defaultHeight / 2;
        return defaultHeight;
    }

    @Override
    public int getControlType() {
        return 2;
    }

    @Override
    public void setUsing(Variable v) {
        if (v instanceof Numeric) {
            this.setNumeric();
        }
        super.setUsing(v);
    }

    @Override
    public void setTo(Variable v) {
        if (v instanceof Numeric) {
            this.setNumeric();
        }
        super.setTo(v);
    }

    public void setIncludeReturn(boolean state) {
        this.textArea.setIncludeReturn(state);
    }

    public boolean isIncludeReturn() {
        return this.textArea.isIncludeReturn();
    }

    public void setLineWrap(boolean state) {
        this.textArea.setLineWrap(state);
    }

    public boolean isLineWrap() {
        return this.getLineWrap();
    }

    public boolean getLineWrap() {
        return this.textArea.getLineWrap();
    }

    @Override
    public void setKey(char c) {
        this.textArea.setFocusAccelerator(c);
    }

    @Override
    public void setCleanTitle(String s) {
        this.textArea.setToolTipText(s);
        this.scrollPane.setToolTipText(s);
    }

    public void setVerticalScrollBarPolicy(int value) {
        this.scrollPane.setVerticalScrollBarPolicy(value);
    }

    public int getVerticalScrollBarPolicy() {
        return this.scrollPane.getVerticalScrollBarPolicy();
    }

    public void setHorizontalScrollBarPolicy(int value) {
        this.scrollPane.setHorizontalScrollBarPolicy(value);
    }

    public int getHorizontalScrollBarPolicy() {
        return this.scrollPane.getHorizontalScrollBarPolicy();
    }

    @Override
    protected void updateValue() {
        int length;
        String func = "LEntryField.updateValue(): ";
        if (this.multipleValues == null) {
            super.updateValue();
            return;
        }
        String text = this.textArea.getText();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer("LEntryField.updateValue(): text=" + text + ".");
        }
        if ((length = this.multipleValues.length) <= 1) {
            return;
        }
        if (this.multipleValues[1] instanceof IDatatype) {
            int index;
            int start = index = -1;
            IDatatype indi = null;
            for (int i = 1; i < length; ++i) {
                block8: {
                    try {
                        start = index + 1;
                        index = text.indexOf(10, start);
                        indi = (IDatatype)this.multipleValues[i];
                        String part = null;
                        part = index >= 0 ? text.substring(start, index) : text.substring(start);
                        indi.fromText(part);
                    }
                    catch (Exception individualLineException) {
                        if (!LogSetup.IS_LOGGING_INFO) break block8;
                        LogSetup.LOGGER.info("catch(Exception individualLineException). ");
                        individualLineException.printStackTrace();
                    }
                }
                if (index < 0) break;
            }
            for (int clear = i + 1; clear < length; ++clear) {
                indi = (IDatatype)this.multipleValues[clear];
                indi.fromText(" ");
            }
        }
    }

    @Override
    public void setMultipleValues(String[] data) {
        this.setValue(data);
    }

    @Override
    public void setMultipleValues(Object[] data) {
        this.setValue(data);
    }

    @Override
    public void setMultipleValues(IDatatype[] data) {
        this.setValue(data);
    }

    public void setValue(Object[] multipleValues) {
        String func = ".setValue(Object[] multipleValues): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setValue(Object[] multipleValues): Object[]=" + multipleValues + ".");
        }
        if (multipleValues == null) {
            return;
        }
        this.multipleValues = multipleValues;
        int length = multipleValues.length;
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < length; ++i) {
            if (multipleValues[i] != null) {
                String value = String.valueOf(multipleValues[i]).trim();
                result.append(value).append('\n');
                continue;
            }
            result.append('\n');
        }
        this.setCleanValue(result.toString());
    }

    public void setValue(Variable[] multipleValues) {
        String func = ".setValue(Variable[] multipleValues): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setValue(Variable[] multipleValues): Variable[]=" + multipleValues + ".");
        }
        if (multipleValues == null) {
            return;
        }
        this.multipleValues = multipleValues;
        int length = multipleValues.length;
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < length; ++i) {
            if (multipleValues[i] != null) {
                String value = multipleValues[i].toText().trim();
                result.append(value).append('\n');
                continue;
            }
            result.append('\n');
        }
        this.setCleanValue(result.toString());
    }

    public void setValue(IDatatype[] multipleValues) {
        String func = ".setValue(IDatatype[] multipleValues): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setValue(IDatatype[] multipleValues): IDatatype[]=" + multipleValues + ".");
        }
        if (multipleValues == null) {
            return;
        }
        this.multipleValues = multipleValues;
        int length = multipleValues.length;
        StringBuffer result = new StringBuffer();
        for (int i = 1; i < length; ++i) {
            if (multipleValues[i] != null) {
                String value = multipleValues[i].toText().trim();
                result.append(value).append('\n');
                continue;
            }
            result.append('\n');
        }
        this.setCleanValue(result.toString());
    }

    public void setValue(Object value) {
        String func = ".setValue(Object value): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setValue(Object value): Object value=" + value + ".");
        }
        if (value instanceof Object[]) {
            this.setValue((Object[])value);
        } else if (value instanceof IDatatype[]) {
            this.setValue((IDatatype[])value);
        } else if (value instanceof String[]) {
            this.setValue((String[])value);
        } else {
            this.setValue(String.valueOf(value));
        }
    }

    @Override
    public void setValue(String value) {
        String func = ".setValue(String value): ";
        this.multipleValues = null;
        String value2 = null;
        Variable picVariable = null;
        if (this.getPicture() == null) {
            value2 = value;
        } else {
            picVariable = new Variable(this.getPicture(), value, true);
            value2 = picVariable.toText();
            if (picVariable.isTypeNumericEdited()) {
                this.setNumericEdited(true);
            }
            if (picVariable.getDecimal() == ',') {
                this.setDecimalIsComma(true);
            }
        }
        if (value2 != null) {
            this.valueLength = value2.length();
        }
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setValue(String value): Value to be displayed. value=" + value + ". value2=" + String2.makeDisplayable(value2) + ". getPicture()=" + this.getPicture() + ". picVariable=" + (picVariable == null ? "NULL" : String2.makeDisplayable(picVariable.toDebugString2())));
        }
        String cleanValue = this.setCleanValue(value2);
        super.setValue(cleanValue);
    }

    public String setCleanValue(String value) {
        String func = ".setCleanValue(String value): ";
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".setCleanValue(String value): Trim blanks for display. value=" + value + ".");
        }
        value = value.trim();
        if (this.blankWhenZero) {
            boolean blank = true;
            int c = 48;
            for (int i = 0; i < value.length(); ++i) {
                c = value.charAt(i);
                if (c == 48 || c == 46 || c == 32 || c == 45) continue;
                blank = false;
                break;
            }
            if (blank) {
                value = "";
            }
        }
        this.textArea.setText(value);
        return value;
    }

    public void reformatData() {
        String value = this.textArea.getText();
        this.setCleanValue(value);
    }

    @Override
    public String getValue() {
        String func = ".getValue(): ";
        String text = this.textArea.getText();
        if (LogSetup.IS_LOGGING) {
            LogSetup.LOGGER.finer(".getValue(): text=" + text + ". locale=" + this.textArea.getLocale());
        }
        if (this.multipleValues == null) {
            return text;
        }
        int length = this.multipleValues.length;
        if (length <= 1) {
            return text;
        }
        if (this.multipleValues[1] instanceof Variable) {
            int index;
            int start = index = -1;
            Variable indi = null;
            for (int i = 1; i < length; ++i) {
                try {
                    start = index + 1;
                    index = text.indexOf(10, start);
                    indi = (Variable)this.multipleValues[i];
                    if (index >= 0) {
                        indi.moveNational(text.substring(start, index));
                        continue;
                    }
                    indi.moveNational(text.substring(start));
                    continue;
                }
                catch (Exception individualLineException) {
                    if (!LogSetup.IS_LOGGING_INFO) continue;
                    LogSetup.LOGGER.info("catch(Exception individualLineException). ");
                    individualLineException.printStackTrace();
                }
            }
            return null;
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reconfigureEnvironment() {
        String s;
        block13: {
            block12: {
                try {
                    s = LEntryField.getParameter("EF-UPPER-WIDE");
                    if (s != null && s.length() > 0) {
                        switch (s.charAt(0)) {
                            case '1': 
                            case 'T': 
                            case 'Y': 
                            case 't': 
                            case 'y': {
                                EF_UPPER_WIDE = true;
                                break;
                            }
                            case '0': 
                            case 'F': 
                            case 'N': 
                            case 'f': 
                            case 'n': {
                                EF_UPPER_WIDE = false;
                                break;
                            }
                            default: {
                                if (Integer.parseInt(s.trim()) == 0) break;
                                EF_UPPER_WIDE = true;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block12;
                    LogSetup.LOGGER.info("catch(Exception e) 1st. ");
                    e.printStackTrace();
                }
            }
            try {
                s = LEntryField.getParameter("EF-WIDE-SIZE");
                if (s != null) {
                    EF_WIDE_SIZE = Integer.parseInt(s.trim());
                }
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block13;
                LogSetup.LOGGER.info("catch(Exception e) 2nd. ");
                e.printStackTrace();
            }
        }
        try {
            s = LEntryField.getParameter("FONT-WIDE-SIZE-ADJUST");
            if (s == null) return;
            FONT_WIDE_SIZE_ADJUST = Integer.parseInt(s.trim());
            return;
        }
        catch (Exception e) {
            if (!LogSetup.IS_LOGGING_INFO) return;
            LogSetup.LOGGER.info("catch(Exception e) 3rd. ");
            e.printStackTrace();
        }
    }

    @Override
    public int getUnitWidth() {
        if (EF_UPPER_WIDE && this.isUpper()) {
            return this.wideWidth + FONT_WIDE_SIZE_ADJUST;
        }
        if (this.size <= (double)EF_WIDE_SIZE) {
            return this.wideWidth + FONT_WIDE_SIZE_ADJUST;
        }
        return super.getUnitWidth();
    }

    @Override
    protected void initializeUnits(Font f) {
        super.initializeUnits(f);
        this.minimumWidth = this.maxWidthChar;
    }

    @Override
    public void recalculateSizes() {
        super.recalculateSizes();
        this.scrollPane.revalidate();
    }

    @Override
    public void determineDefaultSize() {
        if (this.size > 0.0) {
            return;
        }
        if (this.size <= 0.0) {
            this.size = this.valueLength;
            if (this.size > 0.0) {
                this.recalculateSizes();
                return;
            }
        }
        if (this.size <= 0.0) {
            this.size = 8.0;
        }
        this.recalculateSizes();
    }

    public void setMask(String s) {
        this.textArea.setMask(s);
    }

    public String getMask() {
        return this.textArea.getMask();
    }

    public boolean isLeft() {
        return this.isStyle(1);
    }

    public int getLeft() {
        return this.isLeft() ? 1 : 0;
    }

    public void setLeft() {
        this.setStyleOn(1, 6);
    }

    public void setLeft(boolean state) {
        this.setStyle(1, state, 6);
    }

    public boolean isRight() {
        return this.isStyle(2);
    }

    public int getRight() {
        return this.isRight() ? 1 : 0;
    }

    public void setRight() {
        this.setStyleOn(2, 5);
    }

    public void setRight(boolean state) {
        this.setStyle(2, state, 5);
    }

    public boolean isCenter() {
        return this.isStyle(4);
    }

    public int getCenter() {
        return this.isCenter() ? 1 : 0;
    }

    public void setCenter() {
        this.setStyleOn(4, 3);
    }

    public void setCenter(boolean state) {
        this.setStyle(4, state, 3);
    }

    public boolean isBox() {
        return this.isStyle(8);
    }

    public int getBox() {
        return this.isBox() ? 1 : 0;
    }

    public void setBox() {
        this.setStyleOn(8, 16);
    }

    public void setBox(boolean state) {
        this.setStyle(8, state, 16);
    }

    public boolean isNoBox() {
        return this.isStyle(16);
    }

    public int getNoBox() {
        return this.isNoBox() ? 1 : 0;
    }

    public void setNoBox() {
        this.setStyleOn(16, 8);
    }

    public void setNoBox(boolean state) {
        this.setStyle(16, state, 8);
    }

    public boolean isMultiline() {
        return this.isStyle(32);
    }

    public int getMultiline() {
        return this.isMultiline() ? 1 : 0;
    }

    public void setMultiline() {
        this.setStyleOn(32);
    }

    public void setMultiline(boolean state) {
        this.setStyle(32, state);
    }

    public boolean isVscroll() {
        return this.isStyle(96);
    }

    public int getVscroll() {
        return this.isVscroll() ? 1 : 0;
    }

    public void setVscroll() {
        this.setStyleOn(96);
    }

    public void setVscroll(boolean state) {
        this.setStyle(96, state);
    }

    public boolean isVscrollBar() {
        return this.isStyle(224);
    }

    public int getVscrollBar() {
        return this.isVscrollBar() ? 1 : 0;
    }

    public void setVscrollBar() {
        this.setStyleOn(224);
    }

    public void setVscrollBar(boolean state) {
        this.setStyle(224, state);
    }

    public boolean isUseReturn() {
        return this.isStyle(256);
    }

    public int getUseReturn() {
        return this.isUseReturn() ? 1 : 0;
    }

    public void setUseReturn() {
        this.setStyleOn(256);
    }

    public void setUseReturn(boolean state) {
        this.setStyle(256, state);
    }

    public boolean isUseTab() {
        return this.isStyle(512);
    }

    public int getUseTab() {
        return this.isUseTab() ? 1 : 0;
    }

    public void setUseTab() {
        this.setStyleOn(512);
    }

    public void setUseTab(boolean state) {
        this.setStyle(512, state);
    }

    @Override
    public boolean isUpper() {
        return this.isStyle(1024);
    }

    public int getUpper() {
        return this.isUpper() ? 1 : 0;
    }

    public void setUpper() {
        this.setStyleOn(1024);
    }

    public void setUpper(boolean state) {
        this.setStyle(1024, state);
    }

    @Override
    public boolean isLower() {
        return this.isStyle(2048);
    }

    public int getLower() {
        return this.isLower() ? 1 : 0;
    }

    public void setLower() {
        this.setStyleOn(2048);
    }

    public void setLower(boolean state) {
        this.setStyle(2048, state);
    }

    public boolean isNoAutosel() {
        return this.isStyle(4096);
    }

    public int getNoAutosel() {
        return this.isNoAutosel() ? 1 : 0;
    }

    public void setNoAutosel() {
        this.setStyleOn(4096);
    }

    public void setNoAutosel(boolean state) {
        this.setStyle(4096, state);
    }

    public boolean isReadOnly() {
        return this.isStyle(8192);
    }

    public int getReadOnly() {
        return this.isReadOnly() ? 1 : 0;
    }

    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Override
    public boolean isAcceptable() {
        return !this.isReadOnly() && this.isEnabled() && this.isVisible();
    }

    public void setReadOnly() {
        this.setStyleOn(8192);
    }

    public void setReadOnly(boolean state) {
        this.setStyle(8192, state);
    }

    public boolean isAutoterminate() {
        return this.isStyle(16384);
    }

    public int getAutoterminate() {
        return this.isAutoterminate() ? 1 : 0;
    }

    public void setAutoterminate() {
        this.setStyleOn(16384);
    }

    public void setAutoterminate(boolean state) {
        this.setStyle(16384, state);
    }

    public boolean isAuto() {
        return this.isStyle(16384);
    }

    public int getAuto() {
        return this.isAuto() ? 1 : 0;
    }

    public void setAuto() {
        this.setStyleOn(16384);
    }

    public void setAuto(boolean state) {
        this.setStyle(16384, state);
    }

    public boolean isNotifyChange() {
        return this.isStyle(32768);
    }

    public int getNotifyChange() {
        return this.isNotifyChange() ? 1 : 0;
    }

    public void setNotifyChange() {
        this.setStyleOn(32768);
    }

    public void setNotifyChange(boolean state) {
        this.setStyle(32768, state);
    }

    public void setRequired() {
        this.setRequired(true);
    }

    public void setRequired(boolean state) {
        this.textArea.setRequired(state);
    }

    public int getRequired() {
        return this.textArea.getRequired() ? 1 : 0;
    }

    public void setReverse() {
        this.setReverse(true);
    }

    public void setReverse(boolean state) {
        this.textArea.setInverse(state);
    }

    public int getReverse() {
        return this.textArea.getInverse() ? 1 : 0;
    }

    public void setWordWrap() {
        this.setWordWrap(true);
    }

    public void setWordWrap(boolean state) {
        block2: {
            try {
                this.textArea.setWordWrap(state);
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
    }

    public int getWordWrap() {
        try {
            boolean wordWrap = this.textArea.getLineWrap() && this.textArea.getWrapStyleWord();
            return wordWrap ? 1 : 0;
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
            return 0;
        }
    }

    public boolean isSecure() {
        return this.isStyle(65536);
    }

    public int getSecure() {
        return this.isSecure() ? 1 : 0;
    }

    public void setSecure() {
        this.setStyleOn(65536);
    }

    public void setSecure(boolean state) {
        this.setStyle(65536, state);
    }

    public boolean isNumeric() {
        return this.isStyle(131072);
    }

    public int getNumeric() {
        return this.isNumeric() ? 1 : 0;
    }

    public void setNumeric() {
        this.setStyleOn(131072);
    }

    public void setNumeric(boolean state) {
        this.setStyle(131072, state);
    }

    public boolean isSpinner() {
        return this.isStyle(262144);
    }

    public int getSpinner() {
        return this.isSpinner() ? 1 : 0;
    }

    public void setSpinner() {
        this.setStyleOn(262144);
    }

    public void setSpinner(boolean state) {
        this.setStyle(262144, state);
    }

    public boolean isAutoSpin() {
        return this.isStyle(262208);
    }

    public int getAutoSpin() {
        return this.isAutoSpin() ? 1 : 0;
    }

    public void setAutoSpin() {
        this.setStyleOn(262208);
    }

    public void setAutoSpin(boolean state) {
        this.setStyle(262208, state);
    }

    private char getSecureChar() {
        String temp = LEntryField.getParameter("SECURE-CHAR");
        if (temp == null || temp.length() < 1) {
            return '*';
        }
        return temp.charAt(0);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 0x40000) == 262144) {
            this.spinnerControl.setVisible((mask & 0x40000) == 262144);
        }
        boolean bl = this.autospin = (mask & 0x40040) == 262208;
        if ((change & 7) != 0) {
            if ((mask & 4) == 4) {
                this.setHorizontalAlignment(0);
            } else if ((mask & 2) == 2) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        }
        if ((change & 0x2000018) != 0) {
            if ((mask & 0x2000000) == 0x2000000) {
                this.scrollPane.setBorder(new BevelBorder(1));
            } else if ((mask & 0x10) == 16) {
                this.scrollPane.setBorder(null);
            } else {
                this.scrollPane.setBorder(this.originalBorder);
            }
        }
        if ((change & 0x20000) != 0) {
            this.textArea.setNumericsOnly((mask & 0x20000) == 131072);
        }
        if ((change & 0x10000) != 0) {
            this.textArea.setPasswordChar((mask & 0x10000) == 65536 ? this.getSecureChar() : (char)'\u0000');
        }
        if ((change & 0x2000) != 0) {
            this.textArea.setEditable((mask & 0x2000) != 8192);
        }
        if ((change & 0x400) != 0) {
            this.textArea.setForceUppercase((mask & 0x400) == 1024);
        }
        if ((change & 0x800) != 0) {
            this.textArea.setForceLowercase((mask & 0x800) == 2048);
        }
        if ((mask & 0x40000) != 0) {
            this.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_NEVER);
        } else if ((change & 0x400C0) != 0) {
            if ((mask & 0x80) == 128) {
                this.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_ALWAYS);
            } else {
                this.setVerticalScrollBarPolicy(VERTICAL_SCROLLBAR_NEVER);
            }
            if (((change & 0x40) != 0 || (change & 0x80) != 0) && (this.style & 0x20) == 0) {
                this.style |= 0x20;
                change ^= 0x20;
            }
        }
        if ((change & 0x4000) == 16384) {
            boolean state = (mask & 0x4000) == 16384;
            this.textArea.setAuto(state);
        }
        if ((change & 0x1000) == 4096) {
            this.textArea.setSelectOnFocus((mask & 0x1000) != 4096);
        }
        if ((change & 0x20) == 32) {
            this.textArea.setLineWrap((mask & 0x20) == 32);
        }
        if ((change & 0x200) == 512) {
            this.textArea.setIncludeTabs((mask & 0x200) == 512);
        }
        if ((change & 0x100) == 256) {
            this.setIncludeReturn((mask & 0x100) == 256);
        }
        super.setStyle(mask);
        this.revalidateAndDisplay();
    }

    @Override
    public void setLines(double value) {
        super.setLines(value);
        if (value >= 2.0) {
            this.setMultiline();
        }
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 3: {
                this.setMaxText(this.getInt(property));
                break;
            }
            case 4: {
                this.setMaxLines(this.getInt(property));
                break;
            }
            case 5: {
                this.setMinVal(this.getInt(property));
                break;
            }
            case 6: {
                this.setMaxVal(this.getInt(property));
                break;
            }
            case 7: {
                this.setAutoDecimal(this.getInt(property));
                break;
            }
            case 8: {
                this.setCursorRow(this.getInt(property));
                break;
            }
            case 4096: {
                this.setCursorPosition(this.getInt(property));
                break;
            }
            case 4098: {
                this.setAction(this.getInt(property));
                break;
            }
            case 4099: {
                this.setSelectionText(this.getString(property));
                break;
            }
            case 4100: {
                this.setCursorCol(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 3: {
                return String.valueOf(this.getMaxText());
            }
            case 4: {
                return String.valueOf(this.getMaxLines());
            }
            case 5: {
                return String.valueOf(this.getMinVal());
            }
            case 6: {
                return String.valueOf(this.getMaxVal());
            }
            case 7: {
                return String.valueOf(this.getAutoDecimal());
            }
            case 8: {
                return String.valueOf(this.getCursorRow());
            }
            case 4096: {
                return String.valueOf(this.getCursorPosition());
            }
            case 4098: {
                return String.valueOf(this.getAction());
            }
            case 4099: {
                return this.getSelectionText();
            }
            case 4100: {
                return String.valueOf(this.getCursorCol());
            }
        }
        return super.getProperty(number);
    }

    @Override
    public void setEnabled(boolean state) {
        this.textArea.setEnabled(state);
        super.setEnabled(state);
    }

    public void setMinVal(int value) {
        this.minimumValue = value;
        this.textArea.setMinimumValue(value);
    }

    public int getMinVal() {
        return this.minimumValue;
    }

    public void setMaxVal(int value) {
        this.maximumValue = value;
        this.textArea.setMaximumValue(value);
    }

    public int getMaxVal() {
        return this.maximumValue;
    }

    @Override
    public void spinnerIncrease() {
        block9: {
            if (this.listenersAdded && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16416, null))) {
                return;
            }
            if (this.autospin) {
                try {
                    String s = this.textArea.getText();
                    if (s != null) {
                        s = s.trim();
                        int value = Integer.parseInt(s);
                        ++value;
                        if (this.minimumValue != this.maximumValue) {
                            if (value > this.maximumValue) {
                                value = this.maximumValue;
                            } else if (value < this.minimumValue) {
                                value = this.minimumValue;
                            }
                        }
                        this.textArea.setText(String.valueOf(value));
                    }
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block9;
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void spinnerDecrease() {
        block9: {
            if (this.listenersAdded && this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16417, null))) {
                return;
            }
            if (this.autospin) {
                try {
                    String s = this.textArea.getText();
                    if (s != null) {
                        s = s.trim();
                        int value = Integer.parseInt(s);
                        --value;
                        if (this.minimumValue != this.maximumValue) {
                            if (value > this.maximumValue) {
                                value = this.maximumValue;
                            } else if (value < this.minimumValue) {
                                value = this.minimumValue;
                            }
                        }
                        this.textArea.setText(String.valueOf(value));
                    }
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block9;
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
            }
        }
    }

    public void setMaxText(int value) {
        this.maxTextIsSet = true;
        this.setMaxTextInternal(value);
    }

    private void setMaxTextInternal(int value) {
        if (value > 0) {
            this.textArea.setDataBufferLength(value);
        } else {
            this.textArea.setDataBufferLength(-1);
        }
    }

    public int getMaxText() {
        return this.textArea.getDataBufferLength();
    }

    public void setMaxLines(int value) {
        this.maxLines = value;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setCursorRow(int value) {
        block2: {
            try {
                int cursor = this.textArea.getCaretPosition();
                int row = cursor / (int)this.size;
                int col = cursor - row * (int)this.size;
                row = value;
                cursor = row * (int)this.size + col;
                this.textArea.setCaretPosition(cursor);
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
    }

    public int getCursorRow() {
        try {
            int cursor = this.textArea.getCaretPosition();
            int row = cursor / (int)this.size;
            return row;
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
            return 0;
        }
    }

    public void setCursorCol(int value) {
        block2: {
            try {
                int cursor = this.textArea.getCaretPosition();
                int row = cursor / (int)this.size;
                int col = cursor - row * (int)this.size;
                col = value - 1;
                cursor = row * (int)this.size + col;
                this.textArea.setCaretPosition(cursor);
            }
            catch (Exception e) {
                if (!LogSetup.IS_LOGGING_INFO) break block2;
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
        }
    }

    public int getCursorCol() {
        try {
            int cursor = this.textArea.getCaretPosition();
            int row = cursor / (int)this.size;
            int col = cursor - row * (int)this.size;
            return col + 1;
        }
        catch (Exception e) {
            if (LogSetup.IS_LOGGING_INFO) {
                LogSetup.LOGGER.info("catch(Exception e). ");
                e.printStackTrace();
            }
            return 0;
        }
    }

    public void setCursorPosition(int value) {
        this.textArea.setCaretPosition(value);
    }

    public int getCursorPosition() {
        return this.textArea.getCaretPosition();
    }

    public void setAction(int value) {
        this.lastAction = value;
        switch (this.lastAction) {
            case 1: {
                this.doCut();
                break;
            }
            case 2: {
                this.doCopy();
                break;
            }
            case 3: {
                this.doPaste();
                break;
            }
            case 4: {
                this.doDelete();
                break;
            }
            case 5: {
                this.doUndo();
                break;
            }
            case 6: {
                this.doSelect();
            }
        }
    }

    public int getAction() {
        return this.lastAction;
    }

    public void doCut() {
        this.textArea.cut();
    }

    public void doCopy() {
        this.textArea.copy();
    }

    public void doPaste() {
        this.textArea.paste();
    }

    public void doDelete() {
        this.textArea.delete();
    }

    public void doUndo() {
    }

    public void doSelect() {
        this.textArea.selectAll();
    }

    public void setAutoDecimal(int value) {
        this.setStyleOn(16384);
        this.textArea.setAutoDecimal(value);
    }

    public int getAutoDecimal() {
        return this.textArea.getAutoDecimal();
    }

    public int getLength() {
        return this.selectionLength >= 0 ? this.selectionLength : -this.selectionLength;
    }

    public void setLength(int n) {
        this.selectionLength = -n;
    }

    public void setSelectionText(String value) {
        if (value == null) {
            value = "";
        }
        if (this.selectionLength < 0) {
            String substring;
            block5: {
                substring = value;
                try {
                    substring = value.substring(0, -this.selectionLength);
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block5;
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
            }
            this.textArea.replaceSelection(substring);
        } else {
            this.textArea.replaceSelection(value);
        }
    }

    public String getSelectionText() {
        String text = this.textArea.getSelectedText();
        this.selectionLength = text.length();
        return text;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.textArea.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.textArea.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.textArea.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        this.textArea.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.textArea.setForeground(c);
        super.setForeground(c);
    }

    public void setHorizontalAlignment(int value) {
        this.horizontalAlignment = value;
        this.textArea.setHorizontalAlignment(value);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @Override
    public void setOpaque(boolean state) {
        this.textArea.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.textArea.setFont(f);
    }

    public static Dimension getDefaultCellSize() {
        return LEntryField.getDefaultCellSize(Handle.DEFAULT_FONT);
    }

    public static Dimension getDefaultCellSize(int h) {
        return LEntryField.getDefaultCellSize(Handle.getHandle(h));
    }

    public static Dimension getDefaultCellSize(Handle h) {
        return LEntryField.getDefaultCellSize(h.getFont());
    }

    public static Dimension getDefaultCellSize(Font f) {
        FontMetrics fm = Utils.getFontMetrics(f);
        int size = (int)((double)fm.getHeight() * 1.5);
        int width = fm.charWidth('0');
        return new Dimension(width, size);
    }

    private JFileChooser getJFileChooser() {
        if (this.jFileChooser == null) {
            block3: {
                this.jFileChooser = new JFileChooser();
                this.jFileChooser.setMultiSelectionEnabled(false);
                this.browseButton = new JButton(this.browseText);
                try {
                    this.spinnerControl.setVisible(false);
                    this.remove(this.spinnerControl);
                }
                catch (Exception e) {
                    if (!LogSetup.IS_LOGGING_INFO) break block3;
                    LogSetup.LOGGER.info("catch(Exception e). ");
                    e.printStackTrace();
                }
            }
            this.browseButton.setVisible(true);
            this.browseButton.addActionListener(this);
            this.add((Component)this.browseButton, "East");
            this.repaint();
        }
        return this.jFileChooser;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.browseButton != null && event.getSource() == this.browseButton) {
            this.browseOpen();
        }
    }

    private void browseOpen() {
        int result = 1;
        switch (this.getJFileChooser().getDialogType()) {
            case 0: {
                result = this.getJFileChooser().showOpenDialog(this);
                break;
            }
            case 1: {
                result = this.getJFileChooser().showSaveDialog(this);
            }
        }
        switch (result) {
            case 1: {
                break;
            }
            case 0: {
                File f = this.getJFileChooser().getSelectedFile();
                if (f == null) break;
                this.setCleanValue(f.toString());
            }
        }
    }

    public void setOpenDialog() {
        this.getJFileChooser().setDialogType(0);
    }

    public void setSaveDialog() {
        this.getJFileChooser().setDialogType(1);
    }

    public void setFilenameField() {
        this.getJFileChooser().setFileSelectionMode(0);
    }

    public void setDirectoryField() {
        this.getJFileChooser().setFileSelectionMode(1);
    }

    public void setFilenameAndDirectoryField() {
        this.getJFileChooser().setFileSelectionMode(2);
    }

    public void setCurrentDirectory(String dirname) {
        this.getJFileChooser().setCurrentDirectory(new File(dirname));
    }

    public String getCurrentDirectory() {
        return this.getJFileChooser().getCurrentDirectory().toString();
    }

    public void setApproveButtonText(String text) {
        this.getJFileChooser().setApproveButtonText(text);
    }

    public String getApproveButtonText() {
        return this.getJFileChooser().getApproveButtonText();
    }

    public void setApproveButtonMnemonic(String mnemonic) {
        char c = '\u0000';
        if (mnemonic != null && (mnemonic = mnemonic.trim()).length() > 0) {
            c = mnemonic.charAt(0);
        }
        if (c != '\u0000') {
            this.getJFileChooser().setApproveButtonMnemonic(c);
        }
    }

    public String getApproveButtonMnemonic() {
        return String.valueOf((char)this.getJFileChooser().getApproveButtonMnemonic());
    }

    public void setApproveButtonToolTipText(String text) {
        this.getJFileChooser().setApproveButtonToolTipText(text);
    }

    public String getApproveButtonToolTipText() {
        return this.getJFileChooser().getApproveButtonToolTipText();
    }

    public void setDialogTitle(String title) {
        this.getJFileChooser().setDialogTitle(title);
    }

    public String getDialogTitle() {
        return this.getJFileChooser().getDialogTitle();
    }

    public void setBrowseText(String browseText) {
        if (this.browseButton != null) {
            this.browseButton.setText(browseText);
        }
        this.browseText = browseText;
    }

    public String getBrowseText() {
        if (this.browseButton != null) {
            return this.browseButton.getText();
        }
        return this.browseText;
    }

    static {
        LEntryField.reconfigureEnvironment();
    }
}

