/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LWindow;
import com.heirloomcomputing.ecs.jfc.SJLabel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class LLabel
extends LComponent
implements KeyListener {
    private SJLabel label = new SJLabel();
    private double labelOffset = 0.2;
    private boolean labelOffsetSet;

    public LLabel() {
        this.label.setForeground(null);
        this.label.setBackground(null);
        this.setLayout(new BorderLayout());
        this.setVerticalAlignment(1);
        this.setOpaque(true);
        this.add("Center", this.label);
        this.lines = 1.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.label.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.label.removeKeyListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    @Override
    public int getControlType() {
        return 1;
    }

    @Override
    public void setTitle(String value) {
        if (this.isNoKeyLetter()) {
            this.setCleanTitle(value);
        } else {
            super.setTitle(value);
        }
    }

    @Override
    public void setCleanTitle(String value) {
        super.setCleanTitle(value);
        if (value == null) {
            value = "";
        } else if (value.startsWith("\u0000")) {
            value = "";
        }
        this.label.setText(value);
        this.determineDefaultSize();
    }

    @Override
    public void setValue(String value) {
        if (COMPATIBILITY <= 0) {
            this.setTitle(value);
        }
    }

    @Override
    public void setFrom(String value) {
        this.setTitle(value);
    }

    @Override
    public String getValue() {
        return this.getTitle();
    }

    @Override
    public void determineDefaultSize() {
        if (this.size > 0.0) {
            return;
        }
        Dimension prefSize = this.label.getPreferredSize();
        int width = prefSize.width;
        if (width == 0) {
            return;
        }
        double divisor = this.isWidthInCells() ? (double)this.getCellWidth() : (double)this.getUnitWidth();
        if (++width > 0 && divisor > 0.0) {
            this.size = (double)width / divisor;
            this.lines = 1.0;
            if (this.isHeightInCells()) {
                width = prefSize.height;
                divisor = this.getCellHeight();
                this.lines = (double)width / divisor;
            }
            this.recalculateSizes();
        }
    }

    @Override
    public void setKey(char c) {
        if (!this.isNoKeyLetter()) {
            this.label.setDisplayedMnemonic(c);
        }
    }

    public boolean isLeft() {
        return this.isStyle(1);
    }

    public int getLeft() {
        return this.isLeft() ? 1 : 0;
    }

    public void setLeft() {
        this.setStyleOn(1, 6);
    }

    public void setLeft(boolean state) {
        this.setStyle(1, state, 6);
    }

    public boolean isRight() {
        return this.isStyle(2);
    }

    public int getRight() {
        return this.isRight() ? 1 : 0;
    }

    public void setRight() {
        this.setStyleOn(2, 5);
    }

    public void setRight(boolean state) {
        this.setStyle(2, state, 5);
    }

    public boolean isCenter() {
        return this.isStyle(4);
    }

    public int getCenter() {
        return this.isCenter() ? 1 : 0;
    }

    public void setCenter() {
        this.setStyleOn(4, 3);
    }

    public void setCenter(boolean state) {
        this.setStyle(4, state, 3);
    }

    public boolean isJustified() {
        return (this.style & 7) != 0;
    }

    public boolean isNoKeyLetter() {
        return this.isStyle(8);
    }

    public int getNoKeyLetter() {
        return this.isNoKeyLetter() ? 1 : 0;
    }

    public void setNoKeyLetter() {
        this.setStyleOn(8);
    }

    public void setNoKeyLetter(boolean state) {
        this.setStyle(8, state);
    }

    @Override
    public boolean isTransparent() {
        return this.isStyle(16);
    }

    @Override
    public int getTransparent() {
        return this.isTransparent() ? 1 : 0;
    }

    public void setTransparent() {
        this.setStyleOn(16);
    }

    @Override
    public void setTransparent(boolean state) {
        this.setStyle(16, state);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 7) != 0) {
            if ((mask & 4) == 4) {
                this.setHorizontalAlignment(0);
            } else if ((mask & 2) == 2) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
        }
        if ((change & 8) == 8) {
            if ((mask & 8) == 8) {
                this.setDisplayedMnemonic(0);
            }
            this.setCleanTitle(this.title);
        }
        if ((change & 0x10) == 16) {
            this.setOpaque((mask & 0x10) != 16);
        }
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setLabelOffset(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getLabelOffset());
            }
        }
        return super.getProperty(number);
    }

    public void setLabelOffset(int offset) {
        this.labelOffset = (double)offset / 100.0;
        this.labelOffsetSet = true;
        if (this.line > 0.0) {
            this.setLine(this.line);
        }
    }

    @Override
    public void setWindow(LComponent window) {
        double setLabelOffset;
        super.setWindow(window);
        if (!this.labelOffsetSet && this.labelOffset != (setLabelOffset = (double)((LWindow)window).getLabelOffset() / 100.0) && this.line > 0.0) {
            this.setLine(this.line);
        }
    }

    public int getLabelOffset() {
        return (int)(this.labelOffset * 100.0);
    }

    @Override
    public void setLine(double value) {
        super.setLine(value + this.labelOffset);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.label.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.label.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.label.getMaximumSize();
    }

    @Override
    public void setOpaque(boolean state) {
        this.label.setOpaque(state);
        super.setOpaque(state);
    }

    public void setDisplayedMnemonic(int c) {
        this.label.setDisplayedMnemonic(c);
        this.revalidateAndDisplay();
    }

    public void setHorizontalAlignment(int v) {
        this.label.setHorizontalAlignment(v);
        this.revalidateAndDisplay();
    }

    public void setVerticalAlignment(int v) {
        this.label.setVerticalAlignment(v);
        this.revalidateAndDisplay();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.label.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.label.setEnabled(state);
        super.setEnabled(state);
    }
}

