/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LListComboModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

final class LListComboCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private LListComboModel listModel = null;
    private LComponent parentComponent;

    public LListComboCellRenderer(LComponent parent) {
        this.parentComponent = parent;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String s = String.valueOf(value);
        try {
            if (this.parentComponent.isUpper()) {
                s = s.toUpperCase();
            } else if (this.parentComponent.isLower()) {
                s = s.toLowerCase();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setOpaque(true);
        this.setText(s);
        Color background = null;
        Color foreground = null;
        if (isSelected) {
            background = list.getSelectionBackground();
            foreground = list.getSelectionForeground();
        } else {
            background = list.getBackground();
            foreground = list.getForeground();
        }
        this.setBackground(background);
        this.setForeground(foreground);
        this.setEnabled(list.isEnabled());
        Font f = list.getFont();
        this.setFont(f);
        try {
            this.listModel = (LListComboModel)list.getModel();
        }
        catch (Throwable throwable) {
            this.listModel = null;
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        block37: {
            if (this.listModel == null) {
                super.paint(g);
                return;
            }
            try {
                Font f = this.getFont();
                FontMetrics fm = g.getFontMetrics(f);
                int unitWidth = fm.charWidth('0');
                Color color1 = null;
                Color color2 = null;
                Color colors = null;
                if (this.isEnabled()) {
                    color1 = this.getForeground();
                } else {
                    color1 = this.getBackground().brighter();
                    color2 = this.getBackground().darker();
                }
                colors = (color1.getRGB() & 0xFFFFFF) == 0 ? Color.darkGray : ((color1.getRGB() & 0xFFFFFF) == 0xFFFFFF ? Color.lightGray : color1.brighter());
                Vector<Integer> dataColumns = this.listModel.dataColumns;
                Vector<Integer> displayColumns = this.listModel.displayColumns;
                Vector<Integer> alignments = this.listModel.alignments;
                Vector<Integer> dividers = this.listModel.dividers;
                Vector<Integer> separators = this.listModel.separators;
                if (dataColumns == null && displayColumns == null && alignments == null && dividers == null && separators == null) {
                    try {
                        super.paintComponent(g);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                Rectangle r = this.getBounds();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, r.width, r.height);
                Rectangle oldClipBounds = null;
                if (dataColumns == null) break block37;
                int size = dataColumns.size();
                int dataColumn = 0;
                int displayColumn = 0;
                int alignment = 0;
                int divider = 0;
                int separator = 0;
                Integer obj = null;
                int xtracker = 0;
                String subtext = null;
                String text = this.getText();
                int y = fm.getAscent();
                int displayWidth = 0;
                for (int i = 0; i < size; ++i) {
                    dataColumn = -1;
                    displayColumn = -1;
                    alignment = 2;
                    divider = 0;
                    separator = 0;
                    try {
                        int individualSize;
                        obj = dataColumns.elementAt(i);
                        dataColumn = obj;
                        obj = displayColumns.elementAt(i);
                        displayColumn = obj;
                        try {
                            if (alignments != null && i < alignments.size() && (obj = alignments.elementAt(i)) != null) {
                                alignment = obj;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (dividers != null && i < dividers.size() && (obj = dividers.elementAt(i)) != null) {
                                divider = obj;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (separators != null && i < separators.size() && (obj = separators.elementAt(i)) != null) {
                            separator = obj;
                        }
                        if (separator > 0) {
                            separator = (int)((double)unitWidth * ((double)separator / 10.0));
                        }
                        xtracker = individualSize = displayColumn * unitWidth;
                        displayWidth = 0;
                        try {
                            int currentWidth = 0;
                            if (i >= 0 && i < displayColumns.size()) {
                                obj = displayColumns.elementAt(i);
                                currentWidth = obj;
                            }
                            int nextWidth = 0;
                            if (i + 1 >= 0 && i + 1 < displayColumns.size() && (obj = displayColumns.elementAt(i + 1)) != null) {
                                nextWidth = obj;
                            }
                            displayWidth = (nextWidth - currentWidth) * unitWidth;
                        }
                        catch (Exception currentWidth) {
                            // empty catch block
                        }
                        if (displayWidth <= 0) {
                            displayWidth = r.width - xtracker;
                        }
                        oldClipBounds = null;
                        if (dataColumn < text.length()) {
                            int nextColumn = -1;
                            try {
                                obj = dataColumns.elementAt(i + 1);
                                if (obj != null) {
                                    nextColumn = obj;
                                    subtext = text.substring(dataColumn, nextColumn);
                                } else {
                                    subtext = text.substring(dataColumn);
                                }
                            }
                            catch (Exception e) {
                                subtext = text.substring(dataColumn);
                            }
                            subtext = subtext.trim();
                            int textWidth = SwingUtilities.computeStringWidth(fm, subtext);
                            int calcWidth = displayWidth;
                            calcWidth -= separator;
                            calcWidth -= divider;
                            int x = 0;
                            switch (alignment) {
                                case 4: {
                                    x = calcWidth - textWidth - 1;
                                    break;
                                }
                                case 0: {
                                    x = (calcWidth - textWidth) / 2;
                                    break;
                                }
                                case 2: {
                                    if (i <= 0) break;
                                    ++x;
                                }
                            }
                            x += xtracker;
                            oldClipBounds = g.getClipBounds();
                            g.clipRect(xtracker, 0, xtracker + calcWidth, r.height);
                            if (this.isEnabled()) {
                                g.setColor(color1);
                                g.drawString(subtext, x, y);
                            } else {
                                g.setColor(color1);
                                g.drawString(subtext, x, y);
                                g.setColor(color2);
                                g.drawString(subtext, x + 1, y + 1);
                            }
                        }
                        if (oldClipBounds != null) {
                            g.setClip(oldClipBounds.x, oldClipBounds.y, oldClipBounds.width, oldClipBounds.height);
                        }
                        g.setColor(colors);
                        if (divider <= 0) continue;
                        g.fillRect(xtracker + displayWidth - divider, 0, divider, r.height);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

