/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class LMasterWindow
extends LComponent
implements KeyListener {
    private boolean overrideFocusTraversable = false;
    private int columnCount = 80;
    private int lineCount = 25;
    private boolean gradient = false;
    private Color fromColor = Color.black;
    private Color toColor = Color.blue;
    private int fromRed;
    private int fromGreen;
    private int fromBlue;
    private int toRed;
    private int toGreen;
    private int toBlue;
    private int baseRed;
    private int baseGreen;
    private int baseBlue;
    private int differenceRed;
    private int differenceGreen;
    private int differenceBlue;
    private boolean autoBorder = true;
    private int borderThickness = 0;
    private Color borderColor = Color.black;

    @Override
    public boolean isFocusable() {
        if (this.overrideFocusTraversable) {
            this.overrideFocusTraversable = false;
            return true;
        }
        return super.isFocusable();
    }

    public void snatchFocus() {
        this.overrideFocusTraversable = true;
        this.requestFocus();
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 9) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        this.addKeyListener(this);
    }

    public void removeConstantListeners() {
        this.removeKeyListener(this);
    }

    @Override
    public int getControlType() {
        return 1009;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
        this.repaint();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public void setColumnCount(int x) {
        if (x <= 0) {
            return;
        }
        this.columnCount = x;
        this.updateSize();
    }

    public void setLineCount(int y) {
        if (y <= 0) {
            return;
        }
        this.lineCount = y;
        this.updateSize();
    }

    public void setColumnLineCount(int x, int y) {
        if (x <= 0 && y <= 0) {
            return;
        }
        if (x > 0) {
            this.columnCount = x;
        }
        if (y > 0) {
            this.lineCount = y;
        }
        this.updateSize();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    @Override
    public void setCellWidth(int width) {
        super.setCellWidth(width);
        this.updateSize();
    }

    @Override
    public void setCellHeight(int height) {
        super.setCellHeight(height);
        this.updateSize();
    }

    @Override
    public void setCellSize(Dimension d) {
        super.setCellSize(d);
        this.updateSize(d.width, d.height);
    }

    @Override
    public void setCellSize(int width, int height) {
        super.setCellSize(width, height);
        this.updateSize(width, height);
    }

    private void updateSize() {
        this.updateSize(this.getCellWidth(), this.getCellHeight());
    }

    private void updateSize(int cellWidth, int cellHeight) {
        this.setSize(cellWidth * this.columnCount, cellHeight * this.lineCount);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getCellWidth() * this.columnCount, this.getCellHeight() * this.lineCount);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void setGradient(int state) {
        this.gradient = state != 0;
    }

    public void setGradient(boolean state) {
        this.gradient = state;
        if (state) {
            try {
                if (this.fromColor == null) {
                    this.fromColor = Color.blue;
                }
                this.fromRed = this.fromColor.getRed();
                this.fromGreen = this.fromColor.getGreen();
                this.fromBlue = this.fromColor.getBlue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.toColor == null) {
                    this.toColor = Color.black;
                }
                this.toRed = this.toColor.getRed();
                this.toGreen = this.toColor.getGreen();
                this.toBlue = this.toColor.getBlue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.determineGradient();
        }
    }

    private void determineGradient() {
        this.baseRed = this.fromRed;
        this.baseGreen = this.fromGreen;
        this.baseBlue = this.fromBlue;
        this.differenceRed = this.toRed - this.fromRed;
        this.differenceGreen = this.toGreen - this.fromGreen;
        this.differenceBlue = this.toBlue - this.fromBlue;
        if (this.autoBorder) {
            int intensityRed = (this.fromRed + this.toRed) / 2;
            int intensityGreen = (this.fromGreen + this.toGreen) / 2;
            int intensityBlue = (this.fromBlue + this.toBlue) / 2;
            this.borderColor = new Color(intensityRed, intensityGreen, intensityBlue);
        }
        this.repaint();
    }

    public boolean isGradient() {
        return this.gradient;
    }

    public int getGradient() {
        return this.gradient ? 1 : 0;
    }

    public void setGradientForeground(Color c) {
        this.fromColor = c;
        this.fromRed = c.getRed();
        this.fromGreen = c.getGreen();
        this.fromBlue = c.getBlue();
        this.determineGradient();
    }

    public Color getGradientForeground() {
        return this.fromColor;
    }

    public void setGradientForeground(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setGradientForeground(c);
    }

    public void setGradientBackground(Color c) {
        this.toColor = c;
        this.toRed = c.getRed();
        this.toGreen = c.getGreen();
        this.toBlue = c.getBlue();
        this.determineGradient();
    }

    public Color getGradientBackground() {
        return this.toColor;
    }

    public void setGradientBackground(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setGradientBackground(c);
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int n) {
        this.borderThickness = n;
        this.repaint();
    }

    public boolean isGradientBorder() {
        return this.autoBorder;
    }

    public int getGradientBorder() {
        return this.autoBorder ? 1 : 0;
    }

    public void setGradientBorder(boolean state) {
        this.autoBorder = state;
    }

    public void setGradientBorder(int state) {
        this.autoBorder = state != 0;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.repaint();
    }

    public void setBorderColor(int color2) {
        Color c = colorArray[this.adjustForeground(color2)];
        this.setBorderColor(c);
    }

    @Override
    public void paintChildren(Graphics g) {
        try {
            if (this.gradient) {
                this.paintGradient(g);
            }
            super.paintChildren(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintGradient(Graphics g) {
        int i;
        Dimension size = this.getSize();
        int width = size.width - 1;
        int height = size.height;
        double gradationRed = (double)this.differenceRed / (double)height;
        double gradationGreen = (double)this.differenceGreen / (double)height;
        double gradationBlue = (double)this.differenceBlue / (double)height;
        for (i = 0; i < height; ++i) {
            double di = i;
            int intensityRed = (int)((double)this.baseRed + gradationRed * di);
            int intensityGreen = (int)((double)this.baseGreen + gradationGreen * di);
            int intensityBlue = (int)((double)this.baseBlue + gradationBlue * di);
            Color color2 = new Color(intensityRed, intensityGreen, intensityBlue);
            g.setColor(color2);
            g.drawLine(0, i, width, i);
        }
        try {
            if (this.borderThickness > 0) {
                --height;
                g.setColor(this.borderColor);
                for (i = 0; i < this.borderThickness; ++i) {
                    g.drawLine(i, i, width - i, i);
                    g.drawLine(i, height - i, width - i, height - i);
                    g.drawLine(i, i, i, height - i);
                    g.drawLine(width - i, i, width - i, height - i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.setColor(this.getForeground());
    }
}

