/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.IO;
import com.heirloomcomputing.ecs.exec.LNF;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.LWindow;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class LMessageBox
extends JDialog {
    public static final int MB_OK = 1;
    public static final int MB_YES_NO = 2;
    public static final int MB_OK_CANCEL = 3;
    public static final int MB_YES_NO_CANCEL = 4;
    public static final int MB_YES = 1;
    public static final int MB_NO = 2;
    public static final int MB_CANCEL = 3;
    public static final int MB_DEFAULT_ICON = 1;
    public static final int MB_WARNING_ICON = 2;
    public static final int MB_ERROR_ICON = 3;
    private String YES = ResourceManager.get("component.message-box.yes", "Yes");
    private String NO = ResourceManager.get("component.message-box.no", "No");
    private String OK = ResourceManager.get("component.message-box.ok", "OK");
    private String CANCEL = ResourceManager.get("component.message-box.cancel", "Cancel");
    private boolean gotten = false;
    private String text = null;
    private String title = null;
    private int type = 1;
    private int icon = 0;
    private int defaultValue = 0;
    private int returnValue = 0;
    private Vector<String> optionsMaster = null;
    private LComponent window;
    private int resultValue = 0;
    private Handle myHandle;
    private Handle saveHandle = null;

    public LMessageBox() {
    }

    public LMessageBox(Frame frame) {
        super(frame);
    }

    public LMessageBox(Frame frame, String title) {
        super(frame, title);
    }

    public LMessageBox(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public LMessageBox(String messageText, String messageTitle, int messageMode) {
        this.setTitle(messageTitle);
        this.setValue(messageText);
        int guimode = messageMode & 3;
        switch (guimode) {
            case 0: {
                this.setType(1);
                break;
            }
            case 1: {
                this.setType(2);
                break;
            }
            case 2: {
                this.setType(3);
                break;
            }
            case 3: {
                this.setType(4);
            }
        }
        if ((messageMode & 0x1000) == 4096) {
            this.setDefault(2);
        } else if ((messageMode & 0x2000) == 8192) {
            this.setDefault(3);
        }
        if ((messageMode & 0x100) == 256) {
            this.setIconType(2);
        } else if ((messageMode & 0x200) == 512) {
            this.setIconType(3);
        }
    }

    public void setImplicitTitle(String value) {
        this.setValue(value);
    }

    public void setValue(String text) {
        this.text = text != null ? text.replace('\u0000', ' ').trim() : null;
    }

    public String getValue() {
        this.gotten = true;
        this.showOptionPane();
        return String.valueOf(this.returnValue);
    }

    @Override
    public void setTitle(String title) {
        this.title = title != null ? title.replace('\u0000', ' ').trim() : null;
    }

    @Override
    public String getTitle() {
        return this.getValue();
    }

    public void setType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.type = type;
                break;
            }
            default: {
                this.type = 1;
            }
        }
    }

    public void setIconType(int icon) {
        switch (icon) {
            case 1: 
            case 2: 
            case 3: {
                this.icon = icon;
                break;
            }
            default: {
                this.icon = 1;
            }
        }
    }

    public String getIconType() {
        return this.getValue();
    }

    public void setDefault(int defaultValue) {
        switch (defaultValue) {
            case 1: 
            case 2: 
            case 3: {
                this.defaultValue = defaultValue;
                break;
            }
            default: {
                this.defaultValue = 0;
            }
        }
    }

    public String getDefault() {
        return this.getValue();
    }

    @Override
    public void show() {
        if (!this.gotten) {
            this.showOptionPane();
        }
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.showOptionPane();
        }
    }

    public void setOption(String value) {
        if (value == null || value.trim().length() == 0) {
            this.optionsMaster = null;
        } else {
            if (this.optionsMaster == null) {
                this.optionsMaster = new Vector();
            }
            this.optionsMaster.addElement(value);
        }
    }

    public String getOption() {
        return this.getValue();
    }

    public void setWindow(LComponent window) {
        this.window = window;
    }

    public void setWindow() {
        try {
            this.window = (LWindow)IO.getCurrentIONoCreate().getIOHandle().getComponent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setResultValue(int value) {
        this.resultValue = value;
    }

    public int getResultValue() {
        return this.resultValue;
    }

    public int showOptionPane() {
        int result = 0;
        boolean custom = false;
        Object[] options = null;
        Object initialValue = null;
        int optionType = 0;
        int messageType2 = 0;
        if (this.optionsMaster != null) {
            custom = true;
            options = new Object[this.optionsMaster.size()];
            this.optionsMaster.copyInto(options);
            if (this.defaultValue > 0) {
                initialValue = options[this.defaultValue - 1];
            }
            switch (this.icon) {
                case 1: {
                    if (options.length > 1) {
                        messageType2 = 3;
                        break;
                    }
                    messageType2 = 1;
                    break;
                }
                case 4: {
                    messageType2 = 1;
                    break;
                }
                case 5: {
                    messageType2 = 3;
                    break;
                }
                case 6: {
                    messageType2 = -1;
                }
            }
        }
        if (options == null) {
            try {
                switch (this.type) {
                    case 1: {
                        options = new Object[]{this.OK};
                        optionType = -1;
                        messageType2 = 1;
                        break;
                    }
                    case 2: {
                        options = new Object[]{this.YES, this.NO};
                        optionType = 0;
                        messageType2 = 3;
                        break;
                    }
                    case 3: {
                        options = new Object[]{this.OK, this.CANCEL};
                        optionType = 2;
                        messageType2 = 1;
                        break;
                    }
                    case 4: {
                        options = new Object[]{this.YES, this.NO, this.CANCEL};
                        optionType = 1;
                        messageType2 = 3;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        switch (this.icon) {
            case 1: {
                break;
            }
            case 2: {
                messageType2 = 2;
                break;
            }
            case 3: {
                messageType2 = 0;
            }
        }
        try {
            if (initialValue == null) {
                switch (this.defaultValue) {
                    case 1: {
                        initialValue = options[0];
                        break;
                    }
                    case 2: {
                        initialValue = options[1];
                        break;
                    }
                    case 3: {
                        initialValue = options[2];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LComponent parentComponent = null;
        if (this.window != null) {
            parentComponent = this.window;
        }
        final LComponent passParentComponent = parentComponent;
        final String passText = this.text;
        final String passTitle = this.title;
        final int passOptionType = optionType;
        final int passMessageType = messageType2;
        final Object[] passOptions = options;
        final Object passInitialValue = initialValue;
        this.setResultValue(result);
        if (SwingUtilities.isEventDispatchThread()) {
            int result2 = JOptionPane.showOptionDialog(parentComponent, this.text, this.title, optionType, messageType2, null, options, initialValue);
            this.setResultValue(result2);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        int result2 = JOptionPane.showOptionDialog(passParentComponent, passText, passTitle, passOptionType, passMessageType, null, passOptions, passInitialValue);
                        LMessageBox.this.setResultValue(result2);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        result = this.getResultValue();
        if (custom) {
            this.returnValue = result + 1;
            return this.returnValue;
        }
        block25 : switch (result) {
            case 0: {
                this.returnValue = 1;
                break;
            }
            case 1: {
                this.returnValue = 2;
                break;
            }
            case 2: {
                this.returnValue = 3;
                break;
            }
            default: {
                switch (this.type) {
                    case 1: {
                        this.returnValue = 1;
                        break block25;
                    }
                    case 2: {
                        this.returnValue = 2;
                        break block25;
                    }
                }
                this.returnValue = 3;
            }
        }
        return this.returnValue;
    }

    public Handle getHandle() {
        return this.myHandle;
    }

    public void setHandle(Handle myHandle) {
        this.myHandle = myHandle;
    }

    public void setHandleIn(Handle copyHandle) {
        this.saveHandle = copyHandle;
        copyHandle.set(this.myHandle);
    }

    public Handle getHandleIn() {
        return this.myHandle;
    }

    public void setIO(IO io) {
        if (this.saveHandle != null) {
            this.saveHandle.setIO(io);
            this.saveHandle = null;
        }
    }

    static {
        LNF.setNativeLookAndFeel();
    }
}

