/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.exec.ResourceManager;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LBitmapIcon;
import com.heirloomcomputing.ecs.jfc.LButtonDirect;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public final class LPushButton
extends LComponent
implements ActionListener,
FocusListener,
KeyListener {
    private static final int DEFAULT_ADJUST_SIZE = 2;
    private LButtonDirect button;
    private Border defaultButtonBorder;
    private Border defaultBorder;
    private int backup_lines = 2;
    private int bitmapNumber = 1;
    private int bitmapHandle;
    private boolean recreating;
    public LBitmap bitmapComponent;
    public Icon bitmapIcon;

    public LPushButton() {
        this.setLayout(new BorderLayout());
        this.adjustSize = 2;
        this.button = new LButtonDirect();
        this.button.setDefaultCapable(false);
        this.add("Center", this.button);
        this.defaultBorder = this.getBorder();
        this.defaultButtonBorder = this.button.getBorder();
        this.lines = 1.0;
        this.size = 8.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int code;
        if (event != null && ((code = event.getKeyCode()) == 10 || code == 32)) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        try {
            this.button.addFocusListener(this);
            this.button.addActionListener(this);
            this.button.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.button.removeFocusListener(this);
            this.button.removeActionListener(this);
            this.button.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4, event));
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
        this.notifyRootPaneIfDefaultButton();
    }

    public void notifyRootPaneIfDefaultButton() {
        boolean isDefault = this.isDefaultButton();
        if (isDefault) {
            return;
        }
        if (!this.button.isDefaultCapable()) {
            return;
        }
        JRootPane root = SwingUtilities.getRootPane(this);
        if (root != null) {
            root.setDefaultButton(this.button);
        }
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.button.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.button.hasFocus();
    }

    @Override
    protected int getDefaultUnitHeight(Font f) {
        if (this.isBitmap()) {
            return super.getDefaultUnitHeight(f);
        }
        int defaultHeight = LPushButton.getDefaultHeight(f);
        this.backup_lines = this.adjustLines = defaultHeight / 2;
        return defaultHeight;
    }

    @Override
    protected int getDefaultUnitHeight(Font f, FontMetrics fm) {
        if (this.isBitmap()) {
            return super.getDefaultUnitHeight(f, fm);
        }
        int defaultHeight = LPushButton.getDefaultHeight(f, fm);
        this.backup_lines = this.adjustLines = defaultHeight / 2;
        return defaultHeight;
    }

    @Override
    public int getControlType() {
        return 3;
    }

    @Override
    public void setCleanTitle(String value) {
        super.setCleanTitle(value);
        if (!this.isBitmap()) {
            this.button.setText(value);
        }
        if (value != null) {
            this.setToolTipText(value.trim());
            this.button.setToolTipText(value.trim());
        } else {
            this.setToolTipText(value);
            this.button.setToolTipText(value);
        }
    }

    @Override
    public void setKey(char c) {
        this.button.setMnemonic(c);
    }

    public boolean isDefaultButton() {
        return this.isStyle(1);
    }

    public int getDefaultButton() {
        return this.isDefaultButton() ? 1 : 0;
    }

    public void setDefaultButton() {
        this.setStyleOn(1);
    }

    public void setDefaultButton(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isEscapeButton() {
        return this.isStyle(2);
    }

    public int getEscapeButton() {
        return this.isEscapeButton() ? 1 : 0;
    }

    public void setEscapeButton() {
        this.setStyleOn(2);
    }

    public void setEscapeButton(boolean state) {
        this.setStyle(2, state);
    }

    public boolean isOkButton() {
        return this.isStyle(4);
    }

    public int getOkButton() {
        return this.isOkButton() ? 1 : 0;
    }

    public void setOkButton() {
        this.setStyleOn(4);
    }

    public void setOkButton(boolean state) {
        this.setStyle(4, state);
    }

    public boolean isCancelButton() {
        return this.isStyle(8);
    }

    public int getCancelButton() {
        return this.isCancelButton() ? 1 : 0;
    }

    public void setCancelButton() {
        this.setStyleOn(8);
    }

    public void setCancelButton(boolean state) {
        this.setStyle(8, state);
    }

    public boolean isNoAutoDefault() {
        return this.isStyle(16);
    }

    public int getNoAutoDefault() {
        return this.isNoAutoDefault() ? 1 : 0;
    }

    public void setNoAutoDefault() {
        this.setStyleOn(16);
    }

    public void setNoAutoDefault(boolean state) {
        this.setStyle(16, state);
    }

    public boolean isBitmap() {
        return this.isStyle(32768);
    }

    public int getBitmap() {
        return this.isBitmap() ? 1 : 0;
    }

    public void setBitmap() {
        this.setStyleOn(32768);
    }

    public void setBitmap(boolean state) {
        this.setStyle(32768, state);
    }

    public boolean isSquare() {
        return this.isStyle(16384);
    }

    public int getSquare() {
        return this.isSquare() ? 1 : 0;
    }

    public void setSquare() {
        this.setStyleOn(16384);
    }

    public void setSquare(boolean state) {
        this.setStyle(16384, state);
    }

    public boolean isFramed() {
        return this.isStyle(8192);
    }

    public int getFramed() {
        return this.isFramed() ? 1 : 0;
    }

    public void setFramed() {
        this.setStyleOn(8192);
    }

    public void setFramed(boolean state) {
        this.setStyle(8192, state);
    }

    public boolean isUnframed() {
        return this.isStyle(4096);
    }

    public int getUnframed() {
        return this.isUnframed() ? 1 : 0;
    }

    public void setUnframed() {
        this.setStyleOn(4096);
    }

    public void setUnframed(boolean state) {
        this.setStyle(4096, state);
    }

    public boolean isFlat() {
        return this.isStyle(2048);
    }

    public int getFlat() {
        return this.isFlat() ? 1 : 0;
    }

    public void setFlat() {
        this.setStyleOn(2048);
    }

    public void setFlat(boolean state) {
        this.setStyle(2048, state);
    }

    @Override
    protected boolean isHeightInPixels() {
        return this.isBitmap();
    }

    @Override
    protected boolean isWidthInPixels() {
        return this.isBitmap();
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 4) == 4 && (mask & 4) == 4) {
            if (this.title == null) {
                this.setTitle(ResourceManager.get("component.push-button.ok", "&OK"));
            }
            change |= 1;
            mask |= 1;
            this.setTerminationValue(13);
            this.setExceptionValue(0);
        } else if ((change & 8) == 8 && (mask & 8) == 8) {
            if (this.title == null) {
                this.setTitle(ResourceManager.get("component.push-button.cancel", "&Cancel"));
            }
            this.setExceptionValue(27);
            this.setTerminationValue(0);
            mask |= 2;
            change |= 2;
        } else if ((change & 2) == 2 && (mask & 2) == 2) {
            this.setExceptionValue(27);
            this.setTerminationValue(0);
        }
        if ((change & 0x800) == 2048) {
            if ((mask & 0x800) == 2048) {
                this.setBorder(this.defaultBorder);
                this.button.setBorder(this.defaultButtonBorder);
                if ((mask & 0x8000) != 0) {
                    this.adjustLines = 8;
                    this.adjustSize = 8;
                } else {
                    this.adjustLines = this.backup_lines;
                    this.adjustSize = 2;
                }
            } else {
                this.setBorder(this.defaultBorder);
                this.button.setBorder(this.defaultButtonBorder);
                if ((mask & 0x8000) != 0) {
                    this.adjustLines = 8;
                    this.adjustSize = 8;
                } else {
                    this.adjustLines = this.backup_lines;
                    this.adjustSize = 2;
                }
            }
        }
        boolean dc = true;
        if ((change & 0x10) == 16) {
            dc = (mask & 0x10) == 16;
            this.button.setDefaultCapable(dc);
        }
        if ((change & 1) == 1 && (mask & 1) == 1) {
            this.button.setDefaultCapable(dc);
            JRootPane rootPane = this.button.getRootPane();
            if (rootPane != null) {
                rootPane.setDefaultButton(this.button);
            }
        }
        boolean setup_bitmap = false;
        boolean clear_bitmap = false;
        if ((change & 0x8000) == 32768) {
            if ((mask & 0x8000) == 32768) {
                setup_bitmap = true;
                if (this.bitmapHandle == 0) {
                    this.setBitmapHandle(LBitmap.getDefaultBitmapHandle());
                }
            } else {
                clear_bitmap = true;
            }
        }
        super.setStyle(mask);
        if (setup_bitmap) {
            this.adjustLines = 8;
            this.adjustSize = 8;
            if (this.usingDefaultLines) {
                this.lines = 15.0;
            }
            if (this.usingDefaultSize) {
                this.size = 16.0;
            }
            this.recalculateSizes();
            this.button.setMargin(new Insets(4, 4, 4, 4));
            this.button.setText(null);
            this.recreateBitmap();
        } else if (clear_bitmap) {
            this.adjustLines = this.backup_lines;
            this.adjustSize = 2;
            this.recalculateSizes();
            this.button.setMargin(new Insets(2, 2, 2, 2));
            this.button.setText(this.button.getToolTipText());
        }
        this.revalidateAndDisplay();
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 3: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 4: {
                this.setBitmapHandle((Handle)property);
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 3: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 4: {
                return String.valueOf(this.getBitmapHandle());
            }
        }
        return super.getProperty(number);
    }

    @Override
    public void setColumns(double size) {
        super.setColumns(size);
        this.recreateBitmap();
    }

    @Override
    public void setColumnsPixels(int size) {
        super.setColumnsPixels(size);
        this.recreateBitmap();
    }

    public void setBitmapNumber(int value) {
        this.bitmapNumber = value;
        this.recreateBitmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateBitmap() {
        if (!this.isBitmap()) {
            return;
        }
        if (this.bitmapComponent == null) {
            return;
        }
        LPushButton lPushButton = this;
        synchronized (lPushButton) {
            if (this.recreating) {
                return;
            }
            this.recreating = true;
            try {
                if (this.usingDefaultLines) {
                    this.lines = 15.0;
                }
                if (this.usingDefaultSize) {
                    this.size = 16.0;
                }
                this.adjustLines = 8;
                this.adjustSize = 8;
                this.bitmapIcon = new LBitmapIcon(this.bitmapComponent, this.bitmapNumber, (int)this.size);
                this.button.setIcon(this.bitmapIcon);
                this.setBitmap();
                this.setLines(this.lines);
                this.setColumns(this.size);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.recreating = false;
        }
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapValue(String resourceName) {
        try {
            String oldResourceName;
            boolean create = true;
            if (this.bitmapComponent != null && (oldResourceName = this.bitmapComponent.getValue()) != null && oldResourceName.equals(resourceName)) {
                create = false;
            }
            if (create) {
                this.setBitmapValue(new LBitmap(resourceName));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapValue(LBitmap component) {
        if (this.bitmapComponent != component) {
            this.bitmapComponent = component;
            Handle h = new Handle(this.bitmapComponent);
            this.bitmapHandle = h.getHandleNumber();
            this.setBitmap();
            this.recreateBitmap();
        }
    }

    public void setBitmapHandle(int value) {
        if (value != this.bitmapHandle) {
            try {
                this.bitmapHandle = value;
                this.setBitmapHandle(Handle.getHandle(value));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setBitmapHandle(Handle value) {
        try {
            if (value == null) {
                this.bitmapHandle = 0;
                this.bitmapComponent = null;
            } else {
                this.bitmapHandle = value.getHandleNumber();
                this.bitmapComponent = (LBitmap)value.getComponent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setBitmap();
        this.recreateBitmap();
    }

    public int getBitmapHandle() {
        return this.bitmapHandle;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.button.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.button.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.button.getMaximumSize();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.button.setPreferredSize(d);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.button.setMinimumSize(d);
        super.setMinimumSize(d);
    }

    @Override
    public void setMaximumSize(Dimension d) {
        this.button.setMaximumSize(d);
        super.setMaximumSize(d);
    }

    @Override
    public void setBackground(Color c) {
        if (COMPATIBILITY <= 1) {
            this.button.setBackground(c);
            super.setBackground(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        if (COMPATIBILITY <= 1) {
            this.button.setForeground(c);
            super.setForeground(c);
        }
    }

    @Override
    public void setOpaque(boolean state) {
        this.button.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.button.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.button.setEnabled(state);
        super.setEnabled(state);
    }
}

