/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LBitmapIcon;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public final class LRadioButton
extends LComponent
implements FocusListener,
ActionListener,
ItemListener,
KeyListener {
    private JRadioButton checkbox = new JRadioButton(){

        @Override
        protected void processComponentKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 9) {
                event.consume();
                return;
            }
            super.processComponentKeyEvent(event);
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }
    };
    private Border defaultBorder;
    private Border defaultCheckBoxBorder;
    private static final Border raisedBorder = new BevelBorder(0);
    private static final Border loweredBorder = new BevelBorder(1);
    private static final Border emptyBorder = new EmptyBorder(2, 2, 2, 2);
    private static final Vector<ButtonGroup> buttonGroups = new Vector();
    private int group = -1;
    private int groupValue;
    private int effectiveGroupValue = 1;
    private boolean groupInEffect;
    private int bitmapNumber = 1;
    private int bitmapHandle;
    private boolean recreating;
    public LBitmap bitmapComponent;
    public Icon bitmapIcon;

    public LRadioButton() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.checkbox);
        this.defaultBorder = this.getBorder();
        this.defaultCheckBoxBorder = this.checkbox.getBorder();
        this.setOpaque(true);
        this.checkbox.setBackground(null);
        this.checkbox.setForeground(null);
        this.adjustLines = 2;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        try {
            this.checkbox.addFocusListener(this);
            this.checkbox.addActionListener(this);
            this.checkbox.addItemListener(this);
            this.checkbox.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.checkbox.removeFocusListener(this);
            this.checkbox.removeActionListener(this);
            this.checkbox.removeItemListener(this);
            this.checkbox.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.updateBorder();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else if (this.isNotify()) {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 4, event));
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
        if (this.checkbox.isSelected()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LRadioButton.this.group > 0 && LRadioButton.this.checkbox != null) {
                    ButtonModel model = LRadioButton.this.checkbox.getModel();
                    if (!model.isEnabled()) {
                        return;
                    }
                    if (!model.isArmed()) {
                        model.setArmed(true);
                    }
                    model.setPressed(true);
                    try {
                        Thread.sleep(68L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    model.setPressed(false);
                    model.setArmed(false);
                }
            }
        });
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.group < 0) {
            this.setGroup(1);
        }
        this.updateBorder();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.checkbox.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.checkbox.hasFocus();
    }

    @Override
    protected void updateValue() {
        String value;
        int integerValue;
        if (this.toVariable != null && ((integerValue = Integer.parseInt((value = this.getValue()).trim())) == 0 || integerValue == this.effectiveGroupValue)) {
            if (!this.groupInEffect) {
                this.toVariable.move(value);
            } else if (integerValue != 0) {
                this.toVariable.move(value);
            }
        }
    }

    @Override
    public int getControlType() {
        return 5;
    }

    @Override
    public void setCleanTitle(String value) {
        super.setCleanTitle(value);
        this.checkbox.setText(value);
        this.setToolTipText(value);
        this.checkbox.setToolTipText(value);
        this.determineDefaultSize();
    }

    @Override
    public void determineDefaultSize() {
        if (this.size > 0.0) {
            return;
        }
        Dimension prefSize = this.checkbox.getPreferredSize();
        int width = prefSize.width;
        double divisor = this.isWidthInCells() ? (double)this.getCellWidth() : (double)this.getUnitWidth();
        if (width > 0 && divisor > 0.0) {
            this.size = (double)width / divisor;
            this.lines = 1.0;
            if (this.isHeightInCells()) {
                width = prefSize.height;
                divisor = this.getCellHeight();
                this.lines = (double)width / divisor;
            }
            this.recalculateSizes();
        }
    }

    @Override
    public void setKey(char c) {
        this.checkbox.setMnemonic(c);
    }

    @Override
    public void setValue(String value) {
        try {
            int integerValue = Integer.parseInt(value.trim());
            if (integerValue == 0 || integerValue == this.effectiveGroupValue) {
                this.setValue(integerValue != 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(int value) {
        if (value == 0 || value == this.effectiveGroupValue) {
            this.setValue(value == this.effectiveGroupValue);
        }
    }

    public void setValue(boolean value) {
        this.checkbox.setSelected(value);
        this.updateBorder();
    }

    @Override
    public String getValue() {
        return this.checkbox.isSelected() ? String.valueOf(this.effectiveGroupValue) : "0";
    }

    public boolean isBitmap() {
        return this.isStyle(32768);
    }

    public int getBitmap() {
        return this.isBitmap() ? 1 : 0;
    }

    public void setBitmap() {
        this.setStyleOn(32768);
    }

    public void setBitmap(boolean state) {
        this.setStyle(32768, state);
    }

    public boolean isSquare() {
        return this.isStyle(16384);
    }

    public int getSquare() {
        return this.isSquare() ? 1 : 0;
    }

    public void setSquare() {
        this.setStyleOn(16384);
    }

    public void setSquare(boolean state) {
        this.setStyle(16384, state);
    }

    public boolean isFramed() {
        return this.isStyle(8192);
    }

    public int getFramed() {
        return this.isFramed() ? 1 : 0;
    }

    public void setFramed() {
        this.setStyleOn(8192);
    }

    public void setFramed(boolean state) {
        this.setStyle(8192, state);
    }

    public boolean isUnframed() {
        return this.isStyle(4096);
    }

    public int getUnframed() {
        return this.isUnframed() ? 1 : 0;
    }

    public void setUnframed() {
        this.setStyleOn(4096);
    }

    public void setUnframed(boolean state) {
        this.setStyle(4096, state);
    }

    public boolean isFlat() {
        return this.isStyle(2048);
    }

    public int getFlat() {
        return this.isFlat() ? 1 : 0;
    }

    public void setFlat() {
        this.setStyleOn(2048);
    }

    public void setFlat(boolean state) {
        this.setStyle(2048, state);
    }

    public boolean isLeftText() {
        return this.isStyle(2);
    }

    public int getLeftText() {
        return this.isLeftText() ? 1 : 0;
    }

    public void setLeftText() {
        this.setStyleOn(2);
    }

    public void setLeftText(boolean state) {
        this.setStyle(2, state);
    }

    public boolean isNoGroupTab() {
        return this.isStyle(1);
    }

    public int getNoGroupTab() {
        return this.isNoGroupTab() ? 1 : 0;
    }

    public void setNoGroupTab() {
        this.setStyleOn(1);
    }

    public void setNoGroupTab(boolean state) {
        this.setStyle(1, state);
    }

    @Override
    public boolean isHandleNoTab() {
        if (this.isNoGroupTab()) {
            return super.isHandleNoTab();
        }
        if (this.checkbox != null && this.checkbox.isSelected()) {
            return super.isHandleNoTab();
        }
        if (this.group > 0) {
            return true;
        }
        return super.isHandleNoTab();
    }

    @Override
    protected boolean isHeightInPixels() {
        return this.isBitmap();
    }

    @Override
    protected boolean isWidthInPixels() {
        return this.isBitmap();
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 2) == 2) {
            if ((mask & 2) == 2) {
                this.setHorizontalTextPosition(2);
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalTextPosition(4);
                this.setHorizontalAlignment(2);
            }
        }
        if ((change & 0x800) == 2048) {
            if ((mask & 0x800) == 2048) {
                this.setBorder(this.defaultBorder);
                this.checkbox.setBorder(this.defaultCheckBoxBorder);
                if ((mask & 0x8000) != 0) {
                    this.adjustLines = 8;
                    this.adjustSize = 8;
                } else {
                    this.adjustLines = 2;
                    this.adjustSize = 0;
                }
            } else {
                this.setBorder(this.defaultBorder);
                this.checkbox.setBorder(this.defaultCheckBoxBorder);
                if ((mask & 0x8000) != 0) {
                    this.adjustLines = 8;
                    this.adjustSize = 8;
                } else {
                    this.adjustLines = 2;
                    this.adjustSize = 0;
                }
            }
        }
        boolean setup_bitmap = false;
        boolean clear_bitmap = false;
        if ((change & 0x8000) == 32768) {
            if ((mask & 0x8000) == 32768) {
                setup_bitmap = true;
                if (this.bitmapHandle == 0) {
                    this.setBitmapHandle(LBitmap.getDefaultBitmapHandle());
                }
            } else {
                clear_bitmap = true;
            }
        }
        super.setStyle(mask);
        if (setup_bitmap) {
            this.adjustLines = 8;
            this.adjustSize = 8;
            if (this.usingDefaultLines) {
                this.lines = 15.0;
            }
            if (this.usingDefaultSize) {
                this.size = 16.0;
            }
            this.recalculateSizes();
            this.checkbox.setMargin(new Insets(4, 4, 4, 4));
            this.checkbox.setText(null);
            this.recreateBitmap();
            this.updateBorder();
        } else if (clear_bitmap) {
            this.adjustLines = 2;
            this.adjustSize = 0;
            this.recalculateSizes();
            this.checkbox.setMargin(null);
            this.checkbox.setText(this.checkbox.getToolTipText());
            this.setBorder(null);
        }
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 3: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 4: {
                this.setBitmapHandle((Handle)property);
                break;
            }
            case 5: {
                this.setGroup(this.getInt(property));
                break;
            }
            case 6: {
                this.setGroupValue(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 3: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 4: {
                return String.valueOf(this.getBitmapHandle());
            }
            case 5: {
                return String.valueOf(this.getGroup());
            }
            case 6: {
                return String.valueOf(this.getGroupValue());
            }
        }
        return super.getProperty(number);
    }

    @Override
    public void setColumns(double size) {
        super.setColumns(size);
        this.recreateBitmap();
    }

    @Override
    public void setColumnsPixels(int size) {
        super.setColumnsPixels(size);
        this.recreateBitmap();
    }

    public void setBitmapNumber(int value) {
        this.bitmapNumber = value;
        this.recreateBitmap();
    }

    private void recreateBitmap() {
        if (!this.isBitmap()) {
            return;
        }
        if (this.bitmapComponent == null) {
            return;
        }
        if (this.recreating) {
            return;
        }
        this.recreating = true;
        try {
            if (this.usingDefaultLines) {
                this.lines = 15.0;
            }
            if (this.usingDefaultSize) {
                this.size = 16.0;
            }
            if (this.isFlat()) {
                this.adjustLines = 8;
                this.adjustSize = 8;
            } else {
                this.adjustLines = 8;
                this.adjustSize = 8;
            }
            this.bitmapIcon = new LBitmapIcon(this.bitmapComponent, this.bitmapNumber, (int)this.size);
            this.checkbox.setIcon(this.bitmapIcon);
            this.setBitmap();
            this.setLines(this.lines);
            this.setColumns(this.size);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.recreating = false;
        this.updateBorder();
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setBitmapHandle(int value) {
        try {
            this.bitmapHandle = value;
            this.setBitmapHandle(Handle.getHandle(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapHandle(Handle value) {
        try {
            if (value == null) {
                this.bitmapHandle = 0;
                this.bitmapComponent = null;
            } else {
                this.bitmapHandle = value.getHandleNumber();
                this.bitmapComponent = (LBitmap)value.getComponent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setBitmap();
        this.recreateBitmap();
    }

    public int getBitmapHandle() {
        return this.bitmapHandle;
    }

    public void setBitmapValue(String resourceName) {
        try {
            this.setBitmapValue(new LBitmap(resourceName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapValue(LBitmap component) {
        if (this.bitmapComponent != component) {
            this.bitmapComponent = component;
            Handle h = new Handle(this.bitmapComponent);
            this.bitmapHandle = h.getHandleNumber();
            this.setBitmap();
            this.recreateBitmap();
        }
    }

    public static ButtonGroup getButtonGroup(int value) {
        ButtonGroup theGroup = null;
        try {
            theGroup = buttonGroups.elementAt(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return theGroup;
    }

    public ButtonGroup getButtonGroup() {
        return LRadioButton.getButtonGroup(this.group);
    }

    public void setGroup(int value) {
        if (value < 0) {
            return;
        }
        int currentGroup = this.group;
        if (currentGroup != value) {
            if (buttonGroups.size() < value + 1) {
                buttonGroups.setSize(value + 1);
            }
            ButtonGroup theGroup = null;
            if (currentGroup > 0 && (theGroup = buttonGroups.elementAt(currentGroup)) != null) {
                theGroup.remove(this.checkbox);
            }
            this.group = value;
            if (this.group > 0) {
                boolean groupIsNew;
                theGroup = buttonGroups.elementAt(this.group);
                boolean bl = groupIsNew = theGroup == null;
                if (theGroup == null) {
                    theGroup = new ButtonGroup();
                    buttonGroups.setElementAt(theGroup, this.group);
                }
                theGroup.add(this.checkbox);
                if (groupIsNew) {
                    this.checkbox.setSelected(true);
                    this.updateBorder();
                }
            }
        }
    }

    public int getGroup() {
        return this.group >= 0 ? this.group : 1;
    }

    public void setGroupValue(int value) {
        this.groupValue = value;
        if (value == 0) {
            this.effectiveGroupValue = 1;
            this.groupInEffect = false;
        } else {
            this.effectiveGroupValue = value;
            this.groupInEffect = true;
        }
    }

    public int getGroupValue() {
        return this.groupValue;
    }

    public boolean isGroupValue() {
        return this.groupValue > 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.checkbox.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.checkbox.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.checkbox.getMaximumSize();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.checkbox.setPreferredSize(d);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.checkbox.setMinimumSize(d);
        super.setMinimumSize(d);
    }

    @Override
    public void setMaximumSize(Dimension d) {
        this.checkbox.setMaximumSize(d);
        super.setMaximumSize(d);
    }

    @Override
    public void setOpaque(boolean state) {
        this.checkbox.setOpaque(state);
        super.setOpaque(state);
    }

    public void setHorizontalAlignment(int v) {
        this.checkbox.setHorizontalAlignment(v);
        this.revalidateAndDisplay();
    }

    public void setVerticalAlignment(int v) {
        this.checkbox.setVerticalAlignment(v);
    }

    public int getHorizontalAlignment() {
        return this.checkbox.getHorizontalAlignment();
    }

    public int getVerticalAlignment() {
        return this.checkbox.getVerticalAlignment();
    }

    public void setHorizontalTextPosition(int v) {
        this.checkbox.setHorizontalTextPosition(v);
        this.checkbox.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.checkbox.getHorizontalTextPosition();
    }

    public void setVerticalTextPosition(int v) {
        this.checkbox.setVerticalTextPosition(v);
    }

    public int getVerticalTextPosition() {
        return this.checkbox.getVerticalTextPosition();
    }

    @Override
    public void setEnabled(boolean state) {
        this.checkbox.setEnabled(state);
        super.setEnabled(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.checkbox.setFont(f);
    }

    public void updateBorder() {
        if (this.isBitmap()) {
            if (this.checkbox.isSelected()) {
                this.setBorder(loweredBorder);
            } else {
                this.setBorder(this.isFlat() ? emptyBorder : raisedBorder);
            }
        } else {
            this.setBorder(null);
        }
    }
}

