/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class LSlider
extends LComponent
implements FocusListener,
ChangeListener,
KeyListener {
    private JSlider slider;

    public LSlider() {
        this.setLayout(new BorderLayout());
        this.slider = new JSlider(1);
        this.add("Center", this.slider);
        Dimension d = this.slider.getPreferredSize();
        int min = Math.min(d.width, d.height);
        this.minimumWidth = min + 4;
        this.minimumHeight = min + 4;
        this.lines = 1.0;
        this.size = 1.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (event.getModifiers() == 0) {
            int keyCode = event.getKeyCode();
            if (keyCode == 38) {
                return;
            }
            if (keyCode == 40) {
                return;
            }
            if (keyCode == 37) {
                return;
            }
            if (keyCode == 39) {
                return;
            }
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.updateValue();
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else if (this.isTrackThumb()) {
            if (this.slider.getValueIsAdjusting()) {
                this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16390, event, 0, this.slider.getValue()));
            }
        } else {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16389, event, 0, this.slider.getValue()));
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    public void addConstantListeners() {
        try {
            this.slider.addFocusListener(this);
            this.slider.addChangeListener(this);
            this.slider.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.slider.removeFocusListener(this);
            this.slider.removeChangeListener(this);
            this.slider.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.slider.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.slider.hasFocus();
    }

    @Override
    public int getControlType() {
        return 1000;
    }

    public JSlider getJSlider() {
        return this.slider;
    }

    @Override
    public int getUnitWidth() {
        return this.getCellWidth();
    }

    @Override
    public int getUnitHeight() {
        return this.getCellHeight();
    }

    @Override
    public void setCleanTitle(String s) {
        this.slider.setToolTipText(s);
    }

    @Override
    public void setValue(String s) {
        this.setValue(Integer.parseInt(s.trim()));
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    @Override
    public String getValue() {
        return String.valueOf(this.slider.getValue());
    }

    public void setMinVal(int value) {
        this.slider.setMinimum(value);
    }

    public void setMaxVal(int value) {
        this.slider.setMaximum(value);
    }

    public int getMinVal() {
        return this.slider.getMinimum();
    }

    public int getMaxVal() {
        return this.slider.getMaximum();
    }

    public boolean isHorizontal() {
        return this.isStyle(1);
    }

    public int getHorizontal() {
        return this.isHorizontal() ? 1 : 0;
    }

    public void setHorizontal() {
        this.setStyleOn(1);
    }

    public void setHorizontal(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isTrackThumb() {
        return this.isStyle(2);
    }

    public int getTrackThumb() {
        return this.isTrackThumb() ? 1 : 0;
    }

    public void setTrackThumb() {
        this.setStyleOn(2);
    }

    public void setTrackThumb(boolean state) {
        this.setStyle(2, state);
    }

    @Override
    public void setStyle(int mask) {
        int change = this.style ^ mask;
        if ((change & 1) == 1) {
            if ((mask & 1) == 1) {
                this.slider.setOrientation(0);
            } else {
                this.slider.setOrientation(1);
            }
        }
        super.setStyle(mask);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setMinVal(this.getInt(property));
                break;
            }
            case 2: {
                this.setMaxVal(this.getInt(property));
                break;
            }
            case 1000: {
                this.setPaintLabels(this.getInt(property));
                break;
            }
            case 1001: {
                this.setPaintTicks(this.getInt(property));
                break;
            }
            case 1002: {
                this.setPaintTrack(this.getInt(property));
                break;
            }
            case 1003: {
                this.setSnapToTicks(this.getInt(property));
                break;
            }
            case 1004: {
                this.setInverted(this.getInt(property));
                break;
            }
            case 1005: {
                this.setMajorTick(this.getInt(property));
                break;
            }
            case 1006: {
                this.setMinorTick(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getMinVal());
            }
            case 2: {
                return String.valueOf(this.getMaxVal());
            }
            case 1000: {
                return String.valueOf(this.getPaintLabels());
            }
            case 1001: {
                return String.valueOf(this.getPaintTicks());
            }
            case 1002: {
                return String.valueOf(this.getPaintTrack());
            }
            case 1003: {
                return String.valueOf(this.getSnapToTicks());
            }
            case 1004: {
                return String.valueOf(this.getInverted());
            }
            case 1005: {
                return String.valueOf(this.getMajorTick());
            }
            case 1006: {
                return String.valueOf(this.getMinorTick());
            }
        }
        return super.getProperty(number);
    }

    public void setPaintLabels(boolean state) {
        this.slider.setPaintLabels(state);
    }

    public void setPaintLabels(int value) {
        this.setPaintLabels(value != 0);
    }

    public void setPaintLabels(String value) {
        this.setPaintLabels(Integer.parseInt(value.trim()));
    }

    public int getPaintLabels() {
        return this.slider.getPaintLabels() ? 1 : 0;
    }

    public void setPaintTicks(boolean state) {
        this.slider.setPaintTicks(state);
    }

    public void setPaintTicks(int value) {
        this.setPaintTicks(value != 0);
    }

    public void setPaintTicks(String value) {
        this.setPaintTicks(Integer.parseInt(value.trim()));
    }

    public int getPaintTicks() {
        return this.slider.getPaintTicks() ? 1 : 0;
    }

    public void setPaintTrack(boolean state) {
        this.slider.setPaintTrack(state);
    }

    public void setPaintTrack(int value) {
        this.setPaintTrack(value != 0);
    }

    public void setPaintTrack(String value) {
        this.setPaintTrack(Integer.parseInt(value.trim()));
    }

    public int getPaintTrack() {
        return this.slider.getPaintTrack() ? 1 : 0;
    }

    public void setSnapToTicks(boolean state) {
        this.slider.setSnapToTicks(state);
    }

    public void setSnapToTicks(int value) {
        this.setSnapToTicks(value != 0);
    }

    public void setSnapToTicks(String value) {
        this.setSnapToTicks(Integer.parseInt(value.trim()));
    }

    public int getSnapToTicks() {
        return this.slider.getSnapToTicks() ? 1 : 0;
    }

    public void setInverted(boolean state) {
        this.slider.setInverted(state);
    }

    public void setInverted(int value) {
        this.setInverted(value != 0);
    }

    public void setInverted(String value) {
        this.setInverted(Integer.parseInt(value.trim()));
    }

    public int getInverted() {
        return this.slider.getInverted() ? 1 : 0;
    }

    public void setMajorTick(int value) {
        this.slider.setMajorTickSpacing(value);
    }

    public void setMajorTick(String value) {
        this.setMajorTick(Integer.parseInt(value.trim()));
    }

    public int getMajorTick() {
        return this.slider.getMajorTickSpacing();
    }

    public void setMinorTick(int value) {
        this.slider.setMinorTickSpacing(value);
    }

    public void setMinorTick(String value) {
        this.setMinorTick(Integer.parseInt(value.trim()));
    }

    public int getMinorTick() {
        return this.slider.getMinorTickSpacing();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.slider.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.slider.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.slider.getMaximumSize();
    }

    @Override
    public void setBackground(Color c) {
        this.slider.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.slider.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.slider.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.slider.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.slider.setEnabled(state);
        super.setEnabled(state);
    }
}

