/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.SpinnerListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.plaf.basic.BasicArrowButton;

final class LSpinner
extends LComponent
implements MouseListener,
SpinnerListener,
KeyListener {
    BasicArrowButton up;
    BasicArrowButton down;
    private int value;
    private int minimumValue;
    private int maximumValue;
    private boolean limits;
    private final Vector<SpinnerListener> spinnerListeners = new Vector();

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public boolean isAcceptable() {
        return false;
    }

    public Component getIncreaseComponent() {
        return this.up;
    }

    public Component getDecreaseComponent() {
        return this.down;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpinnerListener(SpinnerListener listener) {
        Vector<SpinnerListener> vector = this.spinnerListeners;
        synchronized (vector) {
            this.spinnerListeners.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpinnerListener(SpinnerListener listener) {
        Vector<SpinnerListener> vector = this.spinnerListeners;
        synchronized (vector) {
            this.spinnerListeners.removeElement(listener);
        }
    }

    public LSpinner() {
        this.setReverseOrder(false);
        this.setLayout(new GridLayout(2, 1));
        this.up = new BasicArrowButton(1);
        this.down = new BasicArrowButton(5);
        this.up.setPreferredSize(new Dimension(15, 16));
        this.down.setPreferredSize(new Dimension(15, 16));
        this.up.setMaximumSize(new Dimension(15, 16));
        this.down.setMaximumSize(new Dimension(15, 16));
        this.add(this.up);
        this.add(this.down);
        this.up.addMouseListener(this);
        this.down.addMouseListener(this);
        this.up.addKeyListener(this);
        this.down.addKeyListener(this);
    }

    public void setMinimumValue(int value) {
        this.minimumValue = value;
    }

    public void setMaximumValue(int value) {
        this.maximumValue = value;
    }

    public void setLimits(boolean state) {
        if (this.limits == state) {
            return;
        }
        this.limits = state;
        if (this.limits) {
            this.addSpinnerListener(this);
        } else {
            this.removeSpinnerListener(this);
        }
    }

    public void setLimits(int min, int max) {
        this.minimumValue = min;
        this.maximumValue = max;
        this.setLimits(true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.spinnerListeners == null) {
            return;
        }
        int size = 0;
        SpinnerListener listener = null;
        Vector<SpinnerListener> vector = this.spinnerListeners;
        synchronized (vector) {
            size = this.spinnerListeners.size();
        }
        try {
            boolean increase = event.getSource() == this.up;
            for (int i = 0; i < size; ++i) {
                Vector<SpinnerListener> vector2 = this.spinnerListeners;
                synchronized (vector2) {
                    listener = this.spinnerListeners.elementAt(i);
                }
                if (listener == null) continue;
                if (increase) {
                    listener.spinnerIncrease();
                    continue;
                }
                listener.spinnerDecrease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void spinnerIncrease() {
        ++this.value;
        if (this.value > this.maximumValue) {
            this.value = this.maximumValue;
        }
    }

    @Override
    public void spinnerDecrease() {
        --this.value;
        if (this.value < this.minimumValue) {
            this.value = this.minimumValue;
        }
    }

    @Override
    public int getControlType() {
        return 1005;
    }

    class SpinnerThread
    implements Runnable {
        private Vector<SpinnerListener> spinnerThreads = null;
        private boolean stopThread = true;
        private boolean increase = false;
        private int primaryDelay = 500;
        private int secondaryDelay = 100;

        public void setPrimaryDelay(int value) {
            this.primaryDelay = value;
        }

        public void setSecondaryDelay(int value) {
            this.secondaryDelay = value;
        }

        public int getPrimaryDelay() {
            return this.primaryDelay;
        }

        public int getSecondaryDelay() {
            return this.secondaryDelay;
        }

        public SpinnerThread(Vector<SpinnerListener> v) {
            this.spinnerThreads = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVector(Vector<SpinnerListener> v) {
            Vector<SpinnerListener> vector = this.spinnerThreads;
            synchronized (vector) {
                this.spinnerThreads = v;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SpinnerListener listener;
            int size;
            int delay;
            block16: {
                delay = this.primaryDelay;
                size = 0;
                listener = null;
                try {
                    Thread.sleep(this.secondaryDelay / 4);
                }
                catch (Exception e) {
                    if (!this.stopThread) break block16;
                    return;
                }
            }
            while (!this.stopThread) {
                if (this.spinnerThreads != null) {
                    Vector<SpinnerListener> e = this.spinnerThreads;
                    synchronized (e) {
                        size = this.spinnerThreads.size();
                    }
                    try {
                        for (int i = 0; i < size; ++i) {
                            Vector<SpinnerListener> vector = this.spinnerThreads;
                            synchronized (vector) {
                                listener = this.spinnerThreads.elementAt(i);
                            }
                            if (listener == null) continue;
                            if (this.increase) {
                                listener.spinnerIncrease();
                                continue;
                            }
                            listener.spinnerDecrease();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                delay = this.secondaryDelay;
            }
        }

        public void up() {
            this.increase = true;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        public void down() {
            this.increase = false;
            if (this.stopThread) {
                this.stopThread = false;
                ThreadQueue t = new ThreadQueue(this);
                t.start();
            }
        }

        public void nospin() {
            this.stopThread = true;
        }
    }
}

