/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.Handle;
import com.heirloomcomputing.ecs.jfc.LBitmap;
import com.heirloomcomputing.ecs.jfc.LBitmapIcon;
import com.heirloomcomputing.ecs.jfc.LComponent;
import com.heirloomcomputing.ecs.jfc.SJTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class LTabControl
extends LComponent
implements FocusListener,
ChangeListener,
KeyListener {
    public static final int CLIP_BOTTOM = 3;
    SJTabbedPane tabbedPane;
    private int tabIndex = 1;
    private int bitmapHandle;
    private int bitmapWidth = 16;
    private int bitmapNumber;
    private int useBitmapIndex = 1;
    public LBitmap bitmapComponent;
    private String tabToAdd = "";
    protected Color highlight = Color.lightGray;
    protected Color lightHighlight = Color.white;
    protected Color shadow = Color.darkGray;
    protected Color darkShadow = Color.black;

    public LTabControl() {
        this.tabbedPane = new SJTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "North");
        this.lines = 5.0;
        this.size = 12.0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode == 38) {
            return;
        }
        if (keyCode == 40) {
            return;
        }
        if (keyCode == 37) {
            return;
        }
        if (keyCode == 39) {
            return;
        }
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    public void addConstantListeners() {
        try {
            this.tabbedPane.addFocusListener(this);
            this.tabbedPane.addChangeListener(this);
            this.tabbedPane.addKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeConstantListeners() {
        try {
            this.tabbedPane.removeFocusListener(this);
            this.tabbedPane.removeChangeListener(this);
            this.tabbedPane.removeKeyListener(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.updateValue();
        if (this.exceptionValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 2, this.exceptionValue, event));
        } else if (this.terminationValue != 0) {
            this.processAcceptKey(new AcceptEvent(this.getHandle(), 1, this.terminationValue, event));
        } else {
            this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 7, event, this.tabbedPane.getSelectedIndex() + 1));
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public void requestChildFocus() {
        this.tabbedPane.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.tabbedPane.hasFocus();
    }

    public boolean isMultiline() {
        return this.isStyle(1);
    }

    public int getMultiline() {
        return this.isMultiline() ? 1 : 0;
    }

    public void setMultiline() {
        this.setStyleOn(1);
    }

    public void setMultiline(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isButtons() {
        return this.isStyle(2);
    }

    public int getButtons() {
        return this.isButtons() ? 1 : 0;
    }

    public void setButtons() {
        this.setStyleOn(2);
    }

    public void setButtons(boolean state) {
        this.setStyle(1, state);
    }

    public boolean isFixedWidth() {
        return this.isStyle(4);
    }

    public int getFixedWidth() {
        return this.isFixedWidth() ? 1 : 0;
    }

    public void setFixedWidth() {
        this.setStyleOn(1);
    }

    public void setFixedWidth(boolean state) {
        this.setStyle(1, state);
    }

    @Override
    public int getControlType() {
        return 10;
    }

    public void setValue(int value) {
        this.tabbedPane.setSelectedIndex(value - 1);
    }

    @Override
    public String getValue() {
        return String.valueOf(this.tabbedPane.getSelectedIndex() + 1);
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                this.setBitmapHandle(this.getInt(property));
                break;
            }
            case 2: {
                this.setBitmapWidth(this.getInt(property));
                break;
            }
            case 3: {
                this.setBitmapNumber(this.getInt(property));
                break;
            }
            case 4097: {
                this.setTabToAdd(this.getString(property));
                break;
            }
            case 4098: {
                this.setResetTabs(this.getInt(property));
                break;
            }
            case 4099: {
                this.setTabToDelete(this.getInt(property));
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getBitmapHandle());
            }
            case 2: {
                return String.valueOf(this.getBitmapWidth());
            }
            case 3: {
                return String.valueOf(this.getBitmapNumber());
            }
            case 4097: {
                return this.getTabToAdd();
            }
            case 4098: {
                return String.valueOf(this.getResetTabs());
            }
            case 4099: {
                return String.valueOf(this.getTabToDelete());
            }
        }
        return super.getProperty(number);
    }

    public void setBitmapHandle(int value) {
        try {
            this.bitmapHandle = value;
            this.setBitmapHandle(Handle.getHandle(value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapHandle(Handle value) {
        try {
            if (value == null) {
                this.bitmapHandle = 0;
                this.bitmapComponent = null;
            } else {
                this.bitmapHandle = value.getHandleNumber();
                this.bitmapComponent = (LBitmap)value.getComponent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getBitmapHandle() {
        return this.bitmapHandle;
    }

    public void setBitmapValue(String resourceName) {
        try {
            this.setBitmapValue(new LBitmap(resourceName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapValue(LBitmap component) {
        this.bitmapComponent = component;
    }

    public void setBitmapWidth(int value) {
        this.bitmapWidth = value;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setIconForTab(int iconNumber, int tabNumber) {
        try {
            this.tabbedPane.setIconAt(tabNumber - 1, new LBitmapIcon(this.bitmapComponent, iconNumber, this.bitmapWidth));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBitmapNumber(int value) {
        if (value == 1) {
            this.useBitmapIndex = 1;
        }
        this.bitmapNumber = value;
        this.setIconForTab(this.bitmapNumber, this.useBitmapIndex);
        ++this.useBitmapIndex;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public void setTabToAdd(String value) {
        if (value == null) {
            value = "";
        }
        try {
            this.tabToAdd = value;
            int index = value.indexOf(38);
            if (index >= 0) {
                try {
                    String left = "";
                    String right = "";
                    if (index > 0) {
                        left = value.substring(0, index);
                    }
                    if (index < value.length() - 1) {
                        right = value.substring(index + 1);
                    }
                    value = left + right;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (value.length() == 0) {
                value = "Tab " + this.tabIndex;
            }
            this.tabbedPane.addTab(value, null);
            this.setIconForTab(this.tabIndex, this.tabIndex);
            ++this.tabIndex;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTabToAdd() {
        return this.tabToAdd;
    }

    public void setTabToDelete(int value) {
        try {
            this.tabbedPane.removeTabAt(value - 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTabToDelete() {
        return 0;
    }

    public void setResetTabs(int value) {
        if (value > 0) {
            this.tabIndex = 1;
            int count = this.tabbedPane.getTabCount();
            for (int i = 0; i < count; ++i) {
                try {
                    this.tabbedPane.removeTabAt(i);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.useBitmapIndex = 1;
        }
    }

    public int getResetTabs() {
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.tabbedPane.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.tabbedPane.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.tabbedPane.getMaximumSize();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.tabbedPane.setPreferredSize(d);
        super.setPreferredSize(d);
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.tabbedPane.setMinimumSize(d);
        super.setMinimumSize(d);
    }

    @Override
    public void setMaximumSize(Dimension d) {
        this.tabbedPane.setMaximumSize(d);
        super.setMaximumSize(d);
    }

    @Override
    public void setBackground(Color c) {
        this.tabbedPane.setBackground(c);
        super.setBackground(c);
    }

    @Override
    public void setForeground(Color c) {
        this.tabbedPane.setForeground(c);
        super.setForeground(c);
    }

    @Override
    public void setOpaque(boolean state) {
        this.tabbedPane.setOpaque(state);
        super.setOpaque(state);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.tabbedPane.setFont(f);
    }

    @Override
    public void setEnabled(boolean state) {
        this.tabbedPane.setEnabled(state);
        super.setEnabled(state);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            Color oldColor = g.getColor();
            this.paintContentBorder(this, g, this.tabbedPane.getTabPlacement(), this.tabbedPane.getSelectedIndex());
            g.setColor(oldColor);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paintContentBorder(JComponent tabPane, Graphics g, int tabPlacement, int selectedIndex) {
        try {
            Dimension size = tabPane.getSize();
            int width = size.width;
            int height = size.height;
            Insets insets = tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int w = width - insets.right - insets.left;
            int h = height - insets.top - insets.bottom;
            int topheight = this.tabbedPane.getSize().height;
            y += topheight;
            h -= topheight;
            this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y -= 3, w, h += 3);
            this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.highlight = UIManager.getColor("TabbedPane.highlight");
        this.lightHighlight = UIManager.getColor("TabbedPane.lightHighlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
    }

    public void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.lightHighlight);
        g.drawLine(x, y, x + w - 2, y);
    }

    public void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.setColor(this.darkShadow);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
    }

    public void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.lightHighlight);
        g.drawLine(x, y, x, y + h - 2);
    }

    public void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
        g.setColor(this.darkShadow);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
    }
}

