/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

final class LTitledBorder
extends AbstractBorder {
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private Point textLoc = new Point();
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;

    public LTitledBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        this.title = title;
        this.border = border;
        this.titleFont = titleFont;
        this.titleColor = titleColor;
        this.setTitleJustification(titleJustification);
        this.setTitlePosition(titlePosition);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font2 = g.getFont();
        Color color2 = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = 0;
        String title = this.getTitle();
        if (title != null) {
            stringWidth = fm.stringWidth(title);
        }
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (width >= height) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                this.textLoc.x = grooveRect.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if (titlePos == 2 || titlePos == 5 || titlePos == 0) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                clipRect.setBounds(saveClip);
                if (LTitledBorder.computeIntersection(clipRect, x, y, this.textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (LTitledBorder.computeIntersection(clipRect, this.textLoc.x + stringWidth, 0, width - stringWidth - this.textLoc.x, height)) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                clipRect.setBounds(saveClip);
                if (titlePos == 2 || titlePos == 0) {
                    if (LTitledBorder.computeIntersection(clipRect, this.textLoc.x, grooveRect.y + insets.top, stringWidth, height - grooveRect.y - insets.top)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                } else if (LTitledBorder.computeIntersection(clipRect, this.textLoc.x, y, stringWidth, height - insets.bottom - (height - grooveRect.height - grooveRect.y))) {
                    g.setClip(clipRect);
                    border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.getTitleColor());
        if (title != null) {
            g.drawString(title, this.textLoc.x, this.textLoc.y);
        }
        g.setFont(font2);
        g.setColor(color2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        int descent = 0;
        int ascent = 16;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                ((AbstractBorder)border).getBorderInsets(c, insets);
            } else {
                Insets i = border.getBorderInsets(c);
                insets.top = i.top;
                insets.right = i.right;
                insets.bottom = i.bottom;
                insets.left = i.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        if (c == null) {
            return insets;
        }
        insets.left += 4;
        insets.right += 4;
        insets.top += 4;
        insets.bottom += 4;
        Font font2 = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font2);
        if (fm != null) {
            descent = fm.getDescent();
            ascent = fm.getAscent();
        }
        switch (this.getTitlePosition()) {
            case 1: {
                insets.top += ascent + descent + (Math.max(2, 4) - 2);
                break;
            }
            case 0: 
            case 2: {
                insets.top += ascent + descent;
                break;
            }
            case 3: {
                insets.top += ascent + descent + 2;
                break;
            }
            case 4: {
                insets.bottom += ascent + descent + 2;
                break;
            }
            case 5: {
                insets.bottom += ascent + descent;
                break;
            }
            case 6: {
                insets.bottom += ascent + 2;
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        Border b = this.border;
        if (b == null) {
            b = UIManager.getBorder("TitledBorder.border");
        }
        return b;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        Font f = this.titleFont;
        if (f == null) {
            f = UIManager.getFont("TitledBorder.font");
        }
        return f;
    }

    public Color getTitleColor() {
        Color c = this.titleColor;
        if (c == null) {
            c = UIManager.getColor("TitledBorder.titleColor");
        }
        return c;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int titlePosition) {
        switch (titlePosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = titlePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException(titlePosition + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int titleJustification) {
        switch (titleJustification) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = titleJustification;
                break;
            }
            default: {
                throw new IllegalArgumentException(titleJustification + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Dimension getMinimumSize(Component c) {
        Insets insets = this.getBorderInsets(c);
        Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font2 = this.getFont(c);
        FontMetrics fm = c.getFontMetrics(font2);
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                minSize.width = Math.max(fm.stringWidth(this.getTitle()), minSize.width);
                break;
            }
            default: {
                minSize.width += fm.stringWidth(this.getTitle());
            }
        }
        return minSize;
    }

    protected Font getFont(Component c) {
        Font font2 = this.getTitleFont();
        if (font2 != null) {
            return font2;
        }
        if (c != null && (font2 = c.getFont()) != null) {
            return font2;
        }
        return new Font("Dialog", 0, 12);
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

