/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.exec.AcceptEvent;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.jfc.LComponent;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public final class LWebBrowser
extends LComponent
implements KeyListener,
FocusListener {
    private JScrollPane scroller;
    private static String searchPage = "http://www.google.com";
    private static String homePage = "http://heirloom.cc";
    private static final int DEFAULT_HISTORY_SIZE = 25;
    private static final boolean INCLUDE_CONTROLS = false;
    private boolean busy;
    private String value;
    private Thread pageThread;
    private JButton back;
    private JButton forward;
    private JEditorPane viewer;
    private JTextField urlField;
    private URL[] history;
    private int historyPos;
    private String statusText = "";
    private int progress = 0;
    private int maxProgress = 100;

    public LWebBrowser(int historySize) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(600, 360));
        this.lines = 12.0;
        this.size = 40.0;
        this.history = new URL[historySize];
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setContentType("text/html");
        this.viewer.setBorder(new EtchedBorder());
        this.scroller = new JScrollPane(this.viewer);
        this.add("Center", this.scroller);
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.processKey(this, event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (!this.isSelfAct() && this.processGotoEvent(new AcceptEvent(this.getHandle(), 0, 3, event))) {
            return;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (this.processAcceptEvent(new AcceptEvent(this.getHandle(), 0, 16391, event))) {
            this.requestFocus();
            return;
        }
    }

    public void addConstantListeners() {
        this.viewer.addKeyListener(this);
        this.viewer.addFocusListener(this);
    }

    public void removeConstantListeners() {
        this.viewer.removeKeyListener(this);
        this.viewer.removeFocusListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addConstantListeners();
    }

    @Override
    public void removeNotify() {
        this.removeConstantListeners();
        super.removeNotify();
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public static void error(Throwable t) {
    }

    @Override
    public int getControlType() {
        return 15;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setValue(String urlString, boolean addToHistory) {
        try {
            URL url2 = null;
            try {
                url2 = new URL(urlString);
                this.value = urlString;
            }
            catch (Throwable t) {
                urlString = "http://" + urlString;
                url2 = new URL(urlString);
                this.value = urlString;
            }
            this.setValue(url2, addToHistory);
        }
        catch (Throwable t) {
            LWebBrowser.error(t);
        }
    }

    @Override
    public void setValue(String url2) {
        this.setValue(url2, true);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int getBusy() {
        return this.busy ? 1 : 0;
    }

    public void setBusy(int state) {
        this.busy = state == 1;
    }

    public String getType() {
        if (this.viewer != null) {
            return this.viewer.getContentType();
        }
        return "text/plain";
    }

    public LWebBrowser(URL url2) {
        this(25);
        this.setValue(url2, true);
    }

    public LWebBrowser(URL url2, int historySize) {
        this(historySize);
        this.setValue(url2, true);
    }

    public LWebBrowser() {
        this(25);
    }

    @Override
    public void requestChildFocus() {
        this.viewer.requestFocus();
    }

    @Override
    public boolean hasFocusChild() {
        return this.hasFocus() || this.viewer.hasFocus();
    }

    public void setValue(URL url2, boolean addToHistory) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        this.pageThread = new PageLoader(url2, addToHistory);
        this.pageThread.start();
    }

    private static void beep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void back() {
        if (this.historyPos <= 1) {
            LWebBrowser.beep();
        } else {
            this.setValue(this.history[--this.historyPos - 1], false);
        }
    }

    public void setGoBack(int value) {
        this.back();
    }

    public int getGoBack() {
        return 0;
    }

    public void forward() {
        if (this.history.length - this.historyPos <= 1) {
            LWebBrowser.beep();
        } else {
            URL url2 = this.history[this.historyPos];
            if (url2 == null) {
                LWebBrowser.beep();
            } else {
                ++this.historyPos;
                this.setValue(url2, false);
            }
        }
    }

    public void setGoForward(int value) {
        this.forward();
    }

    public int getGoForward() {
        return 0;
    }

    public void home() {
        String value = RuntimeEnvironment.getGlobalParameter("browser.home");
        if (value != null) {
            homePage = value;
        }
        this.setValue(homePage);
    }

    public void setGoHome(String value) {
        try {
            int integerValue = Integer.parseInt(value.trim());
            if (integerValue != 0) {
                this.home();
            }
        }
        catch (Exception e) {
            try {
                homePage = value;
                this.home();
            }
            catch (Exception e2) {
                this.home();
            }
        }
    }

    public void setGoHome(int value) {
        if (value != 0) {
            this.home();
        }
    }

    public int getGoHome() {
        return 0;
    }

    public void search() {
        String value = RuntimeEnvironment.getGlobalParameter("browser.search");
        if (value != null) {
            searchPage = value;
        }
        this.setValue(searchPage);
    }

    public void setGoSearch(String value) {
        try {
            int integerValue = Integer.parseInt(value.trim());
            if (integerValue != 0) {
                this.search();
            }
        }
        catch (Exception e) {
            try {
                searchPage = value;
                this.search();
            }
            catch (Exception e2) {
                this.search();
            }
        }
    }

    public void setGoSearch(int value) {
        if (value != 0) {
            this.search();
        }
    }

    public int getGoSearch() {
        return 0;
    }

    public void refresh() {
    }

    public void setRefresh(int value) {
        if (value != 0) {
            this.refresh();
        }
    }

    public void setRefresh() {
        this.refresh();
    }

    public int getRefresh() {
        return 0;
    }

    public void stop() {
    }

    public void setStop(int value) {
        if (value != 0) {
            this.stop();
        }
    }

    public void setStop() {
        this.stop();
    }

    public int getStop() {
        return 0;
    }

    @Override
    public int getUnitHeight() {
        return this.getCellHeight();
    }

    @Override
    public void setProperty(int number, Object property) {
        switch (number) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setStatusText(this.getString(property));
                break;
            }
            case 4: {
                this.setValue(this.getString(property));
                break;
            }
            case 5: {
                this.setProgress(this.getInt(property));
                break;
            }
            case 6: {
                this.setMaxProgress(this.getInt(property));
                break;
            }
            case 4097: {
                this.setGoBack(this.getInt(property));
                break;
            }
            case 4098: {
                this.setGoForward(this.getInt(property));
                break;
            }
            case 4099: {
                this.setGoHome(this.getString(property));
                break;
            }
            case 4100: {
                this.setGoSearch(this.getString(property));
                break;
            }
            case 4101: {
                this.setRefresh();
                break;
            }
            case 4102: {
                this.setStop();
                break;
            }
            default: {
                super.setProperty(number, property);
            }
        }
    }

    @Override
    public String getProperty(int number) {
        switch (number) {
            case 1: {
                return String.valueOf(this.getBusy());
            }
            case 2: {
                return this.getType();
            }
            case 3: {
                return this.getStatusText();
            }
            case 4: {
                return this.getValue();
            }
            case 5: {
                return String.valueOf(this.getProgress());
            }
            case 6: {
                return String.valueOf(this.getMaxProgress());
            }
            case 4097: {
                return String.valueOf(this.getGoBack());
            }
            case 4098: {
                return String.valueOf(this.getGoForward());
            }
            case 4099: {
                return String.valueOf(this.getGoHome());
            }
            case 4100: {
                return String.valueOf(this.getGoSearch());
            }
            case 4101: {
                return String.valueOf(this.getRefresh());
            }
            case 4102: {
                return String.valueOf(this.getStop());
            }
        }
        return super.getProperty(number);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int value) {
        this.progress = value;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int value) {
        this.maxProgress = value;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String value) {
        this.statusText = value;
    }

    public void setNavigateUrl(String value) {
        this.setValue(value);
    }

    public String getNavigateUrl() {
        return this.getValue();
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (event instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)LWebBrowser.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)event);
                } else {
                    URL url2 = event.getURL();
                    if (url2 != null) {
                        LWebBrowser.this.setValue(url2, true);
                    }
                }
            } else if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                LWebBrowser.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
                LWebBrowser.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 10) {
                try {
                    LWebBrowser.this.setValue(LWebBrowser.this.urlField.getText(), true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == LWebBrowser.this.back) {
                LWebBrowser.this.back();
            } else if (source == LWebBrowser.this.forward) {
                LWebBrowser.this.forward();
            }
        }
    }

    class PageLoader
    extends Thread {
        private URL url;
        private boolean addToHistory;

        public PageLoader(URL url2, boolean addToHistory) {
            this.setValues(url2, addToHistory);
        }

        public void setValues(URL url2, boolean addToHistory) {
            this.url = url2;
            this.addToHistory = addToHistory;
        }

        @Override
        public void run() {
            LWebBrowser.this.viewer.setCursor(Cursor.getDefaultCursor());
            try {
                String urlString = this.url.toString();
                if (LWebBrowser.this.urlField != null) {
                    LWebBrowser.this.urlField.setText(urlString);
                }
                LWebBrowser.this.viewer.setPage(this.url);
                if (this.addToHistory) {
                    ((LWebBrowser)LWebBrowser.this).history[((LWebBrowser)LWebBrowser.this).historyPos++] = this.url;
                    if (LWebBrowser.this.history.length == LWebBrowser.this.historyPos) {
                        System.arraycopy(LWebBrowser.this.history, 1, LWebBrowser.this.history, 0, LWebBrowser.this.history.length);
                    }
                    ((LWebBrowser)LWebBrowser.this).history[((LWebBrowser)LWebBrowser.this).historyPos] = null;
                }
            }
            catch (Throwable t) {
                LWebBrowser.error(t);
            }
            LWebBrowser.this.busy = false;
        }
    }
}

