/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import com.heirloomcomputing.ecs.jfc.LLabel;
import com.heirloomcomputing.ecs.jfc.SJLabel;
import com.heirloomcomputing.ecs.jfc.TextAndWidth;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

class SJLabelUI
extends BasicLabelUI {
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    SJLabelUI() {
    }

    protected String layoutCL(SJLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        this.layoutIt(label, fontMetrics, text, icon, viewR, iconR, textR);
        return text;
    }

    protected Vector<TextAndWidth> layoutIt(SJLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        boolean textIsEmpty;
        int hAlign = label.getHorizontalAlignment();
        int hTextPos = label.getHorizontalTextPosition();
        boolean justification = false;
        try {
            justification = ((LLabel)label.getParent()).isJustified();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        switch (hAlign) {
            case 10: {
                hAlign = 2;
                break;
            }
            case 11: {
                hAlign = 4;
            }
        }
        switch (hTextPos) {
            case 10: {
                hTextPos = 2;
                break;
            }
            case 11: {
                hTextPos = 4;
            }
        }
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean bl = textIsEmpty = text == null || text.equals("");
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
        } else {
            textR.width = 0;
            textR.height = label.getFont().getSize();
        }
        int gap = textIsEmpty || icon == null ? 0 : label.getIconTextGap();
        int horizontalTextPosition = label.getHorizontalTextPosition();
        int verticalTextPosition = label.getVerticalTextPosition();
        Vector<TextAndWidth> v = new Vector<TextAndWidth>();
        if (!textIsEmpty) {
            int textWidth = 0;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            int usedTextWidth = 0;
            String indi = null;
            String group = text;
            if (availTextWidth <= 0) {
                availTextWidth = 1;
            }
            do {
                indi = group;
                while (true) {
                    if (indi.length() > 0 && indi.charAt(0) == ' ' && v.size() > 0) {
                        indi = indi.substring(1);
                        group = group.substring(1);
                    }
                    if (justification) {
                        indi = indi.trim();
                    }
                    usedTextWidth = SwingUtilities.computeStringWidth(fontMetrics, indi);
                    if (indi.length() <= 1 || usedTextWidth <= availTextWidth) break;
                    int index = indi.lastIndexOf(32);
                    if (index >= 0) {
                        indi = indi.substring(0, index);
                        continue;
                    }
                    indi = indi.substring(0, indi.length() - 1);
                }
                if (usedTextWidth > textWidth) {
                    textWidth = usedTextWidth;
                }
                if (indi.length() <= 0) {
                    group = null;
                    continue;
                }
                group = group.substring(indi.length());
                v.addElement(new TextAndWidth(indi, usedTextWidth));
                if (group.length() != 0) continue;
                group = null;
            } while (group != null);
            textR.width = textWidth;
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dx = 0;
        int dy = 0;
        int verticalAlignment = label.getVerticalAlignment();
        int useHeight = viewR.height;
        int labelR_heights = labelR_height * v.size();
        dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + useHeight / 2 - (labelR_y + labelR_heights / 2) : viewR.y + useHeight - (labelR_y + labelR_heights));
        textR.height *= v.size();
        viewR.height *= v.size();
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return v;
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY, int mnemonic) {
        g.setColor(l.getForeground());
        BasicGraphicsUtils.drawString(g, s, mnemonic, textX, textY);
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY, int mnemonic) {
        Color background = l.getBackground();
        g.setColor(background.brighter());
        BasicGraphicsUtils.drawString(g, s, mnemonic, textX, textY);
        g.setColor(background.darker());
        BasicGraphicsUtils.drawString(g, s, mnemonic, textX + 1, textY + 1);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        try {
            Icon icon;
            SJLabel label = (SJLabel)c;
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            paintViewInsets = c.getInsets(paintViewInsets);
            SJLabelUI.paintViewR.x = SJLabelUI.paintViewInsets.left;
            SJLabelUI.paintViewR.y = SJLabelUI.paintViewInsets.top;
            SJLabelUI.paintViewR.width = c.getWidth() - (SJLabelUI.paintViewInsets.left + SJLabelUI.paintViewInsets.right);
            SJLabelUI.paintViewR.height = g.getFont().getSize() - (SJLabelUI.paintViewInsets.top + SJLabelUI.paintViewInsets.bottom);
            SJLabelUI.paintIconR.height = 0;
            SJLabelUI.paintIconR.width = 0;
            SJLabelUI.paintIconR.y = 0;
            SJLabelUI.paintIconR.x = 0;
            SJLabelUI.paintTextR.height = 0;
            SJLabelUI.paintTextR.width = 0;
            SJLabelUI.paintTextR.y = 0;
            SJLabelUI.paintTextR.x = 0;
            Vector<TextAndWidth> textVector = this.layoutIt(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            if (icon != null) {
                icon.paintIcon(c, g, SJLabelUI.paintIconR.x, SJLabelUI.paintIconR.y);
            }
            if (textVector != null) {
                int mnemonic;
                int ascent = fm.getAscent();
                int height = g.getFont().getSize();
                int textX = SJLabelUI.paintTextR.x;
                int textY = SJLabelUI.paintTextR.y + ascent;
                int offsetX = 0;
                int align = label.getHorizontalAlignment();
                int masterWidth = SJLabelUI.paintViewR.width;
                int mnemonic2 = mnemonic = label.getDisplayedMnemonic();
                mnemonic = Character.toUpperCase((char)mnemonic);
                mnemonic2 = Character.toLowerCase((char)mnemonic2);
                if (label.isEnabled()) {
                    int size = textVector.size();
                    for (int i = 0; i < size; ++i) {
                        TextAndWidth taw = textVector.elementAt(i);
                        String elem = taw.getText();
                        offsetX = 0;
                        if (align == 4) {
                            offsetX = masterWidth - taw.getWidth() - SJLabelUI.paintViewInsets.right;
                        } else if (align == 0) {
                            offsetX = (masterWidth - taw.getWidth()) / 2;
                        }
                        this.paintEnabledText(label, g, elem, textX + offsetX, textY + i * height - 1, mnemonic);
                        if (elem.indexOf(mnemonic) >= 0) {
                            mnemonic = 0;
                            continue;
                        }
                        if (elem.indexOf(mnemonic2) < 0) continue;
                        mnemonic = 0;
                    }
                } else {
                    int size = textVector.size();
                    for (int i = 0; i < size; ++i) {
                        TextAndWidth taw = textVector.elementAt(i);
                        String elem = taw.getText();
                        offsetX = 0;
                        if (align == 4) {
                            offsetX = masterWidth - taw.getWidth() - SJLabelUI.paintViewInsets.right;
                        } else if (align == 0) {
                            offsetX = (masterWidth - taw.getWidth()) / 2;
                        }
                        this.paintDisabledText(label, g, elem, textX, textY + i * height - 1, mnemonic);
                        if (elem.indexOf(mnemonic) >= 0) {
                            mnemonic = 0;
                            continue;
                        }
                        if (elem.indexOf(mnemonic2) < 0) continue;
                        mnemonic = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

