/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.jfc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

class SJTabbedPane
extends JTabbedPane
implements Serializable {
    private static final long serialVersionUID = 1L;

    SJTabbedPane() {
    }

    @Override
    public String getTitleAt(int index) {
        Component c;
        String title = null;
        try {
            title = super.getTitleAt(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (title == null && ((title = (c = this.getComponentAt(index)).getName()) == null || title.trim().length() == 0)) {
            return "Tab " + (index + 1);
        }
        return title;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (index < this.getTabCount()) {
            try {
                super.setSelectedIndex(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            BasicTabbedPaneUI ui = (BasicTabbedPaneUI)this.getUI();
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < 0) {
                selectedIndex = 0;
            }
            Rectangle r = ui.getTabBounds(this, selectedIndex);
            int clipBottom = 3;
            int height = r.height * this.getTabRunCount() + 5 + clipBottom;
            return new Dimension(r.width, height);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics g) {
        int clipBottom = 3;
        if (clipBottom <= 0) {
            super.paint(g);
            return;
        }
        Dimension size = this.getSize();
        Rectangle clip = g.getClipBounds();
        Rectangle set = null;
        int max = size.height - clipBottom;
        if (clip.y + clip.height > max) {
            set = new Rectangle(clip.x, clip.y, clip.width, clip.height);
            if ((max -= clip.y) < 0) {
                max = 0;
            }
            g.clipRect(clip.x, clip.y, clip.width, max);
        }
        super.paint(g);
        if (set != null) {
            g.setClip(set);
        }
    }
}

