/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.libcall.BytestreamFileHandler;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

class BytestreamRandomAccessFile
extends BytestreamFileHandler {
    RandomAccessFile raf = null;

    protected BytestreamRandomAccessFile(Object filename) {
        super(filename);
    }

    @Override
    public int close(boolean closeStream) {
        int result = super.close(closeStream);
        try {
            if (closeStream) {
                this.raf.close();
            }
            this.raf = null;
        }
        catch (IOException ioException) {
            result = 30;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public int createFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof RandomAccessFile) {
            this.raf = (RandomAccessFile)this.filename;
        } else {
            String filenameString = this.filenameString(this.filename);
            try {
                FileOutputStream fout = new FileOutputStream(filenameString);
                fout.close();
                try {
                    String rafMode = accessMode == 1 ? "r" : "rw";
                    this.raf = new RandomAccessFile(String.valueOf(this.filename), rafMode);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    result = 30;
                }
                catch (Throwable t2) {
                    result = 90;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                result = 30;
            }
            catch (IOException ioException) {
                result = 30;
            }
            catch (Throwable t) {
                result = 90;
            }
        }
        return result;
    }

    @Override
    public int openFile(int accessMode, int denyMode) {
        int result = 0;
        if (this.filename instanceof RandomAccessFile) {
            this.raf = (RandomAccessFile)this.filename;
        } else {
            String filenameString = this.filenameString(this.filename);
            try {
                String rafMode = accessMode == 1 ? "r" : "rw";
                this.raf = new RandomAccessFile(filenameString, rafMode);
            }
            catch (FileNotFoundException fileNotFoundException) {
                result = 30;
            }
            catch (Throwable t) {
                result = 90;
            }
        }
        return result;
    }

    @Override
    public int readFile(long offset, int length, byte[] buffer) {
        int result = 0;
        if (length <= 0) {
            length = buffer.length;
        }
        if (length > buffer.length) {
            length = buffer.length;
            result = 80;
        }
        try {
            if (offset >= 0L) {
                this.raf.seek(offset);
            }
            try {
                int count = this.raf.read(buffer, 0, length);
                if (count <= 0) {
                    result = 10;
                    count = 0;
                }
                while (count < length) {
                    buffer[count] = 32;
                    ++count;
                }
            }
            catch (IOException ioReadException) {
                result = 10;
            }
            catch (Throwable t2) {
                result = 90;
            }
        }
        catch (IOException ioException) {
            result = 10;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public int writeFile(long offset, int length, byte[] buffer) {
        int result = 0;
        if (length <= 0) {
            length = buffer.length;
        }
        if (length > buffer.length) {
            length = buffer.length;
            result = 91;
        }
        try {
            if (offset > 0L) {
                this.raf.seek(offset);
            }
            try {
                this.raf.write(buffer, 0, length);
            }
            catch (IOException ioWriteException) {
                result = 30;
            }
            catch (Throwable t2) {
                result = 90;
            }
        }
        catch (IOException ioException) {
            result = 30;
        }
        catch (Throwable t) {
            result = 90;
        }
        return result;
    }

    @Override
    public long length() {
        try {
            return this.raf.length();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    @Override
    public int flushFile() {
        int result = 0;
        try {
            this.raf.getFD().sync();
        }
        catch (Throwable t) {
            result = -1;
        }
        return result;
    }
}

