/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.api.IGenericBarcode;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.Exec;
import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.MediaAudio;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Shutdown;
import com.heirloomcomputing.ecs.exec.Utilities;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.exec.smartFile;
import com.heirloomcomputing.ecs.libcall.DefaultCall;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class C {
    public static final String DEFAULT_BARCODE_DRIVER_STRING = "com.heirloomcomputing.ecs.exec.BarcodeDragon";
    private static Class<?> defaultBarcodeDriver = null;

    public static class GETTOTALMEMORY
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            return new Numeric(Runtime.getRuntime().totalMemory());
        }
    }

    public static class GETFREEMEMORY
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            return new Numeric(Runtime.getRuntime().freeMemory());
        }
    }

    public static class BARCODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                IGenericBarcode barcode = null;
                for (int i = 0; i < paramSize - 1; i += 2) {
                    Object value;
                    String name;
                    if (param.isOmitted(i) || (name = param.getString(i)) == null) continue;
                    if (name.endsWith(".class")) {
                        name = name.substring(0, name.length() - 6);
                    }
                    if ((name = name.trim().toUpperCase().replace('-', '_').replace(' ', '_').replace('/', '.')).equals("DRIVER")) {
                        value = param.getString(i + 1);
                        if (value == null) continue;
                        String possibleValue = RuntimeEnvironment.getGlobalParameter((String)(value = ((String)value).trim()));
                        if (possibleValue != null) {
                            value = possibleValue.trim();
                        }
                        if ("DEFAULT".equals(value)) {
                            value = C.DEFAULT_BARCODE_DRIVER_STRING;
                        }
                        if ("DRAGON".equals(value)) {
                            value = C.DEFAULT_BARCODE_DRIVER_STRING;
                        }
                        try {
                            defaultBarcodeDriver = Class.forName((String)value);
                            continue;
                        }
                        catch (Throwable t) {
                            return new Numeric(-1);
                        }
                    }
                    if (barcode == null) {
                        if (defaultBarcodeDriver == null) {
                            try {
                                defaultBarcodeDriver = Class.forName(C.DEFAULT_BARCODE_DRIVER_STRING);
                            }
                            catch (Throwable t) {
                                return new Numeric(-2);
                            }
                        }
                        try {
                            barcode = (IGenericBarcode)defaultBarcodeDriver.newInstance();
                        }
                        catch (Throwable t) {
                            return new Numeric(-3);
                        }
                        if (barcode == null) {
                            return new Numeric(-4);
                        }
                    }
                    value = null;
                    try {
                        value = name.startsWith("COLOR_") || name.endsWith("_COLOR") ? ColorProvider.getColor(param.getString(i + 1)) : (name.startsWith("BOOL_") || name.startsWith("BOOLEAN_") || name.endsWith("_BOOL") || name.endsWith("_BOOLEAN") ? new Boolean(param.getBoolean(i + 1)) : (name.startsWith("INT_") || name.startsWith("INTEGER_") || name.endsWith("_INT") || name.endsWith("_INTEGER") ? new Integer(param.getInt(i + 1)) : (name.startsWith("DOUBLE_") || name.endsWith("_DOUBLE") ? new Double(param.getDouble(i + 1)) : param.getDisplayString(i + 1))));
                        barcode.setProperty(name, value);
                        continue;
                    }
                    catch (Throwable t) {
                        return new Numeric(-5);
                    }
                }
                if (barcode != null) {
                    return barcode.getObject();
                }
                return new Numeric(-6);
            }
            return new Numeric(-7);
        }
    }

    public static class WRU
    extends DefaultCall {
    }

    public static class TITLE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            try {
                if (param != null) {
                    Utilities.setTitle(param.getDisplayString(0));
                    return new Numeric(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Numeric(-1);
        }
    }

    public static class TBARSEQ
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                for (int i = 0; i < paramSize; i += 2) {
                    if (i >= paramSize - 1) continue;
                    throw new RuntimeException("C$TBARSEQ not supported");
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class TBAREN
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null) {
                int paramSize = param.size();
                for (int i = 0; i < paramSize; i += 2) {
                    if (i >= paramSize - 1) continue;
                    throw new RuntimeException("C$TBAREN not supported");
                }
                return new Numeric(0);
            }
            return new Numeric(-1);
        }
    }

    public static class TBAR
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            int paramSize;
            if (param != null && (paramSize = param.size()) > 0) {
                throw new RuntimeException("C$TBAR not supported");
            }
            return new Numeric(0);
        }
    }

    public static class SHOWARGS
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            int numArgs = 0;
            if (param != null) {
                numArgs = param.size();
            }
            System.out.println("Name=\"C$SHOWARGS\", Args= " + numArgs);
            System.out.println("");
            for (int i = 0; i < numArgs; ++i) {
                Variable v = param.getVariable(i);
                System.out.print(" Arg # " + i + " ");
                if (v != null) {
                    if (v instanceof Numeric) {
                        System.out.print("NUMERIC ");
                        System.out.print(" Size : " + v.length());
                        System.out.print(" Usage: " + v.getUsage());
                        System.out.print(" Place: " + v.getPlace());
                        System.out.print(" Scale: " + v.getScale());
                    } else {
                        System.out.print("NON-NUMERIC");
                        System.out.print(" Size : " + v.length());
                        System.out.print(" Usage: " + v.getUsage());
                        System.out.print(" Place: " + v.getPlace());
                        System.out.print(" Scale: " + v.getScale());
                    }
                } else {
                    Object o = param.getObject(i);
                    if (o != null) {
                        System.out.print("OBJECT");
                    } else {
                        System.out.print("OMITTED");
                    }
                }
                System.out.println("");
            }
            if (numArgs > 0) {
                System.out.println("");
            }
            return new Numeric(0);
        }
    }

    public static class SHOW
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            Frame f;
            if (param != null && param.size() >= 1 && (f = Utilities.getFrame()) != null) {
                switch (param.getInt(0)) {
                    case 0: {
                        if (f == null) break;
                        f.setVisible(false);
                        break;
                    }
                    case 1: {
                        if (f == null) break;
                        f.setVisible(true);
                        break;
                    }
                    case 2: {
                        if (f != null) {
                            f.setVisible(true);
                        }
                        try {
                            Class[] cparams = new Class[]{Integer.TYPE};
                            Method m = Frame.class.getMethod("setState", cparams);
                            if (m == null) break;
                            Object[] oparams = new Object[]{new Integer(1)};
                            m.invoke((Object)f, oparams);
                        }
                        catch (Throwable cparams) {}
                        break;
                    }
                    case 3: {
                        if (f != null) {
                            f.setVisible(true);
                        }
                        try {
                            Class[] cparams = new Class[]{Integer.TYPE};
                            Method m = Frame.class.getMethod("setState", cparams);
                            if (m == null) break;
                            Object[] oparams = new Object[]{new Integer(0)};
                            m.invoke((Object)f, oparams);
                        }
                        catch (Throwable cparams) {}
                        break;
                    }
                    case 4: {
                        if (f == null) break;
                        f.setVisible(true);
                        break;
                    }
                    case 5: {
                        if (f == null) break;
                        f.setVisible(true);
                        break;
                    }
                    case 6: {
                        try {
                            Class[] cparams = new Class[]{Integer.TYPE};
                            Method m = Frame.class.getMethod("setState", cparams);
                            if (m == null) break;
                            Object[] oparams = new Object[]{new Integer(1)};
                            m.invoke((Object)f, oparams);
                        }
                        catch (Throwable cparams) {}
                        break;
                    }
                    case 7: {
                        if (f == null) break;
                        f.setVisible(true);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        try {
                            Class[] cparams = new Class[]{Integer.TYPE};
                            Method m = Frame.class.getMethod("setState", cparams);
                            if (m == null) break;
                            Object[] oparams = new Object[]{new Integer(0)};
                            m.invoke((Object)f, oparams);
                        }
                        catch (Throwable throwable) {}
                        break;
                    }
                    case 10: {
                        if (f == null) break;
                        f.toFront();
                        break;
                    }
                    case 11: {
                        if (f == null) break;
                        f.toBack();
                    }
                }
            }
            return new Numeric(0);
        }
    }

    public static class SETSYN
    extends DefaultCall {
    }

    public static class SETENV
    extends DefaultCall {
    }

    public static class SETDEVELOPMENTMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            Utilities.setDevelopmentMode(true);
            return new Numeric(0);
        }
    }

    public static class SCWR
    extends DefaultCall {
    }

    public static class SCRD
    extends DefaultCall {
    }

    public static class SBAR
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            String statusBarText;
            if (param != null && param.size() >= 1 && (statusBarText = param.getDisplayString(0)) != null) {
                throw new RuntimeException("C$SBAR not supported");
            }
            return new Numeric(-1);
        }
    }

    public static class RBMENU
    extends DefaultCall {
    }

    public static class PLAYSOUND
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                String soundName = param.getString(0).trim();
                if (soundName.length() == 0) {
                    soundName = null;
                }
                int soundFlags = 0;
                if (param.size() >= 2) {
                    soundFlags = param.getInt(1);
                }
                if (MediaAudio.playSound(soundName, soundFlags)) {
                    return new Numeric(1);
                }
                return new Numeric();
            }
            return new Numeric();
        }
    }

    public static class OSLOCKINFO
    extends DefaultCall {
    }

    public static class MEMORYDEALLOCATE
    extends DefaultCall {
    }

    public static class MEMORYALLOCATE
    extends DefaultCall {
    }

    public static class MBAR
    extends DefaultCall {
    }

    public static class GUICFG
    extends DefaultCall {
    }

    public static class GETSYSINFO
    extends DefaultCall {
    }

    public static class GETSYN
    extends DefaultCall {
    }

    public static class GETRMINFO
    extends DefaultCall {
    }

    public static class GETLASTFILEOP
    extends DefaultCall {
    }

    public static class GETLASTFILENAME
    extends DefaultCall {
    }

    public static class GETENV
    extends DefaultCall {
    }

    public static class FORGET
    extends DefaultCall {
    }

    public static class DELAY
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                int seconds = param.getInt(0);
                try {
                    Thread.sleep(seconds * 1000);
                }
                catch (Throwable t) {
                    return new Numeric(-2);
                }
                return new Numeric(0);
            }
            return new Numeric(0);
        }
    }

    public static class CLEARDEVELOPMENTMODE
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            Utilities.setDevelopmentMode(false);
            return new Numeric(0);
        }
    }

    public static class CENTURY
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            Calendar cal = Calendar.getInstance();
            int century = cal.get(1);
            if (param != null && param.size() >= 1) {
                param.set(0, century);
            }
            return new Numeric(century);
        }
    }

    public static class CARG
    extends DefaultCall {
    }

    public static class BTRV
    extends DefaultCall {
    }

    public static class BITMAP
    extends DefaultCall {
        @Override
        public Object callGiving(parameterList param) {
            String filename;
            if (param != null && param.size() >= 1 && (filename = param.getString(0)) != null) {
                Image image = MediaImage.getImage(filename);
                if (image != null) {
                    Utilities.setIconImage(image);
                    return new Numeric(0);
                }
                return new Numeric(-2);
            }
            return new Numeric(-1);
        }
    }

    public static class TOLOWER
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() > 1) {
                int i;
                String text = param.getString(0);
                StringBuffer result = new StringBuffer(text.length());
                int length = param.getInt(1);
                for (i = 0; i < length; ++i) {
                    result.append(Character.toLowerCase(text.charAt(i)));
                }
                for (i = length; i < text.length(); ++i) {
                    result.append(text.charAt(i));
                }
                String resultString = result.toString();
                param.set(0, resultString);
                return new Variable(resultString);
            }
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class TOUPPER
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() > 1) {
                int i;
                String text = param.getString(0);
                StringBuffer result = new StringBuffer(text.length());
                int length = param.getInt(1);
                for (i = 0; i < length; ++i) {
                    result.append(Character.toUpperCase(text.charAt(i)));
                }
                for (i = length; i < text.length(); ++i) {
                    result.append(text.charAt(i));
                }
                String resultString = result.toString();
                param.set(0, resultString);
                return new Variable(resultString);
            }
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class SYSTEM
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                try {
                    int flags = 0;
                    if (param.size() >= 2) {
                        flags = param.getInt(1);
                    }
                    if (!(flags & true)) {
                        int returnCode = Exec.execWait(param.getString(0).trim());
                        return new Variable(String.valueOf(returnCode));
                    }
                    int returnCode = Exec.exec(param.getString(0).trim());
                    return new Numeric(returnCode);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new Variable("-1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class SLEEP
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            double time = 1.0;
            String result = "1";
            if (param != null && param.size() > 0) {
                time = param.getDouble(0);
            }
            try {
                Thread.sleep((long)(time * 1000.0));
            }
            catch (Exception sleepException) {
                result = "0";
            }
            return new Variable(result);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class RUN
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                try {
                    int returnCode = Exec.exec(param.getString(0).trim());
                    return new Numeric(returnCode);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new Variable("-1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class RERRNAME
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                String rerrName = Utilities.getLastUsedFileName();
                if (rerrName == null) {
                    rerrName = " ";
                }
                param.set(0, rerrName);
            }
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class RERR
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 3) {
                param.set(0, " ");
                param.set(1, " ");
            }
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class RECOVER
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            throw new RuntimeException("C$RECOVER not implemented.");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class PARAMSIZE
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            throw new RuntimeException("Obsolete, use declare SIZE IN numeric-id in PROCEDURE DIVISION USING to obtain paramsize.");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class OPENSAVEBOX
    implements ICallableProgramGiving {
        public static final int OPENSAVE_SUPPORTED = 1;
        public static final int OPENSAVE_OPEN_BOX = 2;
        public static final int OPENSAVE_SAVE_BOX = 3;
        public static final int OPENSAVERR_UNSUPPORTED = 0;
        public static final int OPENSAVERR_CANCELLED = -1;
        public static final int OPENSAVERR_NO_MEMORY = -2;
        public static final int OPENSAVERR_NAME_TOO_LARGE = -3;

        private static String trim(String s) {
            if (s == null) {
                return null;
            }
            if ((s = s.trim()).length() == 0) {
                return null;
            }
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                if (s.charAt(i) == '\u0000') continue;
                return s;
            }
            return null;
        }

        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 2) {
                int opcode = param.getInt(0);
                if (opcode == 1) {
                    return new Numeric(1);
                }
                Variable vFilename = null;
                Variable vFlags = null;
                Variable vDefaultExt = null;
                Variable vTitle = null;
                Variable vFilters = null;
                Variable vDefaultFilter = null;
                Variable vDefaultDir = null;
                Variable vBasename = null;
                String opensavFilename = null;
                String opensavDefaultExt = null;
                String opensavTitle = null;
                String opensavDefaultDir = null;
                Variable vSaveData = param.getVariable(1);
                try {
                    if (vSaveData != null) {
                        vFilename = vSaveData.getChild();
                        vFlags = vFilename.getSibling();
                        vDefaultExt = vFlags.getSibling();
                        vTitle = vDefaultExt.getSibling();
                        vFilters = vTitle.getSibling();
                        vDefaultFilter = vFilters.getSibling();
                        vDefaultDir = vDefaultFilter.getSibling();
                        vBasename = vDefaultDir.getSibling();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    opensavFilename = vFilename.toString();
                    opensavDefaultExt = vDefaultExt.toString();
                    opensavTitle = vTitle.toString();
                    opensavDefaultDir = vDefaultDir.toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (opensavFilename != null) {
                    opensavFilename = OPENSAVEBOX.trim(opensavFilename);
                }
                if (opensavDefaultDir != null) {
                    opensavDefaultDir = OPENSAVEBOX.trim(opensavDefaultDir);
                }
                if (opensavTitle != null) {
                    opensavTitle = OPENSAVEBOX.trim(opensavTitle);
                }
                if (opensavDefaultExt != null) {
                    opensavDefaultExt = OPENSAVEBOX.trim(opensavDefaultExt);
                }
                if (opensavDefaultDir == null) {
                    try {
                        opensavDefaultDir = RuntimeEnvironment.getGlobalParameter("user.dir");
                        if (!new File(opensavDefaultDir).exists()) {
                            opensavDefaultDir = null;
                        }
                    }
                    catch (Throwable t) {
                        opensavDefaultDir = null;
                    }
                }
                if (opensavTitle == null) {
                    opensavTitle = opcode == 2 ? "Open File..." : "Save File As...";
                }
                if (opensavFilename == null && opensavDefaultExt != null) {
                    opensavFilename = "*." + opensavDefaultExt;
                }
                int type = opcode == 2 ? 0 : 1;
                String opensavDirectory = opensavDefaultDir;
                try {
                    String defaultFilename = opensavFilename;
                    opensavFilename = " ";
                    Frame fileDialogFrame = new Frame(opensavTitle);
                    FileDialog fileDialog = new FileDialog(fileDialogFrame, opensavTitle, type);
                    fileDialog.setTitle(opensavTitle);
                    if (opensavDefaultDir != null) {
                        fileDialog.setDirectory(opensavDefaultDir);
                    }
                    if (defaultFilename != null) {
                        fileDialog.setFile(defaultFilename);
                    }
                    fileDialog.setVisible(true);
                    opensavFilename = fileDialog.getFile();
                    opensavDirectory = fileDialog.getDirectory();
                    fileDialogFrame.dispose();
                    fileDialogFrame = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (opensavFilename == null) {
                    return new Numeric(-1);
                }
                try {
                    if (opensavFilename.length() > vBasename.length()) {
                        return new Numeric(-3);
                    }
                    if (vBasename != null) {
                        vBasename.move(opensavFilename);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (opensavDirectory == null) {
                        opensavDirectory = opensavDefaultDir;
                    }
                    if (opensavDirectory == null) {
                        opensavDirectory = RuntimeEnvironment.getGlobalParameter("user.dir");
                    }
                    if (!opensavDirectory.endsWith(File.separator)) {
                        opensavDirectory = opensavDirectory + File.separator;
                    }
                    if ((opensavDirectory = opensavDirectory + opensavFilename).length() > vFilename.length()) {
                        return new Numeric(-3);
                    }
                    if (vFilename != null) {
                        vFilename.move(opensavDirectory);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new Numeric(1);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class NARG
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() > 0) {
                int narg = Variable.getNarg();
                if (narg < 0) {
                    narg = RuntimeEnvironment.getGlobalRuntimeEnvironment().getArgumentCount();
                }
                param.set(0, narg);
                return new Numeric(narg);
            }
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class MEMCPY
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class MAKEDIR
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            try {
                if (param != null && param.size() >= 1) {
                    String dirName = smartFile.convertFilename(param.getString(0).trim());
                    File f = new File(dirName);
                    if (!f.mkdirs() && !f.mkdirs()) {
                        return new Numeric(1);
                    }
                    return new Numeric();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Numeric(1);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class LOCKPID
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class LOCALPRINT
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class KEYMAP
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class JUSTIFY
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            String result = "";
            if (param != null && param.size() >= 1) {
                int justify = 82;
                if (param.size() >= 2) {
                    justify = param.getChar(1);
                }
                String dataItem = param.getString(0);
                int length = dataItem.length();
                if (dataItem != null) {
                    dataItem = dataItem.trim();
                    switch (justify) {
                        case 76: {
                            result = dataItem;
                            break;
                        }
                        case 67: {
                            result = Variable.all(' ', (length - dataItem.length()) / 2) + dataItem;
                            break;
                        }
                        default: {
                            result = Variable.all(' ', length - dataItem.length()) + dataItem;
                        }
                    }
                    param.set(0, result);
                }
            }
            return new Variable(result);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class GETCGI
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            int size = -1;
            try {
                if (param != null && param.size() >= 2) {
                    String name = param.getString(0).trim();
                    String value = RuntimeEnvironment.getGlobalParameter(name);
                    param.set(1, value);
                    size = value.length();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Numeric(size);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class FULLNAME
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 3) {
                try {
                    File f = new File(param.getString(0).trim());
                    if (!f.exists()) {
                        return new Variable("1");
                    }
                    param.set(1, f.getCanonicalPath());
                    long lastModified = f.lastModified();
                    Date last = new Date(lastModified);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(last);
                    int cen = cal.get(1);
                    int month = cal.get(2) + 1;
                    int date = cal.get(5);
                    int hour = cal.get(10);
                    int min = cal.get(12);
                    int sec = cal.get(13);
                    long file_date = cen * 10000 + month * 100 + date;
                    long file_time = hour * 1000000 + min * 10000 + sec * 100;
                    long file_size = f.length();
                    try {
                        Variable file_info = param.getVariable(2);
                        Variable fileSize = file_info.getChild();
                        Variable fileDate = fileSize.getSibling();
                        Variable fileTime = fileDate.getSibling();
                        fileSize.move(file_size);
                        fileDate.move(file_date);
                        fileTime.move(file_time);
                    }
                    catch (Exception e) {
                        int i;
                        int length = param.getSize(2);
                        length -= 8;
                        byte[] result = new byte[8 + (length /= 2) * 2];
                        for (i = 0; i < 8; ++i) {
                            result[i] = (byte)(file_size & 0xFFL);
                            file_size >>= 8;
                        }
                        for (i = 0; i < length; ++i) {
                            result[8 + i] = (byte)(file_date & 0xFFL);
                            file_date >>= 8;
                            result[8 + length + i] = (byte)(file_time & 0xFFL);
                            file_time >>= 8;
                        }
                        param.set(2, new Variable(result));
                    }
                    return new Variable("0");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Variable("1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class FILESYS
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            return null;
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class FILEINFO
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 2) {
                try {
                    File f = new File(param.getString(0).trim());
                    if (!f.exists()) {
                        return new Variable("1");
                    }
                    long lastModified = f.lastModified();
                    Date last = new Date(lastModified);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(last);
                    int cen = cal.get(1);
                    int month = cal.get(2) + 1;
                    int date = cal.get(5);
                    int hour = cal.get(10);
                    int min = cal.get(12);
                    int sec = cal.get(13);
                    long file_date = cen * 10000 + month * 100 + date;
                    long file_time = hour * 1000000 + min * 10000 + sec * 100;
                    long file_size = f.length();
                    try {
                        Variable file_info = param.getVariable(1);
                        Variable fileSize = file_info.getChild();
                        Variable fileDate = fileSize.getSibling();
                        Variable fileTime = fileDate.getSibling();
                        fileSize.move(file_size);
                        fileDate.move(file_date);
                        fileTime.move(file_time);
                    }
                    catch (Exception e) {
                        int i;
                        int length = param.getSize(1);
                        length -= 8;
                        byte[] result = new byte[8 + (length /= 2) * 2];
                        for (i = 0; i < 8; ++i) {
                            result[i] = (byte)(file_size & 0xFFL);
                            file_size >>= 8;
                        }
                        for (i = 0; i < length; ++i) {
                            result[8 + i] = (byte)(file_date & 0xFFL);
                            file_date >>= 8;
                            result[8 + length + i] = (byte)(file_time & 0xFFL);
                            file_time >>= 8;
                        }
                        param.set(1, new Variable(result));
                    }
                    return new Variable("0");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Variable("1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class DELETE
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            try {
                String filename;
                File f;
                if (param != null && param.size() >= 1 && (f = new File(filename = param.getString(0))).exists()) {
                    f.delete();
                    return new Numeric();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Numeric(1);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class COPY
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 2) {
                String sourceFilename = param.getString(0).trim();
                String destFilename = param.getString(1).trim();
                Utilities.copy(sourceFilename, destFilename);
                return new Variable("0");
            }
            return new Variable("1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class CHDIR
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            int errorNumber = 1;
            if (param != null && param.size() >= 1) {
                String dirName = param.getString(0);
                if (dirName != null) {
                    dirName = dirName.trim();
                }
                if (dirName == null || dirName.length() == 0) {
                    param.set(0, RuntimeEnvironment.getGlobalParameter("USER.DIR"));
                    errorNumber = 0;
                } else if (new File(dirName).exists()) {
                    try {
                        RuntimeEnvironment.setGlobalParameter("USER.DIR", dirName);
                        Properties props = System.getProperties();
                        props.put("user.dir", dirName);
                        System.setProperties(props);
                    }
                    catch (Throwable t) {
                        errorNumber = 2;
                    }
                } else {
                    errorNumber = 3;
                }
                if (param.size() >= 2) {
                    param.set(1, errorNumber);
                }
            }
            return new Variable(String.valueOf(errorNumber));
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class CHAIN
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param != null && param.size() >= 1) {
                try {
                    Process p = Runtime.getRuntime().exec(param.getString(0).trim());
                    Shutdown.exit();
                    return new Numeric(p.exitValue());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return new Variable("-1");
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class CALLERR
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            int failCode = Context.getCallPriorFailCode();
            if (param != null && param.size() >= 1) {
                param.set(0, failCode);
                if (param.size() >= 2) {
                    param.set(1, Context.getCallFailMessage(failCode));
                }
            }
            return new Variable(String.valueOf(failCode));
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }

    public static class CALLEDBY
    implements ICallableProgramGiving {
        @Override
        public Object callGiving(parameterList param) {
            if (param.size() >= 1) {
                param.set(0, " ");
            }
            return new Numeric(-1);
        }

        @Override
        public Object callGiving() {
            return this.callGiving(null);
        }

        @Override
        public void call() {
            this.call(null);
        }

        @Override
        public void call(parameterList param) {
            this.callGiving(param);
        }

        @Override
        public void cancel() {
        }

        @Override
        public String redirectCall() {
            return null;
        }
    }
}

