/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.libcall;

import com.heirloomcomputing.ecs.exec.ICallableProgramGiving;
import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.parameterList;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class CEEDAYS
implements ICallableProgramGiving {
    public static final List<String> dateFormatterList = new ArrayList<String>();

    @Override
    public void call(parameterList param) {
        this.callGiving(param);
    }

    @Override
    public Object callGiving() {
        return "";
    }

    @Override
    public void call() {
    }

    @Override
    public Object callGiving(parameterList param) {
        int statuscode;
        block11: {
            statuscode = 0;
            try {
                if (param.getLength() == 4) {
                    LocalDate lilianDate = LocalDate.of(1582, Month.OCTOBER, 14);
                    String dateString = param.getVariable(0).toString();
                    String dateFormat = param.getVariable(1).toString();
                    if (dateString == null) {
                        this.setStatus(param, "CEE2EC");
                        statuscode = 2;
                    }
                    if (dateFormat == null) {
                        this.setStatus(param, "CEE2EM");
                        statuscode = 2;
                    }
                    if (statuscode == 2) {
                        return new Integer(statuscode);
                    }
                    if (dateFormat.equalsIgnoreCase("YYDDD")) {
                        dateFormat = "yyD";
                    }
                    for (String formatterPattern : dateFormatterList) {
                        if (!dateFormat.toLowerCase().contains(formatterPattern.toLowerCase())) continue;
                        dateFormat = formatterPattern;
                        break;
                    }
                    try {
                        LocalDate parsedDate = LocalDate.parse(dateString.trim(), DateTimeFormatter.ofPattern(dateFormat));
                        int currentYear = Calendar.getInstance().get(1);
                        if (currentYear + 20 < parsedDate.getYear()) {
                            parsedDate = parsedDate.minusYears(100L);
                        }
                        param.set(2, new Variable(ChronoUnit.DAYS.between(lilianDate, parsedDate)));
                        statuscode = 0;
                    }
                    catch (DateTimeParseException e) {
                        LogSetup.LOGGER.warning("CEEDAYS DateTimeParseException " + e.getMessage());
                        this.setStatus(param, "CEE2EM");
                        statuscode = 2;
                    }
                    this.setStatus(param, "CEE000");
                    break block11;
                }
                statuscode = 2;
            }
            catch (Exception e) {
                LogSetup.LOGGER.warning("CEEDAYS exception " + e.getMessage());
                this.setStatus(param, "CEE2EC");
                statuscode = 2;
            }
        }
        return new Integer(statuscode);
    }

    private void setStatus(parameterList param, String status) {
        for (Variable child : param.getVariable(3).getChildrenWithArrayElementsAsItems()) {
            child.setConditionalStatusByName(status, true);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public String redirectCall() {
        return null;
    }

    static {
        dateFormatterList.add("MM/dd/yyyy");
        dateFormatterList.add("MM/dd/yy");
        dateFormatterList.add("dd/MM/yyyy");
        dateFormatterList.add("dd/MM/yy");
        dateFormatterList.add("MMddyyyy");
        dateFormatterList.add("yyyyMMdd");
        dateFormatterList.add("MMddyy");
        dateFormatterList.add("ddMMyyyy");
        dateFormatterList.add("ddMMyy");
        dateFormatterList.sort((o1, o2) -> o2.length() - o1.length());
    }
}

