/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mfc;

import com.heirloomcomputing.ecs.exec.Memory;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.UnbufferedMemory;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.idxFile;
import com.heirloomcomputing.ecs.exec.parameterList;
import com.heirloomcomputing.ecs.libcall.CBL_TRANSFORM;
import com.heirloomcomputing.ecs.mfc.HostWsAgt;
import com.heirloomcomputing.ecs.mfc.Response;
import com.heirloomcomputing.ecs.mfc.VsamRequest;
import com.heirloomcomputing.ecs.util.HexUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CBIndexedFile
extends idxFile {
    private int priorErrorCode = 0;
    public Variable filenameVariable = null;
    public boolean optional = false;
    public Variable fileStatus = null;
    public int blockFrom = 0;
    public int blockTo = 0;
    public boolean isRecords = false;
    public int recordFrom = 0;
    public int recordTo = 0;
    public Variable dependingOn = null;
    public int numberOfKeys = 0;
    public Variable[] keyArray = new Variable[256];
    private int readMode;
    private int fileHandle;
    private int sessionId;
    private HostWsAgt hwa;
    public ACCESSMODE accessMode = ACCESSMODE.UNKNOWN;

    public CBIndexedFile() {
        this.setFileHandle(0);
        this.setReadMode(0);
        this.setHwa();
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, filenameVariable, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, Variable filenameVariable, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        this.filenameVariable = filenameVariable;
        String assignTo = filenameVariable.toString();
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn, int newModes) {
        return this.declare(optional, assignTo, reserve, fileStatus, accessMode, recordKey, blockFrom, blockTo, isRecords, recordFrom, recordTo, dependingOn);
    }

    @Override
    public synchronized idxFile declare(boolean optional, String assignTo, int reserve, Variable fileStatus, int accessMode, Variable recordKey, int blockFrom, int blockTo, boolean isRecords, int recordFrom, int recordTo, Variable dependingOn) {
        String func = ".declare()";
        this.optional = optional;
        if (assignTo != null && this.assignTo == null) {
            this.assignTo = this.aliasFilename(assignTo, true);
        }
        this.fileStatus = fileStatus;
        this.accessMode = accessMode == 1 ? ACCESSMODE.SEQUENTIAL : (accessMode == 2 ? ACCESSMODE.RANDOM : (accessMode == 4 ? ACCESSMODE.DYNAMIC : ACCESSMODE.UNKNOWN));
        this.blockFrom = blockFrom;
        this.blockTo = blockTo;
        this.isRecords = isRecords;
        this.recordFrom = recordFrom;
        this.recordTo = recordTo;
        this.dependingOn = dependingOn;
        return this;
    }

    @Override
    public synchronized boolean open(int mode) throws RuntimeException {
        VsamRequest vsamRequest = new VsamRequest();
        this.setFileHandle(-1);
        this.setSessionId(-1);
        vsamRequest.cmd = "open";
        vsamRequest.dsn = this.assignTo.replaceFirst("^CB:", "").replaceFirst("^cb:", "");
        vsamRequest.mode = "rb,type=record";
        HostWsAgt hwa = this.getHwa();
        String respStr = hwa.callMfZ(vsamRequest, "/vsam");
        Response respObj = null;
        try {
            respObj = (Response)hwa.wsmap.readValue(respStr, Response.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respObj == null) {
            System.out.println("respObj is null");
            this.setIOStatus(-90);
            return false;
        }
        if (respObj.vsamresp == null) {
            System.out.println("respObj.vsamresp is null");
            this.setIOStatus(-90);
            return false;
        }
        if (respObj.session == -1) {
            System.out.println("respObj.session is -1");
            this.setIOStatus(-90);
            return false;
        }
        this.setFileHandle(respObj.vsamresp.fh);
        this.setSessionId(respObj.session);
        if (respObj.vsamresp.rc != 0) {
            this.setIOStatus(respObj.vsamresp.rc);
            return false;
        }
        this.setIOStatus(0);
        return true;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        return this.read(intoVar, keyIs, mode, timeout);
    }

    @Override
    public boolean read(Variable intoVar, Variable keyIs, int mode, Numeric timeout) {
        String func = ".read()";
        this.setReadMode(mode >> 8);
        VsamRequest vsamRequest = new VsamRequest();
        vsamRequest.cmd = "read";
        vsamRequest.session = this.getSessionId();
        vsamRequest.fh = this.getFileHandle();
        switch (mode &= 0xFF) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case -1: {
                break;
            }
            case -2: {
                break;
            }
        }
        if (keyIs != null) {
            vsamRequest.key = keyIs.toHexString();
            vsamRequest.keyfmt = "HEX";
        }
        vsamRequest.recfmt = "HEX";
        vsamRequest.count = 1;
        HostWsAgt hwa = this.getHwa();
        String respStr = hwa.callMfZ(vsamRequest, "/vsam");
        Response respObj = null;
        try {
            respObj = (Response)hwa.wsmap.readValue(respStr, Response.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respObj == null) {
            System.out.println("respObj is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.vsamresp == null) {
            System.out.println("respObj.vsamresp is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.session == -1) {
            System.out.println("respObj.session is -1");
            this.setIOStatus(-90);
            return true;
        }
        if ("yes".equalsIgnoreCase(respObj.vsamresp.eof)) {
            this.setIOStatus(-10);
            return true;
        }
        if (respObj.vsamresp.rc != 0) {
            this.setIOStatus(-respObj.vsamresp.rc);
            return true;
        }
        this.setIOStatus(0);
        Object[] dataRecs = respObj.vsamresp.data;
        String rec = dataRecs[0] instanceof String ? (String)dataRecs[0] : "";
        intoVar.fromByteArray(HexUtils.parseHexBinary(rec));
        UnbufferedMemory _memory = new UnbufferedMemory(256, "cbindexfile.wk");
        Variable errmessg = new Variable();
        errmessg.declare((Memory)_memory, 0, 256, "ERRMESSG", null, null, null, null, null, 0);
        CBL_TRANSFORM tform = new CBL_TRANSFORM();
        parameterList parms = new parameterList();
        parms.add(intoVar);
        parms.add(errmessg);
        parms.add("CONV(EBC2ASC)");
        parms.add("FROMCHAR(IBM1047)");
        parms.add("TOCHAR(ISO-8859-1)");
        tform.call(parms);
        return false;
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs);
    }

    @Override
    public synchronized boolean read(Variable intoVar, Variable keyIs) {
        return this.read(intoVar, keyIs, 0, null);
    }

    @Override
    public synchronized boolean read(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.read(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar, int mode, Numeric timeout) {
        Variable key = this.keyArray[0];
        return this.read(intoVar, key, mode, timeout);
    }

    @Override
    public synchronized boolean read(Variable intoVar) {
        return this.read(intoVar, 0, null);
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar, int mode, Numeric timeout) {
        return this.readNext(intoVar, mode, timeout);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar, int mode, Numeric timeout) {
        String func = ".readNext()";
        this.setReadMode(mode >> 8);
        mode &= 0xFF;
        VsamRequest vsamRequest = new VsamRequest();
        vsamRequest.cmd = "read";
        vsamRequest.session = this.getSessionId();
        vsamRequest.fh = this.getFileHandle();
        vsamRequest.recfmt = "HEX";
        vsamRequest.count = 1;
        HostWsAgt hwa = this.getHwa();
        String respStr = hwa.callMfZ(vsamRequest, "/vsam");
        Response respObj = null;
        try {
            respObj = (Response)hwa.wsmap.readValue(respStr, Response.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respObj == null) {
            System.out.println("respObj is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.vsamresp == null) {
            System.out.println("respObj.vsamresp is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.session == -1) {
            System.out.println("respObj.session is -1");
            this.setIOStatus(-90);
            return true;
        }
        if ("yes".equalsIgnoreCase(respObj.vsamresp.eof)) {
            this.setIOStatus(-10);
            return true;
        }
        if (respObj.vsamresp.rc != 0) {
            this.setIOStatus(-respObj.vsamresp.rc);
            return true;
        }
        this.setIOStatus(0);
        Object[] dataRecs = respObj.vsamresp.data;
        String rec = dataRecs[0] instanceof String ? (String)dataRecs[0] : "";
        intoVar.fromByteArray(HexUtils.parseHexBinary(rec));
        UnbufferedMemory _memory = new UnbufferedMemory(256, "cbindexfile.wk");
        Variable errmessg = new Variable();
        errmessg.declare((Memory)_memory, 0, 256, "ERRMESSG", null, null, null, null, null, 0);
        CBL_TRANSFORM tform = new CBL_TRANSFORM();
        parameterList parms = new parameterList();
        parms.add(intoVar);
        parms.add(errmessg);
        parms.add("CONV(EBC2ASC)");
        parms.add("FROMCHAR(IBM1047)");
        parms.add("TOCHAR(ISO-8859-1)");
        tform.call(parms);
        return false;
    }

    @Override
    public synchronized boolean readNext(String format, Variable nullKeyMap, Variable nullMap, Variable intoVar) {
        return this.readNext(intoVar);
    }

    @Override
    public synchronized boolean readNext(Variable intoVar) {
        return this.readNext(intoVar, 0, null);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset, byte[] replacementData) {
        return this.start(mode, keyOffset, replacementData);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, int keyOffset) {
        return this.start(mode, keyOffset);
    }

    @Override
    public synchronized boolean start(String format, Variable nullKeyMap, int mode, Variable currentKey) {
        return this.start(mode, currentKey);
    }

    @Override
    public synchronized boolean start(int mode, Variable currentKey) {
        this.setReadMode(mode >> 8);
        VsamRequest vsamRequest = new VsamRequest();
        vsamRequest.cmd = "locate";
        vsamRequest.session = this.getSessionId();
        vsamRequest.fh = this.getFileHandle();
        switch (mode &= 0xFF) {
            case 0: {
                vsamRequest.locopt = "KEY_EQ";
                break;
            }
            case 1: {
                vsamRequest.locopt = "KEY_GE";
                break;
            }
            case 2: {
                vsamRequest.locopt = "KEY_GT";
                break;
            }
            case -1: {
                break;
            }
            case -2: {
                break;
            }
            default: {
                vsamRequest.locopt = "KEY_GE";
            }
        }
        UnbufferedMemory _memory = new UnbufferedMemory(256, "cbindexfile.wk");
        Variable errmessg = new Variable();
        errmessg.declare((Memory)_memory, 0, 256, "ERRMESSG", null, null, null, null, null, 0);
        CBL_TRANSFORM tform = new CBL_TRANSFORM();
        parameterList parms = new parameterList();
        parms.add(currentKey);
        parms.add(errmessg);
        parms.add("CONV(ASC2EBC)");
        parms.add("FROMCHAR(ISO-8859-1)");
        parms.add("TOCHAR(IBM1047)");
        tform.call(parms);
        vsamRequest.key = HexUtils.printHexBinary(currentKey.getBytes());
        vsamRequest.keyfmt = "HEX";
        HostWsAgt hwa = this.getHwa();
        String respStr = hwa.callMfZ(vsamRequest, "/vsam");
        Response respObj = null;
        try {
            respObj = (Response)hwa.wsmap.readValue(respStr, Response.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respObj == null) {
            System.out.println("respObj is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.vsamresp == null) {
            System.out.println("respObj.vsamresp is null");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.session == -1) {
            System.out.println("respObj.session is -1");
            this.setIOStatus(-90);
            return true;
        }
        if (respObj.vsamresp.rc != 0) {
            this.setIOStatus(respObj.vsamresp.rc);
            return true;
        }
        this.setIOStatus(0);
        return false;
    }

    @Override
    public synchronized boolean close() {
        return this.close(0);
    }

    @Override
    public synchronized boolean close(int mode) {
        VsamRequest vsamRequest = new VsamRequest();
        vsamRequest.cmd = "close";
        vsamRequest.session = this.getSessionId();
        vsamRequest.fh = this.getFileHandle();
        HostWsAgt hwa = this.getHwa();
        String respStr = hwa.callMfZ(vsamRequest, "/vsam");
        Response respObj = null;
        try {
            respObj = (Response)hwa.wsmap.readValue(respStr, Response.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (respObj == null) {
            System.out.println("respObj is null");
            this.setIOStatus(-90);
            return false;
        }
        if (respObj.vsamresp == null) {
            System.out.println("respObj.vsamresp is null");
            this.setIOStatus(-90);
            return false;
        }
        if (respObj.session == -1) {
            System.out.println("respObj.session is -1");
            this.setIOStatus(-90);
            return false;
        }
        if (respObj.vsamresp.rc != 0) {
            this.setIOStatus(respObj.vsamresp.rc);
            return false;
        }
        this.setIOStatus(0);
        return true;
    }

    @Override
    public synchronized int priorError() {
        return this.getPriorError();
    }

    @Override
    public final int getPriorError() {
        if (this.priorErrorCode > 0) {
            return -this.priorErrorCode;
        }
        return this.priorErrorCode;
    }

    @Override
    public final void setPriorError(int priorError) {
        this.priorErrorCode = priorError;
    }

    @Override
    public final int setIOStatus(int status) {
        char[] smallChar = new char[]{'0', '0'};
        if ((status = status < 0 ? -status : 0) == 9) {
            status = 0;
        }
        this.setPriorError(status);
        if (this.fileStatus != null) {
            if (status == 0) {
                this.fileStatus.moveZeroes();
            } else if (status < 10) {
                smallChar[1] = (char)(status + 48);
                this.fileStatus.move(smallChar);
            } else {
                this.fileStatus.move(status);
            }
        }
        return status;
    }

    @Override
    public final int setIOStatus(String x) {
        int status = 0;
        try {
            status = Integer.decode(x);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.setIOStatus(-status);
    }

    @Override
    public synchronized boolean isOK() {
        int priorErrorCode = this.getPriorError();
        return priorErrorCode > -10 && priorErrorCode < 10;
    }

    public int getFileHandle() {
        return this.fileHandle;
    }

    public void setFileHandle(int fileHandle) {
        this.fileHandle = fileHandle;
    }

    public int getReadMode() {
        return this.readMode;
    }

    public void setReadMode(int readMode) {
        this.readMode = readMode;
    }

    private HostWsAgt getHwa() {
        return this.hwa;
    }

    private void setHwa() {
        HostWsAgt hwa = null;
        String url2 = System.getProperty("cburl");
        if (url2 != null) {
            hwa = new HostWsAgt(url2);
        } else {
            url2 = this.getUrlProperty();
            hwa = new HostWsAgt(url2);
        }
        this.hwa = hwa;
    }

    private String getUrlProperty() {
        String url2 = null;
        try (InputStream input = CBIndexedFile.class.getClassLoader().getResourceAsStream("deploy.properties");){
            Properties prop = new Properties();
            if (input == null) {
                System.err.println("Unable to find deploy.properties on classpath");
            } else {
                prop.load(input);
                url2 = prop.getProperty("cburl");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return url2;
    }

    private int getSessionId() {
        return this.sessionId;
    }

    private void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public static enum ACCESSMODE {
        UNKNOWN,
        SEQUENTIAL,
        RANDOM,
        DYNAMIC;

    }
}

