/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi.jms;

import com.heirloomcomputing.ecs.mqi.MQIConnectionAbstract;
import com.heirloomcomputing.ecs.mqi.MQIConnectionManagerAbstract;
import com.heirloomcomputing.ecs.mqi.api.MQIBaseEntity;
import com.heirloomcomputing.ecs.mqi.api.MQIMessageDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIObjectDescriptor;
import com.heirloomcomputing.ecs.mqi.api.MQIPutMessageOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIReadableEntity;
import com.heirloomcomputing.ecs.mqi.api.MQIResponse;
import com.heirloomcomputing.ecs.mqi.api.MQIWriteableEntity;
import com.heirloomcomputing.ecs.mqi.jms.JMSConnectionManager;
import com.heirloomcomputing.ecs.mqi.jms.JMSEntity;
import com.heirloomcomputing.ecs.mqi.jms.module.AbstractJMSModule;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.naming.NamingException;

public class JMSConnection
extends MQIConnectionAbstract {
    private boolean connectionStarted;
    private String qmName;
    private AbstractJMSModule jmsModule;
    private Connection connectionInstance;
    private int connectionHandle;
    private Session jmsSession;
    private SessionTransactionSupport transactionType;

    JMSConnection(String queueManagerName, AbstractJMSModule mod, Connection connection, int hConn) {
        this.qmName = queueManagerName;
        this.connectionInstance = connection;
        this.connectionHandle = hConn;
        this.jmsModule = mod;
    }

    private Session createSession(Connection connection, boolean transacted, int i) throws JMSException {
        if (connection instanceof XAConnection) {
            transacted = false;
        }
        if (connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(transacted, i);
        }
        if (connection instanceof TopicConnection) {
            return ((TopicConnection)connection).createTopicSession(transacted, i);
        }
        if (transacted) {
            return connection.createSession(transacted, 2);
        }
        return connection.createSession(transacted, i);
    }

    @Override
    public Session createSession(boolean transacted) throws JMSException {
        return this.createSession(this.connectionInstance, transacted, 1);
    }

    void a(int i) {
        super.remoteFromOpened(i);
    }

    @Override
    public int getConnectionHandle() {
        return this.connectionHandle;
    }

    public Connection getConnectionInstance() {
        return this.connectionInstance;
    }

    public String getQmName() {
        return this.qmName;
    }

    @Override
    public MQIBaseEntity mqOpen(MQIObjectDescriptor aa1, int i) {
        this.response.assign(0, 0);
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("Called mqOpen(objectDescriptor=" + aa1 + ", options=" + i + ")");
        }
        if (aa1 == null) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  Invalid (null) object descriptor passed, returning MQHO_UNUSABLE_HOBJ");
            }
            this.assignResponseReason(2044);
            return null;
        }
        JMSEntity jmsEntity = null;
        if (aa1.getObjectType() != 1) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  The object type requested is not supported (type=" + aa1.getObjectType() + "), returning MQHO_UNUSABLE_HOBJ");
            }
            this.assignResponseReason(2043);
            return null;
        }
        if ((i & 0x20) == 32) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  MPOO_INQUIRE not supported (JMS limitation)");
            }
            this.assignResponseReason(2046);
            return null;
        }
        if ((i & 0x40) == 64) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  MQOO_SET not supported (JMS limitation)");
            }
            this.assignResponseReason(2046);
            return null;
        }
        try {
            Destination destination;
            if (this.jmsSession == null) {
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqOpen:  There is no current unit of work, creating unit of work (session)...");
                }
                this.jmsSession = this.createSession(true);
                boolean xaSessionFlag = this.jmsSession instanceof XASession;
                if (!xaSessionFlag && this.jmsSession != null) {
                    xaSessionFlag = "bitronix.tm.resource.jms.DualSessionWrapper".equals(this.jmsSession.getClass().getName());
                }
                this.transactionType = xaSessionFlag ? SessionTransactionSupport.XATRANSACTION : (this.jmsSession.getTransacted() ? SessionTransactionSupport.LOCALTRANSACTION : SessionTransactionSupport.NOTRANSACTION);
            }
            if ((destination = this.jmsModule.obtainDestination(this.jmsSession, aa1)) == null) {
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqOpen:  Problem encountered initializing jms Destination object, returning MQHO_UNUSABLE_HOBJ");
                }
                this.assignResponseReason(2085);
                return null;
            }
            int j = this.j();
            jmsEntity = new JMSEntity(aa1, i, this.jmsModule, this.jmsSession, destination, this.connectionHandle, j);
            if (!this.connectionStarted) {
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqOpen:  Calling start on the jms connection object to make sure the connection has been started...");
                }
                this.connectionInstance.start();
                this.connectionStarted = true;
            }
            this.addToOpened(j, jmsEntity);
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  Open was successful, returning object handle: " + j);
            }
            return jmsEntity;
        }
        catch (NamingException namingexception) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  An exception occurred, e=" + namingexception);
            }
            this.jmsModule.convertNamingExceptionToResponseCodes(this.response, namingexception);
        }
        catch (JMSException jmsexception) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  An exception occurred, e=" + (Object)((Object)jmsexception));
            }
            this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception);
        }
        catch (Throwable throwable) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqOpen:  An unexpected error occurred:");
                this.jmsModule.logException(throwable);
            }
            this.response.assign(2, 2195);
        }
        if (jmsEntity != null) {
            jmsEntity.mqClose(0);
        }
        return null;
    }

    @Override
    public MQIBaseEntity getOpenedQueue(int i) {
        return (MQIBaseEntity)this.getOpenedEntity(i);
    }

    @Override
    public boolean mqOpen(MQIObjectDescriptor aa1, MQIMessageDescriptor MQIMessageDescriptor2, MQIPutMessageOptions ad1, byte[] abyte0) {
        return this.mqOpen(aa1, MQIMessageDescriptor2, ad1, abyte0, 0, abyte0 == null ? 0 : abyte0.length);
    }

    @Override
    public boolean mqOpen(MQIObjectDescriptor aa1, MQIMessageDescriptor MQIMessageDescriptor2, MQIPutMessageOptions ad1, byte[] abyte0, int i) {
        return this.mqOpen(aa1, MQIMessageDescriptor2, ad1, abyte0, 0, i);
    }

    @Override
    public boolean mqOpen(MQIObjectDescriptor aa1, MQIMessageDescriptor MQIMessageDescriptor2, MQIPutMessageOptions ad1, byte[] abyte0, int i, int j) {
        MQIBaseEntity t1;
        int k = ad1.getOptions();
        int l = 16;
        if ((k & 0x800) == 2048) {
            l |= 0x800;
        } else if ((k & 0x100) == 256) {
            l |= 0x100;
        } else if ((k & 0x200) == 512) {
            l |= 0x200;
        } else if ((k & 0x400) == 1024) {
            l |= 0x400;
        }
        if ((k & 0x1000) == 4096) {
            l |= 0x1000;
        }
        if ((k & 0x2000) == 8192) {
            l |= 0x2000;
        }
        if ((t1 = this.mqOpen(aa1, l)) == null) {
            return false;
        }
        boolean flag = ((MQIWriteableEntity)t1).mqPut(MQIMessageDescriptor2, ad1, abyte0);
        if (!t1.mqClose(0)) {
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean mqBegin(int i) {
        this.response.assign(0, 0);
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("Called mqBegin(beginOptions=" + i + ")");
        }
        if (this.connectionInstance == null) {
            this.assignResponseReason(2018);
            return false;
        }
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("mqBegin:  This call is not supported, use local unit of work (syncpoint).");
        }
        this.assignResponseReason(2012);
        return false;
    }

    @Override
    public boolean mqCommit() {
        this.response.assign(0, 0);
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("Called mqCommit()");
        }
        if (this.connectionInstance == null) {
            this.assignResponseReason(2018);
            return false;
        }
        try {
            if (this.jmsSession != null) {
                if (this.transactionType == SessionTransactionSupport.XATRANSACTION) {
                    this.assignResponseReason(2012);
                    return false;
                }
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqCommit:  There is a current unit of work, committing current session");
                }
                this.jmsSession.commit();
            } else if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqCommit:  There is not a current unit of work, so no commit is needed");
            }
            return true;
        }
        catch (JMSException jmsexception) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqCommit:  An exception occurred, e=" + (Object)((Object)jmsexception));
            }
            this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception);
        }
        catch (Throwable throwable) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqCommit:  An unexpected error occurred:");
                this.jmsModule.logException(throwable);
            }
            this.response.assign(2, 2195);
        }
        return false;
    }

    @Override
    public boolean mqBack() {
        this.response.assign(0, 0);
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("Called mqBack()");
        }
        if (this.connectionInstance == null) {
            this.assignResponseReason(2018);
            return false;
        }
        try {
            if (this.jmsSession != null) {
                if (this.transactionType == SessionTransactionSupport.XATRANSACTION) {
                    this.assignResponseReason(2012);
                    return false;
                }
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqBack:  There is a current unit of work, calling rollback on current session");
                }
                this.jmsSession.rollback();
            } else if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqBack:  There is not a current unit of work, so no rollback is needed");
            }
        }
        catch (JMSException jmsexception) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqBack:  An exception occurred, e=" + (Object)((Object)jmsexception));
            }
            this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception);
        }
        catch (Throwable throwable) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqBack:  An unexpected error occurred:");
                this.jmsModule.logException(throwable);
            }
            this.response.assign(2, 2195);
        }
        return !this.response.setError();
    }

    @Override
    public boolean mqDisconnect() {
        this.response.assign(0, 0);
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("Called mqDisconnect()");
        }
        if (this.connectionInstance == null) {
            this.assignResponseReason(2018);
            return false;
        }
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("mqDisconnect:  Attempting to close all object handles for this connection");
        }
        Enumeration<Object> enumeration = this.getListOfOpenedEntities();
        while (enumeration.hasMoreElements()) {
            MQIReadableEntity y1 = (MQIReadableEntity)enumeration.nextElement();
            y1.mqClose(0);
        }
        if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("mqDisconnect:  Done closing object handles for this connection");
        }
        if (this.jmsSession != null) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  There is a current unit of work, committing and closing current session.  transactionType is " + (Object)((Object)this.transactionType));
            }
            try {
                if (this.transactionType == SessionTransactionSupport.LOCALTRANSACTION || this.transactionType == SessionTransactionSupport.XATRANSACTION) {
                    boolean xaSessionFlag = false;
                    if (this.jmsSession != null) {
                        xaSessionFlag = "bitronix.tm.resource.jms.DualSessionWrapper".equals(this.jmsSession.getClass().getName());
                    }
                    if (!xaSessionFlag) {
                        this.jmsSession.commit();
                    }
                }
            }
            catch (JMSException jmsexception) {
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqDisconnect:  An exception occurred, e=" + (Object)((Object)jmsexception));
                }
                this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception);
            }
            try {
                this.jmsSession.close();
                this.jmsSession = null;
            }
            catch (JMSException jmsexception1) {
                if (this.jmsModule.isLoggingEnabled()) {
                    this.jmsModule.log("mqDisconnect:  An exception occurred, e=" + (Object)((Object)jmsexception1));
                }
                this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception1);
            }
        } else if (this.jmsModule.isLoggingEnabled()) {
            this.jmsModule.log("mqDisconnect:  There is not a current unit of work, so no session commit or session close is needed");
        }
        try {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  Closing connection...");
            }
            this.connectionInstance.close();
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  Connection closed, destroying connection handle...");
            }
            ((JMSConnectionManager)MQIConnectionManagerAbstract.getInstance()).mqDisconnect(this.connectionHandle);
            this.connectionInstance = null;
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  Disconnected.");
            }
            this.jmsModule.closeNamingContext();
        }
        catch (JMSException jmsexception2) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  An exception occurred, e=" + (Object)((Object)jmsexception2));
            }
            this.jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception2);
        }
        catch (Throwable throwable) {
            if (this.jmsModule.isLoggingEnabled()) {
                this.jmsModule.log("mqDisconnect:  An unexpected error occurred:");
                this.jmsModule.logException(throwable);
            }
            this.response.assign(2, 2195);
        }
        return !this.response.setError();
    }

    @Override
    public MQIResponse h() {
        return (MQIResponse)this.response.clone();
    }

    private static enum SessionTransactionSupport {
        XATRANSACTION,
        LOCALTRANSACTION,
        NOTRANSACTION;

    }
}

