/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.mqi.jms;

import com.heirloomcomputing.ecs.mqi.MQIConnectionManagerAbstract;
import com.heirloomcomputing.ecs.mqi.api.MQIConnectOptions;
import com.heirloomcomputing.ecs.mqi.api.MQIConnection;
import com.heirloomcomputing.ecs.mqi.jms.JMSConnection;
import com.heirloomcomputing.ecs.mqi.jms.module.AbstractJMSModule;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.naming.NamingException;

public class JMSConnectionManager
extends MQIConnectionManagerAbstract {
    void mqDisconnect(int i) {
        super.removeConnectionFromCache(i);
    }

    @Override
    protected MQIConnection mqConnect(String queueManagerName, MQIConnectOptions u, Object connectionObject, int conHandle) {
        String queueManagerName2 = queueManagerName;
        if (queueManagerName2 == null) {
            try {
                queueManagerName2 = ((Connection)connectionObject).getMetaData().getJMSProviderName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AbstractJMSModule.setConfigProperties(MQIConnectionManagerAbstract.getConfigProperties());
        AbstractJMSModule jmsModule = AbstractJMSModule.hInstantiate(queueManagerName2);
        if (jmsModule.isLoggingEnabled()) {
            if (connectionObject != null) {
                jmsModule.log("Called mqConnect(<Existing JMS connection>)");
                jmsModule.log("mqConnect:  This call simply registers the connection with a connection");
                jmsModule.log("mqConnect:  handle, it does not actually do an MQCONN.");
            } else {
                jmsModule.log("Called mqConnect(" + queueManagerName + ", connectionOptions)");
            }
        }
        if (connectionObject == null) {
            try {
                connectionObject = jmsModule.obtainConnection(queueManagerName, u);
            }
            catch (JMSException jmsexception) {
                if (jmsModule.isLoggingEnabled()) {
                    jmsModule.log("mqConnect:  An exception occurred, e=");
                    jmsModule.logException(jmsexception);
                }
                jmsModule.convertJMSExceptionToResponseCodes(this.response, jmsexception);
            }
            catch (NamingException namingexception) {
                if (jmsModule.isLoggingEnabled()) {
                    jmsModule.log("mqConnect:  An exception occurred, e=");
                    jmsModule.logException(namingexception);
                }
                jmsModule.convertNamingExceptionToResponseCodes(this.response, namingexception);
            }
        }
        if (this.response.setError()) {
            return null;
        }
        return new JMSConnection(queueManagerName2, jmsModule, (Connection)connectionObject, conHandle);
    }
}

