/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.print;

import com.heirloomcomputing.ecs.api.IGenericPrinter;
import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.ConvertData;
import com.heirloomcomputing.ecs.exec.MediaImage;
import com.heirloomcomputing.ecs.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JVM11Driver
implements IGenericPrinter {
    private boolean dialogEnabled = true;
    private Hashtable<String, String> attributes = new Hashtable();
    public double multiplierXInches = 1.0;
    public double multiplierXMetric = 1.0;
    public double multiplierXCharacters = 1.0;
    public double multiplierXDeviceUnits = 0.12;
    public double multiplierYInches = 1.0;
    public double multiplierYMetric = 1.0;
    public double multiplierYCharacters = 1.0;
    public double multiplierYDeviceUnits = 0.12;
    public static final int BASIC_LEFT_MARGIN = 12;
    public static final int BASIC_TOP_MARGIN = 12;
    public static final int BASIC_BOTTOM_MARGIN = 12;
    private int leftMargin = 12;
    private int topMargin = 12;
    private int nextTopMargin = 12;
    private int bottomMargin = 12;
    private double xpos = 12.0;
    private double ypos = 12.0;
    private double lineFromX = 12.0;
    private double lineFromY = 12.0;
    private boolean fontUnderline;
    private boolean fontStrikeOut;
    private boolean fontDoubleStrike;
    private Frame frame = new Frame("Printer 1.1");
    private PrintJob job;
    private Graphics page;
    private Dimension pagesize;
    private int printerFontHeight;
    private int printerFontWidth;
    private double printerFontMetricHeight;
    private int printerPageLength = 66;
    private int cols = 80;
    private int rows = -1;
    private int translatex;
    private int translatey;
    private int alignx;
    private int aligny;
    private boolean escapeSequences;
    private int tabStop = 60;
    private Color textColor = Color.black;
    private Color penColor;
    private Color shadeColor;
    private int lineExtend = 0;
    private Font font;
    private Font defaultFont;
    private FontMetrics fontMetrics;
    private int fontAscent = 0;
    private int fontDescent = 0;
    private boolean enableGraphics;
    private String graphicsTag = "<GFX>";
    private int CONNECTION_THICKNESS = 1;
    private final Vector<ConnectorNode> connectors = new Vector();
    private int pageBoundaryX;
    private int pageBoundaryY;
    private static final char[] ESCAPES_FULL = new char[]{'\t', '\n', '\r', '\u000e', '\u000f', '\u001b'};
    private static final char[] ESCAPES_SIMPLE = new char[]{'\n', '\r'};
    private int pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;

    private void init() {
        this.attributes = new Hashtable();
        this.leftMargin = 12;
        this.topMargin = this.nextTopMargin;
        this.bottomMargin = 12;
        this.fontUnderline = false;
        this.fontStrikeOut = false;
        this.fontDoubleStrike = false;
        this.resetX();
        this.resetY();
    }

    private void resetX() {
        this.xpos = 0.0;
    }

    private void resetY() {
        this.topMargin = this.nextTopMargin;
        this.leftMargin = 12;
        this.ypos = this.multiplierYCharacters * 2.0;
        this.pageSplitBoundary = this.pageBoundaryY - this.bottomMargin - this.topMargin;
    }

    private Frame getFrame() {
        try {
            if (this.frame == null) {
                this.frame = new Frame("Printer 1.1");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.frame;
    }

    @Override
    public Component getComponent() {
        return this.getFrame();
    }

    private Graphics getGraphics() {
        if (this.page != null) {
            return this.page;
        }
        if (this.job == null) {
            this.open(this.dialogEnabled, false, null);
        }
        if (this.job != null) {
            this.page = this.job.getGraphics();
        }
        this.page.setFont(this.getFont());
        this.page.setColor(this.getTextColor());
        return this.page;
    }

    @Override
    public void clearDialog() {
        this.attributes.remove("RETURN");
        this.attributes.remove("EXTENDED_ERROR");
        this.attributes.remove("ALL_PAGES_FLAG");
        this.attributes.remove("SELECTION_FLAG");
        this.attributes.remove("PAGE_NUMBERS_FLAG");
        this.attributes.remove("NO_SELECTION_FLAG");
        this.attributes.remove("NO_PAGE_NUMBERS_FLAG");
        this.attributes.remove("COLLATE_FLAG");
        this.attributes.remove("PRINT_SETUP_FLAG");
        this.attributes.remove("PRINT_TO_FILE_FLAG");
        this.attributes.remove("NO_WARNING_FLAG");
        this.attributes.remove("USER_DEVICE_MODE_COPIES_FLAG");
        this.attributes.remove("DISABLE_PRINT_TO_FILE_FLAG");
        this.attributes.remove("HIDE_PRINT_TO_FILE_FLAG");
        this.attributes.remove("NO_NETWORK_BUTTON_FLAG");
        this.attributes.remove("FROM_PAGE");
        this.attributes.remove("TO_PAGE");
        this.attributes.remove("MIN_PAGE");
        this.attributes.remove("MAX_PAGE");
        this.attributes.remove("PRINT_DIALOG_COPIES");
        this.attributes.remove("DEVICE_NAME");
        this.attributes.remove("ORIENTATION");
        this.attributes.remove("PAPER_SIZE");
        this.attributes.remove("PAPER_LENGTH");
        this.attributes.remove("PAPER_WIDTH");
        this.attributes.remove("SCALE");
        this.attributes.remove("DEVICE_MODE_COPIES");
        this.attributes.remove("DEFAULT_SOURCE");
        this.attributes.remove("PRINT_QUALITY");
        this.attributes.remove("COLOR");
        this.attributes.remove("DUPLEX");
        this.attributes.remove("Y_RESOLUTION");
        this.attributes.remove("TRUE_TYPE_OPTION");
        this.attributes.remove("COLLATE");
        this.attributes.remove("ICM_METHOD");
        this.attributes.remove("MEDIA_TYPE");
        this.attributes.remove("DITHER_TYPE");
    }

    @Override
    public boolean displayDialog() {
        Toolkit toolkit = null;
        try {
            toolkit = this.getFrame().getToolkit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (toolkit == null) {
            try {
                toolkit = Toolkit.getDefaultToolkit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (toolkit == null) {
            return false;
        }
        this.job = toolkit.getPrintJob(this.getFrame(), "Printer", new Properties());
        return this.job != null;
    }

    @Override
    public String getDialog(String attribute) {
        if ((attribute = this.normalizeAttribute(attribute)) != null && attribute.startsWith("SUPPORTED")) {
            return "0";
        }
        return this.getAttribute(attribute);
    }

    @Override
    public void setDialog(String attribute, String value) {
        this.setAttribute(attribute, value);
    }

    private String normalizeAttribute(String name) {
        return name != null ? name.trim().toUpperCase().replace('-', '_').replace(' ', '_') : null;
    }

    public String getAttribute(String name) {
        if (name != null) {
            name = this.normalizeAttribute(name);
            try {
                String value = this.attributes.get(name);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        if (name != null) {
            name = this.normalizeAttribute(name);
            this.attributes.put(name, value);
        }
    }

    @Override
    public double getScaleX(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierXInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierXMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierXCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierXDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public double getScaleY(String units) {
        if (units == null) {
            return 1.0;
        }
        if ((units = units.trim()).length() > 0) {
            switch (units.charAt(0)) {
                case 'I': 
                case 'i': {
                    return this.multiplierYInches;
                }
                case 'M': 
                case 'm': {
                    return this.multiplierYMetric;
                }
                case 'C': 
                case 'c': {
                    return this.multiplierYCharacters;
                }
                case 'D': 
                case 'T': 
                case 'd': 
                case 't': {
                    return this.multiplierYDeviceUnits;
                }
                case 'P': 
                case 'p': {
                    return 1.0;
                }
            }
        }
        return 1.0;
    }

    @Override
    public void draw(Image image, double xpos, double ypos, double width, double height) {
        if (image != null) {
            if (width <= 0.0 && height <= 0.0) {
                this.getGraphics().drawImage(image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), Color.white, this.getFrame());
            } else {
                if (width <= 0.0) {
                    width = image.getWidth(this.getFrame());
                }
                if (height <= 0.0) {
                    height = image.getHeight(this.getFrame());
                }
                this.getGraphics().drawImage(image, (int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height, Color.white, this.getFrame());
            }
        }
    }

    @Override
    public void draw(Component component, double xpos, double ypos, double width, double height) {
        Graphics componentGraphics = this.getGraphics().create((int)(xpos + (double)this.leftMargin), (int)(ypos + (double)this.topMargin), (int)width, (int)height);
        componentGraphics.setFont(this.getFont());
        componentGraphics.setColor(this.getPenColor());
        component.printAll(componentGraphics);
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, boolean _3d, boolean raised) {
        Graphics g = this.getGraphics();
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            g.setColor(this.getShadeColor());
            if (_3d) {
                g.fill3DRect(bx, by, sw, sh, raised);
            } else {
                g.fillRect(bx, by, sw, sh);
            }
        }
        g.setColor(c);
        if (_3d) {
            g.draw3DRect(bx, by, sw, sh, raised);
        } else {
            g.drawRect(bx, by, sw, sh);
        }
    }

    @Override
    public void drawBox(double xpos, double ypos, double width, double height, boolean shade, int arcWidth, int arcHeight) {
        Graphics g = this.getGraphics();
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            g.setColor(this.getShadeColor());
            g.fillRoundRect(bx, by, sw, sh, arcWidth, arcHeight);
        }
        g.setColor(c);
        g.drawRoundRect(bx, by, sw, sh, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(double xpos, double ypos, double width, double height, boolean shade) {
        Graphics g = this.getGraphics();
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            g.setColor(this.getShadeColor());
            g.fillOval(bx, by, sw, sh);
        }
        g.setColor(c);
        g.drawOval(bx, by, sw, sh);
    }

    @Override
    public void drawArc(double xpos, double ypos, double width, double height, boolean shade, int startAngle, int endAngle) {
        Graphics g = this.getGraphics();
        Color c = this.getPenColor();
        int bx = (int)(xpos + (double)this.leftMargin);
        int by = (int)(ypos + (double)this.topMargin);
        int sw = (int)width;
        int sh = (int)height;
        if (shade) {
            g.setColor(this.getShadeColor());
            g.fillArc(bx, by, sw, sh, startAngle, endAngle);
        }
        g.setColor(c);
        g.drawArc(bx, by, sw, sh, startAngle, endAngle);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        Graphics g = this.getGraphics();
        Color c = this.getPenColor();
        g.setColor(c);
        g.drawLine((int)(x1 + (double)this.leftMargin), (int)(y1 + (double)this.topMargin), (int)(x2 + (double)this.leftMargin), (int)(y2 + (double)this.topMargin));
        this.lineFromX = x2;
        this.lineFromY = y2;
    }

    @Override
    public void drawLineFrom(double x1, double y1) {
        this.lineFromX = x1;
        this.lineFromY = y1;
    }

    @Override
    public void drawLineTo(double x2, double y2) {
        this.drawLine(this.lineFromX, this.lineFromY, x2, y2);
    }

    @Override
    public void setShadeColor(Color shade) {
        if (shade == null) {
            shade = Color.lightGray;
        }
        this.shadeColor = shade;
    }

    @Override
    public Color getShadeColor() {
        if (this.shadeColor != null) {
            return this.shadeColor;
        }
        return Color.lightGray;
    }

    @Override
    public void setPen(int penStyle, double penWidth, Color penColor) {
        this.penColor = penColor;
    }

    public Color getPenColor() {
        return this.penColor != null ? this.penColor : this.getTextColor();
    }

    @Override
    public double getPositionX() {
        return this.xpos;
    }

    @Override
    public double getPositionY() {
        return this.ypos;
    }

    @Override
    public void setPositionX(double xpos) {
        this.xpos = xpos;
    }

    @Override
    public void setPositionY(double ypos) {
        this.ypos = ypos;
    }

    @Override
    public boolean open(boolean enableDialog, boolean rawMode, String filename) {
        try {
            this.dialogEnabled = enableDialog;
            this.init();
            if (filename == null) {
                filename = "";
            }
            if (filename.indexOf(63) >= 0) {
                this.dialogEnabled = true;
            }
            if (this.dialogEnabled) {
                if (this.displayDialog()) {
                    this.dialogEnabled = false;
                } else {
                    return false;
                }
            }
            if (this.job == null) {
                return false;
            }
            String pf_font = "Monospaced";
            int pf_size = -1;
            int pf_style = 0;
            boolean pf_bold = false;
            boolean pf_italic = false;
            this.translatex = -1;
            this.translatey = -1;
            double HEIGHT_ADJUST = 0.97;
            double PAGESIZE_WIDTH_ADJUST = 0.93;
            double PAGESIZE_HEIGHT_ADJUST = 0.91;
            double DIMENSION = 0.825;
            int DPI = 600;
            try {
                StringTokenizer st = new StringTokenizer(filename, "/\\:;");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    String value = "";
                    if (token == null) continue;
                    int equals = token.indexOf(61);
                    if (equals >= 0) {
                        value = token.substring(equals + 1);
                        token = token.substring(0, equals);
                    }
                    if ((token = token.trim().toUpperCase()).equals("FONT")) {
                        pf_font = value;
                        continue;
                    }
                    if (token.equals("SIZE")) {
                        pf_size = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("COLS")) {
                        this.cols = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ROWS")) {
                        this.rows = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("CODEPAGE") || token.equals("CP")) {
                        value = value.trim();
                        continue;
                    }
                    if (token.equals("ALIGNX")) {
                        this.alignx = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("ALIGNY")) {
                        this.aligny = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINX")) {
                        this.translatex = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("MARGINY")) {
                        this.translatey = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("DPI")) {
                        DPI = ConvertData.parseInt(value.trim());
                        continue;
                    }
                    if (token.equals("BOLD")) {
                        pf_bold = true;
                        continue;
                    }
                    if (token.equals("ITALIC")) {
                        pf_italic = true;
                        continue;
                    }
                    if (token.equals("PLAIN")) {
                        pf_bold = false;
                        pf_italic = false;
                        continue;
                    }
                    if (token.equals("GRAPHICS") || token.equals("GFX")) {
                        this.enableGraphics = true;
                        if (value == null || value.length() <= 0) continue;
                        this.graphicsTag = value;
                        continue;
                    }
                    if (token.equals("TEXT")) {
                        this.enableGraphics = false;
                        continue;
                    }
                    if (token.equals("HEIGHT-ADJUST")) {
                        HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(HEIGHT_ADJUST <= 0.0)) continue;
                        HEIGHT_ADJUST = 0.97;
                        continue;
                    }
                    if (token.equals("PAGE-WIDTH-ADJUST")) {
                        PAGESIZE_WIDTH_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_WIDTH_ADJUST <= 0.0)) continue;
                        PAGESIZE_WIDTH_ADJUST = 0.93;
                        continue;
                    }
                    if (token.equals("PAGE-HEIGHT-ADJUST")) {
                        PAGESIZE_HEIGHT_ADJUST = Double.valueOf(value.trim());
                        if (!(PAGESIZE_HEIGHT_ADJUST <= 0.0)) continue;
                        PAGESIZE_HEIGHT_ADJUST = 0.91;
                        continue;
                    }
                    if (!token.equals("DIMENSION") || !((DIMENSION = Double.valueOf(value.trim()).doubleValue()) <= 0.0)) continue;
                    DIMENSION = 0.825;
                }
            }
            catch (Throwable st) {
                // empty catch block
            }
            this.pagesize = this.job.getPageDimension();
            this.pageBoundaryX = this.pagesize.width;
            this.pageBoundaryY = this.pagesize.height;
            int pixelsPerInch = this.job.getPageResolution();
            this.multiplierXInches = pixelsPerInch;
            this.multiplierYInches = pixelsPerInch;
            this.multiplierXMetric = this.multiplierXInches * 0.3937;
            this.multiplierYMetric = this.multiplierYInches * 0.3937;
            this.multiplierYDeviceUnits = (double)pixelsPerInch / (double)DPI;
            this.multiplierXDeviceUnits = (double)pixelsPerInch / (double)DPI;
            int pagesize_width = (int)((double)this.pagesize.width * PAGESIZE_WIDTH_ADJUST);
            int pagesize_height = (int)((double)this.pagesize.height * PAGESIZE_HEIGHT_ADJUST);
            if (this.translatex < 0) {
                this.translatex = (this.pagesize.width - pagesize_width) / 2;
            }
            if (this.translatey < 0) {
                this.translatey = (this.pagesize.height - pagesize_height) / 2;
            }
            double doublePrinterPageLength = DIMENSION * (double)this.cols;
            this.printerPageLength = (int)doublePrinterPageLength;
            if (this.rows == -1) {
                this.rows = this.printerPageLength;
            }
            if (this.rows < this.printerPageLength) {
                this.printerPageLength = this.rows;
            }
            this.printerFontHeight = (int)Math.ceil((double)pagesize_height / doublePrinterPageLength);
            --this.printerFontHeight;
            if (pf_size < 0) {
                pf_size = this.printerFontHeight;
            }
            if (pf_bold) {
                pf_style |= 1;
            }
            if (pf_italic) {
                pf_style |= 2;
            }
            boolean renderHeight = false;
            try {
                this.setFont(new Font(pf_font, pf_style, pf_size));
            }
            catch (Exception pf_e) {
                this.setFont(new Font("Monospaced", 0, this.printerFontHeight));
            }
            this.printerFontWidth = pagesize_width / this.cols;
            this.printerFontMetricHeight = (double)renderHeight * HEIGHT_ADJUST;
            this.page = null;
            this.resetX();
            this.resetY();
        }
        catch (Throwable logException) {
            return false;
        }
        return true;
    }

    @Override
    public void eject() {
        try {
            this.realizeConnectors();
            if (this.page != null) {
                if (this.frame != null) {
                    this.frame.print(this.page);
                }
                this.page.dispose();
                this.page = null;
            }
            this.frame = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetX();
        this.resetY();
    }

    @Override
    public void close() {
        this.eject();
        if (this.job != null) {
            this.job.end();
            this.job = null;
        }
    }

    @Override
    public void clearFont() {
        this.setFont(this.defaultFont);
    }

    @Override
    public Dimension getTextExtent(String text) {
        FontMetrics fontMetrics = this.getFontMetrics();
        if (fontMetrics != null) {
            int width = fontMetrics.stringWidth(text);
            int height = fontMetrics.getHeight();
            return new Dimension(width, height);
        }
        return null;
    }

    @Override
    public double getTextPositionX(boolean bottom) {
        return this.xpos;
    }

    @Override
    public double getTextPositionY(boolean bottom) {
        if (bottom) {
            return this.ypos + (double)this.fontDescent;
        }
        return this.ypos - (double)this.fontAscent;
    }

    @Override
    public void setFont(Font f, boolean underline, boolean strikeOut, boolean doubleStrike) {
        this.setFont(f);
        this.fontUnderline = underline;
        this.fontStrikeOut = strikeOut;
        this.fontDoubleStrike = doubleStrike;
    }

    @Override
    public boolean isFontUnderline() {
        return this.fontUnderline;
    }

    @Override
    public boolean isFontStrikeOut() {
        return this.fontStrikeOut;
    }

    public boolean isFontDoubleStrike() {
        return this.fontDoubleStrike;
    }

    public void setFont(Font f) {
        if (this.defaultFont == null) {
            this.defaultFont = f;
        }
        if (f == null) {
            f = this.defaultFont;
        }
        this.font = f;
        this.fontMetrics = this.page != null ? this.page.getFontMetrics(this.font) : (this.frame != null ? this.frame.getFontMetrics(this.font) : Utils.getFontMetrics(this.font));
        this.fontAscent = this.fontMetrics.getHeight() + this.fontMetrics.getAscent();
        this.fontDescent = this.fontMetrics.getDescent();
        this.multiplierYCharacters = (this.fontMetrics.getHeight() - this.fontMetrics.getDescent() + (this.fontMetrics.getLeading() + this.fontMetrics.getAscent())) / 2 - 1;
        if (this.multiplierYCharacters < 1.0) {
            this.multiplierYCharacters = 1.0;
        }
        int totalWidth = 0;
        int totalCount = 0;
        int indiWidth = 0;
        for (int i = 0; i < 128; ++i) {
            indiWidth = this.fontMetrics.charWidth(i);
            if (indiWidth <= 1) continue;
            ++totalCount;
            totalWidth += indiWidth;
        }
        this.multiplierXCharacters = totalCount > 0 ? (double)totalWidth / (double)totalCount : this.multiplierYCharacters;
        this.multiplierYDeviceUnits = 0.12;
        this.multiplierXDeviceUnits = 0.12;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("Monospaced", 0, 10));
        }
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.getFont();
        }
        return this.fontMetrics;
    }

    @Override
    public void setLineExtend(double extend) {
        this.lineExtend = (int)extend;
    }

    @Override
    public void setPitch(int pitchType) {
    }

    @Override
    public void setTabStop(double tabStop) {
        this.tabStop = (int)tabStop;
    }

    @Override
    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public Color getTextColor() {
        return this.textColor != null ? this.textColor : Color.black;
    }

    @Override
    public void setTextPositionX(double xpos, boolean bottom) {
        this.xpos = xpos;
    }

    @Override
    public void setTextPositionY(double ypos, boolean bottom) {
        this.ypos = bottom ? ypos - (double)this.fontDescent : ypos + (double)this.fontAscent;
    }

    @Override
    public void textOut(String text, double xpos, double ypos, boolean box, boolean shade) {
        Graphics g = this.getGraphics();
        g.setFont(this.getFont());
        Color c = this.getTextColor();
        int w = this.fontMetrics.stringWidth(text);
        int h = (int)this.multiplierYCharacters;
        int lines = 1;
        int advances = 0;
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            if (text.charAt(i) == '\n') {
                ++lines;
            }
            if (text.charAt(i) != '\r') continue;
            ++advances;
        }
        h *= lines;
        int x = (int)xpos;
        int y = (int)ypos;
        int boxOffsetX = x + this.leftMargin - 2;
        int boxOffsetY = y - (h += advances * this.lineExtend) + this.topMargin;
        int widestW = -1;
        if (w > 0 && shade) {
            g.setColor(this.getShadeColor());
            g.fillRect(boxOffsetX, boxOffsetY, w + 2, h + 2);
        }
        g.setColor(c);
        StringBuffer result = new StringBuffer();
        String resultString = null;
        char ch = '\u0000';
        int descender = this.fontMetrics.getDescent();
        block6: for (int i = 0; i < textLength; ++i) {
            ch = text.charAt(i);
            switch (ch) {
                case '\r': {
                    int stringWidth;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        g.drawString(resultString, x + this.leftMargin, y + this.topMargin);
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            g.drawLine(x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender);
                        }
                        if (this.fontStrikeOut) {
                            g.drawLine(x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2);
                        }
                        if (this.fontDoubleStrike) {
                            g.drawString(resultString, x + this.leftMargin + 1, y + this.topMargin);
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += this.lineExtend;
                    x = 0;
                    continue block6;
                }
                case '\n': {
                    int stringWidth;
                    resultString = result.toString();
                    if (resultString != null && resultString.length() > 0) {
                        g.drawString(resultString, x + this.leftMargin, y + this.topMargin);
                        stringWidth = this.fontMetrics.stringWidth(resultString);
                        if (stringWidth > widestW) {
                            widestW = stringWidth;
                        }
                        if (this.fontUnderline) {
                            g.drawLine(x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender);
                        }
                        if (this.fontStrikeOut) {
                            g.drawLine(x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2);
                        }
                        if (this.fontDoubleStrike) {
                            g.drawString(resultString, x + this.leftMargin + 1, y + this.topMargin);
                        }
                        x += stringWidth;
                    }
                    result.setLength(0);
                    y += h;
                    y -= this.lineExtend;
                    continue block6;
                }
                case '\u0000': {
                    continue block6;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        if (result.length() > 0 && (resultString = result.toString()) != null && resultString.length() > 0) {
            g.drawString(resultString, x + this.leftMargin, y + this.topMargin);
            int stringWidth = this.fontMetrics.stringWidth(resultString);
            if (stringWidth > widestW) {
                widestW = stringWidth;
            }
            if (this.fontUnderline) {
                g.drawLine(x + this.leftMargin, y + this.topMargin + descender, x + this.leftMargin + stringWidth, y + this.topMargin + descender);
            }
            if (this.fontStrikeOut) {
                g.drawLine(x + this.leftMargin, y + this.topMargin - h / 2, x + this.leftMargin + stringWidth, y + this.topMargin - h / 2);
            }
            if (this.fontDoubleStrike) {
                g.drawString(resultString, x + this.leftMargin + 1, y + this.topMargin);
            }
            x += stringWidth;
        }
        this.xpos = x;
        this.ypos = y;
        w = widestW;
        if (w > 0) {
            g.setColor(c);
            if (box) {
                g.drawRect(boxOffsetX, boxOffsetY, w + 2, h + 2);
            }
        }
    }

    private int indexOfEscapesFull(String text) {
        return this.indexOfAny(text, ESCAPES_FULL);
    }

    private int indexOfEscapesSimple(String text) {
        return this.indexOfAny(text, ESCAPES_SIMPLE);
    }

    private int indexOfAny(String text, char[] escapes) {
        int min = Integer.MAX_VALUE;
        int index = -1;
        if (escapes != null) {
            int length = escapes.length;
            for (int i = 0; i < length; ++i) {
                index = text.indexOf(escapes[i]);
                if (index < 0 || index >= min) continue;
                min = index;
            }
        }
        return min == Integer.MAX_VALUE ? -1 : min;
    }

    @Override
    public boolean write(String text) {
        boolean ejected;
        block12: {
            if (text == null) {
                return false;
            }
            String partial = null;
            ejected = false;
            text = text.replace('\u0000', ' ');
            try {
                if (this.escapeSequences) {
                    int split = -1;
                    do {
                        if ((split = this.indexOfEscapesFull(text)) >= 0) {
                            try {
                                partial = text.substring(0, split);
                                this.writeText(partial);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            text = this.writeEscape(text.substring(split));
                            ejected |= this.checkPageSplit();
                            continue;
                        }
                        this.writeText(text);
                        text = null;
                    } while (split >= 0);
                    break block12;
                }
                int split = -1;
                do {
                    if ((split = this.indexOfEscapesSimple(text)) >= 0) {
                        try {
                            partial = text.substring(0, split);
                            this.writeText(partial);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        text = this.writeEscape(text.substring(split));
                        ejected |= this.checkPageSplit();
                        continue;
                    }
                    this.writeText(text);
                    text = null;
                } while (split >= 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ejected;
    }

    private boolean checkPageSplit() {
        if (this.ypos >= (double)this.pageSplitBoundary) {
            this.eject();
            this.resetX();
            this.resetY();
            return true;
        }
        return false;
    }

    public void writeText(String text) {
        if (text == null) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        if (this.enableGraphics && text.startsWith(this.graphicsTag)) {
            this.drawTextEscapeGraphics(text);
            return;
        }
        Graphics g = this.getGraphics();
        g.setColor(this.getTextColor());
        g.setFont(this.getFont());
        g.drawString(text, (int)(this.xpos + (double)this.leftMargin), (int)(this.ypos + (double)this.topMargin));
        this.xpos += (double)this.fontMetrics.stringWidth(text);
    }

    public String writeEscape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 0) {
            return text;
        }
        switch (text.charAt(0)) {
            case '\t': {
                int int_xpos = (int)this.xpos;
                int int_tabStop = this.tabStop;
                if (int_tabStop > 0) {
                    int_xpos = int_xpos % int_tabStop == 0 ? (int_xpos += int_tabStop) : (int_xpos += int_xpos % int_tabStop);
                    this.xpos = int_xpos;
                }
                if (this.xpos >= (double)this.pageBoundaryX) {
                    this.resetX();
                    this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                }
                return text.substring(1);
            }
            case '\n': {
                this.ypos += this.multiplierYCharacters - (double)this.lineExtend;
                return text.substring(1);
            }
            case '\r': {
                this.resetX();
                this.ypos += (double)this.lineExtend;
                return text.substring(1);
            }
            case '\u000e': {
                Font currentFont = this.getFont();
                this.setFont(new Font(currentFont.getName(), currentFont.getStyle() | 1, currentFont.getSize()));
                return text.substring(1);
            }
            case '\u000f': {
                Font currentFont = this.getFont();
                this.setFont(new Font(currentFont.getName(), currentFont.getStyle() & 0xFFFFFFFE, currentFont.getSize()));
                return text.substring(1);
            }
            case '\u001b': {
                char value = text.charAt(3);
                switch (text.charAt(1)) {
                    case '&': {
                        switch (text.charAt(2)) {
                            case 'a': {
                                switch (text.charAt(4)) {
                                    case 'L': {
                                        this.leftMargin = (int)(12.0 + (double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'k': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        this.tabStop = (int)((double)value * this.multiplierXCharacters);
                                    }
                                }
                                return text.substring(4);
                            }
                            case 'l': {
                                switch (text.charAt(4)) {
                                    case 'D': {
                                        this.lineExtend = value;
                                        break;
                                    }
                                    case 'E': {
                                        this.topMargin = (int)((double)value * this.multiplierYCharacters + 12.0);
                                        break;
                                    }
                                    case 'F': {
                                        break;
                                    }
                                    case 'H': {
                                        break;
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '(': {
                        switch (text.charAt(2)) {
                            case 's': {
                                switch (text.charAt(4)) {
                                    case 'H': {
                                        break;
                                    }
                                    case 'S': {
                                        break;
                                    }
                                    case 'V': {
                                        Font currentFont = this.getFont();
                                        this.setFont(new Font(currentFont.getName(), currentFont.getStyle(), value));
                                    }
                                }
                                return text.substring(4);
                            }
                        }
                        return text.substring(3);
                    }
                    case '9': {
                        return text.substring(2);
                    }
                    case 'E': {
                        this.clearFont();
                        this.leftMargin = 12;
                        this.topMargin = 12;
                        return text.substring(2);
                    }
                }
                return text.substring(2);
            }
        }
        return text.substring(1);
    }

    @Override
    public void setLeftMargin(double leftMargin) {
        this.leftMargin = (int)leftMargin + 12;
    }

    @Override
    public double getLeftMargin() {
        return this.leftMargin - 12;
    }

    @Override
    public void setBottomMargin(double leftMargin) {
        this.bottomMargin = this.bottomMargin;
    }

    @Override
    public double getBottomMargin() {
        return this.bottomMargin;
    }

    @Override
    public void setTopMargin(double topMargin) {
        boolean reset = false;
        if (topMargin < 0.0) {
            topMargin = -topMargin;
        }
        this.nextTopMargin = (int)topMargin + 12;
        if (reset) {
            this.resetY();
        }
    }

    @Override
    public double getTopMargin() {
        return this.topMargin - 12;
    }

    @Override
    public void setDeviceMode(String attrib, String value) {
        this.setAttribute(attrib, value);
    }

    @Override
    public String getDeviceCapability(String attrib) {
        if ((attrib = this.normalizeAttribute(attrib)) != null) {
            if (attrib.startsWith("TECHNOLOGY")) {
                return "Elastic COBOL JDK 1.1 Driver";
            }
            if (attrib != null && attrib.startsWith("SUPPORTED")) {
                return "11,HORIZONTAL_AREA,VERTICAL_AREA,HORIZONTAL_RESOLUTION,VERTICAL_RESOLUTION,HORIZONTAL_INCHES,VERTICAL_INCHES,PHYSICAL_WIDTH,PHYSICAL_HEIGHT,LOGICAL_PIXELS_X,LOGICAL_PIXELS_Y,TECHNOLOGY";
            }
            if (this.job != null) {
                int pixelsPerInch = this.job.getPageResolution();
                Dimension pagesize = this.job.getPageDimension();
                if (attrib.startsWith("HORIZONTAL_AREA")) {
                    return String.valueOf((double)pagesize.width / (this.multiplierXMetric * 10.0));
                }
                if (attrib.startsWith("VERTICAL_AREA")) {
                    return String.valueOf((double)pagesize.height / (this.multiplierYMetric * 10.0));
                }
                if (attrib.startsWith("HORIZONTAL_RESOLUTION")) {
                    return String.valueOf(pagesize.width);
                }
                if (attrib.startsWith("VERTICAL_RESOLUTION")) {
                    return String.valueOf(pagesize.height);
                }
                if (attrib.startsWith("HORIZONTAL_INCHES")) {
                    return String.valueOf((double)pagesize.width / this.multiplierXInches);
                }
                if (attrib.startsWith("VERTICAL_INCHES")) {
                    return String.valueOf((double)pagesize.height / this.multiplierYInches);
                }
                if (attrib.startsWith("PHYSICAL_WIDTH")) {
                    return String.valueOf((double)pagesize.width / this.multiplierXDeviceUnits);
                }
                if (attrib.startsWith("PHYSICAL_HEIGHT")) {
                    return String.valueOf((double)pagesize.height / this.multiplierYDeviceUnits);
                }
                if (attrib.startsWith("LOGICAL_PIXELS_X")) {
                    return String.valueOf(pixelsPerInch);
                }
                if (attrib.startsWith("LOGICAL_PIXELS_Y")) {
                    return String.valueOf(pixelsPerInch);
                }
            }
        }
        return this.getAttribute(attrib);
    }

    @Override
    public void setEscapeSequences(boolean state) {
        this.escapeSequences = state;
    }

    @Override
    public String getPrinterInfo(String attrib) {
        attrib = this.normalizeAttribute(attrib);
        return this.getAttribute(attrib);
    }

    @Override
    public void setConnectorThickness(int thickness) {
        if (thickness < 0) {
            thickness = 0;
        }
        this.CONNECTION_THICKNESS = thickness;
    }

    @Override
    public void setConnector(double xpos, double ypos, int type) {
        this.connect((int)xpos, (int)ypos, type);
    }

    public void resetConnectors() {
        this.connectors.setSize(0);
    }

    public void connect(int effectiveX, int effectiveY, int connect) {
        ConnectorNode add = new ConnectorNode(effectiveX, effectiveY, connect);
        this.connectors.addElement(add);
    }

    public void connect(ConnectorNode from, ConnectorNode to) {
        boolean shade;
        int fromX = from.x;
        int fromY = from.y;
        int toX = to.x;
        int toY = to.y;
        int width = (toX += this.leftMargin) - (fromX += this.leftMargin);
        int height = (toY += this.topMargin) - (fromY += this.topMargin);
        if (width < 0) {
            width = -width;
        }
        if (height < 0) {
            height = -height;
        }
        boolean horizontal = false;
        if (fromY == toY) {
            horizontal = true;
        }
        Graphics g = this.getGraphics();
        g.setColor(this.getPenColor());
        int thick = from.connect & 0xF0 | to.connect & 0xF0;
        boolean bl = shade = (thick & 0x10) == 16;
        if ((thick & 0x20) == 32) {
            if (shade) {
                g.setColor(this.getShadeColor());
            }
            g.drawLine(fromX, fromY, toX, toY);
            if (shade) {
                g.setColor(this.getPenColor());
            }
        }
        if ((thick & 0x80) == 128) {
            int arcWidth = this.CONNECTION_THICKNESS;
            int arcHeight = this.CONNECTION_THICKNESS;
            if (shade) {
                g.setColor(this.getShadeColor());
            }
            if (horizontal) {
                if (shade) {
                    g.fillRoundRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight);
                    g.setColor(this.getPenColor());
                }
                g.drawRoundRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight);
            } else {
                if (shade) {
                    g.drawRoundRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight);
                    g.setColor(this.getPenColor());
                }
                g.drawRoundRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2, arcWidth, arcHeight);
            }
        }
        if ((thick & 0x40) == 64) {
            if (shade) {
                g.setColor(this.getShadeColor());
            }
            if (horizontal) {
                if (shade) {
                    g.fillRect(fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1);
                    g.setColor(this.getPenColor());
                }
                g.drawRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2);
            } else {
                if (shade) {
                    g.fillRect(fromX - this.CONNECTION_THICKNESS + 1, fromY - this.CONNECTION_THICKNESS + 1, width + this.CONNECTION_THICKNESS * 2 - 1, height + this.CONNECTION_THICKNESS * 2 - 1);
                    g.setColor(this.getPenColor());
                }
                g.drawRect(fromX - this.CONNECTION_THICKNESS, fromY - this.CONNECTION_THICKNESS, width + this.CONNECTION_THICKNESS * 2, height + this.CONNECTION_THICKNESS * 2);
            }
        }
    }

    public void realizeConnectors() {
        ConnectorNode toDraw;
        int drawTo;
        int draw;
        int cSize;
        ConnectorNode cand;
        int k;
        int candidateSize;
        int j;
        int i;
        int size = this.connectors.size();
        ConnectorNode base = null;
        ConnectorNode check = null;
        Vector<ConnectorNode> candidate = new Vector<ConnectorNode>();
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 0xC) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.x != base.x || (check.connect & 0xC) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.y <= check.y) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block3: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 8) != 8) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 4) != 4) continue;
                    baseDraw.connect &= 0xFFFFFFF7;
                    toDraw.connect &= 0xFFFFFFFB;
                    this.connect(baseDraw, toDraw);
                    continue block3;
                }
            }
        }
        base = null;
        check = null;
        candidate.setSize(0);
        for (i = 0; i < size - 1; ++i) {
            base = this.connector(i);
            if ((base.connect & 3) == 0) continue;
            candidate.setSize(0);
            candidate.addElement(base);
            for (j = i + 1; j < size; ++j) {
                check = this.connector(j);
                if (check.y != base.y || (check.connect & 3) == 0) continue;
                candidateSize = candidate.size();
                boolean inserted = false;
                for (k = 0; k < candidateSize; ++k) {
                    cand = (ConnectorNode)candidate.elementAt(k);
                    if (cand.x <= check.x) continue;
                    candidate.insertElementAt(check, k);
                    inserted = true;
                    break;
                }
                if (inserted) continue;
                candidate.addElement(check);
            }
            cSize = candidate.size();
            block8: for (draw = 0; draw < cSize; ++draw) {
                ConnectorNode baseDraw = (ConnectorNode)candidate.elementAt(draw);
                if ((baseDraw.connect & 2) != 2) continue;
                for (drawTo = draw + 1; drawTo < cSize; ++drawTo) {
                    toDraw = (ConnectorNode)candidate.elementAt(drawTo);
                    if ((toDraw.connect & 1) != 1) continue;
                    baseDraw.connect &= 0xFFFFFFFD;
                    toDraw.connect &= 0xFFFFFFFE;
                    this.connect(baseDraw, toDraw);
                    continue block8;
                }
            }
        }
        this.resetConnectors();
    }

    public ConnectorNode connector(int i) {
        try {
            return this.connectors.elementAt(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setXORMode(Color c) {
        this.getGraphics().setXORMode(c);
    }

    @Override
    public void setPaintMode() {
        this.getGraphics().setPaintMode();
    }

    private final String drawTextEscapeGraphics(String drawLine) {
        Graphics page = this.getGraphics();
        int x = (int)this.xpos;
        int y = (int)this.ypos;
        if (this.enableGraphics && drawLine != null && drawLine.startsWith(this.graphicsTag)) {
            StringTokenizer st = new StringTokenizer(drawLine.substring(5), "\t\n\r(),:; ");
            String token = null;
            token = st.nextToken();
            if (token == null) {
                token = st.nextToken();
            }
            String[] param = new String[8];
            int[] intParam = new int[8];
            String paramToken = null;
            for (int paramCounter = 0; st.hasMoreTokens() && paramCounter < 8; ++paramCounter) {
                param[paramCounter] = paramToken = st.nextToken();
                if (paramToken == null || paramToken.length() <= 0) continue;
                try {
                    paramToken = paramToken.trim();
                    if (paramToken.equals("<X>")) {
                        intParam[paramCounter] = x;
                        continue;
                    }
                    if (paramToken.equals("<Y>")) {
                        intParam[paramCounter] = y;
                        continue;
                    }
                    char tokenModifier = paramToken.charAt(0);
                    switch (tokenModifier) {
                        case 'R': 
                        case 'r': {
                            intParam[paramCounter] = this.translatey + this.aligny + (int)((double)(ConvertData.parseInt(paramToken.substring(1).trim()) + 1) * this.printerFontMetricHeight);
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            intParam[paramCounter] = this.translatex + this.alignx + ConvertData.parseInt(paramToken.substring(1).trim()) * this.printerFontWidth;
                            break;
                        }
                        default: {
                            intParam[paramCounter] = ConvertData.parseInt(paramToken.trim());
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (token != null) {
                if ((token = token.toUpperCase()).equals("CLEARRECT") || token.equals("CLEAR")) {
                    page.clearRect(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("CLIPRECT") || token.equals("CLIP")) {
                    page.clipRect(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("COPYAREA") || token.equals("COPY")) {
                    page.copyArea(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]);
                } else if (token.equals("DRAW3DRECT") || token.equals("3DRECT")) {
                    page.draw3DRect(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0);
                } else if (token.equals("DRAWARC") || token.equals("ARC")) {
                    page.drawArc(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]);
                } else if (token.equals("DRAWLINE") || token.equals("LINE")) {
                    page.drawLine(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("DRAWOVAL") || token.equals("OVAL")) {
                    page.drawOval(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("DRAWRECT") || token.equals("RECT") || token.equals("RECTANGLE")) {
                    page.drawRect(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("DRAWROUNDRECT") || token.equals("ROUNDRECT") || token.equals("ROUNDRECTANGLE")) {
                    page.drawRoundRect(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]);
                } else if (token.equals("DRAWSTRING") || token.equals("STRING") || token.equals("TEXT")) {
                    page.drawString(param[0], intParam[1], intParam[2]);
                } else if (token.equals("FILL3DRECT") || token.equals("FILL3DRECTANGLE")) {
                    page.fill3DRect(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4] != 0);
                } else if (token.equals("FILLARC")) {
                    page.fillArc(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]);
                } else if (token.equals("FILLOVAL")) {
                    page.fillOval(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("FILLRECT") || token.equals("FILLRECTANGLE")) {
                    page.fillRect(intParam[0], intParam[1], intParam[2], intParam[3]);
                } else if (token.equals("FILLROUNDRECT") || token.equals("FILLROUNDRECTANGLE")) {
                    page.fillRoundRect(intParam[0], intParam[1], intParam[2], intParam[3], intParam[4], intParam[5]);
                } else if (token.equals("FONT")) {
                    page.setFont(Font.decode(param[0]));
                } else if (token.equals("PAINTMODE") || token.equals("PAINT")) {
                    page.setPaintMode();
                } else if (token.equals("XORMODE") || token.equals("XOR")) {
                    page.setXORMode(ColorProvider.getColor(param[0]));
                } else if (token.equals("COLOR")) {
                    page.setColor(ColorProvider.getColor(param[0]));
                } else if (token.equals("TRANSLATE")) {
                    page.translate(intParam[0], intParam[1]);
                } else if (!token.equals("SETLINE")) {
                    if (token.equals("DRAWIMAGE") || token.equals("IMAGE")) {
                        try {
                            page.drawImage(MediaImage.getImage(param[0]), intParam[1], intParam[2], intParam[3], intParam[4], this.getComponent());
                        }
                        catch (Exception exception) {}
                    } else {
                        return drawLine;
                    }
                }
                return null;
            }
        }
        return drawLine;
    }

    @Override
    public String command(String command) {
        return " ";
    }

    private static class ConnectorNode {
        public int x;
        public int y;
        public int connect;

        public String toString() {
            return "(" + this.x + "," + this.y + ":" + this.connect + ")";
        }

        public ConnectorNode(int x, int y, int connect) {
            this.x = x;
            this.y = y;
            this.connect = connect;
        }
    }
}

