/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.run;

import com.heirloomcomputing.ecs.exec.ColorProvider;
import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.IEnvironment;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.ThreadQueue;
import com.heirloomcomputing.ecs.exec.Utilities;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Date;
import java.util.Vector;

public class applet
extends Applet
implements ActionListener,
IEnvironment {
    private static final boolean DEFAULT_PROGRAM_STACKTRACE = true;
    private static final boolean DEFAULT_PROGRESS_BAR = true;
    private static final int STATE_DESTROY = 0;
    private static final int STATE_INIT = 1;
    private static final int STATE_START = 2;
    private static final int STATE_STOP = 3;
    private static final String applet_prefix = "applet";
    private static final String[][] parameterInfo = new String[][]{{"program", "Program class name"}, {"program.name", "User visible program name"}, {"program.description", "Short description of program"}, {"program.license", "License text"}, {"program.progress", "Progress bar while loading, yes or no"}, {"program.progress.stripe", "Color of stripe #RRGGBB"}, {"program.progress.base", "Color of base #RRGGBB"}, {"program.progress.border", "Color of border #RRGGBB"}, {"program.stacktrace", "Display stack trace upon error"}};
    private boolean programVectorUsed = false;
    private final Vector<String> programVector = new Vector();
    private static int currentState = 0;
    private boolean specialAppletMethods;
    private Method applet_init;
    private Method applet_init_old;
    private Method applet_start;
    private Method applet_stop;
    private Method applet_destroy;
    private Method applet_setup;
    private Method applet_run;
    private Method applet_runBegin;
    private Method applet_runEnd;
    private String programName;
    private Class<?> programClass;
    private Object program;
    private String program_name;
    private String program_description;
    private String program_license;
    private String program_image;
    private boolean progressBar = true;
    private boolean program_stacktrace = true;
    private boolean alreadySetup;
    private Color progress_border;
    private Color progress_red;
    private Color progress_white;
    private Panel nameAndDescription;
    private Panel enterProgramName;
    private Panel enterProgramPanel;
    private Panel progressAndLicense;
    private Label programLabel;
    private Label programDescription;
    private Label enterProgramLabel;
    private Label licenseLabel;
    private TextField enterProgramField;
    private Choice enterProgramChoice;
    private Button enterProgramButton;
    private BarberProgress progressBarComponent;
    private BarberTick tick;
    private Image image;
    private Insets insets = new Insets(4, 4, 4, 4);
    private final Object waitForProgramName = new Object();

    private void fillVector() {
        String check;
        this.programVectorUsed = false;
        this.programVector.removeAllElements();
        int element = 1;
        while ((check = this.getSafeParameter("program." + element)) != null) {
            this.programVectorUsed = true;
            this.programVector.addElement(check);
            ++element;
        }
    }

    private void fillChoiceFromVector() {
        if (this.enterProgramChoice == null) {
            return;
        }
        if (!this.programVectorUsed) {
            return;
        }
        int size = this.programVector.size();
        for (int i = 0; i < size; ++i) {
            String visibleName = this.programVector.elementAt(i);
            String check = this.getSafeParameter("program.name." + (i + 1));
            if (check != null) {
                visibleName = check;
            }
            if (visibleName == null) {
                visibleName = "Empty Slot";
            }
            this.enterProgramChoice.add(visibleName);
        }
    }

    private static void yield() {
        try {
            Thread.yield();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void reinitialize() {
        this.specialAppletMethods = false;
        this.applet_init = null;
        this.applet_init_old = null;
        this.applet_start = null;
        this.applet_stop = null;
        this.applet_destroy = null;
        this.applet_setup = null;
        this.applet_run = null;
        this.applet_runBegin = null;
        this.applet_runEnd = null;
        this.programName = null;
        this.programClass = null;
        this.program = null;
        this.program_name = null;
        this.program_description = null;
        this.program_license = null;
        this.program_image = null;
        this.progressBar = true;
        this.program_stacktrace = true;
        this.alreadySetup = false;
        this.progress_border = null;
        this.progress_red = null;
        this.progress_white = null;
        this.nameAndDescription = null;
        this.enterProgramName = null;
        this.enterProgramPanel = null;
        this.progressAndLicense = null;
        this.programLabel = null;
        this.programDescription = null;
        this.enterProgramLabel = null;
        this.enterProgramField = null;
        this.enterProgramButton = null;
        this.progressBarComponent = null;
        this.tick = null;
        this.licenseLabel = null;
        this.fillVector();
    }

    private boolean initialize() {
        if (this.programClass == null) {
            Throwable loadException;
            block6: {
                this.promptForProgramName();
                this.programName = this.massage(this.programName);
                loadException = null;
                try {
                    this.beginProgressBar();
                    try {
                        this.programClass = Class.forName(this.programName);
                        this.setupProgram(this.programClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        loadException = classNotFoundException;
                        Class<?> thisClass = this.getClass();
                        ClassLoader thisClassLoader = thisClass.getClassLoader();
                        this.programClass = thisClassLoader.loadClass(this.programName);
                    }
                }
                catch (Throwable throwable) {
                    if (loadException != null) break block6;
                    loadException = throwable;
                }
            }
            this.endProgressBar();
            this.removeGraphics();
            if (loadException != null) {
                this.giveError(loadException);
            }
        }
        return this.programClass != null;
    }

    private void parseParameters() {
        this.parseParameters("");
    }

    private void parseParameters(String append) {
        String temp;
        if (append == null) {
            append = "";
        }
        if (append.length() == 0) {
            this.programName = this.getSafeParameter("program.class" + append);
            if (this.programName == null) {
                this.programName = this.getSafeParameter("program" + append);
            }
            if (this.programName == null) {
                this.programName = this.getSafeParameter("applet.class" + append);
            }
            if (this.programName == null) {
                this.programName = this.getSafeParameter(applet_prefix + append);
            }
            if (this.programName == null) {
                this.programName = this.getSafeParameter("program-id" + append);
            }
            if (this.programName == null) {
                this.programName = this.getSafeParameter("program_id" + append);
            }
        }
        this.program_name = this.getSafeParameter("program.name" + append);
        if (this.program_name == null) {
            this.program_name = this.getSafeParameter("program_name" + append);
        }
        this.program_description = this.getSafeParameter("program.description" + append);
        if (this.program_description == null) {
            this.getSafeParameter("program_description" + append);
        }
        this.program_license = this.getSafeParameter("program.license" + append);
        if (this.program_license == null) {
            this.program_license = this.getSafeParameter("program_license" + append);
        }
        if (this.program_license == null) {
            this.program_license = this.getSafeParameter("program.copyright" + append);
        }
        if (this.program_license == null) {
            this.program_license = this.getSafeParameter("program_copyright" + append);
        }
        this.program_image = this.getSafeParameter("program.image" + append);
        if (this.program_image == null) {
            this.program_image = this.getSafeParameter("program_image" + append);
        }
        if ((temp = this.getSafeParameter("program.progress" + append)) == null) {
            temp = this.getSafeParameter("program_progress" + append);
        }
        if (temp != null) {
            boolean bl = this.progressBar = (temp = temp.toUpperCase()).startsWith("Y") || temp.startsWith("T") || temp.startsWith("1");
        }
        if ((temp = this.getSafeParameter("program.stacktrace" + append)) == null) {
            temp = this.getSafeParameter("program_stacktrace" + append);
        }
        if (temp != null && temp.length() > 0) {
            switch (temp.charAt(0)) {
                case '1': 
                case 'T': 
                case 'Y': 
                case 't': 
                case 'y': {
                    this.program_stacktrace = true;
                    break;
                }
                default: {
                    this.program_stacktrace = false;
                }
            }
        }
        if ((temp = this.getSafeParameter("program.progress.stripe" + append)) == null) {
            temp = this.getSafeParameter("program_progress_stripe" + append);
        }
        if (temp == null) {
            temp = this.getSafeParameter("program.progress.red" + append);
        }
        if (temp == null) {
            temp = this.getSafeParameter("program_progress_red" + append);
        }
        if (temp != null) {
            this.progress_red = ColorProvider.getColor(temp);
        }
        if ((temp = this.getSafeParameter("program.progress.base" + append)) == null) {
            temp = this.getSafeParameter("program_progress_base" + append);
        }
        if (temp == null) {
            temp = this.getSafeParameter("program.progress.white" + append);
        }
        if (temp == null) {
            temp = this.getSafeParameter("program_progress_white" + append);
        }
        if (temp != null) {
            this.progress_white = ColorProvider.getColor(temp);
        }
        if ((temp = this.getSafeParameter("program.progress.border" + append)) == null) {
            temp = this.getSafeParameter("program_progress_border" + append);
        }
        if (temp != null) {
            this.progress_border = ColorProvider.getColor(temp);
        }
    }

    private final Method getMethod(String name, Class<?>[] params) throws NoSuchMethodException {
        return this.programClass.getMethod(name, params);
    }

    public void setupProgram(Class<?> clazz) {
        Method[] methods;
        if (this.programName == null) {
            this.programName = clazz.getName();
        }
        this.programClass = clazz;
        Class[] params = new Class[]{};
        try {
            this.applet_init = this.getMethod("applet_init", params);
            if (this.applet_init != null) {
                this.specialAppletMethods = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_init_old = this.getMethod("applet_init_old", params);
            if (this.applet_init_old != null) {
                this.specialAppletMethods = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_start = this.getMethod("applet_start", params);
            if (this.applet_start != null) {
                this.specialAppletMethods = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_stop = this.getMethod("applet_stop", params);
            if (this.applet_stop != null) {
                this.specialAppletMethods = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_destroy = this.getMethod("applet_destroy", params);
            if (this.applet_destroy != null) {
                this.specialAppletMethods = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_setup = this.programClass.getMethod("setup", Context.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.applet_setup == null) {
                this.applet_setup = this.programClass.getMethod("_setup", Context.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_run = this.programClass.getMethod("run", params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.applet_run == null) {
                this.applet_run = this.programClass.getMethod("_run", params);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_runBegin = this.programClass.getMethod("runBegin", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.applet_runBegin == null) {
                this.applet_runBegin = this.programClass.getMethod("_runBegin", new Class[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.applet_runEnd = this.programClass.getMethod("runEnd", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.applet_runEnd == null) {
                this.applet_runEnd = this.programClass.getMethod("_runEnd", new Class[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.specialAppletMethods && (methods = this.programClass.getMethods()) != null) {
            int methodsLength = methods.length;
            Method check = null;
            String name = null;
            for (int i = 0; i < methodsLength; ++i) {
                check = methods[i];
                name = check.getName();
                if (!name.startsWith(applet_prefix)) continue;
                if (name.startsWith("applet_init")) {
                    if (this.applet_init == null) {
                        this.applet_init = check;
                    }
                    this.specialAppletMethods = true;
                    continue;
                }
                if (name.startsWith("applet_start")) {
                    if (this.applet_start == null) {
                        this.applet_start = check;
                    }
                    this.specialAppletMethods = true;
                    continue;
                }
                if (name.startsWith("applet_stop")) {
                    if (this.applet_stop == null) {
                        this.applet_stop = check;
                    }
                    this.specialAppletMethods = true;
                    continue;
                }
                if (!name.startsWith("applet_destroy")) continue;
                if (this.applet_destroy == null) {
                    this.applet_destroy = check;
                }
                this.specialAppletMethods = true;
            }
        }
    }

    private void giveError(Throwable t) {
        String cure = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
            PrintWriter writer = new PrintWriter(bos);
            t.printStackTrace(writer);
            writer.flush();
            writer.close();
            this.insets = new Insets(4, 4, 4, 4);
            this.repaint();
            String message = "";
            String lineSep = "\r\n";
            try {
                lineSep = System.getProperty("line.separator");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t instanceof RuntimeException) {
                message = "Runtime Exception loading '" + this.programName + "': " + t + lineSep;
            } else if (t instanceof Exception) {
                message = "Exception loading '" + this.programName + "': " + t + lineSep;
            } else if (t instanceof Error) {
                message = "Error loading '" + this.programName + "': " + t + lineSep;
            } else if (t instanceof Throwable) {
                message = "General Exception loading '" + this.programName + "': " + t + lineSep;
            }
            if (cure == null) {
                cure = t instanceof ClassCastException ? "The code attempted to cast an object to a subclass of which it is not an instance." : (t instanceof ClassCircularityError ? "A circularity error has been detected while initializing a class." + lineSep + "This means that Class A is referring to Class B, and Class B to Class A in a manner which cannot be resolved by this JVM." : (t instanceof ClassFormatError ? "The Java Virtual Machine attempted to read a class file but has determined that the file is malformed" + lineSep + "or otherwise cannot be interpreted as a class file." : (t instanceof ClassNotFoundException ? "An attempt has been made to load a class by name, but the named class could not be found." + lineSep + "Check the name of the the class '" + this.programName + "' against the actual .class file." + lineSep + "Check that the file is in the correct location on the server." : (t instanceof SecurityException ? "The program has attempted to perform an action which" + lineSep + "was disallowed by the Java security manager." : "No general suggestions are available for this error."))));
            }
            String environment = "";
            try {
                environment = lineSep + "Environment " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " / " + System.getProperty("os.arch") + " using " + System.getProperty("java.vendor") + " JVM " + System.getProperty("java.version") + lineSep;
            }
            catch (Exception exception) {
                // empty catch block
            }
            String bosString = "";
            if (this.program_stacktrace) {
                bosString = bos.toString();
            }
            bosString = cure + lineSep + environment + lineSep + message + lineSep + bosString;
            this.removeGraphics();
            this.removeAll();
            TextArea textArea = new TextArea(20, 60);
            textArea.setText(bosString);
            textArea.setEditable(false);
            this.setLayout(new BorderLayout());
            this.add("Center", textArea);
        }
        catch (Throwable logError) {
            logError.printStackTrace(System.out);
        }
    }

    private synchronized void validateState(int desiredState) {
        do {
            ++currentState;
            switch (currentState &= 3) {
                case 1: {
                    this.doInit();
                    break;
                }
                case 2: {
                    this.doStart();
                    break;
                }
                case 3: {
                    this.doStop();
                    break;
                }
                case 0: {
                    this.doDestroy();
                }
            }
        } while (currentState != desiredState);
    }

    @Override
    public synchronized void init() {
        this.validateState(1);
    }

    @Override
    public synchronized void start() {
        this.validateState(2);
    }

    @Override
    public synchronized void stop() {
        this.validateState(3);
    }

    @Override
    public void destroy() {
        this.validateState(0);
    }

    private void doInit() {
        ThreadQueue.trackThreads();
        this.reinitialize();
        this.parseParameters();
        this.addGraphics();
    }

    private void doStart() {
        RuntimeEnvironment.setGlobalRuntimeEnvironment(this);
        Utilities.startApplet(this);
        this.initialize();
        if (this.programClass != null) {
            Utilities.startApplet(this);
            if (this.specialAppletMethods) {
                this.call(this.applet_init);
                this.call(this.applet_start);
            }
            this.call(this.applet_run);
        }
    }

    private void doStop() {
        if (this.programClass != null) {
            if (this.specialAppletMethods) {
                this.call(this.applet_stop);
            }
            Utilities.stopApplet(this);
        }
    }

    private void doDestroy() {
        if (this.programClass != null && this.specialAppletMethods) {
            this.call(this.applet_destroy);
        }
        this.removeAll();
        this.repaint();
        this.setLayout(new BorderLayout());
        ThreadQueue.stopAllThreads();
        ThreadQueue.resetThreadGroup();
    }

    @Override
    public String getAppletInfo() {
        String footer = "Elastic COBOL Applet started " + new Date() + "\nElastic COBOL Runtime Copyright (C) 2010-2023 Heirloom Computing.\nAll Rights Reserved.\n";
        String header = null;
        String linesep = "\n";
        try {
            linesep = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            // empty catch block
        }
        header = this.program_name != null ? this.program_name : this.programName;
        if (header != null) {
            header = header + linesep;
            if (this.program_description != null) {
                header = header + this.program_description + linesep;
            }
            if (this.program_license != null) {
                header = header + this.program_license + linesep;
            }
            header = header + linesep;
        }
        if (header == null) {
            header = "";
        }
        return header + footer;
    }

    @Override
    public String[][] getParameterInfo() {
        return parameterInfo;
    }

    private String getSafeParameter(String name) {
        try {
            String result = this.getParameter(name);
            if (result == null) {
                result = this.getParameter(name.toUpperCase());
            }
            if (result == null) {
                return null;
            }
            if ((result = result.trim()).length() == 0) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void updateProgramDescription() {
        this.programDescription.setText(this.program_description != null ? this.program_description : (this.programName == null ? "Welcome" : "Loading..."));
    }

    private void addGraphics() {
        this.removeAll();
        this.setupImage();
        this.setLayout(new BorderLayout());
        this.nameAndDescription = new Panel();
        this.nameAndDescription.setName("nameAndDecscription");
        this.nameAndDescription.setLayout(new BorderLayout());
        this.programLabel = this.program_name != null ? new Label(this.program_name) : (this.programName != null ? new Label(this.programName) : new Label("Applet Runner"));
        this.programLabel.setFont(new Font("Serif", 3, 24));
        this.programLabel.setAlignment(1);
        this.programDescription = new Label(this.program_description != null ? this.program_description : " ");
        this.updateProgramDescription();
        this.programDescription.setFont(new Font("Serif", 0, 16));
        this.programDescription.setAlignment(1);
        this.nameAndDescription.add("North", this.programLabel);
        this.nameAndDescription.add("South", this.programDescription);
        this.add("North", this.nameAndDescription);
        if (this.programName == null) {
            this.enterProgramPanel = new Panel();
            this.enterProgramPanel.setName("enterProgramPanel");
            this.enterProgramPanel.setLayout(new BorderLayout(10, 10));
            this.enterProgramName = new Panel();
            this.enterProgramName.setName("enterProgramName");
            this.enterProgramName.setLayout(new BorderLayout(20, 20));
            this.enterProgramLabel = new Label("Enter program name:");
            if (this.programVectorUsed) {
                this.enterProgramChoice = new Choice();
                this.fillChoiceFromVector();
            } else {
                this.enterProgramField = new TextField(64);
            }
            this.enterProgramButton = new Button("Start");
            this.enterProgramName.add("North", this.enterProgramLabel);
            Panel enterProgramInner = new Panel();
            enterProgramInner.setName("enterProgramInner");
            enterProgramInner.setLayout(new BorderLayout(10, 10));
            if (this.programVectorUsed) {
                enterProgramInner.add("Center", this.enterProgramChoice);
            } else {
                enterProgramInner.add("Center", this.enterProgramField);
            }
            enterProgramInner.add("East", this.enterProgramButton);
            this.enterProgramName.add("Center", enterProgramInner);
            this.enterProgramPanel.add("North", this.enterProgramName);
            this.add("Center", this.enterProgramPanel);
            this.enterProgramButton.addActionListener(this);
            if (!this.programVectorUsed) {
                this.enterProgramField.addActionListener(this);
            }
        }
        this.progressAndLicense = new Panel();
        this.progressAndLicense.setName("progressAndLicense");
        this.progressAndLicense.setLayout(new BorderLayout());
        if (this.progressBar) {
            this.progressBarComponent = new BarberProgress();
            if (this.progress_border != null) {
                this.progressBarComponent.setBorderColor(this.progress_border);
            }
            if (this.progress_red != null) {
                this.progressBarComponent.setRed(this.progress_red);
            }
            if (this.progress_white != null) {
                this.progressBarComponent.setWhite(this.progress_white);
            }
            this.tick = new BarberTick(this.progressBarComponent);
            this.progressAndLicense.add("Center", this.progressBarComponent);
            this.progressBarComponent.setEnabled(false);
        }
        String defaultText = "Session Started " + new Date() + " on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " / " + System.getProperty("os.arch") + " using " + System.getProperty("java.vendor") + " JVM " + System.getProperty("java.version");
        this.licenseLabel = new Label(this.program_license != null ? this.program_license : defaultText);
        this.licenseLabel.setAlignment(1);
        this.licenseLabel.setFont(new Font("Serif", 2, 10));
        this.progressAndLicense.add("South", this.licenseLabel);
        this.add("South", this.progressAndLicense);
        this.setVisible(true);
        if (this.enterProgramField != null) {
            this.enterProgramField.requestFocus();
        } else if (this.enterProgramChoice != null) {
            this.enterProgramChoice.requestFocus();
        } else {
            this.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void promptForProgramName() {
        if (this.programName == null) {
            Object object = this.waitForProgramName;
            synchronized (object) {
                try {
                    this.waitForProgramName.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.programName != null && this.programLabel != null) {
                int length = this.programName.length();
                StringBuffer visibleName = new StringBuffer(length);
                boolean cap = true;
                for (int i = 0; i < length; ++i) {
                    char c = this.programName.charAt(i);
                    if (cap) {
                        c = Character.toUpperCase(c);
                    }
                    boolean bl = cap = !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
                    if (c == '-' || c == '_') {
                        c = ' ';
                    }
                    visibleName.append(c);
                }
                this.programLabel.setText(visibleName.toString());
                this.updateProgramDescription();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        int index;
        if (this.enterProgramField != null) {
            this.programName = this.enterProgramField.getText();
        } else if (this.enterProgramChoice != null && (index = this.enterProgramChoice.getSelectedIndex()) >= 0 && index < this.enterProgramChoice.getItemCount() && index < this.programVector.size()) {
            this.programName = this.programVector.elementAt(index);
            this.parseParameters("." + (++index + 1));
        }
        if (this.programName != null) {
            this.programName = this.programName.trim();
            if (this.programName.length() > 0) {
                this.enterProgramButton.removeActionListener(this);
                if (this.enterProgramField != null) {
                    this.enterProgramField.removeActionListener(this);
                }
                this.enterProgramPanel.setVisible(false);
                Object object = this.waitForProgramName;
                synchronized (object) {
                    try {
                        this.waitForProgramName.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = this.insets;
        if (insets != null) {
            return insets;
        }
        return super.getInsets();
    }

    public void drawImage(Graphics g) {
        if (this.image != null) {
            Dimension size = this.getSize();
            int imageBorderWidth = 2;
            int imageBorderHeight = 2;
            g.drawImage(this.image, imageBorderWidth, imageBorderHeight, size.width - imageBorderWidth * 2, size.height - imageBorderHeight * 2, this);
            g.setColor(this.getForeground());
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
            Insets insets = this.insets;
            if (insets != null) {
                Color fore = this.getForeground();
                Color back = this.getBackground();
                Color base = new Color((fore.getRed() + back.getRed()) / 2, (fore.getGreen() + back.getGreen()) / 2, (fore.getBlue() + back.getBlue()) / 2);
                Color bright = base.brighter();
                Color dark = base.darker();
                Dimension d = this.getSize();
                int w = d.width - 1;
                int h = d.height - 1;
                g.setColor(bright);
                g.drawLine(0, 0, w, 0);
                g.drawLine(1, 1, w - 1, 1);
                g.drawLine(0, 0, 0, h);
                g.drawLine(1, 1, 1, h - 1);
                g.setColor(dark);
                g.drawLine(0, h, w, h);
                g.drawLine(1, h - 1, w - 1, h - 1);
                g.drawLine(w, 0, w, h);
                g.drawLine(w - 1, 1, w - 1, h - 1);
                g.setColor(fore);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeGraphics() {
        if (this.nameAndDescription != null) {
            this.nameAndDescription.setVisible(false);
        }
        if (this.enterProgramPanel != null) {
            this.enterProgramPanel.setVisible(false);
        }
        if (this.progressAndLicense != null) {
            this.progressAndLicense.setVisible(false);
        }
        applet.yield();
        if (this.nameAndDescription != null) {
            this.remove(this.nameAndDescription);
            this.nameAndDescription = null;
        }
        if (this.enterProgramPanel != null) {
            this.remove(this.enterProgramPanel);
            this.enterProgramPanel = null;
        }
        if (this.progressAndLicense != null) {
            this.remove(this.progressAndLicense);
            this.progressAndLicense = null;
        }
        if (this.tick != null) {
            this.tick.kill();
        }
        this.programLabel = null;
        this.programDescription = null;
        this.enterProgramLabel = null;
        this.enterProgramField = null;
        this.enterProgramChoice = null;
        this.enterProgramButton = null;
        this.progressBarComponent = null;
        this.licenseLabel = null;
        this.insets = null;
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        applet.yield();
        this.removeAll();
        applet.yield();
        this.setLayout(new BorderLayout());
        applet.yield();
        this.repaint();
        applet.yield();
    }

    private void beginProgressBar() {
        if (!this.progressBar) {
            return;
        }
        if (this.progressBarComponent != null) {
            this.progressBarComponent.setEnabled(true);
        }
        if (this.tick != null) {
            try {
                new ThreadQueue(this.tick).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void endProgressBar() {
        if (!this.progressBar) {
            return;
        }
        if (this.tick != null) {
            this.tick.kill();
        }
    }

    private void call(final Method m) {
        if (m == null) {
            return;
        }
        try {
            if (this.program == null) {
                this.program = this.programClass.newInstance();
            }
            Object context = null;
            if (!this.alreadySetup) {
                this.alreadySetup = true;
                if (this.applet_setup != null && context == null) {
                    context = this.applet_setup.invoke(this.program, new Object[]{null});
                }
            }
            if (m == this.applet_run) {
                new ThreadQueue("Main Cobol Applet Thread (" + m + ")"){

                    @Override
                    public void run() {
                        try {
                            m.invoke(applet.this.program, new Object[0]);
                        }
                        catch (Throwable runException) {
                            applet.this.giveError(runException);
                        }
                    }
                }.start();
            } else {
                if (this.applet_runBegin != null) {
                    this.applet_runBegin.invoke(this.program, new Object[0]);
                }
                m.invoke(this.program, new Object[0]);
                if (this.applet_runEnd != null) {
                    this.applet_runEnd.invoke(this.program, new Object[0]);
                }
            }
        }
        catch (Throwable callException) {
            this.giveError(callException);
        }
    }

    public void message(String message) {
        this.showStatus(message);
    }

    protected String massage(String program) {
        if (program == null) {
            return "default";
        }
        program = program.replace('/', '.');
        program = program.replace('\\', '.');
        program = program.replace(File.separatorChar, '.');
        String programCompare = (program = program.replace('-', '_')).toUpperCase();
        if (programCompare.endsWith(".CLASS")) {
            program = program.substring(0, program.length() - 6);
        } else if (programCompare.endsWith(".JAVA")) {
            program = program.substring(0, program.length() - 5);
        }
        return program;
    }

    protected void begin() {
    }

    protected void end() {
    }

    private static void help(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        applet.help("com.heirloomcomputing.ecs.run.applet");
        applet.help("");
        applet.help("This class sets up the Elastic COBOL environment to run under the applet");
        applet.help("environment.  It should be the main program for an applet, with");
        applet.help("the Elastic COBOL program specified in the 'program' init parameter");
        applet.help("for the main applet.");
        applet.help("");
    }

    private void setupImage() {
        this.image = this.loadImage();
        this.repaint();
    }

    public Image loadImage() {
        if (this.program_image == null) {
            return null;
        }
        Image result = null;
        try {
            MediaTracker tracker = new MediaTracker(this);
            URL url2 = new URL(this.getDocumentBase(), this.program_image);
            result = this.getImage(url2);
            tracker.addImage(result, 0);
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public class BarberProgress
    extends Canvas {
        private int counter = 0;
        private int width = 2;
        private int size = 7;
        private Color red = Color.red;
        private Color white = Color.white;
        private Color borderColor = Color.black;
        private Dimension d = new Dimension(640, 10);

        public void setRed(Color c) {
            this.red = c;
        }

        public void setWhite(Color c) {
            this.white = c;
        }

        public void setBorderColor(Color c) {
            this.borderColor = c;
        }

        @Override
        public void setEnabled(boolean state) {
            super.setEnabled(state);
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            Color back = this.getBackground();
            Color red = this.red;
            Color white = this.white;
            Color borderColor = this.borderColor;
            if (!this.isEnabled()) {
                red = back;
                white = back;
                borderColor = back;
            }
            int w = d.width - 1;
            int h = d.height - 1;
            g.setColor(borderColor);
            g.drawRect(0, 0, w, h);
            g.clipRect(1, 1, w - 1, h - 1);
            int countdown = this.counter % this.size;
            g.setColor(white);
            int slant = --h - 1;
            w += slant;
            for (int i = 1 - slant; i < w; ++i) {
                if (--countdown < 0) {
                    countdown = this.size;
                    g.setColor(white);
                }
                if (countdown == this.width) {
                    g.setColor(red);
                }
                g.drawLine(i + slant, 1, i, h);
            }
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        public void tick() {
            ++this.counter;
            this.repaint();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.d;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.d;
        }
    }

    public class BarberTick
    implements Runnable {
        private boolean alive = true;
        private boolean pause = false;
        private BarberProgress progress;
        private int timer;

        public BarberTick(BarberProgress progress) {
            this(progress, 200);
        }

        public BarberTick(BarberProgress progress, int timer) {
            this.progress = progress;
            this.timer = timer;
        }

        @Override
        public void run() {
            while (this.alive) {
                try {
                    Thread.sleep(this.timer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.pause) continue;
                this.progress.tick();
            }
        }

        public void kill() {
            this.alive = false;
        }

        public void pause() {
            this.pause = true;
        }

        public void unpause() {
            this.pause = false;
        }
    }
}

