/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.run;

import com.heirloomcomputing.ecs.exec.Context;
import com.heirloomcomputing.ecs.exec.ServletContext;
import com.heirloomcomputing.ecs.exec.Version;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class servlet
extends HttpServlet {
    private static boolean servletLogging;
    private boolean specialServletMethods;
    private Method servlet_delete;
    private Method servlet_options;
    private Method servlet_trace;
    private Method servlet_put;
    private Method servlet_post;
    private Method servlet_get;
    private Method servlet_last_modified;
    private Method servlet_init;
    private Method servlet_destroy;
    private Method servlet_setup;
    private Method servlet_call;
    private String programName;
    private Class<?> programClass;
    private Object cachedProgram;
    private boolean gzip;

    private static void initializeServletLogging() {
        try {
            char c;
            String s = System.getProperty("ecobol.servlet.logging");
            if (s == null) {
                s = System.getProperty("servlet.logging");
            }
            if (s != null && (s = s.trim().toUpperCase()).length() > 0 && ((c = s.charAt(0)) == '1' || c == 'Y' || c == 'T')) {
                servletLogging = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void logServlet(String s) {
        if (!servletLogging) {
            return;
        }
        System.out.println("ServletLog: " + s);
    }

    private static void logServlet(Throwable t) {
        if (!servletLogging) {
            return;
        }
        t.printStackTrace(System.out);
    }

    public servlet() {
        if (servletLogging) {
            servlet.logServlet("servlet() constructor");
        }
    }

    public servlet(String name) {
        block3: {
            if (servletLogging) {
                servlet.logServlet("servlet(String '" + name + "') constructor: The name is the name for Class.forName()");
            }
            try {
                this.programName = name;
                this.setupProgram(this.programName);
            }
            catch (Throwable t) {
                if (!servletLogging) break block3;
                servlet.logServlet("servlet() constructor: " + t);
                servlet.logServlet(t);
            }
        }
    }

    public servlet(Class<?> clazz) {
        block3: {
            if (servletLogging) {
                servlet.logServlet("servlet(Class '" + clazz + "') constructor: The Class is the Class template");
            }
            try {
                this.setupProgram(clazz);
            }
            catch (Throwable t) {
                if (!servletLogging) break block3;
                servlet.logServlet("servlet() constructor: " + t);
                servlet.logServlet(t);
            }
        }
    }

    public servlet(Object program) {
        block3: {
            if (servletLogging) {
                servlet.logServlet("servlet(Object '" + program + "') constructor: the object is the program template");
            }
            try {
                this.cachedProgram = program;
                this.setupProgram(program.getClass());
            }
            catch (Throwable t) {
                if (!servletLogging) break block3;
                servlet.logServlet("servlet() constructor: " + t);
                servlet.logServlet(t);
            }
        }
    }

    public void setupProgram(String programName) throws ServletException {
        if (programName == null) {
            this.message("");
            this.message("com.heirloomcomputing.ecs.run.servlet:");
            this.message("");
            this.message("Cannot initialize Elastic COBOL servlet; no name specified.");
            this.message("");
            this.message("Program name must be specified as a servlet init parameter in servlet.properties");
            this.message("or equivalent such as web.xml or weblogic.properties.");
            this.message("");
            this.message("ecobol-servlet=name_of_program");
            this.message("");
            this.message("In EJB 2.0, there may be parent/child classloaders, where this loading class is");
            this.message("in the parent and cannot see the child servlet application specified.");
            this.message("Such may occur when deploying an ear with jars and wars each containing the");
            this.message("Elastic COBOL runtime.  Exclude this class (exclude servlets) from the EJB jar,");
            this.message("that does not need it, and then this class will be found in the child class loader");
            this.message("context where it may find the servlet application.");
            this.message("");
            if (servletLogging) {
                servlet.logServlet("Cannot setupProgram(null);");
            }
            throw new ServletException("Elastic COBOL servlet cannot initialize; no ecobol-servlet init parameter specified.");
        }
        programName = this.massage(programName);
        if (servletLogging) {
            servlet.logServlet("Massaged setupProgram('" + programName + "')");
        }
        this.programClass = null;
        try {
            this.programClass = Class.forName(programName);
        }
        catch (Throwable t) {
            if (servletLogging) {
                servlet.logServlet("Class.forName('" + programName + "') failed: " + t);
                servlet.logServlet(t);
            }
            this.message("");
            this.message("com.heirloomcomputing.ecs.run.servlet:");
            this.message("");
            this.message("Cannot initialize Elastic COBOL servlet '" + programName + "'; no such class: " + t);
            this.message("");
            this.message("Servlet application class must be in classpath available to servlet environment.");
            this.message("");
            this.message("Suggestion:");
            this.message("If deployed within an EAR in an EJB 2.0+ environment, there may be a hierarchy of");
            this.message("classloaders.  The classloader that loads the com.heirloomcomputing.ecs.run.servlet class");
            this.message("must also be the one to load the COBOL servlet as well.  Deploy only the servlet");
            this.message("environment in the .war files, and anything but the servlet environment in the");
            this.message("EJB .jar files.  This will help ensure that the proper classloader is used at");
            this.message("all times.");
            this.message("");
            this.message(t);
            throw new ServletException("Elastic COBOL servlet cannot initialize; cannot load class '" + programName + "'");
        }
        this.setupProgram(this.programClass);
    }

    public void setupProgram(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        if (this.programName == null) {
            this.programName = clazz.getName();
        }
        this.programClass = clazz;
        if (servletLogging) {
            servlet.logServlet("setupProgram(Class '" + clazz + "', programName='" + this.programName + "')");
        }
        Class[] params = new Class[]{};
        try {
            this.servlet_delete = this.programClass.getMethod("servlet_delete", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_delete=" + this.servlet_delete);
        }
        try {
            this.servlet_options = this.programClass.getMethod("servlet_options", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_options=" + this.servlet_options);
        }
        try {
            this.servlet_trace = this.programClass.getMethod("servlet_trace", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_trace=" + this.servlet_trace);
        }
        try {
            this.servlet_put = this.programClass.getMethod("servlet_put", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_put=" + this.servlet_put);
        }
        try {
            this.servlet_get = this.programClass.getMethod("servlet_get", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_get=" + this.servlet_get);
        }
        try {
            this.servlet_post = this.programClass.getMethod("servlet_post", params);
            this.specialServletMethods = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_post=" + this.servlet_post);
        }
        try {
            Method servlet_servlet = this.programClass.getMethod("servlet", params);
            if (this.servlet_get == null) {
                this.servlet_get = servlet_servlet;
            }
            if (this.servlet_post == null) {
                this.servlet_post = servlet_servlet;
            }
            if (servletLogging) {
                servlet.logServlet("servlet_servlet, for get or post=" + servlet_servlet);
            }
            this.specialServletMethods = true;
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        try {
            this.servlet_last_modified = this.programClass.getMethod("servlet_last_modified", params);
            this.specialServletMethods = true;
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_last_modified=" + this.servlet_last_modified);
        }
        try {
            this.servlet_init = this.programClass.getMethod("servlet_init", params);
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_init=" + this.servlet_init);
        }
        try {
            this.servlet_destroy = this.programClass.getMethod("servlet_destroy", params);
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_destroy=" + this.servlet_destroy);
        }
        try {
            this.servlet_setup = this.programClass.getMethod("setup", Context.class);
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_setup=" + this.servlet_setup);
        }
        try {
            this.servlet_call = this.programClass.getMethod("call", Context.class);
        }
        catch (Exception servlet_servlet) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet_call=" + this.servlet_call);
        }
        if (!this.specialServletMethods) {
            Method[] methods;
            if (servletLogging) {
                servlet.logServlet("no special servlet methods, so check in sections");
            }
            if ((methods = this.programClass.getMethods()) != null) {
                int methodsLength = methods.length;
                Method check = null;
                String name = null;
                for (int i = 0; i < methodsLength; ++i) {
                    check = methods[i];
                    name = check.getName();
                    if (!name.startsWith("servlet")) continue;
                    if (name.startsWith("servlet_delete")) {
                        if (this.servlet_delete == null) {
                            this.servlet_delete = check;
                        }
                    } else if (name.startsWith("servlet_options")) {
                        if (this.servlet_options == null) {
                            this.servlet_options = check;
                        }
                    } else if (name.startsWith("servlet_trace")) {
                        if (this.servlet_trace == null) {
                            this.servlet_trace = check;
                        }
                    } else if (name.startsWith("servlet_put")) {
                        if (this.servlet_put == null) {
                            this.servlet_put = check;
                        }
                    } else if (name.startsWith("servlet_get")) {
                        if (this.servlet_get == null) {
                            this.servlet_get = check;
                        }
                    } else if (name.startsWith("servlet_post")) {
                        if (this.servlet_post == null) {
                            this.servlet_post = check;
                        }
                    } else if (name.startsWith("servlet_last_modified")) {
                        if (this.servlet_last_modified == null) {
                            this.servlet_last_modified = check;
                        }
                    } else if (name.startsWith("servlet_init")) {
                        if (this.servlet_init == null) {
                            this.servlet_init = check;
                        }
                    } else if (name.startsWith("servlet_destroy")) {
                        if (this.servlet_destroy == null) {
                            this.servlet_destroy = check;
                        }
                    } else {
                        if (this.servlet_get == null) {
                            this.servlet_get = check;
                        }
                        if (this.servlet_post == null) {
                            this.servlet_post = check;
                        }
                    }
                    this.specialServletMethods = true;
                }
            }
            if (servletLogging) {
                servlet.logServlet("servlet_delete=" + this.servlet_delete);
                servlet.logServlet("servlet_options=" + this.servlet_options);
                servlet.logServlet("servlet_trace=" + this.servlet_trace);
                servlet.logServlet("servlet_put=" + this.servlet_put);
                servlet.logServlet("servlet_get=" + this.servlet_get);
                servlet.logServlet("servlet_post=" + this.servlet_post);
                servlet.logServlet("servlet_last_modified=" + this.servlet_last_modified);
                servlet.logServlet("servlet_init=" + this.servlet_init);
                servlet.logServlet("servlet_destroy=" + this.servlet_destroy);
                servlet.logServlet("servlet_call=" + this.servlet_call);
            }
        }
    }

    private boolean isInitParameter(ServletConfig config, String name) {
        String option = null;
        option = config.getInitParameter(name);
        if (option == null || option.length() == 0) {
            return false;
        }
        switch (option.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            char c;
            String s = config.getInitParameter("ecobol.servlet.logging");
            if (s == null) {
                s = config.getInitParameter("servlet.logging");
            }
            if (s != null && (s = s.trim().toUpperCase()).length() > 0 && (servletLogging = (c = s.charAt(0)) == '1' || c == 'Y' || c == 'T')) {
                servlet.logServlet("servlet.init(ServletConfig): Set logging from init parameter");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletLogging) {
            servlet.logServlet("servlet.init(ServletConfig)");
        }
        if (this.isInitParameter(config, "version")) {
            Version.outputVersion();
        }
        this.gzip = this.isInitParameter(config, "gzip");
        if (this.programClass == null) {
            this.programName = config.getInitParameter("ecobol-servlet");
            if (this.programName == null) {
                this.programName = config.getInitParameter("ecobol-program");
            }
            if (this.programName == null) {
                this.programName = config.getInitParameter("servlet");
            }
            if (this.programName == null) {
                this.programName = config.getInitParameter("program");
            }
            if (this.programName == null) {
                return;
            }
            this.setupProgram(this.programName);
        }
        this.call(this.servlet_init, null, null);
    }

    private void call(Method m, HttpServletRequest req, HttpServletResponse res) {
        if (this.specialServletMethods) {
            if (servletLogging) {
                servlet.logServlet("call: servlet: method=" + m);
            }
            if (m == null) {
                if (servletLogging) {
                    servlet.logServlet("call: servlet: no method, return");
                }
                return;
            }
            try {
                Object program = this.cachedProgram;
                if (servletLogging) {
                    servlet.logServlet("call: servlet: cachedProgram=" + program);
                }
                if (program == null) {
                    program = this.programClass.newInstance();
                    if (servletLogging) {
                        servlet.logServlet("call: servlet: program new instance=" + program);
                    }
                }
                if (servletLogging) {
                    servlet.logServlet("call: servlet: Create new ServletContext using this, request=" + req + ", response=" + res + ", gzip=" + this.gzip);
                }
                ServletContext context = new ServletContext(this, req, res, this.gzip, servletLogging);
                if (servletLogging) {
                    servlet.logServlet("call: servlet: Setup using new ServletContext");
                }
                this.servlet_setup.invoke(program, context);
                if (servletLogging) {
                    servlet.logServlet("call: servlet: Invoke " + m + " on " + program);
                }
                m.invoke(program, (Object[])null);
                if (servletLogging) {
                    servlet.logServlet("call: servlet: Invocation successful.");
                }
            }
            catch (Throwable program) {}
        } else {
            if (servletLogging) {
                servlet.logServlet("call: non-servlet: method=" + m);
            }
            if (req == null && res == null) {
                if (servletLogging) {
                    servlet.logServlet("call: non-servlet: no request, no response, return");
                }
                return;
            }
            try {
                Object program = this.cachedProgram;
                if (servletLogging) {
                    servlet.logServlet("call: non-servlet: cachedProgram=" + program);
                }
                if (program == null) {
                    program = this.programClass.newInstance();
                    if (servletLogging) {
                        servlet.logServlet("call: non-servlet: program new instance=" + program);
                    }
                }
                if (servletLogging) {
                    servlet.logServlet("call: non-servlet: Create new ServletContext using this, request=" + req + ", response=" + res + ", gzip=" + this.gzip);
                }
                ServletContext context = new ServletContext(this, req, res, this.gzip, servletLogging);
                if (m == null) {
                    if (servletLogging) {
                        servlet.logServlet("call: non-servlet: whole program call to " + this.servlet_call);
                    }
                    this.servlet_call.invoke(program, context);
                } else {
                    if (servletLogging) {
                        servlet.logServlet("call: non-servlet: setup using " + this.servlet_setup);
                    }
                    this.servlet_setup.invoke(program, context);
                    if (servletLogging) {
                        servlet.logServlet("call: non-servlet: whole program call to " + m);
                    }
                    m.invoke(program, (Object[])null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        if (servletLogging) {
            servlet.logServlet("servlet.destroy(): " + this.servlet_destroy);
        }
        this.call(this.servlet_destroy, null, null);
    }

    public String getServletInfo() {
        if (servletLogging) {
            servlet.logServlet("servlet.getServletInfo()");
        }
        return "Elastic COBOL Servlet Runner Copyright (C) 2010-2023 Heirloom Computing)";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            if (servletLogging) {
                servlet.logServlet("servlet.doGet(): " + this.servlet_get);
            }
            if (this.programClass == null && !this.promptUserForProgram(req, res)) {
                return;
            }
            this.call(this.servlet_get, req, res);
            if (this.servlet_get != null || !this.specialServletMethods) {
                try {
                    if (servletLogging) {
                        servlet.logServlet("response flushBuffer");
                    }
                    res.flushBuffer();
                }
                catch (Throwable t) {
                    if (!servletLogging) break block6;
                    servlet.logServlet("response flushBuffer error");
                    servlet.logServlet(t);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            if (servletLogging) {
                servlet.logServlet("servlet.doPost(): " + this.servlet_post);
            }
            if (this.programClass == null && !this.promptUserForProgram(req, res)) {
                return;
            }
            this.call(this.servlet_post, req, res);
            if (this.servlet_post != null || !this.specialServletMethods) {
                try {
                    if (servletLogging) {
                        servlet.logServlet("response flushBuffer");
                    }
                    res.flushBuffer();
                }
                catch (Throwable t) {
                    if (!servletLogging) break block6;
                    servlet.logServlet("response flushBuffer error");
                    servlet.logServlet(t);
                }
            }
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (servletLogging) {
            servlet.logServlet("servlet.doPut(): " + this.servlet_put);
        }
        if (this.servlet_put != null) {
            this.call(this.servlet_put, req, res);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (servletLogging) {
            servlet.logServlet("servlet.doDelete(): " + this.servlet_delete);
        }
        if (this.servlet_delete != null) {
            this.call(this.servlet_delete, req, res);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (servletLogging) {
            servlet.logServlet("servlet.doOptions(): " + this.servlet_options);
        }
        if (this.servlet_options != null) {
            this.call(this.servlet_options, req, res);
        }
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (servletLogging) {
            servlet.logServlet("servlet.doTrace(): " + this.servlet_trace);
        }
        if (this.servlet_trace != null) {
            this.call(this.servlet_trace, req, res);
        }
    }

    protected long getLastModified(HttpServletRequest req) {
        if (servletLogging) {
            servlet.logServlet("servlet.getLastModified(): " + this.servlet_last_modified);
        }
        if (this.servlet_last_modified != null) {
            this.call(this.servlet_last_modified, req, null);
        }
        return -1L;
    }

    public void message(String message) {
        try {
            System.out.println(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void message(Throwable t) {
        try {
            t.printStackTrace(System.out);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String massage(String program) {
        String programCompare = program.toUpperCase();
        if (programCompare.endsWith(".CLASS")) {
            program = program.substring(0, program.length() - 6);
        }
        program = program.replace('/', '.');
        program = program.replace('\\', '.');
        return program;
    }

    protected void option(String option) {
        try {
            if (option.equalsIgnoreCase("sysout=syserr")) {
                System.setOut(System.err);
            } else if (option.equalsIgnoreCase("syserr=sysout")) {
                System.setErr(System.out);
            } else if (option.equalsIgnoreCase("nosysout")) {
                System.setOut(null);
            } else if (option.equalsIgnoreCase("nosyserr")) {
                System.setErr(null);
            } else if (option.equals("version")) {
                Version.outputVersion();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    private boolean promptUserForProgram(HttpServletRequest req, HttpServletResponse res) {
        if (res == null) {
            return false;
        }
        String additionalMessage = null;
        if (this.programClass == null && req != null) {
            String request = req.getParameter("servlet");
            try {
                if (request != null) {
                    this.setupProgram(request);
                }
                if (this.programClass != null) {
                    return true;
                }
            }
            catch (Throwable t) {
                additionalMessage = "<b>Invalid program '" + request + "'</b><p>";
            }
        }
        try {
            res.setContentType("text/html");
            PrintWriter out = res.getWriter();
            out.println("<html>");
            out.println("<head><title>Elastic COBOL Servlet Runner</title></head>");
            out.println("<body><h1>Elastic COBOL Servlet Runner</h1><p>");
            if (additionalMessage != null) {
                out.println(additionalMessage);
            }
            out.println("Enter program name to execute:<br>");
            String action = req.getRequestURI();
            out.println("<form method=\"get\" action=\"" + action + "\">");
            out.println("<input type=\"text\" name=\"servlet\" size=\"40\"></input>");
            out.println("<input type=\"submit\" value=\"Execute\"></input>");
            out.println("</form>");
            out.println("<p>");
            out.println("By passing a parameter named 'servlet' with the value equal to the program name, this screen may be avoided.<p>");
            out.println("</html>");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void help(String s) {
        try {
            System.out.println(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        servlet.help("com.heirloomcomputing.ecs.run.servlet");
        servlet.help("");
        servlet.help("This class sets up the Elastic COBOL environment to run under the servlet");
        servlet.help("environment.  It should be the main program for a servlet, with");
        servlet.help("the Elastic COBOL program specified in the 'servlet' init parameter");
        servlet.help("for the main servlet.");
        servlet.help("");
    }

    static {
        servlet.initializeServletLogging();
    }
}

