/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.sql;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class execJDBC {
    private static String[] MODE = new String[5];

    public static void main(String[] args) {
        String url2 = System.getProperty("sql.url");
        String user = System.getProperty("sql.user");
        String password = System.getProperty("sql.password");
        String driver = System.getProperty("sql.driver");
        execJDBC.MODE[1] = "IN";
        execJDBC.MODE[4] = "OUT";
        execJDBC.MODE[2] = "INOUT";
        execJDBC.MODE[0] = "UNKN";
        if (url2 == null) {
            System.out.println("MESSAGE:-1:0:Specify -Dsql.url=jdbc:driver-name://host-name:port-number/db-name VM parameter.");
            System.exit(1);
            return;
        }
        String sql = "";
        for (String a : args) {
            sql = sql + a + " ";
        }
        try {
            if (driver != null) {
                try {
                    Class.forName(driver);
                }
                catch (ClassNotFoundException e) {
                    System.out.println("MESSAGE:-1:0:Class not found on CLASSPATH - " + e.getMessage() + ":");
                }
            }
            Connection conn = DriverManager.getConnection(url2, user, password);
            if (sql.toLowerCase().startsWith(":storedproc:")) {
                String storedProcFullName = sql.split(":")[2];
                String[] spTokens = storedProcFullName.split("[.]");
                String schema = spTokens[0];
                String psName = spTokens[1];
                execJDBC.processStoredProc(conn, schema, psName);
            } else {
                PreparedStatement ps = sql.toLowerCase().startsWith("call") ? conn.prepareCall(sql) : conn.prepareStatement(sql);
                execJDBC.processStatement(ps);
            }
            System.out.println("MESSAGE:0:0:OK:");
        }
        catch (SQLException e) {
            System.out.println("MESSAGE:" + e.getErrorCode() + ":" + e.getSQLState() + ":" + e.getMessage() + ":");
            System.exit(1);
        }
        System.exit(0);
    }

    private static void processStatement(PreparedStatement ps) throws SQLException {
        ResultSetMetaData rmd;
        int i;
        int cnt;
        ParameterMetaData pmd = ps.getParameterMetaData();
        if (pmd != null) {
            cnt = pmd.getParameterCount();
            for (i = 1; i <= cnt; ++i) {
                System.out.println("PARM:" + i + ":" + pmd.getParameterType(i) + ":" + pmd.getParameterTypeName(i).toUpperCase() + ":" + MODE[pmd.getParameterMode(i)] + ":");
            }
        }
        if ((rmd = ps.getMetaData()) != null) {
            cnt = rmd.getColumnCount();
            for (i = 1; i <= cnt; ++i) {
                System.out.println("RESULT:" + i + ":" + rmd.getColumnType(i) + ":" + rmd.getColumnTypeName(i).toUpperCase() + ":" + MODE[2] + ":");
            }
        }
    }

    private static void processStoredProc(Connection conn, String schema, String storedProcName) throws SQLException {
        DatabaseMetaData dbMetaData = conn.getMetaData();
        String schemaPattern = schema.trim();
        String storedProcNamePattern = "%";
        try {
            if (Class.forName("com.ibm.db2.jcc.DB2DatabaseMetaData").isInstance(dbMetaData)) {
                Class<?> klazz = Class.forName("com.ibm.db2.jcc.DB2DatabaseMetaData");
                Method getDBProcedures = klazz.getMethod("getDBProcedures", String.class, String.class, String.class, String.class);
                ResultSet rset = (ResultSet)getDBProcedures.invoke((Object)dbMetaData, null, schema, "%", storedProcName);
                String resultSetsReturned = "0";
                if (rset.next()) {
                    resultSetsReturned = rset.getString(6);
                }
                Method getDBProcedureColumns = klazz.getMethod("getDBProcedureColumns", String.class, String.class, String.class, String.class, String.class);
                rset = (ResultSet)getDBProcedureColumns.invoke((Object)dbMetaData, null, schemaPattern, "%", storedProcName, "%");
                int i = 1;
                while (rset.next()) {
                    System.out.print("PARM:" + i + ":" + rset.getInt("DATA_TYPE") + ":" + rset.getString("TYPE_NAME") + ":" + MODE[rset.getShort("COLUMN_TYPE")] + ":");
                    System.out.print('\n');
                    ++i;
                }
                System.out.println("RESULTSETS:" + resultSetsReturned);
            } else {
                ResultSet rs = dbMetaData.getProcedureColumns(conn.getCatalog(), schemaPattern, storedProcNamePattern, "%");
                int i = 1;
                while (rs.next()) {
                    if (rs.getString("PROCEDURE_NAME").equalsIgnoreCase(storedProcName.trim())) {
                        System.out.print("PARM:" + i + ":" + rs.getInt("DATA_TYPE") + ":" + rs.getString("TYPE_NAME") + ":" + MODE[rs.getShort("COLUMN_TYPE")] + ":");
                        System.out.print('\n');
                    }
                    ++i;
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            ResultSet rs = dbMetaData.getProcedureColumns(conn.getCatalog(), schemaPattern, storedProcNamePattern, "%");
            int i = 1;
            while (rs.next()) {
                if (rs.getString("PROCEDURE_NAME").equalsIgnoreCase(storedProcName.trim())) {
                    System.out.print("PARM:" + i + ":" + rs.getInt("DATA_TYPE") + ":" + rs.getString("TYPE_NAME") + ":" + MODE[rs.getShort("COLUMN_TYPE")] + ":");
                    System.out.print('\n');
                }
                ++i;
            }
        }
    }
}

