/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.util;

import com.heirloomcomputing.ecs.util.BatchTreeItem;
import java.util.ArrayList;

public class BatchTree {
    static BatchTreeItem[] EMPTY_ARRAY = new BatchTreeItem[0];
    protected ArrayList<BatchTreeItem> _children = new ArrayList();
    protected int _columns = 0;

    public BatchTree(int cols) {
        this._columns = cols;
    }

    public BatchTreeItem[] getItems() {
        if (this._children.size() > 0) {
            return this._children.toArray(new BatchTreeItem[this._children.size()]);
        }
        return EMPTY_ARRAY;
    }

    public BatchTreeItem getItem(int idx) {
        return this._children.get(idx);
    }

    public int getItemCount() {
        return this._children.size();
    }

    public void outputTree() {
        for (BatchTreeItem itm : this._children) {
            this.recursivePrint(itm, "");
        }
    }

    private void recursivePrint(BatchTreeItem bti, String indent) {
        System.out.println(indent + bti.getText(0) + "::" + bti.getText(1) + "::" + bti.getText(2));
        for (BatchTreeItem itm : bti.getItems()) {
            this.recursivePrint(itm, indent + "    ");
        }
    }

    public void clear() {
        this._children.clear();
    }
}

