/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecs.vse;

import com.heirloomcomputing.ecs.exec.LogSetup;
import com.heirloomcomputing.ecs.exec.Numeric;
import com.heirloomcomputing.ecs.exec.RuntimeEnvironment;
import com.heirloomcomputing.ecs.exec.Variable;
import com.heirloomcomputing.ecs.exec.seqFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class VSEAssignSequentialFile
extends seqFile {
    public static final String ASSGN_PRINTER_PROTOCOL = "vseprinter:VSEPRINTER";
    public static final String SYSIN_PROTOCOL = "vsesysin:SYSIN";
    private static final String TREAT_VSE_ASSIGN_AS_FBA = "treat_vse_assgn_printer_as_fba";
    public static final String SYSIN_ENV_PREFIX = "sysin";
    public static final String VSE_ASSGN_CARD_GLOBAL_PARAM = "vse_assgn_cards";
    public static final String VSE_ASSGN_LST_PARAM = "vse_assign_printer_lst_params";
    private static int sysinCounter = 1;
    private TypeOfFile type = null;

    @Override
    public boolean open(int mode) {
        this.isVSEAssignFile = true;
        if (this.type == null) {
            this.type = this.getType();
        }
        if (TypeOfFile.SYSIN == this.type) {
            String actualFileName = RuntimeEnvironment.getGlobalParameter(SYSIN_ENV_PREFIX + sysinCounter);
            RuntimeEnvironment.setGlobalParameter(this.ddName, actualFileName);
            ++sysinCounter;
            this.setFilename(actualFileName);
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer(String.format("SYSIN Params: The actual file for {0} is {1}", this.ddName, actualFileName));
            }
        } else if (TypeOfFile.VSEPRINTER == this.type) {
            String actualFileName = this.getAssgnDDCardFileLocation(this.ddName);
            VSEAssignType vseType = this.getAssignTypeFromDDName(this.ddName);
            if (vseType == VSEAssignType.PRINTER && this.assignHasLSTParameter(this.ddName)) {
                RuntimeEnvironment.setGlobalParameter(this.ddName, actualFileName);
                this.setFilename(actualFileName);
            } else {
                try {
                    this.createCombinedAssignedFile(actualFileName, this.ddName);
                }
                catch (IOException e) {
                    if (LogSetup.IS_LOGGING) {
                        LogSetup.LOGGER.finer(String.format("Cannot create file for ASSGN PRINTER :" + e.getMessage(), new Object[0]));
                    }
                    return false;
                }
            }
            if (vseType == VSEAssignType.PRINTER && RuntimeEnvironment.getGlobalParameter(TREAT_VSE_ASSIGN_AS_FBA) != null) {
                this.setLineSequential();
                this.setFormatFBA();
            }
            if (vseType == VSEAssignType.PUNCH) {
                this.setLineSequential();
            }
            return super.open(4);
        }
        return super.open(mode);
    }

    private String getAssgnDDCardFileLocation(String assignDDName) {
        String vseSysnnnPrinterDDCards = RuntimeEnvironment.getGlobalParameter(VSE_ASSGN_CARD_GLOBAL_PARAM);
        List<String> ddCardsNames = Arrays.asList(vseSysnnnPrinterDDCards.split(","));
        for (String ddName : ddCardsNames) {
            String ddNameLocation;
            if (!assignDDName.toLowerCase().startsWith(ddName.toLowerCase()) || (ddNameLocation = RuntimeEnvironment.getGlobalParameter(ddName)) == null) continue;
            return ddNameLocation;
        }
        return null;
    }

    private boolean assignHasLSTParameter(String ddName) {
        String lstParametersAssigns = RuntimeEnvironment.getGlobalParameter(VSE_ASSGN_LST_PARAM);
        if (lstParametersAssigns == null) {
            return false;
        }
        return Arrays.asList(lstParametersAssigns.split(",")).stream().anyMatch(lst -> ddName.toLowerCase().startsWith(lst.toLowerCase()));
    }

    private void createCombinedAssignedFile(String filepath, String ddname) throws IOException {
        VSEAssignType assignType = this.getAssignTypeFromDDName(ddname);
        if (assignType != null) {
            String fileTypeName = assignType == VSEAssignType.PRINTER ? "SYSLST" : "SYSPCH";
            File currentDDFile = new File(filepath);
            String extension = this.getExtensionByStringHandling(currentDDFile.getName()).orElse("");
            String fileName = currentDDFile.getName().replace(extension, "");
            String newAssignFilePath = currentDDFile.getParent() + File.separator + fileName.substring(0, fileName.lastIndexOf(".") + 1) + fileTypeName + extension;
            File assignFile = new File(newAssignFilePath);
            if (!assignFile.exists()) {
                assignFile.createNewFile();
            }
            RuntimeEnvironment.setGlobalParameter(this.ddName, assignFile.getAbsolutePath());
            this.setFilename(assignFile.getAbsolutePath());
            if (LogSetup.IS_LOGGING) {
                LogSetup.LOGGER.finer(String.format("ASSGN PRINTER Params: The actual file for {0} is {1}", this.ddName, assignFile.getAbsolutePath()));
            }
        } else {
            throw new IOException("No Printer or Punch ASSIGN found for " + ddname);
        }
    }

    public Optional<String> getExtensionByStringHandling(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".")));
    }

    private VSEAssignType getAssignTypeFromDDName(String ddname) {
        String vseSysnnnPunchDDCards = RuntimeEnvironment.getGlobalParameter("vse_assgn_punch_cards");
        if (vseSysnnnPunchDDCards != null && Arrays.asList(vseSysnnnPunchDDCards.split(",")).stream().anyMatch(s -> ddname.startsWith((String)s))) {
            return VSEAssignType.PUNCH;
        }
        String vseSysnnnPrinterDDCards = RuntimeEnvironment.getGlobalParameter("vse_assgn_printer_cards");
        if (vseSysnnnPrinterDDCards != null && Arrays.asList(vseSysnnnPrinterDDCards.split(",")).stream().anyMatch(s -> ddname.startsWith((String)s))) {
            return VSEAssignType.PRINTER;
        }
        return null;
    }

    @Override
    public boolean write(Variable data, int mode, Numeric timeout, boolean printSequential) {
        if (RuntimeEnvironment.getGlobalParameter(TREAT_VSE_ASSIGN_AS_FBA) != null || this.lineSequential) {
            return super.write(data, mode, timeout, true);
        }
        return super.write(data, mode, timeout, printSequential);
    }

    private TypeOfFile getType() {
        try {
            return TypeOfFile.valueOf(this.file.getFilename());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    private static enum VSEAssignType {
        PRINTER,
        PUNCH;

    }

    private static enum TypeOfFile {
        SYSIN,
        VSEPRINTER;

    }
}

