/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.CharvaTermJFC;
import com.heirloomcomputing.term.CharvaTermPanel;
import com.heirloomcomputing.term.ScreenProperty;
import com.heirloomcomputing.term.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.JLabel;

public class CharvaTerm {
    public static final boolean debugMode = false;
    public static final String preferredFontName = "Monospaced";
    public final int CURSORBLINKRATE = 276;
    public static final int BLOCKCURSOR = 0;
    public static final int UNDERLINECURSOR = 1;
    public int curCursor = 0;
    public int lines = 24;
    public int columns = 80;
    public font curFont;
    public font boldFont;
    public font plainFont;
    public int screenHeight = 0;
    public int screenWidth = 0;
    public int realHeight = 0;
    public int realWidth = 0;
    public int cursorx = 0;
    public int cursory = 0;
    private cursorComponent cursor = null;
    public CursorHandler cursorHandler = null;
    public boolean cursorHidden = true;
    public boolean cursorOn = false;
    private Image buffer;
    private Rectangle dirtyBufferRegion = new Rectangle();
    private boolean resetDirtyBufferRegion = true;
    private final Object lockBufferObject = new Object();
    public int bg;
    public int fg;
    public Color fgc;
    public Color bgc;
    private int defaultAttr = 0;
    private int cellWidth = -1;
    private int cellHeight = -1;
    private Container panelForWindow;
    private boolean isJFC = false;
    private static final Object cursorOnLock = new Object();
    private CharvaTermJFC termJFC;
    private Dimension pSize = new Dimension(0, 0);
    public boolean refreshed = true;
    private boolean reverseMode = false;
    private boolean underlineMode = false;
    private boolean highlightMode = false;
    private boolean lowlightMode = false;
    private boolean reverseIt = false;
    private boolean leftlineMode = false;
    private boolean overlineMode = false;
    private boolean gridlineMode = false;
    public static boolean consoleCellByCell = false;
    public static char[] consoleCell = null;
    private Graphics curBufferGraphics = null;
    private Method paintImmediatelyMethod = null;
    private Object[] paintImmediatelyParam = new Object[1];
    public static String defaultFontName = null;
    public static int defaultFontWidth = -1;
    public static int defaultFontWidthMin = -1;
    public static int defaultFontWidthMax = -1;
    public static double defaultFontWidthMult = 1.0;

    private static final void debug(String string2) {
        System.out.println("CharvaTerm: " + string2);
    }

    public CharvaTerm(int n, int n2, int n3, Color color2, Color color3) {
        this.lines = n2;
        this.columns = n3;
        this.createPanelForWindow();
        try {
            this.cursorHidden = true;
            this.cursorOn = false;
            this.cursor = new cursorComponent();
            this.cursorHandler = new CursorHandler();
            this.cursorHandler.setDaemon(true);
            this.cursorHandler.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setFontSize(n, false);
        int n4 = ScreenProperty.getClosestColorIndex(color2);
        int n5 = ScreenProperty.getClosestColorIndex(color3);
        this.fgc = ScreenProperty.getColorObject(n4);
        this.bgc = ScreenProperty.getColorObject(n5);
        this.setDefaultColors(n4, n5);
        this.fg = n4 << 14;
        this.bg = n5 << 18;
        Cursor cursor = Cursor.getPredefinedCursor(2);
        this.getPanelForWindow().setCursor(cursor);
    }

    public final int getCharCellsOccupied(char c) {
        return this.plainFont.getCharCellsOccupied(c, this.getCellWidth());
    }

    public final int getCharCellsOccupied(String string2) {
        return this.plainFont.getCharCellsOccupied(string2, this.getCellWidth());
    }

    private void createPanelForWindow() {
        try {
            new JLabel();
            this.isJFC = true;
        }
        catch (Throwable throwable) {
            this.isJFC = false;
        }
        if (this.isJFC) {
            if (this.termJFC == null) {
                this.termJFC = new CharvaTermJFC();
            }
            this.panelForWindow = this.termJFC.createPanelForWindow(this);
            if (this.panelForWindow != null) {
                return;
            }
        }
        this.isJFC = false;
        this.panelForWindow = new CharvaTermPanel(this);
    }

    public Container getPanelForWindow() {
        return this.panelForWindow;
    }

    public void setBackground(Color color2) {
        this.getPanelForWindow().setBackground(color2);
    }

    public void setForeground(Color color2) {
        this.getPanelForWindow().setForeground(color2);
    }

    public void resetBackground() {
        this.getPanelForWindow().setBackground(this.bgc);
    }

    public void resetForeground() {
        this.getPanelForWindow().setForeground(this.fgc);
    }

    public void setDimension(int n, int n2) {
        this.setDimension(n, n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDimension(int n, int n2, boolean bl) {
        Container container = this.getPanelForWindow();
        Object object = container.getTreeLock();
        synchronized (object) {
            Object object2 = this.lockBufferObject;
            synchronized (object2) {
                this.hideCursor();
                this.lines = n;
                this.columns = n2;
                this.screenHeight = this.getCellHeight() * n;
                this.realWidth = this.screenWidth = this.getCellWidth() * n2;
                this.realHeight = this.screenHeight;
                Dimension dimension = this.pSize;
                synchronized (dimension) {
                    this.pSize.width = this.realWidth;
                    this.pSize.height = this.realHeight;
                }
                container.setSize(this.realWidth, this.realHeight);
                if (this.cursorHandler != null && this.cursor != null) {
                    this.cursor.init();
                }
                if (bl && this.buffer != null) {
                    try {
                        this.buffer.getGraphics().dispose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.buffer.flush();
                    this.buffer = null;
                    this.resetDirtyBufferRegion = true;
                    this.addNotify();
                }
            }
        }
    }

    public int getWidth() {
        return this.realWidth;
    }

    public int getHeight() {
        return this.realHeight;
    }

    public int getFG() {
        return this.fg >> 14;
    }

    public int getBG() {
        return this.bg >> 18;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension = this.pSize;
        synchronized (dimension) {
            return this.pSize;
        }
    }

    public void setDefaultColors(int n, int n2) {
        int n3 = 0;
        if (n >= 0 && n < 16) {
            n3 |= n << 14 | 0x800000;
        }
        if (n2 >= 0 && n2 < 16) {
            n3 |= n2 << 18 | 0x400000;
        }
        if (n3 != 0) {
            this.defaultAttr = n3;
        }
    }

    private void redrawScreen(Graphics graphics) {
        if (this.realWidth != this.screenWidth || this.realHeight != this.screenHeight) {
            graphics.drawImage(this.buffer, 0, 0, this.realWidth, this.realHeight, 0, 0, this.screenWidth, this.screenHeight, this.getPanelForWindow());
        } else {
            graphics.drawImage(this.buffer, 0, 0, this.getPanelForWindow());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object = this.panelForWindow.getTreeLock();
        synchronized (object) {
            Object object2 = this.lockBufferObject;
            synchronized (object2) {
                if (this.buffer == null) {
                    if (this.refreshed) {
                        return;
                    }
                    this.resetDirtyBufferRegion = true;
                    this.refreshed = true;
                    return;
                }
                if (this.refreshed) {
                    this.redrawScreen(graphics);
                    return;
                }
                this.redrawScreen(graphics);
                this.resetDirtyBufferRegion = true;
                this.refreshed = true;
            }
        }
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n, int n2) {
        this.getPanelForWindow().setSize(n, n2);
        this.realWidth = n;
        this.realHeight = n2;
        Dimension dimension = this.pSize;
        synchronized (dimension) {
            this.pSize.width = this.realWidth;
            this.pSize.height = this.realHeight;
        }
        if (this.cursorHandler != null && this.cursor != null) {
            this.cursor.init();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.panelForWindow.getTreeLock();
        synchronized (object) {
            Object object2 = this.lockBufferObject;
            synchronized (object2) {
                if (this.buffer != null) {
                    return;
                }
                this.resetDirtyBufferRegion = true;
                this.buffer = this.panelForWindow.createImage(this.screenWidth, this.screenHeight);
                if (this.buffer == null) {
                    return;
                }
                this.curBufferGraphics = null;
            }
        }
    }

    public void setAttributes(int n) {
        Color color2;
        int n2;
        Color color3;
        int n3;
        if ((n & 0x1000) != 0 != this.reverseMode) {
            boolean bl = this.reverseMode = !this.reverseMode;
            if (this.reverseMode) {
                this.reverseIt = true;
            }
        }
        if (this.reverseIt && !this.reverseMode) {
            this.reverseIt = false;
            n3 = this.bg;
            this.bg = this.fg;
            this.fg = n3;
            color3 = this.bgc;
            this.bgc = this.fgc;
            this.fgc = color3;
        }
        if ((n & 0x800000) > 0 && this.fg != (n2 = n & 0x3C000)) {
            this.fg = n2;
            color2 = ScreenProperty.getColorObject(this.fg >> 14);
            if (color2 != null) {
                this.fgc = color2;
            }
        }
        if ((n & 0x400000) > 0 && this.bg != (n2 = n & 0x3C0000)) {
            this.bg = n2;
            color2 = ScreenProperty.getColorObject(this.bg >> 18);
            if (color2 != null) {
                this.bgc = color2;
            }
        }
        if (this.reverseIt && this.reverseMode) {
            n3 = this.bg;
            this.bg = this.fg;
            this.fg = n3;
            color3 = this.bgc;
            this.bgc = this.fgc;
            this.fgc = color3;
        }
        if ((n & 0x2000) != 0 != this.underlineMode) {
            this.underlineMode = !this.underlineMode;
        }
        if ((n & 0x40000000) != 0 != this.leftlineMode) {
            this.leftlineMode = !this.leftlineMode;
        }
        if ((n & 0x1000000) != 0 != this.overlineMode) {
            this.overlineMode = !this.overlineMode;
        }
        if ((n & 0x10000000) != 0 != this.gridlineMode) {
            this.gridlineMode = !this.gridlineMode;
        }
        if ((n & 0x400) != 0 != this.highlightMode) {
            this.highlightMode = !this.highlightMode;
        }
        if ((n & 0x800) != 0 != this.lowlightMode) {
            boolean bl = this.lowlightMode = !this.lowlightMode;
        }
        if (this.highlightMode) {
            if (this.curFont != this.boldFont) {
                this.curFont = this.boldFont;
                this.curFont.setFont(this.getBufferGraphics());
            }
        } else if (this.curFont != this.plainFont) {
            this.curFont = this.plainFont;
            this.curFont.setFont(this.getBufferGraphics());
        }
    }

    public Rectangle getDirtyBufferRegionBounds() {
        if (this.resetDirtyBufferRegion) {
            return null;
        }
        Rectangle rectangle = new Rectangle(this.dirtyBufferRegion.x, this.dirtyBufferRegion.y, this.dirtyBufferRegion.width - this.dirtyBufferRegion.x + 1, this.dirtyBufferRegion.height - this.dirtyBufferRegion.y + 1);
        this.resetDirtyBufferRegion = true;
        return rectangle;
    }

    private void updateDirtyBufferRegion(int n, int n2, int n3, int n4) {
        if (this.resetDirtyBufferRegion) {
            this.dirtyBufferRegion.x = n;
            this.dirtyBufferRegion.y = n2;
            this.dirtyBufferRegion.width = n3;
            this.dirtyBufferRegion.height = n4;
            this.resetDirtyBufferRegion = false;
        } else {
            if (n < this.dirtyBufferRegion.x) {
                this.dirtyBufferRegion.x = n;
            }
            if (n3 > this.dirtyBufferRegion.width) {
                this.dirtyBufferRegion.width = n3;
            }
            if (n2 < this.dirtyBufferRegion.y) {
                this.dirtyBufferRegion.y = n2;
            }
            if (n4 > this.dirtyBufferRegion.height) {
                this.dirtyBufferRegion.height = n4;
            }
        }
    }

    private Color getHighlightedColor(Color color2) {
        double d = 0.6;
        int n = color2.getRed();
        int n2 = color2.getGreen();
        int n3 = color2.getBlue();
        if (n == 0 && n2 == 0 && n3 == 0) {
            int n4 = (int)(255.0 * (1.0 - d));
            return new Color(n4, n4, n4);
        }
        int n5 = (int)(255.0 * (1.0 - d));
        n = n > 0 && n < n5 ? n5 : (int)((double)n / d);
        n2 = n2 > 0 && n2 < n5 ? n5 : (int)((double)n2 / d);
        n3 = n3 > 0 && n3 < n5 ? n5 : (int)((double)n3 / d);
        return new Color(Math.min(n, 255), Math.min(n2, 255), Math.min(n3, 255));
    }

    private Color getLowlightedColor(Color color2, Color color3) {
        int n;
        int n2;
        int n3 = color2.getRed();
        int n4 = color2.getGreen();
        int n5 = color2.getBlue();
        int n6 = (n3 + n4 + n5) / 3;
        int n7 = color3.getRed();
        int n8 = (n7 + (n2 = color3.getGreen()) + (n = color3.getBlue())) / 3;
        if (n8 > n6) {
            return this.getHighlightedColor(color2);
        }
        double d = 0.7;
        return new Color(Math.max((int)((double)n3 * d), 0), Math.max((int)((double)n4 * d), 0), Math.max((int)((double)n5 * d), 0));
    }

    private Color getColorBasedOnMode(Color color2, boolean bl) {
        if (this.highlightMode) {
            if (bl) {
                if (this.reverseMode) {
                    color2 = this.getHighlightedColor(color2);
                }
            } else if (!this.reverseMode) {
                color2 = this.getHighlightedColor(color2);
            }
        } else if (this.lowlightMode) {
            if (bl) {
                if (this.reverseMode) {
                    color2 = this.getLowlightedColor(color2, this.fgc);
                }
            } else if (!this.reverseMode) {
                color2 = this.getLowlightedColor(color2, this.bgc);
            }
        }
        return color2;
    }

    private void setAttributes(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2 + n4 - 1;
        int n8 = n3 + n5 - 1;
        this.updateDirtyBufferRegion(n2, n3, n7, n8);
        this.setAttributes(n);
        graphics.setColor(this.getColorBasedOnMode(this.bgc, true));
        graphics.fillRect(n2, n3, n4, n5);
        graphics.setColor(this.getColorBasedOnMode(this.fgc, false));
        if (this.underlineMode) {
            graphics.drawLine(n2, n8, n7, n8);
        }
        if (this.overlineMode) {
            graphics.drawLine(n2, n3, n7, n3);
        }
        if (this.leftlineMode) {
            graphics.drawLine(n2, n3, n2, n8);
        }
        if (this.gridlineMode && n6 > 0) {
            int n9 = 2;
            int n10 = n8;
            int n11 = n4 / n6;
            int n12 = n2 - 1;
            graphics.drawLine(n12, n10 - n9 + 1, n12, n10);
            for (int i = 0; i < n11; ++i) {
                graphics.drawLine(n12 += n6, n10 - n9 + 1, n12, n10);
            }
        }
    }

    private Graphics getBufferGraphics() {
        if (this.buffer == null) {
            return null;
        }
        if (this.curBufferGraphics != null) {
            return this.curBufferGraphics;
        }
        this.curBufferGraphics = this.buffer.getGraphics();
        if (this.curFont != null) {
            this.curFont.setFont(this.curBufferGraphics);
        }
        return this.curBufferGraphics;
    }

    public void printGUI(int n, int n2, String string2, int[] nArray) {
        if (string2 == null || this.panelForWindow == null) {
            return;
        }
        int n3 = string2.length();
        char[] cArray = new char[n3];
        string2.getChars(0, n3, cArray, 0);
        this.printGUI(n, n2, cArray, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printGUI(int n, int n2, char[] cArray, int[] nArray) {
        if (cArray == null || this.panelForWindow == null) {
            return;
        }
        int n3 = cArray.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.getCellWidth();
        int n5 = this.getCellHeight();
        int n6 = n * n4;
        int n7 = n2 * n5;
        int n8 = n7 + n5 - this.getCellHeightGap();
        int n9 = 0;
        int n10 = 0;
        boolean bl = true;
        Object object = this.panelForWindow.getTreeLock();
        synchronized (object) {
            Object object2 = this.lockBufferObject;
            synchronized (object2) {
                Graphics graphics = this.getBufferGraphics();
                if (graphics == null) {
                    return;
                }
                while (n9 != n3) {
                    int n11 = nArray[n10++];
                    while (n10 < n3 && nArray[n10] == n11) {
                        ++n10;
                    }
                    try {
                        this.setAttributes(n11 == 0 ? this.defaultAttr : n11, graphics, n6 + n9 * n4, n7, (n10 - n9) * n4, n5, n4);
                        int n12 = n9;
                        while (n9 < n10) {
                            char c = cArray[n9];
                            if (c == ' ' || c == '\uffff') {
                                if (!bl) {
                                    if (n12 < n9) {
                                        graphics.drawChars(cArray, n12, n9 - n12, n6 + n12 * n4, n8);
                                    }
                                    bl = true;
                                }
                            } else if (bl) {
                                bl = false;
                                n12 = n9;
                            }
                            ++n9;
                        }
                        if (bl || n12 >= n9) continue;
                        graphics.drawChars(cArray, n12, n9 - n12, n6 + n12 * n4, n8);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void setCursor(int n, int n2) {
        if (this.cursorHandler == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.setCursor(n, n2);
        } else {
            this.cursorx = n;
            this.cursory = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorType(int n) {
        if (n != 0 && n != 1) {
            return;
        }
        Object object = cursorOnLock;
        synchronized (object) {
            if (this.cursorHidden) {
                while (this.cursorOn) {
                    try {
                        cursorOnLock.wait(10L);
                    }
                    catch (Throwable throwable) {}
                }
                this.curCursor = n;
            } else {
                this.hideCursor();
                this.curCursor = n;
                this.showCursor();
            }
        }
    }

    public void requestFocus() {
        this.getPanelForWindow().requestFocus();
    }

    public void showCursor() {
        if (this.cursorHandler == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.showCursor();
        }
    }

    public void hideCursor() {
        if (this.cursorHandler == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.hideCursor();
        }
    }

    public void repaint() {
        Container container = this.getPanelForWindow();
        if (container != null) {
            container.repaint();
        }
    }

    public void refreshJFC() {
        try {
            Rectangle rectangle;
            if (this.paintImmediatelyMethod == null) {
                this.paintImmediatelyMethod = this.panelForWindow.getClass().getMethod("paintImmediately", Rectangle.class);
            }
            if ((rectangle = this.getDirtyBufferRegionBounds()) != null) {
                this.paintImmediatelyParam[0] = rectangle;
                this.paintImmediatelyMethod.invoke((Object)this.panelForWindow, this.paintImmediatelyParam);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.panelForWindow != null) {
            Object object = this.panelForWindow.getTreeLock();
            synchronized (object) {
                Object object2 = this.lockBufferObject;
                synchronized (object2) {
                    if (!this.isJFC) {
                        Graphics graphics = this.panelForWindow.getGraphics();
                        if (graphics != null) {
                            this.refreshed = false;
                            this.panelForWindow.update(graphics);
                            return;
                        }
                    } else {
                        this.refreshed = false;
                        this.refreshJFC();
                        return;
                    }
                }
            }
        }
    }

    public void setFontSize(int n) {
        if (this.boldFont != null && this.boldFont.getSize() == n) {
            return;
        }
        this.setFontSize(n, true);
    }

    private void setFontSize(int n, boolean bl) {
        Container container = this.getPanelForWindow();
        this.plainFont = new font(n, false, container);
        this.boldFont = new font(n, true, container);
        this.cellWidth = -1;
        this.cellHeight = -1;
        this.curFont = this.plainFont;
        this.setDimension(this.lines, this.columns, bl);
    }

    public Font getFont() {
        return this.curFont.getFont();
    }

    public void setFont(Font font2) {
        defaultFontName = font2.getName();
        if (font2 != null) {
            this.setFontSize(font2.getSize());
        }
    }

    public final int getCellWidth() {
        if (this.cellWidth < 0) {
            this.cellWidth = this.plainFont.getWidth();
        }
        return this.cellWidth;
    }

    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    public final int getCellHeight() {
        if (this.cellHeight < 0) {
            this.cellHeight = this.plainFont.getHeight();
        }
        return this.cellHeight;
    }

    public void setCellHeight(int n) {
        this.cellHeight = n;
    }

    public int getCellHeightGap() {
        if (this.cellHeight < 0) {
            return this.plainFont.getGap();
        }
        return this.plainFont.getGap();
    }

    public void updateCursor() {
        if (this.cursorHandler == null) {
            return;
        }
        if (this.cursor != null) {
            this.cursor.updateCursor();
        }
    }

    public void end() {
        if (this.cursorHandler != null) {
            this.cursorHandler.stopThread();
        }
    }

    protected static final void whereAmI() {
        try {
            throw new RuntimeException("whereAmI?");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    class CursorHandler
    extends Thread {
        boolean stopThreadSw = false;

        public void stopThread() {
            this.stopThreadSw = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 23;
            while (!this.stopThreadSw) {
                Object object = cursorOnLock;
                synchronized (object) {
                    for (int i = 0; !(i >= 12 || CharvaTerm.this.cursorHidden && CharvaTerm.this.cursorOn); ++i) {
                        try {
                            cursorOnLock.wait(n);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!CharvaTerm.this.cursorHidden || CharvaTerm.this.cursorOn) {
                        CharvaTerm.this.cursorOn = !CharvaTerm.this.cursorOn;
                        CharvaTerm.this.updateCursor();
                    }
                }
            }
        }
    }

    class cursorComponent {
        cursorComponent() {
        }

        public boolean init() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void showCursor() {
            Object object = cursorOnLock;
            synchronized (object) {
                this.setCursorHidden(false);
            }
        }

        private synchronized void setCursorHidden(boolean bl) {
            CharvaTerm.this.cursorHidden = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hideCursor() {
            Object object = cursorOnLock;
            synchronized (object) {
                if (CharvaTerm.this.cursorHidden) {
                    while (CharvaTerm.this.cursorOn) {
                        try {
                            cursorOnLock.wait(10L);
                        }
                        catch (Throwable throwable) {}
                    }
                    return;
                }
                this.setCursorHidden(true);
                while (CharvaTerm.this.cursorOn) {
                    try {
                        cursorOnLock.wait(10L);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }

        public synchronized void updateCursor() {
            Graphics graphics = CharvaTerm.this.getPanelForWindow().getGraphics();
            if (graphics != null) {
                this.paintCursor(graphics);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCursor(int n, int n2) {
            Object object = cursorOnLock;
            synchronized (object) {
                if (CharvaTerm.this.cursorHidden) {
                    while (CharvaTerm.this.cursorOn) {
                        try {
                            cursorOnLock.wait(10L);
                        }
                        catch (Throwable throwable) {}
                    }
                    CharvaTerm.this.cursorx = n;
                    CharvaTerm.this.cursory = n2;
                    return;
                }
                this.hideCursor();
                CharvaTerm.this.cursorx = n;
                CharvaTerm.this.cursory = n2;
                this.showCursor();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paintCursor(Graphics graphics) {
            Object object = CharvaTerm.this.getPanelForWindow().getTreeLock();
            synchronized (object) {
                Object object2 = CharvaTerm.this.lockBufferObject;
                synchronized (object2) {
                    if (graphics == null) {
                        return;
                    }
                    int n = CharvaTerm.this.cursorx;
                    int n2 = CharvaTerm.this.cursory;
                    Color color2 = CharvaTerm.this.fgc;
                    Color color3 = CharvaTerm.this.bgc;
                    if (color3 == null || color2 == null) {
                        return;
                    }
                    Color color4 = graphics.getColor();
                    graphics.setXORMode(color3);
                    graphics.setColor(color2);
                    if (n >= 0 && n < CharvaTerm.this.columns && n2 >= 0 && n2 < CharvaTerm.this.columns) {
                        if (CharvaTerm.this.curCursor == 0) {
                            int n3 = CharvaTerm.this.getCellWidth();
                            int n4 = CharvaTerm.this.getCellHeight();
                            Rectangle rectangle = new Rectangle(Math.round(n * n3), Math.round(n2 * n4), Math.round(n3), Math.round(n4));
                            CharvaTerm.this.updateDirtyBufferRegion(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        } else {
                            int n5 = CharvaTerm.this.getCellWidth();
                            int n6 = CharvaTerm.this.getCellHeight();
                            Rectangle rectangle = new Rectangle(Math.round(n * n5), Math.round((float)(n2 * n6) + ((float)n6 - (float)n6 / 5.0f)), Math.round(n5), Math.round((float)n6 / 5.0f));
                            CharvaTerm.this.updateDirtyBufferRegion(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
                            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                    }
                    graphics.setPaintMode();
                    if (color4 != null) {
                        graphics.setColor(color4);
                    }
                }
            }
        }
    }

    class font {
        private Font myFont;
        private FontMetrics metrics;
        private int height;
        private int width;
        private int descent;
        private int leading;
        private int gap;
        private boolean bold;
        private int size;

        public String toString() {
            return "" + this.myFont;
        }

        private int getMaxAdvance(FontMetrics fontMetrics) {
            if (defaultFontWidth > 2) {
                if (defaultFontWidthMin != -1 && defaultFontWidth < defaultFontWidthMin) {
                    return defaultFontWidthMin;
                }
                if (defaultFontWidthMax != -1 && defaultFontWidth > defaultFontWidthMax) {
                    return defaultFontWidthMax;
                }
                return defaultFontWidth;
            }
            return fontMetrics.charWidth('0');
        }

        private void setupFont(boolean bl, int n) {
            this.bold = bl;
            if (defaultFontName == null) {
                String string2;
                String string3 = null;
                String string4 = null;
                try {
                    string3 = Utilities.getParameter("user.region");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) {
                    string3 = "US";
                }
                try {
                    string4 = Utilities.getParameter("user.language");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string4 == null) {
                    string4 = "en";
                }
                try {
                    defaultFontName = Utilities.getParameter("console_font_" + string4 + "_" + string3);
                    if (defaultFontName == null) {
                        defaultFontName = Utilities.getParameter("console_font_" + string4);
                    }
                    if (defaultFontName == null) {
                        defaultFontName = Utilities.getParameter("console_font");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String string5 = Utilities.getParameter("console_cell");
                String string6 = Utilities.getParameter("console_width");
                String string7 = Utilities.getParameter("console_width_max");
                String string8 = Utilities.getParameter("console_width_min");
                String string9 = Utilities.getParameter("console_width_mult");
                try {
                    string2 = Utilities.getParameter("console_" + string4 + "_" + string3);
                    if (string2 == null) {
                        string2 = Utilities.getParameter("console_" + string4);
                    }
                    if (string2 == null) {
                        string2 = Utilities.getParameter("console");
                    }
                    if (string2 != null) {
                        int n2;
                        int n3 = 0;
                        do {
                            String string10;
                            if ((n2 = string2.indexOf(44)) >= 0) {
                                try {
                                    string10 = string2.substring(0, n2);
                                    string2 = string2.substring(n2 + 1);
                                }
                                catch (Exception exception) {
                                    string10 = null;
                                    string2 = null;
                                }
                            } else {
                                string10 = string2;
                                string2 = null;
                            }
                            ++n3;
                            if (string10 == null || (string10 = string10.trim()).length() <= 0) continue;
                            switch (n3) {
                                case 0: {
                                    string5 = string10;
                                    break;
                                }
                                case 1: {
                                    string6 = string10;
                                    break;
                                }
                                case 2: {
                                    string8 = string10;
                                    break;
                                }
                                case 3: {
                                    string7 = string10;
                                    break;
                                }
                                case 4: {
                                    string9 = string10;
                                    break;
                                }
                                case 5: {
                                    defaultFontName = string10;
                                }
                            }
                        } while (n2 >= 0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (string5 != null) {
                    consoleCellByCell = Utilities.isParameterValue(string5);
                    consoleCell = new char[1];
                }
                if (string9 != null) {
                    defaultFontWidthMult = Double.valueOf(string9.trim());
                }
                if (string6 != null && (defaultFontWidth = Utilities.parseInt(string6.trim())) < 3) {
                    defaultFontWidth = -1;
                }
                if (string7 != null && (defaultFontWidthMax = Utilities.parseInt(string7.trim())) < 1) {
                    defaultFontWidthMax = -1;
                }
                if (string8 != null && (defaultFontWidthMin = Utilities.parseInt(string8.trim())) < 1) {
                    defaultFontWidthMin = -1;
                }
                if (defaultFontName == null) {
                    try {
                        string2 = Utilities.getParameter("java.vendor");
                        if (string2 != null && (string2 = string2.toUpperCase()).startsWith("MICROSOFT")) {
                            defaultFontName = "Courier";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (defaultFontName == null) {
                        defaultFontName = CharvaTerm.preferredFontName;
                    }
                }
            }
            this.myFont = bl ? new Font(defaultFontName, 1, n) : new Font(defaultFontName, 0, n);
        }

        private void setupMetrics(FontMetrics fontMetrics) {
            if (this.myFont == null) {
                return;
            }
            this.size = this.myFont.getSize();
            this.height = fontMetrics.getHeight();
            this.descent = fontMetrics.getDescent();
            this.leading = fontMetrics.getLeading();
            this.gap = this.descent;
            this.width = this.getMaxAdvance(fontMetrics);
        }

        public font(int n, boolean bl, Graphics graphics) {
            try {
                this.setupFont(bl, n);
                this.metrics = graphics.getFontMetrics(this.myFont);
                this.setupMetrics(this.metrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public font(int n, boolean bl, Component component) {
            try {
                this.setupFont(bl, n);
                if (component.getGraphics() != null) {
                    this.metrics = component.getGraphics().getFontMetrics(this.myFont);
                    this.setupMetrics(this.metrics);
                } else {
                    BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    this.metrics = graphics2D.getFontMetrics(this.myFont);
                    graphics2D.dispose();
                    bufferedImage = null;
                    this.setupMetrics(this.metrics);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setFont(Graphics graphics) {
            graphics.setFont(this.myFont);
        }

        public void setFont(Component component) {
            component.setFont(this.myFont);
        }

        public Font getFont() {
            return this.myFont;
        }

        public final int getCharCellsOccupied(char c, int n) {
            try {
                if (this.getCharWidth(c) > n) {
                    return 2;
                }
                return 1;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public final int getCharWidth(char c) {
            if (this.metrics == null) {
                return -1;
            }
            return this.metrics.charWidth(c);
        }

        public final int getCharCellsOccupied(String string2, int n) {
            try {
                return (int)Math.ceil((double)this.getStringWidth(string2) / (double)n);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public final int getStringWidth(String string2) {
            if (this.metrics == null) {
                return -1;
            }
            return this.metrics.stringWidth(string2);
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDescent() {
            return this.descent;
        }

        public int getLeading() {
            return this.leading;
        }

        public int getGap() {
            return this.gap;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isPlain() {
            return !this.bold;
        }
    }
}

