/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term.jcurses;

import com.heirloomcomputing.term.jcurses.filePtr;
import com.heirloomcomputing.term.jcurses.jniportio;
import com.heirloomcomputing.term.jcurses.struct_termios;
import com.heirloomcomputing.term.jcurses.util;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;

public class tty
extends filePtr {
    public static final boolean debugMode = false;
    private static jniportio p = new jniportio();
    private int fd = -1;
    private OutputStreamWriter osw = null;
    private InputStreamReader isr = null;
    private boolean ttympe = false;

    public tty() {
        String string2 = util.getenv("TTY");
        if (string2 == null && util.getenv("TTYMPE") == null && util.getenv("FID") == null) {
            System.out.println("WARNING: TTY environment string not set in jcurses.properties.");
        }
        this.inittty(string2);
    }

    public tty(String string2) {
        this.inittty(string2);
    }

    public tty(InputStream inputStream) {
        super(inputStream);
    }

    public tty(OutputStream outputStream) {
        super(outputStream);
    }

    public tty(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public tty(Object object) throws IOException {
        super(object);
    }

    private void inittty(String string2) {
        if (string2 == null || string2 == "") {
            String string3 = util.getenv("TTYMPE");
            if (string3 != null) {
                this.ttympe = true;
            }
            this.ioSet(string3, string3);
            return;
        }
        this.ioSet(string2, string2);
    }

    private void tcopen(String string2) {
        this.fd = p.open(string2);
        if (this.fd == -1) {
            throw new RuntimeException("ERROR: Could not open TTY: " + string2);
        }
    }

    private void ioSet(String string2, String string3) {
        PushbackInputStream pushbackInputStream = null;
        FileOutputStream fileOutputStream = null;
        OutputStream outputStream = null;
        if (string2 == null) {
            pushbackInputStream = new PushbackInputStream(System.in);
        } else {
            try {
                pushbackInputStream = new PushbackInputStream(new FileInputStream(string2));
                this.isr = new InputStreamReader(pushbackInputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error: Could not initialize tty '" + string2 + "' for input.");
            }
        }
        if (string3 == null) {
            outputStream = System.out;
        } else {
            try {
                fileOutputStream = new FileOutputStream(string3);
                outputStream = util.getenv("BUFFEREDOUTPUT") != null ? new BufferedOutputStream(fileOutputStream, 2064) : fileOutputStream;
                this.osw = new OutputStreamWriter(outputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error: Could not initialize tty '" + string3 + "' for output.");
            }
        }
        this.setIO(pushbackInputStream, outputStream);
        if (string2 != null || string3 != null) {
            String string4 = string3 != null ? string3 : string2;
            this.tcopen(string4);
        }
    }

    public boolean set_attr(struct_termios struct_termios2, int n) {
        if (this.fd < 0) {
            return false;
        }
        int n2 = 0;
        n2 = p.tcsetattr(this.fd, n, struct_termios2);
        return n2 == 0;
    }

    public boolean get_attr(struct_termios struct_termios2) {
        if (this.fd < 0) {
            return false;
        }
        if (struct_termios2 == null) {
            return false;
        }
        int n = 0;
        n = p.tcgetattr(this.fd, struct_termios2);
        return n == 0;
    }

    public void write(String string2) throws IOException {
        if (this.ttympe) {
            byte[] byArray = string2.getBytes();
            int n = p.write(this.fd, byArray, byArray.length);
        } else {
            try {
                this.osw.write(string2, 0, string2.length());
                this.osw.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (this.ttympe) {
            byte[] byArray2 = new byte[n2];
            n3 = p.read(this.fd, byArray2, n2);
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = byArray2[i];
            }
        } else {
            char[] cArray = new char[n2];
            n3 = this.isr.read(cArray, 0, n2);
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = (byte)cArray[i];
            }
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (this.fd < 0) {
            super.close();
            return;
        }
        p.close(this.fd);
    }

    private void visualize(struct_termios struct_termios2) {
        System.out.println("jcurses:");
        int n = struct_termios2.c_iflag;
        if ((n & 1) != 0) {
            System.out.print("BRKINT ");
        }
        if ((n & 2) != 0) {
            System.out.print("ICRNL ");
        }
        if ((n & 4) != 0) {
            System.out.print("IGNBRK ");
        }
        if ((n & 8) != 0) {
            System.out.print("IGNCR ");
        }
        if ((n & 0x10) != 0) {
            System.out.print("IGNPAR ");
        }
        if ((n & 0x20) != 0) {
            System.out.print("INLCR ");
        }
        if ((n & 0x40) != 0) {
            System.out.print("INPCK ");
        }
        if ((n & 0x80) != 0) {
            System.out.print("ISTRIP ");
        }
        if ((n & 0x100) != 0) {
            System.out.print("IXOFF ");
        }
        if ((n & 0x200) != 0) {
            System.out.print("IXON ");
        }
        if ((n & 0x400) != 0) {
            System.out.print("PARMRK ");
        }
        System.out.print("\n");
        n = struct_termios2.c_oflag;
        if ((n & 1) != 0) {
            System.out.print("OPOST ");
        }
        if ((n & 2) != 0) {
            System.out.print("ONLCR ");
        }
        if ((n & 8) != 0) {
            System.out.print("OCRNL ");
        }
        if ((n & 0x10) != 0) {
            System.out.print("ONOCR ");
        }
        if ((n & 0x20) != 0) {
            System.out.print("TAB3 ");
        }
        System.out.print("\n");
        n = struct_termios2.c_cflag;
        if ((n & 1) != 0) {
            System.out.print("CLOCAL ");
        }
        if ((n & 2) != 0) {
            System.out.print("CREAD ");
        }
        if ((n & 0x18) != 0) {
            System.out.print("CSIZE ");
        }
        if ((n & 0) != 0) {
            System.out.print("CS5 ");
        }
        if ((n & 8) != 0) {
            System.out.print("CS6 ");
        }
        if ((n & 0x10) != 0) {
            System.out.print("CS7 ");
        }
        if ((n & 0x18) != 0) {
            System.out.print("CS8 ");
        }
        if ((n & 0x40) != 0) {
            System.out.print("CSTOPB ");
        }
        if ((n & 0x80) != 0) {
            System.out.print("HUPCL ");
        }
        if ((n & 0x100) != 0) {
            System.out.print("PARENB ");
        }
        if ((n & 0x200) != 0) {
            System.out.print("PARODD ");
        }
        System.out.print("\n");
        n = struct_termios2.c_lflag;
        if ((n & 1) != 0) {
            System.out.print("ECHO ");
        }
        if ((n & 2) != 0) {
            System.out.print("ECHOE ");
        }
        if ((n & 4) != 0) {
            System.out.print("ECHOK ");
        }
        if ((n & 8) != 0) {
            System.out.print("ECHONL ");
        }
        if ((n & 0x10) != 0) {
            System.out.print("ICANON ");
        }
        if ((n & 0x20) != 0) {
            System.out.print("IEXTEN ");
        }
        if ((n & 0x40) != 0) {
            System.out.print("ISIG ");
        }
        if ((n & 0x80) != 0) {
            System.out.print("NOFLSH ");
        }
        if ((n & 0x100) != 0) {
            System.out.print("TOSTOP ");
        }
        System.out.print("\n");
        System.out.println("VDISCARD = " + struct_termios2.c_cc[1]);
        System.out.println("VEOL = " + struct_termios2.c_cc[2]);
        System.out.println("VEOL2 = " + struct_termios2.c_cc[3]);
        System.out.println("VEOF = " + struct_termios2.c_cc[4]);
        System.out.println("VERASE = " + struct_termios2.c_cc[5]);
        System.out.println("VINTR = " + struct_termios2.c_cc[6]);
        System.out.println("VKILL = " + struct_termios2.c_cc[7]);
        System.out.println("VLNEXT = " + struct_termios2.c_cc[8]);
        System.out.println("VMIN = " + struct_termios2.c_cc[9]);
        System.out.println("VQUIT = " + struct_termios2.c_cc[10]);
        System.out.println("VREPRINT = " + struct_termios2.c_cc[11]);
        System.out.println("VSTART = " + struct_termios2.c_cc[12]);
        System.out.println("VSTOP = " + struct_termios2.c_cc[13]);
        System.out.println("VSUSP = " + struct_termios2.c_cc[14]);
        System.out.println("VSWTC = " + struct_termios2.c_cc[15]);
        System.out.println("VTIME = " + struct_termios2.c_cc[16]);
        System.out.println("VWERASE = " + struct_termios2.c_cc[17]);
        System.out.println("VDSUSP = " + struct_termios2.c_cc[18]);
        System.out.println("VCTAB = " + struct_termios2.c_cc[19]);
        System.out.println("--End of jcurses.");
    }
}

