/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import com.heirloomcomputing.ecc.HCILicensing;
import com.heirloomcomputing.ecc.IRAC;
import com.heirloomcomputing.ecc.RACLookup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RAC
implements IRAC {
    private static Date RetryRACWhen = null;
    private static int RetryRACEvery = 600000;
    private static Properties GlobalRACProperties = null;
    public static RACLookup GlobalRACLookup = null;
    public static Logger LOGGER = null;

    private static boolean isTrue(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on") || string.equals("1");
    }

    private static String asCommaList(String[] stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            if (!string.isEmpty()) {
                string = string + ",";
            }
            string = string + string2;
        }
        return string;
    }

    @Override
    public boolean Setup(Properties properties) {
        boolean bl;
        String string;
        if (properties == null) {
            return false;
        }
        if (LOGGER == null) {
            string = properties.getProperty("rac.debug");
            bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string) || "1".equals(string);
            LOGGER = Logger.getLogger("RAC");
            if (bl && LOGGER.getHandlers().length == 0) {
                try {
                    LOGGER.addHandler(new FileHandler("logs/RAC-messages.log"));
                }
                catch (SecurityException securityException) {
                }
                catch (IOException iOException) {
                    try {
                        LOGGER.addHandler(new FileHandler("../logs/RAC-messages.log"));
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (IOException iOException2) {
                        try {
                            LOGGER.addHandler(new FileHandler("RAC-messages.log"));
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                }
            }
            for (Handler handler : LOGGER.getHandlers()) {
                handler.setFormatter(new HCIFormatter());
            }
            LOGGER.setLevel(Level.FINEST);
        }
        GlobalRACProperties = properties;
        bl = false;
        if (GlobalRACLookup == null) {
            if (RetryRACWhen != null && RetryRACWhen.after(new Date())) {
                return false;
            }
            string = GlobalRACProperties.getProperty("rac.connectionurl");
            if (string == null || string.trim().isEmpty()) {
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            string = GlobalRACProperties.getProperty("rac.authentication");
            if (string == null || string.equals("none")) {
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            GlobalRACLookup = new RACLookup();
            bl = true;
        }
        if (!((string = GlobalRACProperties.getProperty("rac.connectionurl")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getConnectionURL()))) {
            bl = true;
            GlobalRACLookup.setConnectionURL(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.alternateurl")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getAlternateURL()))) {
            bl = true;
            GlobalRACLookup.setAlternateURL(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.connectionname")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getConnectionName()))) {
            bl = true;
            GlobalRACLookup.setConnectionName(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.connectionpassword")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getConnectionPassword()))) {
            bl = true;
            GlobalRACLookup.setConnectionPassword(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.connectiontimeout")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getConnectionTimeout()))) {
            bl = true;
            GlobalRACLookup.setConnectionTimeout(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.authentication")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getAuthentication()))) {
            GlobalRACLookup.setAuthentication(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.opidattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getOpidAttribute()))) {
            GlobalRACLookup.setOpidAttribute(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.protocol")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getProtocol()))) {
            GlobalRACLookup.setProtocol(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.userbase")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserBase()))) {
            GlobalRACLookup.setUserBase(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.usersearch")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserSearch()))) {
            GlobalRACLookup.setUserSearch(string);
        }
        if ((string = GlobalRACProperties.getProperty("rac.usersearchasuser")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isUserSearchAsUser()) {
            GlobalRACLookup.setUserSearchAsUser(RAC.isTrue(string));
        }
        if ((string = GlobalRACProperties.getProperty("rac.usersubtree")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isUserSubtree()) {
            GlobalRACLookup.setUserSubtree(RAC.isTrue(string));
        }
        if (!((string = GlobalRACProperties.getProperty("rac.userrolename")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserRoleName()))) {
            GlobalRACLookup.setUserRoleName(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.resourcename")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceName()))) {
            GlobalRACLookup.setResourceName(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.resourcebase")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceBase()))) {
            GlobalRACLookup.setResourceBase(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.resourcememberattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceMemberAttribute()))) {
            GlobalRACLookup.setResourceMemberAttribute(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.resourceruleattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceRuleAttribute()))) {
            GlobalRACLookup.setResourceRuleAttribute(string);
        }
        if ((string = GlobalRACProperties.getProperty("rac.resourcesearchasuser")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isResourceSearchAsUser()) {
            GlobalRACLookup.setResourceSearchAsUser(RAC.isTrue(string));
        }
        if (!((string = GlobalRACProperties.getProperty("rac.resourcetypes")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(RAC.asCommaList(GlobalRACLookup.getResourceTypes())))) {
            GlobalRACLookup.setResourceTypes(string.split(","));
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rgbase")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceGroupBase()))) {
            GlobalRACLookup.setResourceGroupBase(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rgname")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceGroupName()))) {
            GlobalRACLookup.setResourceGroupName(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rgmemberattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceGroupMemberAttribute()))) {
            GlobalRACLookup.setResourceGroupMemberAttribute(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rgruleattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getResourceGroupRuleAttribute()))) {
            GlobalRACLookup.setResourceGroupRuleAttribute(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rolebase")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getRoleBase()))) {
            GlobalRACLookup.setRoleBase(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rolename")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getRoleName()))) {
            GlobalRACLookup.setRoleName(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.rolesearch")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getRoleSearch()))) {
            GlobalRACLookup.setRoleSearch(string);
        }
        if ((string = GlobalRACProperties.getProperty("rac.rolesearchasuser")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isRoleSearchAsUser()) {
            GlobalRACLookup.setRoleSearchAsUser(RAC.isTrue(string));
        }
        if ((string = GlobalRACProperties.getProperty("rac.rolesubtree")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isRoleSubtree()) {
            GlobalRACLookup.setRoleSubtree(RAC.isTrue(string));
        }
        if ((string = GlobalRACProperties.getProperty("rac.rolenested")) != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isRoleNested()) {
            GlobalRACLookup.setRoleNested(RAC.isTrue(string));
        }
        if (!((string = GlobalRACProperties.getProperty("rac.userpassword")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserPassword()))) {
            GlobalRACLookup.setUserPassword(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.userroleattribute")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserRoleAttribute()))) {
            GlobalRACLookup.setUserRoleAttribute(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.userpattern")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getUserPattern()))) {
            GlobalRACLookup.setUserPattern(string);
        }
        if (!((string = GlobalRACProperties.getProperty("rac.commonrole")) == null || string.trim().isEmpty() || string.equals("default") || string.equals(GlobalRACLookup.getCommonRole()))) {
            GlobalRACLookup.setCommonRole(string);
        }
        try {
            string = GlobalRACProperties.getProperty("rac.sizelimit");
            if (string != null && !string.trim().isEmpty() && !string.equals("default") && (long)Integer.parseInt(string) != GlobalRACLookup.getSizeLimit()) {
                GlobalRACLookup.setSizeLimit(Integer.parseInt(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            string = GlobalRACProperties.getProperty("rac.timelimit");
            if (string != null && !string.trim().isEmpty() && !string.equals("default") && Integer.parseInt(string) != GlobalRACLookup.getTimeLimit()) {
                GlobalRACLookup.setTimeLimit(Integer.parseInt(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = GlobalRACProperties.getProperty("rac.debug");
        if (string != null && !string.trim().isEmpty() && !string.equals("default") && RAC.isTrue(string) != GlobalRACLookup.isDebug()) {
            GlobalRACLookup.setDebug(RAC.isTrue(string));
        }
        try {
            string = GlobalRACProperties.getProperty("rac.cachetime");
            if (string != null && !string.trim().isEmpty() && !string.equals("default") && Integer.parseInt(string) != GlobalRACLookup.getCacheTime()) {
                GlobalRACLookup.setCacheTime(Integer.parseInt(string));
                if (GlobalRACLookup.getCacheTime() <= 60) {
                    RetryRACEvery = GlobalRACLookup.getCacheTime() * 60 * 1000;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            string = GlobalRACProperties.getProperty("rac.cachesize");
            if (string != null && !string.trim().isEmpty() && !string.equals("default") && Integer.parseInt(string) != GlobalRACLookup.getCacheSize()) {
                GlobalRACLookup.setCacheSize(Integer.parseInt(string));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            String string2 = GlobalRACLookup.getConnectionURL();
            String string3 = GlobalRACLookup.getAlternateURL();
            if (string2 == null) {
                LOGGER.log(Level.FINEST, "HCI834I");
                GlobalRACLookup = null;
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
            if (string3 == null) {
                string3 = "no alternate security server configured";
            }
            if (GlobalRACLookup.init()) {
                LOGGER.log(Level.INFO, "HCI833I", new Object[]{string2, string3});
                RetryRACWhen = null;
            } else {
                LOGGER.log(Level.SEVERE, "HCI832S", new Object[]{string2, string3});
                GlobalRACLookup = null;
                RetryRACWhen = new Date();
                RetryRACWhen.setTime(RetryRACWhen.getTime() + (long)RetryRACEvery);
                return false;
            }
        }
        return true;
    }

    @Override
    public void TearDown() {
        if (GlobalRACLookup != null) {
            GlobalRACLookup.finish();
            GlobalRACLookup = null;
        }
        RetryRACWhen = null;
    }

    @Override
    public boolean IsRACon() {
        if (GlobalRACLookup != null) {
            return true;
        }
        if (RetryRACWhen == null || RetryRACWhen.before(new Date())) {
            return this.Setup(GlobalRACProperties);
        }
        return GlobalRACLookup != null;
    }

    @Override
    public List<String> GetGroupsForUser(String string) {
        if (!this.IsRACon()) {
            return null;
        }
        return GlobalRACLookup.getRolesForUser(string);
    }

    @Override
    public List<String> Authenticate(String string, String string2) {
        if (!this.IsRACon() || string == null) {
            return new ArrayList<String>();
        }
        RACLookup.AuthenticatedUser authenticatedUser = GlobalRACLookup.authenticate(string, string2);
        if (authenticatedUser == null) {
            return null;
        }
        return authenticatedUser.getRoles();
    }

    @Override
    public boolean Authorize(String string, List<String> list, int n, String string2, String string3) {
        if (!this.IsRACon() || string == null) {
            return true;
        }
        return GlobalRACLookup.authorize(string, list, n, string2, string3) != null;
    }

    @Override
    public String Attribute(String string, String string2) {
        String string3;
        if (!this.IsRACon() || string2 == null) {
            return null;
        }
        if ("opid".equals(string) && (string3 = GlobalRACLookup.getOpidAttribute()) != null) {
            string = string3;
        }
        return GlobalRACLookup.attribute(string2, string);
    }

    protected static class HCIFormatter
    extends Formatter {
        protected HCIFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            if (logRecord == null) {
                return null;
            }
            Pattern pattern = Pattern.compile("HCI(\\d+)\\p{Alpha}+");
            Matcher matcher = pattern.matcher(logRecord.getMessage());
            if (matcher.matches()) {
                int n = 834;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    n = 834;
                }
                return HCILicensing.Message((Integer)n, logRecord.getParameters()) + "\n";
            }
            return logRecord.getMessage();
        }
    }
}

