/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class RACRole
implements Group {
    String roleName;
    Set<Principal> members;

    public RACRole(String string) {
        this.roleName = string;
        this.members = new HashSet<Principal>();
    }

    public String getName() {
        return this.roleName;
    }

    public String toString() {
        String string = "RACRole(";
        if (this.roleName != null) {
            string = string + this.roleName;
        }
        string = string + "):{";
        Iterator<Principal> iterator = this.members.iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next().getName();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        string = string + "}";
        return string;
    }

    public boolean equals(Object object) {
        return object instanceof RACRole && this.roleName.equals(((RACRole)object).getName()) || object instanceof String && this.roleName.equals((String)object);
    }

    public boolean addMember(Principal principal) {
        return this.members.add(principal);
    }

    public boolean isMember(Principal principal) {
        return this.members.contains(principal);
    }

    public Enumeration<? extends Principal> members() {
        return new Vector<Principal>(this.members).elements();
    }

    public boolean removeMember(Principal principal) {
        return this.members.remove(principal);
    }
}

