       IDENTIFICATION DIVISION.
       PROGRAM-ID. ACCTUPD.
      *REMARKS. THIS PREOGRAM IS USED TO UPDATE INDIVIDUAL ACCOUNT 
       
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  PGM-NAME                     PIC X(11) VALUE 'ACCTUPD'.   
       77  TRANS-NAME                   PIC X(11) VALUE 'ACUP'.   
       77  WHEN-UPDATE                  PIC X(40) VALUE 
           'UPDATED 2018-11-30 10:00 AM. '. 
       77  CICS-RESP                    PIC S9(8) BINARY. 
       77  START-CODE                   PIC X(02) VALUE SPACES.          
       01  COUNTERS.
           05  WS-ABSTIME               PIC S9(15).    
      * COMMUNICATIONS AREA PASSED BETWEEN PROGRAMS.
       01  WS-COMMAREA.  
       COPY COMAREA.         
      * CICS BUILTIN ATTRIBUTE VALUES
       COPY DFHBMSCA. 
      * CICS BUILTIN COPYBOOK FOR EIBAID VALUES   
       COPY DFHAID.   
      * VSAM FILE LAYOUT              
       01  ACCTREC.
           COPY ACCTREC.                     
      * BMS MAP LAYOUT 
       COPY ACCTDTL.       
       LINKAGE SECTION.                                 
       01  DFHCOMMAREA                  PIC X(200). 
       
       PROCEDURE DIVISION.
       MAINLINE.
      $if displaymode = 1
           DISPLAY PGM-NAME WHEN-UPDATE UPON SYSERR
      $end-if 
      * CHECK IF PROGRAM WAS STARTED FROM MENU OR FROM TRANSID       
           EXEC CICS ASSIGN
                     STARTCODE (START-CODE)
           END-EXEC 
           
      * INITIALIZE MAP AREA     
           MOVE LOW-VALUES                TO ACCTDTMI           
                            
           EVALUATE TRUE       
             WHEN EIBCALEN = 0 AND
                  START-CODE = 'SD'                                    
                EXEC CICS RETRIEVE 
                          SET (ADDRESS OF DFHCOMMAREA)           
                          LENGTH (LENGTH OF DFHCOMMAREA)         
                          RESP (EIBRESP)                         
                END-EXEC                                                  
                EVALUATE EIBRESP                                          
                   WHEN DFHRESP (NORMAL)
                     MOVE DFHCOMMAREA  TO WS-COMMAREA                   
                     IF WS-CA-IN-ACCTNO = SPACES
                        MOVE -1           TO ACCTDL 
                        MOVE DFHBMFSE      TO ACCTDA
                        MOVE DFHGREEN     TO ACCTDC
                        PERFORM PROTECT-MAP-FIELDS
                        PERFORM CICS-SEND-MAP  
                        PERFORM CICS-RETURN
                     ELSE         
                        PERFORM READ-ACCTFIL
                        EVALUATE TRUE
                          WHEN CICS-RESP = DFHRESP(NORMAL)
                             PERFORM UNPROTECT-MAP-FIELDS                          
                             MOVE 'CHANGE RECORD INFO AND PRESS F10 ' 
                                          TO MSGO
                          WHEN OTHER
                             MOVE -1      TO ACCTDL  
                             MOVE DFHBMFSE  TO ACCTDA
                             MOVE DFHGREEN TO ACCTDC
                             PERFORM PROTECT-MAP-FIELDS                          
                             MOVE 'RECORD NOT FOUND, NOTHING TO UPDATE' 
                                          TO MSGO       
                        END-EVALUATE                                                     
                        PERFORM CICS-SEND-MAP  
                        PERFORM CICS-RETURN                        
                     END-IF  
                   WHEN DFHRESP (ENDDATA)
                       SET DATAONLY-OFF   TO TRUE               
                       PERFORM CICS-SEND-MAP 
                       PERFORM CICS-RETURN                                                         
                END-EVALUATE
             WHEN EIBCALEN = 0
                MOVE -1                   TO ACCTDL
                MOVE DFHBMFSE              TO ACCTDA
                MOVE DFHGREEN             TO ACCTDC 
                PERFORM PROTECT-MAP-FIELDS
                PERFORM CICS-SEND-MAP 
                PERFORM CICS-RETURN                         
           END-EVALUATE
            
           MOVE DFHCOMMAREA               TO WS-COMMAREA
           
           EVALUATE EIBAID
             WHEN DFHCLEAR
               MOVE ZEROS                 TO WS-CA-IN-ACCTNO       
               MOVE SPACES                TO WS-CA-IN-NAME     
               MOVE -1                    TO ACCTDL         
               SET DATAONLY-OFF           TO TRUE     
               MOVE DFHBMFSE              TO ACCTDA
               MOVE DFHGREEN              TO ACCTDC  
               PERFORM CLEAR-FIELDS           
               PERFORM PROTECT-MAP-FIELDS                                
               PERFORM CICS-SEND-MAP 
               PERFORM CICS-RETURN               
             WHEN DFHPF2
               INITIALIZE WS-CA-REINIT-AREA
               MOVE 561                   TO WS-CA-NEXT-CPOSN              
               MOVE WS-CA-PREV-TRANSID    TO WS-CA-TRANSID
               PERFORM START-NEW-TRANSID              
             WHEN DFHPF3
               INITIALIZE WS-COMMAREA
               MOVE 'ACMN'                TO WS-CA-TRANSID
               PERFORM START-NEW-TRANSID
             WHEN DFHPF4                          
               MOVE SPACES                TO WS-CA-IN-ACCTNO
               MOVE DFHBMFSE              TO ACCTDA
               SET DATAONLY-OFF           TO TRUE  
               PERFORM CLEAR-FIELDS       
               PERFORM PROTECT-MAP-FIELDS              
               MOVE 'ENTER ACCOUNT NUMBER TO UPDATE' 
                                          TO MSGO                                           
               PERFORM CICS-SEND-MAP                                                                        
               PERFORM CICS-RETURN
             WHEN OTHER
                CONTINUE  
           END-EVALUATE
              
           PERFORM RECEIVE-MAP               
           PERFORM CICS-SEND-MAP                                                                                                                                                     
                                                                        
           PERFORM CICS-RETURN              
                                                                                                  
           GOBACK                                                                    
           .            
       CICS-SEND-MAP.
       
      * ALWAYS SET CURSOR AT FIRST FIELD FOR DISPLAY PROGRAM 
           MOVE '** UPDATE **'            TO FUNCO   
           MOVE ' F2=RETN PF3=MENU F4=RESET F10=UPDATE'
                                          TO FKEYO 
           
           MOVE TRANS-NAME                TO TRANSO           
           MOVE PGM-NAME                  TO PGMNMO       
           
           EXEC CICS ASKTIME
                ABSTIME (WS-ABSTIME)
           END-EXEC

           EXEC CICS FORMATTIME
                ABSTIME(WS-ABSTIME)
                MMDDYYYY(DATEO)
                DATESEP('/')
                TIME  (TIMEO)
                TIMESEP (':')
           END-EXEC
           
           IF DATAONLY-ON	
               EXEC CICS SEND 
                         MAP('ACCTDTM') 
                         MAPSET('ACCTDTL') 
                         FROM (ACCTDTMO)
                         FREEKB
                         CURSOR
                         DATAONLY 
               END-EXEC
           ELSE        		       
               EXEC CICS SEND 
                         MAP('ACCTDTM') 
                         MAPSET('ACCTDTL') 
                         FROM (ACCTDTMO)
                         FREEKB
                         CURSOR
                         ERASE 
               END-EXEC
               SET DATAONLY-ON            TO TRUE
           END-IF    
           .
       CICS-RETURN.
       
           EXEC CICS RETURN 
                     TRANSID(TRANS-NAME) 
                     COMMAREA (WS-COMMAREA)
                     LENGTH (LENGTH OF WS-COMMAREA)
           END-EXEC
           GOBACK
           .
       RECEIVE-MAP.

           EXEC CICS RECEIVE 
                     MAP('ACCTDTM') 
                     MAPSET('ACCTDTL') 
                     RESP(CICS-RESP) 
           END-EXEC
           EVALUATE CICS-RESP   
             WHEN DFHRESP(MAPFAIL)
               MOVE 'YOU MUST ENTER AN ACCOUNT NUMBER' 
                                          TO MSGO   
             WHEN DFHRESP(NORMAL)
               IF ACCTDI NOT EQUAL WS-CA-IN-ACCTNO 
                  AND WS-CA-IN-ACCTNO EQUAL ZEROS OR SPACES
                    PERFORM VALIDATE-KEY             
               ELSE
                 IF EIBAID = DFHPF10
                   PERFORM UPDATE-ACCTREC
                 ELSE 
                   IF WS-CA-IN-ACCTNO > ZEROS
                     MOVE -1              TO ACCTDL
                     PERFORM VALIDATE-KEY 
                     MOVE 'PRESS F10 TO UPDATE' 
                                          TO MSGO
                   ELSE
                     MOVE -1              TO ACCTDL
                     MOVE 'ENTER ACCOUNT NUMBER TO UPDATE' 
                                          TO MSGO                                    
                 END-IF                              
               END-IF                                  
           END-EVALUATE 
           .  
       UPDATE-ACCTREC.
       
           MOVE WS-CA-IN-ACCTNO           TO ACCTDO OF ACCTREC
           
           EXEC CICS READ 
                     DATASET('ACCTFIL') 
                     RIDFLD(ACCTDO OF ACCTREC) 
                     INTO(ACCTREC)
                     UPDATE
                     RESP(CICS-RESP)
           END-EXEC
           EVALUATE TRUE
             WHEN CICS-RESP = DFHRESP(NORMAL) 
               PERFORM MOVE-FIELDS-FROM-MAP
               PERFORM REWRITE-ACCTREC           
             WHEN OTHER
               MOVE 'UNABLE TO OBTAIN RECORD FOR UPDATE'
                                          TO MSGO                                           
           END-EVALUATE
           .
       MOVE-FIELDS-FROM-MAP. 
       
      * MORE UPPER PART OF THE MAP WITH MOVE CORRESPONDING 
           MOVE CORR ACCTDTMO             TO ACCTREC 
           MOVE WS-CA-IN-ACCTNO           TO ACCTDO OF ACCTREC           
           MOVE SNAMEDO OF ACCTDTMO       TO SNAMEDO OF ACCTREC
           MOVE FNAMEDO OF ACCTDTMO       TO FNAMEDO OF ACCTREC                  
           MOVE DATE1DO                   TO PAY1-YYYYMMDD
           MOVE PAY1DO                    TO PAY1-PAYMENT 
           MOVE BAL1DO                    TO PAY1-BALANCE 
           MOVE DATE2DO                   TO PAY2-YYYYMMDD
           MOVE PAY2DO                    TO PAY2-PAYMENT 
           MOVE BAL2DO                    TO PAY2-BALANCE 
      
           .         
       REWRITE-ACCTREC. 
       
           EXEC CICS REWRITE  
                     DATASET('ACCTFIL') 
                     FROM(ACCTREC)
                     RESP(CICS-RESP)
           END-EXEC           
           EVALUATE TRUE
             WHEN CICS-RESP = DFHRESP(NORMAL)
               MOVE 'UPDATE SUCCESSFUL'   TO MSGO             
             WHEN OTHER
               MOVE 'UPDATE FAILED'       TO MSGO                 
           END-EVALUATE
           .       
       VALIDATE-KEY. 
                    
           MOVE ACCTDI                    TO WS-CA-IN-ACCTNO
           PERFORM READ-ACCTFIL 
           EVALUATE TRUE
             WHEN CICS-RESP = DFHRESP(NORMAL)
               PERFORM UNPROTECT-MAP-FIELDS
                 MOVE 'CHANGE RECORD INFO AND PRESS F10' 
                                          TO MSGO                                            
             WHEN OTHER
               MOVE WS-CA-IN-ACCTNO       TO ACCTDO OF ACCTDTMO
               MOVE SPACES                TO WS-CA-IN-ACCTNO 
               MOVE -1                    TO ACCTDL
               MOVE DFHBMFSE              TO ACCTDA
               MOVE DFHGREEN              TO ACCTDC  
               PERFORM CLEAR-FIELDS           
               PERFORM PROTECT-MAP-FIELDS                       
                 MOVE 'RECORD NOT FOUND, NOTHING TO UPDATE' 
                                          TO MSGO                                                
           END-EVALUATE
           .                                          
       READ-ACCTFIL.
         
           EXEC CICS READ 
                     DATASET('ACCTFIL') 
                     RIDFLD(WS-CA-IN-ACCTNO) 
                     INTO(ACCTREC)
                     RESP(CICS-RESP)
           END-EXEC
      $if displaymode = 1         
           DISPLAY PGM-NAME 
           "CHECK-DETAIL-FIELDS: READ ACCTFIL RESPONSE=" CICS-RESP 
           ". EIBRESP=" EIBRESP 
           ". EIBRCODE=" EIBRCODE 
           ". ACCTNO=" WS-CA-IN-ACCTNO "."  
             UPON SYSERR  
      $end-if          
           IF CICS-RESP = DFHRESP(NORMAL)
               MOVE SPACES                TO MSGO               
               PERFORM BUILD-MAP
           END-IF  
      $if displaymode = 1         
               DISPLAY PGM-NAME 
        "CHECK-DETAIL-FIELDS: READ DATASET ACCTFIL UNEXPECTED EIBRESP="
         EIBRESP 
        "EIBERRMSG=" EIBERRMSG UPON SYSERR
      $end-iF  
           .   
       UPDATE-RECORD.
       
           EXEC CICS READ 
                     DATASET('ACCTFIL') 
                     RIDFLD(WS-CA-IN-ACCTNO) 
                     INTO(ACCTREC)
                     UPDATE
                     RESP(CICS-RESP)
           END-EXEC       
           EVALUATE TRUE
             WHEN CICS-RESP = DFHRESP(NORMAL)                
               EXEC CICS REWRITE 
                         FILE   ('ACCTFIL') 
                         FROM   (ACCTREC)
                         RESP   (CICS-RESP) 
               END-EXEC
               EVALUATE TRUE 
                 WHEN CICS-RESP = DFHRESP(NORMAL)
                   MOVE 'RECORD UPDATED SUCCESSFULLY' 
                                          TO MSGO                                             
                 WHEN OTHER
                   MOVE 'UNABLE TO UPDATE RECORD' 
                                          TO MSGO                                          
               END-EVALUATE                                                                                         
             WHEN OTHER
               MOVE 'ERROR UPDATING RECORD' 
                                          TO MSGO                                              
           END-EVALUATE   
           .                        
       BUILD-MAP. 
       
           MOVE CORRESPONDING ACCTREC     TO ACCTDTMO
           MOVE SNAMEDO OF ACCTREC        TO SNAMEDO OF ACCTDTMO
           MOVE FNAMEDO OF ACCTREC        TO FNAMEDO OF ACCTDTMO
           
           MOVE PAY1-YYYYMMDD             TO DATE1DO
           MOVE PAY1-PAYMENT              TO PAY1DO
           MOVE PAY1-BALANCE              TO BAL1DO
           MOVE PAY2-YYYYMMDD             TO DATE2DO
           MOVE PAY2-PAYMENT              TO PAY2DO
           MOVE PAY2-BALANCE              TO BAL2DO

      $if displaymode = 1     
           DISPLAY PGM-NAME 
          "BUILD-MAP: PAY1-PAYMENT=" PAY1-PAYMENT ". PAY1DO=" PAY1DO "." 
              UPON SYSERR
      $end-if        
          .  
       CLEAR-FIELDS. 

           MOVE SPACES                    TO SNAMEDO     OF ACCTDTMO
                                             FNAMEDO     OF ACCTDTMO
                                             MIDO        OF ACCTDTMO
                                             TTLDO       OF ACCTDTMO
                                             TELDO       OF ACCTDTMO
                                             ADDR1DO     OF ACCTDTMO
                                             ADDR2DO     OF ACCTDTMO
                                             ADDR3DO     OF ACCTDTMO
                                             AUTH1DO     OF ACCTDTMO
                                             AUTH2DO     OF ACCTDTMO
                                             AUTH3DO     OF ACCTDTMO
                                             AUTH4DO     OF ACCTDTMO
                                             IMODO       OF ACCTDTMO
                                             IDAYDO      OF ACCTDTMO
                                             IYRDO       OF ACCTDTMO
                                             RSNDO       OF ACCTDTMO
                                             CCODEDO     OF ACCTDTMO
                                             APPRDO      OF ACCTDTMO
                                             SCODE1DO    OF ACCTDTMO
                                             SCODE2DO    OF ACCTDTMO
                                             SCODE3DO    OF ACCTDTMO
                                             STATDO      OF ACCTDTMO
                                             DATE1DO
                                             DATE2DO
                                             DATE3DO
                            
           MOVE ZEROS                     TO CARDSDO     OF ACCTDTMO 
                                             LIMITDO     OF ACCTDTMO 
                                             PAY1DO
                                             PAY2DO 
                                             PAY3DO     
                                             BAL1DO
                                             BAL2DO                                              
                                             BAL3DO

           .                                                      
       PROTECT-MAP-FIELDS. 
       
           MOVE -1                        TO ACCTDL

           MOVE DFHBMASK                  TO SNAMEDA, FNAMEDA, MIDA, 
                                             TTLDA, TELDA, ADDR1DA,
                                             ADDR2DA, ADDR3DA, AUTH1DA, 
                                             AUTH2DA, AUTH3DA, AUTH4DA, 
                                             CARDSDA, IMODA, IDAYDA, 
                                             IYRDA, RSNDA, CCODEDA, 
                                             APPRDA, SCODE1DA, SCODE2DA, 
                                             SCODE3DA, DATE1DA, DATE2DA,
                                             DATE3DA, PAY1DA, PAY2DA, 
                                             PAY3DA, BAL1DA, BAL2DA, 
                                             BAL3DA, STATDA, LIMITDA                                             
           .                                  
                                             
      * READ ONLY  COLOR
           MOVE DFHBLUE                   TO SNAMEDC, FNAMEDC, MIDC, 
                                             TTLDC, TELDC, ADDR1DC,
                                             ADDR2DC, ADDR3DC, AUTH1DC, 
                                             AUTH2DC, AUTH3DC, AUTH4DC, 
                                             CARDSDC, IMODC, IDAYDC, 
                                             IYRDC, RSNDC, CCODEDC, 
                                             APPRDC, SCODE1DC, SCODE2DC, 
                                             SCODE3DC, DATE1DC, DATE2DC,
                                             DATE3DC, PAY1DC, PAY2DC, 
                                             PAY3DC, BAL1DC, BAL2DC, 
                                             BAL3DC, STATDC, LIMITDC                                                
           .    
                                    
       UNPROTECT-MAP-FIELDS. 
       
      * PROTECT KEY FIELD WHILE UPDATING RECORD
           MOVE DFHBMASK                  TO ACCTDA
           MOVE DFHNEUTR                  TO ACCTDC
           MOVE -1                        TO SNAMEDL      
       

      * UNLOCK FIELDS TO BE UPDATED
           MOVE DFHBMFSE                   TO SNAMEDA, FNAMEDA, MIDA, 
                                             TTLDA, TELDA, ADDR1DA,
                                             ADDR2DA, ADDR3DA, AUTH1DA, 
                                             AUTH2DA, AUTH3DA, AUTH4DA, 
                                             CARDSDA, IMODA, IDAYDA, 
                                             IYRDA, RSNDA, CCODEDA, 
                                             APPRDA, SCODE1DA, SCODE2DA, 
                                             SCODE3DA, DATE1DA, DATE2DA,
                                             DATE3DA, PAY1DA, PAY2DA, 
                                             PAY3DA, BAL1DA, BAL2DA, 
                                             BAL3DA, STATDA, LIMITDA
           .                                  
      * UPDATE COLOR
           MOVE DFHGREEN                  TO SNAMEDC, FNAMEDC, MIDC, 
                                             TTLDC, TELDC, ADDR1DC,
                                             ADDR2DC, ADDR3DC, AUTH1DC, 
                                             AUTH2DC, AUTH3DC, AUTH4DC, 
                                             CARDSDC, IMODC, IDAYDC, 
                                             IYRDC, RSNDC, CCODEDC, 
                                             APPRDC, SCODE1DC, SCODE2DC, 
                                             SCODE3DC, DATE1DC, DATE2DC,
                                             DATE3DC, PAY1DC, PAY2DC, 
                                             PAY3DC, BAL1DC, BAL2DC, 
                                             BAL3DC, STATDC, LIMITDC        
                                             
           .                                                         
       START-NEW-TRANSID.
       
           EXEC CICS START TRANSID  (WS-CA-TRANSID)                    
                           FROM     (WS-COMMAREA)                  
                           LENGTH   (LENGTH OF WS-COMMAREA)                     
                           TERMID   (EIBTRMID)                       
                           RTERMID  (EIBTRMID)                       
                           RESP     (CICS-RESP)                      
           END-EXEC
           EXEC CICS RETURN
           END-EXEC
           GOBACK
           .       